/*
 * Decompiled with CFR 0.152.
 */
package emsl.awt;

import emsl.awt.GUIIcon;
import emsl.awt.GUIPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Panel;

public class GUILabelPanel
extends GUIPanel {
    public static final int TEXT_LEFT = 0;
    public static final int TEXT_RIGHT = 2;
    public static final int ALIGN_LEFT = 0;
    public static final int ALIGN_RIGHT = 1;
    public static final int ALIGN_CENTER = 2;
    public static final int ALIGN_JUSTIFY = 3;
    private static final int BORDER = 1;
    private GUIIcon textIcon;
    private Component component;
    private int behaviour;

    public GUILabelPanel(Component component, String string, Dimension dimension) {
        super(new Dimension(-1, -2));
        this.textIcon = new GUIIcon(dimension);
        this.setComponent(component);
        this.setText(string);
        this.setTextAlignment(0);
        this.setBehaviour(2);
    }

    public GUILabelPanel(Component component, String string, int n) {
        this(component, string, new Dimension(n, -2));
    }

    public GUILabelPanel(Component component, String string) {
        this(component, string, new Dimension(-2, -2));
    }

    public void setComponent(Component component) {
        this.component = component;
        this.redoLayout();
    }

    public void setText(String string) {
        this.textIcon.setText(string);
        this.redoLayout();
    }

    public void setTextAlignment(int n) {
        this.textIcon.setAlignment(n);
        this.redoLayout();
    }

    public void setBehaviour(int n) {
        this.behaviour = n;
        this.redoLayout();
    }

    private void redoLayout() {
        if (this.component == null) {
            return;
        }
        this.removeAll();
        switch (this.behaviour) {
            case 0: {
                this.setLayout(new FlowLayout(0, 1, 1));
                this.add(this.textIcon);
                this.add(this.component);
                return;
            }
            case 1: {
                this.setLayout(new FlowLayout(2, 1, 1));
                this.add(this.textIcon);
                this.add(this.component);
                return;
            }
            case 2: {
                this.setLayout(new FlowLayout(1, 1, 1));
                this.add(this.textIcon);
                this.add(this.component);
                return;
            }
            case 3: {
                Panel panel = new Panel();
                panel.setLayout(new BorderLayout(1, 1));
                panel.add("West", this.textIcon);
                panel.add("Center", this.component);
                panel.add("East", new GUIPanel(new Dimension(1, 1)));
                this.setLayout(new BorderLayout(1, 1));
                this.add("North", panel);
                return;
            }
        }
    }
}

