/*
 * Decompiled with CFR 0.152.
 */
package emsl.awt;

import emsl.awt.GUIButton;
import emsl.awt.GUIIcon;
import emsl.awt.GUIIconBox;
import emsl.awt.GUIPanel;
import emsl.awt.GUIPopUpButton;
import java.awt.AWTEvent;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Panel;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.MouseEvent;

public class GUIPopUpManager
extends Panel
implements Runnable {
    private Container window;
    private Thread motor;
    private GUIPopUpButton triggerButton;
    private boolean isTipText;
    private boolean isLocked = false;
    private GUIIconBox iconBox;
    private int dragMode;
    private int eventCount;

    public GUIPopUpManager(Container container) {
        this.window = container;
        container.setLayout(new FlowLayout());
        container.add(this);
        this.setBackground(Color.black);
        this.setLayout(new FlowLayout(0, 1, 1));
        container.setLayout(new BorderLayout());
    }

    public void managePopUp(GUIPopUpButton gUIPopUpButton, GUIIconBox gUIIconBox) {
        if (this.isLocked) {
            return;
        }
        this.iconBox = gUIIconBox;
        this.triggerButton = gUIPopUpButton;
        this.isTipText = false;
        Point point = this.getComponentLocation(this.triggerButton);
        Point point2 = this.getPopUpLocation(gUIIconBox, this.triggerButton, point, false);
        this.setLocation(point2);
        this.removeAll();
        this.add(gUIIconBox);
        this.setSize(gUIIconBox.getSize().width + 2, gUIIconBox.getSize().height + 2);
        gUIIconBox.setLocation(1, 1);
        this.setVisible(true);
        gUIIconBox.invalidate();
        this.invalidate();
        this.validate();
        gUIIconBox.setPopUpManager(this);
        this.dragMode = 0;
        this.eventCount = 0;
        this.motor = new Thread(this);
        this.motor.start();
    }

    public void showTipText(GUIButton gUIButton, String string) {
        if (this.isLocked) {
            return;
        }
        if (this.motor != null) {
            return;
        }
        this.isTipText = true;
        GUIIcon gUIIcon = new GUIIcon(string);
        gUIIcon.setBackground(new Color(1.0f, 1.0f, 0.5f));
        gUIIcon.setFont(this.getFont());
        Font font = gUIIcon.getFont();
        FontMetrics fontMetrics = Toolkit.getDefaultToolkit().getFontMetrics(font);
        int n = fontMetrics.stringWidth(string) + 20;
        int n2 = fontMetrics.getAscent() + fontMetrics.getDescent() + 6;
        gUIIcon.setSize(new Dimension(n, n2));
        Point point = this.getComponentLocation(gUIButton);
        Point point2 = this.getPopUpLocation(gUIIcon, gUIButton, point, true);
        this.setLocation(point2);
        this.removeAll();
        this.add(gUIIcon);
        gUIIcon.setLocation(1, 1);
        this.setSize(gUIIcon.getSize().width + 2, gUIIcon.getSize().height + 2);
        this.setVisible(true);
    }

    public void hideTipText() {
        if (this.isLocked) {
            return;
        }
        if (this.motor != null) {
            return;
        }
        if (this.isVisible()) {
            this.setVisible(false);
        }
    }

    public void showPanel(GUIPanel gUIPanel) {
        if (this.isLocked) {
            return;
        }
        this.isLocked = true;
        this.removeAll();
        this.add(gUIPanel);
        gUIPanel.setLocation(1, 1);
        this.setSize(gUIPanel.getSize().width + 2, gUIPanel.getSize().height + 2);
        int n = (this.window.getSize().width - gUIPanel.getSize().width) / 2;
        int n2 = (this.window.getSize().height - gUIPanel.getSize().height) / 2;
        this.setLocation(n, n2);
        this.setVisible(true);
    }

    public void hidePanel() {
        this.isLocked = false;
        this.setVisible(false);
    }

    public void run() {
        if (this.isLocked) {
            return;
        }
        EventQueue eventQueue = this.getToolkit().getSystemEventQueue();
        this.dragMode = 0;
        AWTEvent aWTEvent = null;
        do {
            try {
                aWTEvent = eventQueue.getNextEvent();
                if (aWTEvent instanceof MouseEvent) {
                    this.eventFired((MouseEvent)aWTEvent);
                    continue;
                }
                Component component = (Component)aWTEvent.getSource();
                component.dispatchEvent(aWTEvent);
            }
            catch (Exception exception) {}
        } while (this.isVisible());
    }

    public void eventFired(MouseEvent mouseEvent) {
        Point point;
        if (this.isLocked) {
            return;
        }
        int n = mouseEvent.getID();
        if (this.eventCount > 2) {
            if (this.dragMode == 0 && n == 506) {
                this.dragMode = 1;
            }
            if (this.dragMode == 0 && n == 503) {
                this.dragMode = -1;
            }
        }
        ++this.eventCount;
        if (this.dragMode == 1) {
            if (n == 506) {
                point = this.getTranslatedPoint(mouseEvent);
                this.triggerButton.simulateButtonSelection(point);
            }
            if (n == 502) {
                this.stop("DragMode, mouseReleased");
            }
            if (n == 503) {
                this.stop("DragMode, mouseMoved");
            }
        }
        if (this.dragMode == -1) {
            point = this.getTranslatedPoint(mouseEvent);
            this.triggerButton.simulateButtonSelection(point);
            if (n == 506) {
                this.stop("MoveMode, mouseDragged");
            }
            if (n == 501) {
                this.stop("MoveMode, mousePressed");
            }
            if (n == 500) {
                this.stop("MoveMode, mouseClicked");
            }
        }
    }

    private void stop(String string) {
        if (this.isLocked) {
            return;
        }
        this.dragMode = 0;
        this.eventCount = 0;
        this.setVisible(false);
        if (this.iconBox != null) {
            this.iconBox.setPopUpManager(null);
            this.iconBox = null;
        }
        this.triggerButton.popUpManagerFinished();
        this.motor = null;
    }

    private Point getComponentLocation(Component component) {
        Point point = component.getLocation();
        Container container = component.getParent();
        do {
            Point point2 = container.getLocation();
            point.x += point2.x;
            point.y += point2.y;
        } while ((container = !container.equals(this.window) ? container.getParent() : null) != null);
        point.x -= this.window.getLocation().x;
        point.y -= this.window.getLocation().y;
        return point;
    }

    private Point getPopUpLocation(Component component, Component component2, Point point, boolean bl) {
        Dimension dimension = component.getSize();
        Dimension dimension2 = this.window.getSize();
        Point point2 = new Point(0, 0);
        point2.x = point.x;
        if (point2.x + dimension.width > dimension2.width) {
            point2.x = point.x + component2.getSize().width - dimension.width;
        }
        point2.y = point.y;
        if (bl) {
            point2.y += component2.getSize().height;
        }
        if (point2.y + dimension.height > dimension2.height) {
            point2.y = point.y + component2.getSize().height - dimension.height;
            if (bl) {
                point2.y -= component2.getSize().height;
            }
        }
        return point2;
    }

    private Point getTranslatedPoint(MouseEvent mouseEvent) {
        Component component = (Component)mouseEvent.getSource();
        Point point = this.getComponentLocation(component);
        Point point2 = mouseEvent.getPoint();
        point2.x += point.x;
        point2.y += point.y;
        Point point3 = this.getLocation();
        point2.x -= point3.x;
        point2.y -= point3.y;
        return point2;
    }
}

