/*
 * Decompiled with CFR 0.152.
 */
package emsl.awt;

import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;

public class GUITextField
extends TextField
implements ActionListener,
FocusListener {
    public static final int TEXT = 0;
    public static final int INTEGER = 2;
    public static final int DOUBLE = 3;
    private int inputType = 0;
    private double upperBounds;
    private double lowerBounds;
    private boolean rangeChecking = false;
    private String name;

    public GUITextField(String string, int n, int n2) {
        if (n2 > 0) {
            this.setColumns(n2);
        }
        this.name = string;
        this.inputType = n;
        this.rangeChecking = false;
        this.addActionListener(this);
        this.addFocusListener(this);
    }

    public GUITextField(int n, int n2) {
        this("NoName", n, n2);
    }

    public GUITextField(int n) {
        this("NoName", n, 10);
    }

    public GUITextField() {
        this("NoName", 0, 10);
    }

    public void setName(String string) {
        this.name = string;
    }

    public String getName() {
        return this.name;
    }

    public void setNumericalRange(int n, int n2) {
        this.setNumericalRange((double)n, (double)n2);
    }

    public void setNumericalRange(double d, double d2) {
        this.upperBounds = Math.max(d, d2);
        this.lowerBounds = Math.min(d, d2);
        this.rangeChecking = true;
    }

    private String errorCheck(String string) {
        String string2 = "";
        if (this.inputType == 0) {
            return string;
        }
        Double d = new Double(0.0);
        try {
            d = new Double(string);
        }
        catch (Exception exception) {}
        if (this.rangeChecking) {
            if (d < this.lowerBounds) {
                d = new Double(this.lowerBounds);
            }
            if (d > this.upperBounds) {
                d = new Double(this.upperBounds);
            }
        }
        if (this.inputType == 3) {
            string2 = d.toString();
            return string2;
        }
        int n = d.intValue();
        Integer n2 = new Integer(n);
        return n2.toString();
    }

    public void setText(String string) {
        String string2 = this.errorCheck(string);
        super.setText(string2);
    }

    public void setText(int n) {
        Integer n2 = new Integer(n);
        this.setText(n2.toString());
    }

    public void setText(double d) {
        Double d2 = new Double(d);
        this.setText(d2.toString());
    }

    public String getText() {
        String string;
        String string2 = super.getText();
        if (!string2.equals(string = this.errorCheck(string2))) {
            this.setText(string);
        }
        return string;
    }

    public int getInteger() {
        String string = this.getText();
        try {
            Double d = new Double(string);
            int n = d.intValue();
            return n;
        }
        catch (Exception exception) {
            return 0;
        }
    }

    public double getDouble() {
        String string = this.getText();
        try {
            Double d = new Double(string);
            double d2 = d;
            return d2;
        }
        catch (Exception exception) {
            return 0.0;
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        this.getText();
        this.setCaretPosition(500);
    }

    public void focusGained(FocusEvent focusEvent) {
    }

    public void focusLost(FocusEvent focusEvent) {
        this.processActionEvent(new ActionEvent(this, 0, ""));
    }
}

