/*
 * Decompiled with CFR 0.152.
 */
package emsl.beans;

import emsl.beans.BeanLoader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.net.URL;
import java.util.Enumeration;
import java.util.Hashtable;

public class BeanClassLoader
extends ClassLoader {
    BeanLoader beanLoader;
    String beanBasePath;
    Hashtable resourceLocation;
    Hashtable resourceData;
    Hashtable classList;
    Hashtable jarFileEntries;
    Hashtable beanList;
    String classPath;
    boolean debugLoader;
    boolean debugResource;
    Class appletClass;
    static /* synthetic */ Class class$java$applet$Applet;
    static /* synthetic */ Class class$java$awt$Component;

    public BeanClassLoader(BeanLoader beanLoader, String string) {
        this.beanLoader = beanLoader;
        this.beanBasePath = string;
        this.classPath = "";
        this.classList = new Hashtable();
        this.resourceLocation = new Hashtable();
        this.resourceData = new Hashtable();
        this.jarFileEntries = new Hashtable();
        this.beanList = new Hashtable();
        this.debugLoader = false;
        this.debugResource = false;
        this.appletClass = class$java$applet$Applet != null ? class$java$applet$Applet : (class$java$applet$Applet = BeanClassLoader.class$("java.applet.Applet"));
    }

    public BeanLoader getBeanLoader() {
        return this.beanLoader;
    }

    public Hashtable getBeanList() {
        return this.beanList;
    }

    public void setLocalResource(String string, String string2, byte[] byArray) {
        if (string == null || string2 == null || byArray == null) {
            return;
        }
        String string3 = string.toLowerCase();
        String string4 = string2.toLowerCase();
        this.resourceLocation.put(string3, string4);
        this.resourceData.put(string3, byArray);
        if (this.debugResource) {
            System.out.println("Resource " + string3 + " = " + string4);
        }
    }

    public void setBeanList(String string) {
        string = string.replace('\\', '.');
        string = string.replace('/', '.');
        if ((string = string.replace(':', '.')).toLowerCase().endsWith(".class")) {
            Class clazz;
            Class clazz2 = (Class)this.classList.get(string = string.substring(0, string.lastIndexOf(46)));
            if (clazz2 == null) {
                return;
            }
            Class clazz3 = clazz = class$java$awt$Component != null ? class$java$awt$Component : (class$java$awt$Component = BeanClassLoader.class$("java.awt.Component"));
            if (!clazz.isAssignableFrom(clazz2)) {
                return;
            }
            this.beanList.put(string, clazz2);
        }
        if (string.toLowerCase().endsWith(".ser")) {
            string = string.substring(0, string.lastIndexOf(46));
            this.beanList.put(string, "Serialized");
        }
    }

    public void setClassPath(String string) {
        this.classPath = string;
    }

    public void addJarFileEntries(Hashtable hashtable, String string) {
        if (hashtable == null) {
            return;
        }
        Enumeration enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            String string2 = (String)enumeration.nextElement();
            byte[] byArray = (byte[])hashtable.get(string2);
            this.jarFileEntries.put(string2, byArray);
            this.setLocalResource(string2, string, byArray);
        }
    }

    private Class isSystemClass(String string) {
        Class<?> clazz = null;
        try {
            clazz = this.findSystemClass(string);
            if (clazz != null && this.debugLoader && !string.startsWith("java.")) {
                System.out.println("        --- Class in system " + string);
            }
        }
        catch (Exception exception) {}
        return clazz;
    }

    private Class isLoadedClass(String string) {
        Class<?> clazz = null;
        try {
            clazz = this.findLoadedClass(string);
            if (clazz != null && this.debugLoader && !string.startsWith("java.")) {
                System.out.println("        --- Class in system load " + string);
            }
        }
        catch (Exception exception) {}
        return clazz;
    }

    private Class isHashtableClass(String string) {
        Class clazz = null;
        try {
            clazz = (Class)this.classList.get(string);
            if (clazz != null && this.debugLoader) {
                System.out.println("        --- Class in hashtable " + string);
            }
        }
        catch (Exception exception) {}
        return clazz;
    }

    private Class isLoadableClass(String string) {
        Class<?> clazz = null;
        byte[] byArray = null;
        if (this.classPath == null) {
            return clazz;
        }
        try {
            File file = new File(this.classPath, String.valueOf(string) + ".class");
            FileInputStream fileInputStream = new FileInputStream(file);
            byArray = new byte[fileInputStream.available()];
            fileInputStream.read(byArray);
            fileInputStream.close();
            clazz = this.defineClass(null, byArray, 0, byArray.length);
            this.classList.put(string, clazz);
            this.setLocalResource(String.valueOf(string) + ".class", this.classPath, byArray);
            if (this.appletClass.isAssignableFrom(clazz)) {
                this.setBeanList(String.valueOf(string) + ".class");
            }
            if (this.debugLoader) {
                System.out.println("        --- Class read from disk " + string);
            }
        }
        catch (Exception exception) {}
        return clazz;
    }

    private Class isJarFileClass(String string) {
        Class<?> clazz = null;
        byte[] byArray = null;
        if (this.jarFileEntries == null) {
            return clazz;
        }
        try {
            byArray = (byte[])this.jarFileEntries.get(String.valueOf(string) + ".class");
            clazz = this.defineClass(string, byArray, 0, byArray.length);
            this.classList.put(string, clazz);
            new File(this.classPath);
            if (this.debugLoader) {
                System.out.println("        --- Class read from jarList " + string);
            }
        }
        catch (Exception exception) {}
        return clazz;
    }

    public synchronized Class loadClass(String string, boolean bl) {
        Class clazz;
        if (this.debugLoader) {
            System.out.println("Looking for class " + string);
        }
        if ((clazz = this.isSystemClass(string)) == null) {
            clazz = this.isHashtableClass(string);
        }
        if (clazz == null) {
            clazz = this.isJarFileClass(string);
        }
        if (clazz == null) {
            clazz = this.isLoadableClass(string);
        }
        if (clazz == null) {
            int n = string.lastIndexOf(46);
            String string2 = string.substring(n + 1);
            if (n >= 0) {
                clazz = this.isLoadableClass(string2);
            }
        }
        if (clazz == null && this.debugLoader) {
            System.out.println("        --- Class not found " + string);
            return null;
        }
        if (bl) {
            this.resolveClass(clazz);
        }
        return clazz;
    }

    public URL getResource(String string) {
        URL uRL = super.getResource(string = string.toLowerCase());
        if (uRL != null) {
            return uRL;
        }
        return this.getLocalResource(string);
    }

    private URL getLocalResource(String string) {
        Object object;
        String string2 = (String)this.resourceLocation.get(string);
        if (string2 == null) {
            object = string.replace('\\', '.');
            object = ((String)object).replace('/', '.');
            object = ((String)object).replace(':', '.');
            string2 = (String)this.resourceLocation.get(object);
        }
        if (string2 == null) {
            object = string;
            int n = ((String)object).lastIndexOf("/");
            if (n >= 0) {
                object = ((String)object).substring(n + 1);
            }
            string2 = (String)this.resourceLocation.get(object);
        }
        if (string2 == null) {
            if (this.debugResource) {
                System.out.println("Asked for resource as URL, but not found : " + string);
            }
            return null;
        }
        try {
            if (this.debugResource) {
                System.out.println("Resource URL found in internal hashtable : " + string);
            }
            string2 = string2.replace('.', '/');
            string2 = string2.replace('\\', '/');
            string2 = string2.replace(':', '/');
            string2 = String.valueOf(string2) + "/" + string;
            object = new URL("internal", null, string2);
            return object;
        }
        catch (Exception exception) {
            System.out.println("Error :" + exception.toString());
            return null;
        }
    }

    public InputStream getResourceAsStream(String string) {
        InputStream inputStream = super.getResourceAsStream(string = string.toLowerCase());
        if (inputStream != null) {
            return inputStream;
        }
        return this.getLocalResourceAsStream(string);
    }

    private InputStream getLocalResourceAsStream(String string) {
        byte[] byArray = this.getLocalResourceAsData(string);
        if (byArray == null) {
            return null;
        }
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        if (this.debugResource) {
            System.out.println("Resource Stream found in internal hashtable : " + string);
        }
        return byteArrayInputStream;
    }

    private byte[] getLocalResourceAsData(String string) {
        String string2;
        byte[] byArray;
        if (string.startsWith(this.beanBasePath.toLowerCase())) {
            string = string.substring(this.beanBasePath.length() + 1);
        }
        if ((byArray = (byte[])this.resourceData.get(string)) == null) {
            string2 = string.replace('\\', '.');
            string2 = string2.replace('/', '.');
            string2 = string2.replace(':', '.');
            byArray = (byte[])this.resourceData.get(string2);
        }
        if (byArray == null) {
            string2 = string;
            int n = string2.lastIndexOf("/");
            if (n >= 0) {
                string2 = string2.substring(n + 1);
            }
            byArray = (byte[])this.resourceData.get(string2);
        }
        if (byArray == null) {
            if (this.debugResource) {
                System.out.println("Asked for resource as Stream, but not found : " + string);
            }
            return null;
        }
        return byArray;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

