/*
 * Decompiled with CFR 0.152.
 */
package emsl.editors;

import emsl.awt.GUIPanel;
import emsl.awt.GUIProgressBox;
import emsl.awt.GUITextField;
import emsl.editors.PropertySheet;
import emsl.editors.PropertyWrapper;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.beans.BeanDescriptor;
import java.beans.BeanInfo;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.beans.PropertyEditor;
import java.beans.PropertyEditorManager;
import java.util.Enumeration;
import java.util.Vector;

public class BeanSheet
extends PropertySheet {
    private transient Component bean;
    private transient GUIProgressBox progressBox;
    static /* synthetic */ Class class$java$io$File;
    static /* synthetic */ Class class$emsl$editors$FileEditor;

    public BeanSheet(GUIPanel gUIPanel, Component component) {
        super(gUIPanel, "Bean Editor : " + component.getClass());
        this.bean = component;
        PropertyEditorManager.registerEditor(class$java$io$File != null ? class$java$io$File : (class$java$io$File = BeanSheet.class$("java.io.File")), class$emsl$editors$FileEditor != null ? class$emsl$editors$FileEditor : (class$emsl$editors$FileEditor = BeanSheet.class$("emsl.editors.FileEditor")));
        BeanInfo beanInfo = this.getBeanInfo();
        if (beanInfo == null) {
            return;
        }
        this.setWindowTitle(beanInfo);
        Vector vector = this.getPropertyList(beanInfo);
        this.progressBox = new GUIProgressBox(gUIPanel);
        this.progressBox.setProgress(0, "Introspecting Bean...");
        this.progressBox.setTotalIncrements(vector.size());
        if (vector.size() > 10) {
            this.progressBox.display();
        }
        Vector vector2 = this.sortPropertyList(vector);
        this.createPropertyEditors(vector2);
        this.progressBox.dispose();
    }

    private void setWindowTitle(BeanInfo beanInfo) {
        try {
            BeanDescriptor beanDescriptor = beanInfo.getBeanDescriptor();
            this.setTitle("Bean Editor : " + beanDescriptor.getDisplayName());
            return;
        }
        catch (Exception exception) {
            return;
        }
    }

    private BeanInfo getBeanInfo() {
        try {
            Class<?> clazz = this.bean.getClass();
            BeanInfo beanInfo = Introspector.getBeanInfo(clazz);
            return beanInfo;
        }
        catch (Exception exception) {
            System.out.println("An error occured trying to Instrospect the Bean");
            System.out.println(String.valueOf(exception.toString()));
            return null;
        }
    }

    private Vector getPropertyList(BeanInfo beanInfo) {
        Vector<PropertyDescriptor> vector = new Vector<PropertyDescriptor>();
        try {
            PropertyDescriptor[] propertyDescriptorArray = beanInfo.getPropertyDescriptors();
            int n = 0;
            while (n < propertyDescriptorArray.length) {
                PropertyDescriptor propertyDescriptor = propertyDescriptorArray[n];
                boolean bl = true;
                if (propertyDescriptor.getReadMethod() == null) {
                    bl = false;
                }
                if (propertyDescriptor.getWriteMethod() == null) {
                    bl = false;
                }
                if (propertyDescriptor.isHidden()) {
                    bl = false;
                }
                if (propertyDescriptor.isExpert()) {
                    bl = false;
                }
                if (propertyDescriptor.getDisplayName().equals("name")) {
                    bl = false;
                }
                if (bl) {
                    vector.addElement(propertyDescriptor);
                }
                ++n;
            }
        }
        catch (Exception exception) {
            System.out.println("Instrospection Error");
            System.out.println(String.valueOf(exception.toString()));
        }
        return vector;
    }

    private Vector sortPropertyList(Vector vector) {
        boolean bl = true;
        do {
            try {
                bl = true;
                int n = 0;
                while (n < vector.size() - 1) {
                    PropertyDescriptor propertyDescriptor = (PropertyDescriptor)vector.elementAt(n);
                    PropertyDescriptor propertyDescriptor2 = (PropertyDescriptor)vector.elementAt(n + 1);
                    String string = propertyDescriptor.getDisplayName();
                    String string2 = propertyDescriptor2.getDisplayName();
                    if (string2.compareTo(string) < 0) {
                        vector.setElementAt(propertyDescriptor2, n);
                        vector.setElementAt(propertyDescriptor, n + 1);
                        bl = false;
                    }
                    ++n;
                }
            }
            catch (Exception exception) {
                bl = true;
            }
        } while (!bl);
        return vector;
    }

    private void createPropertyEditors(Vector vector) {
        this.resetPropertyPanel();
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            Object object;
            this.progressBox.setProgress("Assembling Property Editors...");
            PropertyDescriptor propertyDescriptor = (PropertyDescriptor)enumeration.nextElement();
            Class<?> clazz = propertyDescriptor.getPropertyType();
            PropertyEditor propertyEditor = null;
            try {
                object = propertyDescriptor.getPropertyEditorClass();
                propertyEditor = (PropertyEditor)((Class)object).newInstance();
            }
            catch (Exception exception) {}
            if (propertyEditor == null) {
                propertyEditor = PropertyEditorManager.findEditor(clazz);
            }
            if (propertyEditor == null) continue;
            object = propertyDescriptor.getDisplayName();
            PropertyWrapper propertyWrapper = new PropertyWrapper(this.bean, propertyDescriptor, propertyEditor);
            propertyWrapper.setText((String)object);
            this.addProperty(propertyWrapper);
        }
        this.resizePanel();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        super.actionPerformed(actionEvent);
        if (actionEvent.getSource() instanceof GUITextField) {
            GUITextField gUITextField = (GUITextField)actionEvent.getSource();
            gUITextField.getName();
            gUITextField.getText();
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

