/*
 * Decompiled with CFR 0.152.
 */
package emsl.inch;

import emsl.awt.GUIPanel;
import emsl.editors.BeanSheet;
import emsl.editors.CustomizerSheet;
import emsl.inch.AppletPanel;
import java.awt.Component;
import java.awt.Cursor;
import java.beans.BeanDescriptor;
import java.beans.BeanInfo;
import java.beans.Introspector;

public class BeanPanel
extends AppletPanel {
    private transient BeanSheet beanSheet;
    private transient CustomizerSheet beanCustomizer;
    private transient Class customizerClass;

    public void setComponent(Component component) {
        super.setComponent(component);
        this.customizerClass = this.getCustomizerClass();
    }

    public String[] getEditOptions() {
        String[] stringArray = new String[]{"Bean Editor..."};
        return stringArray;
    }

    public void setEditOption(String string) {
        try {
            this.getParent().setCursor(new Cursor(3));
            this.setCursor(new Cursor(3));
            if (string.equals("Bean Editor...")) {
                if (this.customizerClass == null) {
                    this.showBeanEditorSheet();
                } else {
                    this.showBeanCustomizer();
                }
            }
            this.setCursor(new Cursor(0));
            this.getParent().setCursor(new Cursor(0));
            return;
        }
        catch (Exception exception) {
            return;
        }
    }

    private void showBeanEditorSheet() {
        if (this.beanSheet == null) {
            this.beanSheet = new BeanSheet((GUIPanel)this, this.getComponent());
        }
        if (this.beanSheet == null) {
            return;
        }
        this.beanSheet.setVisible(true);
    }

    private void showBeanCustomizer() {
        if (this.beanCustomizer == null) {
            this.beanCustomizer = this.makeCustomizer();
        }
        if (this.beanCustomizer == null) {
            return;
        }
        this.beanCustomizer.setObject(this.getComponent());
        this.beanCustomizer.setVisible(true);
    }

    private CustomizerSheet makeCustomizer() {
        if (this.customizerClass == null) {
            return null;
        }
        CustomizerSheet customizerSheet = new CustomizerSheet((GUIPanel)this, this.getComponent());
        customizerSheet.setCustomizer(this.customizerClass);
        return customizerSheet;
    }

    private Class getCustomizerClass() {
        try {
            Class<?> clazz = this.getComponent().getClass();
            BeanInfo beanInfo = Introspector.getBeanInfo(clazz);
            BeanDescriptor beanDescriptor = beanInfo.getBeanDescriptor();
            if (beanDescriptor == null) {
                return null;
            }
            return beanDescriptor.getCustomizerClass();
        }
        catch (Exception exception) {
            System.out.println("An error occured trying to Instrospect the Bean");
            System.out.println(String.valueOf(exception.toString()));
            return null;
        }
    }

    public void copyAttributes(BeanPanel beanPanel) {
        super.copyAttributes(beanPanel);
        if (this.getComponent() != null) {
            beanPanel.setComponent(this.getComponentClone());
        }
    }

    public Object clone() {
        BeanPanel beanPanel = new BeanPanel();
        this.copyAttributes(beanPanel);
        return beanPanel;
    }
}

