/*
 * Decompiled with CFR 0.152.
 */
package emsl.inch;

import emsl.awt.GUIPanel;
import java.awt.Dimension;
import java.awt.Rectangle;

public class InchPanel
extends GUIPanel {
    private Rectangle inchBounds;
    private transient int viewScale;

    public InchPanel() {
        this.setInchBounds(new Rectangle(0, 0, 1000, 1000));
        this.viewScale = 100;
        this.updateBounds();
    }

    public void layoutPage() {
    }

    public void setViewScale(int n) {
        this.viewScale = n;
    }

    public int getViewScale() {
        return this.viewScale;
    }

    public Rectangle getInchBounds() {
        return this.inchBounds;
    }

    public void setInchBounds(Rectangle rectangle) {
        this.inchBounds = new Rectangle(rectangle);
    }

    public Rectangle getPixelBounds() {
        return this.calculatePixelRectangle(this.inchBounds, 100);
    }

    public void setPixelBounds(Rectangle rectangle) {
        this.inchBounds = this.calculateInchRectangle(rectangle, 100);
    }

    public Rectangle getScaledPixelBounds() {
        return this.calculatePixelRectangle(this.inchBounds, this.viewScale);
    }

    public void setScaledPixelBounds(Rectangle rectangle) {
        this.inchBounds = this.calculateInchRectangle(rectangle, this.viewScale);
    }

    public void updateBounds() {
        this.updateSize();
        this.updateLocation();
    }

    public void updateSize() {
        Rectangle rectangle = this.getScaledPixelBounds();
        this.setSize(new Dimension(rectangle.width, rectangle.height));
    }

    public void updateLocation() {
        Rectangle rectangle = this.getScaledPixelBounds();
        this.setLocation(rectangle.x, rectangle.y);
    }

    public Rectangle calculateInchRectangle(Rectangle rectangle, int n) {
        double d = this.getPixelToInchFactor(n);
        Rectangle rectangle2 = new Rectangle();
        rectangle2.x = (int)Math.rint((double)rectangle.x * d);
        rectangle2.y = (int)Math.rint((double)rectangle.y * d);
        rectangle2.width = (int)Math.rint((double)rectangle.width * d);
        rectangle2.height = (int)Math.rint((double)rectangle.height * d);
        return rectangle2;
    }

    public Rectangle calculatePixelRectangle(Rectangle rectangle, int n) {
        double d = this.getInchToPixelFactor(n);
        Rectangle rectangle2 = new Rectangle();
        rectangle2.x = (int)Math.rint((double)rectangle.x * d);
        rectangle2.y = (int)Math.rint((double)rectangle.y * d);
        rectangle2.width = (int)Math.rint((double)rectangle.width * d);
        rectangle2.height = (int)Math.rint((double)rectangle.height * d);
        return rectangle2;
    }

    public double getPixelToInchFactor(int n) {
        double d = 1.0 / (double)this.getDPI() * (100.0 / (double)n) * 1000.0;
        return d;
    }

    public double getInchToPixelFactor(int n) {
        double d = 0.001 * (double)this.getDPI() * (double)n / 100.0;
        return d;
    }

    public void copyAttributes(InchPanel inchPanel) {
        inchPanel.setViewScale(this.getViewScale());
        inchPanel.setInchBounds(this.getInchBounds());
        inchPanel.setBackground(this.getBackground());
        inchPanel.setBorder(this.getBorder());
    }

    public Object clone() {
        InchPanel inchPanel = new InchPanel();
        this.copyAttributes(inchPanel);
        return inchPanel;
    }
}

