/*
 * Decompiled with CFR 0.152.
 */
package emsl.io;

import emsl.awt.GUIAlertBox;
import emsl.io.DataBaseSockets;
import emsl.io.LoginManager;
import emsl.io.RemoteFileBrowser;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.FileDialog;
import java.awt.Frame;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;

public class FileManager {
    public static final int LOAD = 0;
    public static final int SAVE = 1;
    private LoginManager loginManager;
    private Frame parentFrame;
    private String currentLocalDirectory;
    private String currentRemoteDirectory;
    private String currentFile;
    private String currentMachine;

    public FileManager(Frame frame) {
        this.parentFrame = frame;
        this.setMachine("Local");
        this.loginManager = new LoginManager(frame);
        this.currentLocalDirectory = null;
        this.currentRemoteDirectory = null;
    }

    public void login() {
        this.loginManager.display();
    }

    public boolean isDataBaseUsable() {
        return this.loginManager.isDataBaseUsable();
    }

    public void setDirectory(String string) {
        if (this.currentMachine.equals("Local")) {
            this.currentLocalDirectory = string;
            return;
        }
        this.currentRemoteDirectory = string;
    }

    public String getDirectory() {
        if (this.currentMachine.equals("Local")) {
            return this.currentLocalDirectory;
        }
        return this.currentRemoteDirectory;
    }

    public void setFile(String string) {
        this.currentFile = string;
    }

    public String getFile() {
        return this.currentFile;
    }

    public void setMachine(String string) {
        this.currentMachine = "Local";
        if (string.equals("Remote")) {
            this.currentMachine = "Remote";
        }
    }

    public String getMachine() {
        return this.currentMachine;
    }

    public void showLocalBrowser(int n, String string) {
        FileDialog fileDialog = new FileDialog(this.parentFrame, string, n);
        this.setMachine("Local");
        this.setFile(null);
        String string2 = this.getDirectory();
        if (string2 == null) {
            string2 = System.getProperty("user.dir");
        }
        fileDialog.setDirectory(string2);
        fileDialog.show();
        this.setFile(fileDialog.getFile());
        if (this.getFile() != null) {
            this.setDirectory(fileDialog.getDirectory());
        }
    }

    public void showRemoteBrowser(int n, String string) {
        this.setMachine("Remote");
        this.setFile(null);
        if (!this.isDataBaseUsable()) {
            this.login();
            if (!this.isDataBaseUsable()) {
                return;
            }
        }
        RemoteFileBrowser remoteFileBrowser = new RemoteFileBrowser(this.parentFrame, string, n, this.loginManager);
        remoteFileBrowser.setDirectory(this.getDirectory());
        remoteFileBrowser.display();
        this.setFile(remoteFileBrowser.getFile());
        if (this.getFile() != null) {
            this.setDirectory(remoteFileBrowser.getDirectory());
        }
    }

    public boolean setFileData(byte[] byArray) {
        ((Component)this.parentFrame).setCursor(new Cursor(3));
        boolean bl = false;
        bl = this.currentMachine.equals("Remote") ? this.setRemoteFileData(byArray) : this.setLocalFileData(byArray);
        ((Component)this.parentFrame).setCursor(new Cursor(0));
        return bl;
    }

    private boolean setRemoteFileData(byte[] byArray) {
        DataBaseSockets dataBaseSockets = this.loginManager.login();
        if (dataBaseSockets == null) {
            return false;
        }
        if (this.getDirectory() == null) {
            this.setDirectory(dataBaseSockets.getDirectoryRoot());
        }
        String string = String.valueOf(this.getDirectory()) + dataBaseSockets.getSeparator() + this.getFile();
        dataBaseSockets.setFileData(string, byArray);
        this.loginManager.logout(dataBaseSockets);
        return true;
    }

    private boolean setLocalFileData(byte[] byArray) {
        try {
            if (this.getDirectory() == null) {
                this.setDirectory(System.getProperty("user.dir"));
            }
            File file = new File(this.getDirectory(), this.getFile());
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            fileOutputStream.write(byArray);
            fileOutputStream.close();
            return true;
        }
        catch (Exception exception) {
            this.displayError("write a file to local disk", exception.toString());
            return false;
        }
    }

    public byte[] getFileData() {
        ((Component)this.parentFrame).setCursor(new Cursor(3));
        byte[] byArray = null;
        byArray = this.currentMachine.equals("Remote") ? this.getRemoteFileData() : this.getLocalFileData();
        ((Component)this.parentFrame).setCursor(new Cursor(0));
        return byArray;
    }

    private byte[] getRemoteFileData() {
        DataBaseSockets dataBaseSockets = this.loginManager.login();
        if (dataBaseSockets == null) {
            return null;
        }
        if (this.getDirectory() == null) {
            this.setDirectory(dataBaseSockets.getDirectoryRoot());
        }
        String string = String.valueOf(this.getDirectory()) + dataBaseSockets.getSeparator() + this.getFile();
        byte[] byArray = dataBaseSockets.getFileData(string);
        this.loginManager.logout(dataBaseSockets);
        return byArray;
    }

    private byte[] getLocalFileData() {
        try {
            if (this.getDirectory() == null) {
                this.setDirectory(System.getProperty("user.dir"));
            }
            File file = new File(this.getDirectory(), this.getFile());
            FileInputStream fileInputStream = new FileInputStream(file);
            byte[] byArray = new byte[fileInputStream.available()];
            fileInputStream.read(byArray);
            fileInputStream.close();
            return byArray;
        }
        catch (Exception exception) {
            this.displayError("read a file from local disk", exception.toString());
            return null;
        }
    }

    private void displayError(String string, String string2) {
        GUIAlertBox gUIAlertBox = new GUIAlertBox(this.parentFrame, "File Manager Error Message");
        gUIAlertBox.addExitButtons("OK");
        gUIAlertBox.addText("An error has occured whilst trying to ");
        gUIAlertBox.addText(string);
        gUIAlertBox.addText(string2);
        gUIAlertBox.addText(" ");
        gUIAlertBox.display();
    }
}

