/*
 * Decompiled with CFR 0.152.
 */
package emsl.io;

import emsl.awt.GUIAlertBox;
import emsl.awt.GUIProgressBox;
import emsl.io.FileManager;
import java.awt.Frame;
import java.io.ByteArrayOutputStream;
import java.io.ObjectOutputStream;
import java.util.Enumeration;
import java.util.Hashtable;

public class FileWriter {
    private Frame parentFrame;
    private FileManager fileManager;
    private GUIProgressBox progressBox;
    private ByteArrayOutputStream byteStream;
    private ObjectOutputStream outputStream;
    public static final String SECTIONER = "EMSL-OBJECT-SECTION";
    public static final String ITEM_COUNT = "ITEM-COUNT";

    public FileWriter(Frame frame, FileManager fileManager) {
        this.parentFrame = frame;
        this.fileManager = fileManager;
    }

    public boolean saveText(String string) {
        Object object;
        if (string == null) {
            return false;
        }
        this.startProgressBox(2);
        String string2 = new String(string);
        String string3 = System.getProperty("line.separator");
        int n = 0;
        this.progressBox.setProgress("Converting Text...");
        do {
            if ((n = string2.indexOf(10, n)) == -1) continue;
            object = new StringBuffer(string2.substring(0, n));
            ((StringBuffer)object).append(string3);
            ((StringBuffer)object).append(string2.substring(n + 1));
            string2 = ((StringBuffer)object).toString();
            n += string3.length();
        } while (n != -1);
        object = string2.getBytes();
        return this.stopProgressBox((byte[])object);
    }

    public boolean saveData(Hashtable hashtable) {
        Object object;
        if (hashtable == null) {
            return false;
        }
        this.startProgressBox(hashtable.size());
        try {
            this.byteStream = new ByteArrayOutputStream();
            this.outputStream = new ObjectOutputStream(this.byteStream);
        }
        catch (Exception exception) {
            FileWriter.error(this.parentFrame, "Save File", exception, this.fileManager.getFile(), null);
            this.stopProgressBox(null);
            return false;
        }
        this.saveObject(ITEM_COUNT, new Integer(hashtable.size()));
        Enumeration enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            object = (String)enumeration.nextElement();
            Object v = hashtable.get(object);
            this.progressBox.setProgress("Saving " + (String)object + "...");
            this.saveObject((String)object, v);
        }
        object = this.byteStream.toByteArray();
        return this.stopProgressBox((byte[])object);
    }

    private void saveObject(String string, Object object) {
        try {
            this.outputStream.writeUTF(SECTIONER);
            this.outputStream.writeUTF(string);
            this.outputStream.writeObject(object);
            return;
        }
        catch (Exception exception) {
            FileWriter.error(this.parentFrame, "Serialize", exception, string, null);
            return;
        }
    }

    private void startProgressBox(int n) {
        this.progressBox = new GUIProgressBox(this.parentFrame);
        this.progressBox.setTotalIncrements(n + 2);
        this.progressBox.display();
        this.progressBox.setProgress("Preparing to Save Data...");
    }

    private boolean stopProgressBox(byte[] byArray) {
        boolean bl = false;
        if (byArray != null) {
            this.progressBox.setProgress("Saving Data to Disk...");
            bl = this.fileManager.setFileData(byArray);
        }
        this.progressBox.dispose();
        return bl;
    }

    public static void error(Frame frame, String string, Exception exception, String string2, String string3) {
        GUIAlertBox gUIAlertBox = new GUIAlertBox(frame, String.valueOf(string) + " Error");
        gUIAlertBox.addExitButtons("OK");
        gUIAlertBox.addText("An error occured trying to " + string + " : " + string2);
        gUIAlertBox.addText("");
        gUIAlertBox.addText("JavaError : " + exception.toString());
        if (string3 != null) {
            gUIAlertBox.addText("");
            gUIAlertBox.addText(string3);
        }
        gUIAlertBox.display();
        gUIAlertBox.dispose();
    }
}

