/*
 * Decompiled with CFR 0.152.
 */
package emsl.io;

import emsl.awt.GUIAlertBox;
import emsl.awt.GUIButton;
import emsl.awt.GUIDialogueBox;
import emsl.awt.GUIIconBox;
import emsl.awt.GUILabelPanel;
import emsl.awt.GUIPanel;
import emsl.awt.GUIPopUpButton;
import emsl.awt.GUITextField;
import emsl.io.DataBaseSockets;
import emsl.io.LoginManager;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.List;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.TextEvent;
import java.awt.event.TextListener;

public class RemoteFileBrowser
extends GUIDialogueBox
implements ActionListener,
ItemListener,
TextListener {
    private LoginManager loginManager;
    private DataBaseSockets dbSockets;
    private String currentDirectory;
    private GUIIconBox directoryList;
    private GUIPopUpButton directoryButton;
    private GUIButton actionButton;
    private GUIButton cancelButton;
    private GUITextField textField;
    private List fileList;
    private Dimension dirSize;
    private int mode;
    private Frame parent;
    private String separator;

    public RemoteFileBrowser(Frame frame, String string, int n, LoginManager loginManager) {
        super(frame, string, true);
        this.setResizable(true);
        ((Component)this).setSize(500, 400);
        this.currentDirectory = null;
        this.dirSize = new Dimension(400, 22);
        this.loginManager = loginManager;
        this.parent = frame;
        this.mode = n;
        GUIPanel gUIPanel = this.getDisplayPanel();
        gUIPanel.setLayout(new BorderLayout());
        this.createFileListPanel(gUIPanel);
        this.createButtonsPanel(gUIPanel);
    }

    private void createFileListPanel(GUIPanel gUIPanel) {
        GUIPanel gUIPanel2 = new GUIPanel();
        gUIPanel2.setLayout(new BorderLayout());
        gUIPanel.add("Center", gUIPanel2);
        this.fileList = new List(12, false);
        gUIPanel2.add("Center", this.fileList);
        this.fileList.addActionListener(this);
        this.fileList.addItemListener(this);
        this.directoryList = new GUIIconBox(1, 0, "directoryList");
        this.directoryButton = new GUIPopUpButton(this.dirSize, this.directoryList);
        gUIPanel2.add("North", this.directoryButton);
        this.directoryButton.addActionListener(this);
        this.textField = new GUITextField("fileText", 0, 30);
        GUILabelPanel gUILabelPanel = new GUILabelPanel(this.textField, "Selection : ");
        gUILabelPanel.setBehaviour(3);
        gUIPanel2.add("South", gUILabelPanel);
        this.textField.addActionListener(this);
        this.textField.addTextListener(this);
    }

    private void createButtonsPanel(GUIPanel gUIPanel) {
        GUIPanel gUIPanel2 = new GUIPanel(new Dimension(130, -1));
        gUIPanel.add("East", gUIPanel2);
        Dimension dimension = new Dimension(120, 30);
        GUIButton gUIButton = new GUIButton(dimension, "Delete ...");
        gUIPanel2.add(gUIButton);
        gUIButton.addActionListener(this);
        gUIButton = new GUIButton(dimension, "New Folder ...");
        gUIPanel2.add(gUIButton);
        gUIButton.addActionListener(this);
        gUIButton = new GUIButton(dimension, "Login ...");
        gUIPanel2.add(gUIButton);
        gUIButton.addActionListener(this);
        this.cancelButton = this.addExitButton("Cancel", false);
        this.actionButton = this.addExitButton("Open", true);
    }

    public void display() {
        this.dbSockets = this.loginManager.login();
        if (this.dbSockets == null) {
            return;
        }
        this.setDirectory(this.getDirectory());
        super.display();
        this.loginManager.logout(this.dbSockets);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object instanceof List) {
            this.itemStateChanged(null);
            this.exitButtonPressed(this.actionButton);
        }
        if (object instanceof GUIPopUpButton) {
            this.directoryListSelected();
        }
        if (object instanceof GUITextField) {
            this.exitButtonPressed(this.actionButton);
        }
        if (object instanceof GUIButton) {
            String string = actionEvent.getActionCommand();
            if (string.startsWith("New Folder")) {
                this.newFolder();
            }
            if (string.startsWith("Delete")) {
                this.delete();
            }
            if (string.startsWith("Login")) {
                this.login();
            }
        }
        super.actionPerformed(actionEvent);
    }

    public void textValueChanged(TextEvent textEvent) {
        this.setExitButtons();
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        String string = this.fileList.getSelectedItem();
        this.textField.setText(this.getName(string));
        this.setExitButtons();
    }

    public void updateFileList() {
        if (this.dbSockets == null) {
            return;
        }
        String[] stringArray = this.dbSockets.getDirectoryContents(this.currentDirectory);
        if (stringArray == null) {
            return;
        }
        this.fileList.setVisible(false);
        this.fileList.removeAll();
        this.fileList.add("[ Up A Directory.. ]");
        int n = 0;
        while (n < stringArray.length) {
            String string = stringArray[n];
            if (string.startsWith("D")) {
                this.fileList.add("[ " + string.substring(1) + " ]");
            }
            ++n;
        }
        int n2 = 0;
        while (n2 < stringArray.length) {
            String string = stringArray[n2];
            if (string.startsWith("F")) {
                this.fileList.add(string.substring(1));
            }
            ++n2;
        }
        this.fileList.setVisible(true);
    }

    public void updateDirectoryList() {
        this.directoryList.removeAll();
        if (this.dbSockets == null) {
            return;
        }
        String string = this.getSeparator();
        String string2 = String.valueOf(this.currentDirectory) + string + "AnyFile";
        GUIButton gUIButton = null;
        String string3 = "";
        int n = -1;
        do {
            if ((n = string2.indexOf(string)) < 0) continue;
            String string4 = string2.substring(0, n);
            string2 = string2.substring(n + string.length());
            if (!string3.equals("")) {
                string3 = String.valueOf(string3) + string;
            }
            string3 = String.valueOf(string3) + string4;
            gUIButton = new GUIButton(this.dirSize, string4);
            gUIButton.setAlignment(0);
            gUIButton.setName(string3);
            this.directoryList.add(gUIButton);
        } while (n >= 0);
        if (gUIButton != null) {
            this.directoryButton.select(gUIButton, true);
        }
    }

    public void setDirectory(String string) {
        ((Component)this.parent).setCursor(new Cursor(3));
        if (string == null && this.dbSockets != null) {
            string = this.dbSockets.getDirectoryRoot();
        }
        if (string != null) {
            this.currentDirectory = string;
            this.updateFileList();
            this.updateDirectoryList();
        }
        ((Component)this.parent).setCursor(new Cursor(0));
    }

    public String getFile() {
        String string = this.textField.getText();
        if (string.equals("")) {
            return null;
        }
        return string;
    }

    public String getDirectory() {
        if (this.currentDirectory == null) {
            this.setDirectory(null);
        }
        return this.currentDirectory;
    }

    public String getFullFile() {
        return String.valueOf(this.cleanDirectoryName(this.getDirectory())) + this.getFile();
    }

    public String getSeparator() {
        if (this.dbSockets == null) {
            return ":";
        }
        if (this.separator == null) {
            this.separator = this.dbSockets.getSeparator();
        }
        return this.separator;
    }

    public boolean isDirectory(String string) {
        return string.startsWith("[ ") && string.endsWith(" ]");
    }

    public String getName(String string) {
        if (!this.isDirectory(string)) {
            return string;
        }
        String string2 = string.substring(2, string.length() - 2);
        return string2;
    }

    public String cleanDirectoryName(String string) {
        String string2 = new String(string);
        String string3 = this.getSeparator();
        if (string2.endsWith(string3)) {
            string2 = new String(string.substring(0, string.length() - string2.length()));
            string2 = this.cleanDirectoryName(string2);
        }
        string2 = String.valueOf(string2) + string3;
        return string2;
    }

    public String createDirectoryName(String string) {
        if (string == null) {
            string = "";
        }
        string = this.getName(string);
        String string2 = this.cleanDirectoryName(this.currentDirectory);
        if (string.indexOf("..") > 0) {
            int n = string2.lastIndexOf(this.getSeparator());
            if (n > 0) {
                string2 = string2.substring(0, n);
            }
            if ((n = string2.lastIndexOf(this.getSeparator())) > 0) {
                string2 = string2.substring(0, n);
            }
        } else {
            string2 = String.valueOf(string2) + string;
        }
        return string2;
    }

    public void directoryListSelected() {
        String string = this.directoryButton.getSelectedButtonName();
        this.setDirectory(string);
    }

    protected boolean exitButtonPressed(GUIButton gUIButton) {
        if (gUIButton != this.actionButton) {
            return super.exitButtonPressed(gUIButton);
        }
        String string = this.actionButton.getText();
        if (string.equals("Open")) {
            String string2 = "[ " + this.textField.getText() + " ]";
            int n = 0;
            while (n < this.fileList.getItemCount()) {
                String string3 = this.fileList.getItem(n);
                if (string2.equals(string3)) {
                    String string4 = this.createDirectoryName(string3);
                    this.setDirectory(string4);
                }
                this.textField.setText("");
                ++n;
            }
            return false;
        }
        if (string.equals("Save") && !this.confirmOverwrite()) {
            return false;
        }
        if (string.equals("Cancel")) {
            this.textField.setText("");
        }
        return super.exitButtonPressed(gUIButton);
    }

    private void setExitButtons() {
        String string = this.actionButton.getText();
        String string2 = "";
        String string3 = "[ " + this.textField.getText() + " ]";
        int n = 0;
        while (n < this.fileList.getItemCount()) {
            String string4 = this.fileList.getItem(n);
            if (string3.equals(string4)) {
                string2 = "Open";
            }
            ++n;
        }
        if (string2.equals("")) {
            string2 = "Load";
            if (this.mode == 1) {
                string2 = "Save";
            }
        }
        if (!string2.equals(string)) {
            this.actionButton.setText(string2);
            this.actionButton.repaint();
        }
    }

    private boolean confirmOverwrite() {
        String string = this.getFullFile();
        System.out.println("Checking full file " + string);
        if (!this.dbSockets.fileExists(string)) {
            return true;
        }
        GUIAlertBox gUIAlertBox = new GUIAlertBox(this.parent, "File Overwrite Confimation");
        gUIAlertBox.addExitButtons("Save", "Cancel");
        gUIAlertBox.addText("Saving this file will destroy an existing file with the same name");
        gUIAlertBox.addText("Please confirm you action");
        gUIAlertBox.addText(" ");
        gUIAlertBox.display();
        return gUIAlertBox.getExitButton().equals("Save");
    }

    private void delete() {
        String string = this.fileList.getSelectedItem();
        if (string == null) {
            return;
        }
        this.getName(string);
        String string2 = this.getFullFile();
        String string3 = "Delete File";
        if (this.isDirectory(string)) {
            string2 = this.createDirectoryName(string);
            string3 = "Delete Folder";
        }
        GUIAlertBox gUIAlertBox = new GUIAlertBox(this.parent, string3);
        gUIAlertBox.addExitButtons("Delete", "Cancel");
        gUIAlertBox.addText(string3);
        gUIAlertBox.addText(string2);
        gUIAlertBox.display();
        if (gUIAlertBox.getExitButton().equals("Delete")) {
            this.dbSockets.deleteFile(string2);
            this.setDirectory(this.getDirectory());
        }
    }

    private void newFolder() {
        GUIDialogueBox gUIDialogueBox = new GUIDialogueBox(this.parent, "New Folder", false);
        GUIPanel gUIPanel = gUIDialogueBox.getDisplayPanel();
        GUITextField gUITextField = new GUITextField("folder", 0, 30);
        gUIPanel.setSize(new Dimension(400, 100));
        gUIPanel.add(new GUILabelPanel(gUITextField, "Folder Name: "));
        gUIDialogueBox.addExitButtons("Cancel", "OK");
        gUIDialogueBox.display();
        if (gUIDialogueBox.getExitButton().equals("OK")) {
            String string = this.createDirectoryName(gUITextField.getText());
            this.dbSockets.createDirectory(string);
            this.setDirectory(this.getDirectory());
        }
    }

    private void login() {
        this.loginManager.logout(this.dbSockets);
        this.loginManager.display();
        this.exitButtonPressed(this.cancelButton);
    }
}

