/*
 * Decompiled with CFR 0.152.
 */
package emsl.objects;

import java.awt.Dimension;
import java.awt.Toolkit;
import java.io.Serializable;

public class DocumentSize
implements Serializable {
    private int pageWidth;
    private int pageHeight;
    private int topMargin;
    private int bottomMargin;
    private int leftMargin;
    private int rightMargin;
    private int columnTotal;
    private int columnGap;
    private transient int dpi;

    public DocumentSize() {
        this.setPageSize(8500, 11000);
        this.setTopMargin(1000);
        this.setBottomMargin(1000);
        this.setLeftMargin(1000);
        this.setRightMargin(1000);
        this.setColumnTotal(1);
        this.setColumnGap(0);
    }

    public void setPageSize(int n, int n2) {
        this.pageWidth = n;
        this.pageHeight = n2;
    }

    public void setPageSize(Dimension dimension) {
        this.setPageSize(dimension.width, dimension.height);
    }

    public Dimension getPageSize() {
        return new Dimension(this.pageWidth, this.pageHeight);
    }

    public int getPageWidth() {
        return this.pageWidth;
    }

    public int getPageHeight() {
        return this.pageHeight;
    }

    public void setTopMargin(int n) {
        this.topMargin = n;
    }

    public void setBottomMargin(int n) {
        this.bottomMargin = n;
    }

    public void setLeftMargin(int n) {
        this.leftMargin = n;
    }

    public void setRightMargin(int n) {
        this.rightMargin = n;
    }

    public int getTopMargin() {
        return this.topMargin;
    }

    public int getBottomMargin() {
        return this.bottomMargin;
    }

    public int getLeftMargin() {
        return this.leftMargin;
    }

    public int getRightMargin() {
        return this.rightMargin;
    }

    public void setColumnTotal(int n) {
        if (n <= 1) {
            n = 1;
        }
        this.columnTotal = n;
    }

    public void setColumnGap(int n) {
        this.columnGap = n;
    }

    public int getColumnTotal() {
        return this.columnTotal;
    }

    public int getColumnGap() {
        return this.columnGap;
    }

    public int getDPI() {
        if (this.dpi <= 0) {
            Toolkit toolkit = Toolkit.getDefaultToolkit();
            this.dpi = toolkit.getScreenResolution();
        }
        return this.dpi;
    }

    public int toPixels(int n) {
        return n * this.getDPI() / 1000;
    }

    public int toInch(int n) {
        return n * 1000 / this.getDPI();
    }

    public Object clone() {
        DocumentSize documentSize = new DocumentSize();
        documentSize.setPageSize(this.getPageSize());
        documentSize.setTopMargin(this.getTopMargin());
        documentSize.setBottomMargin(this.getBottomMargin());
        documentSize.setLeftMargin(this.getLeftMargin());
        documentSize.setRightMargin(this.getRightMargin());
        documentSize.setColumnTotal(this.getColumnTotal());
        documentSize.setColumnGap(this.getColumnGap());
        return documentSize;
    }
}

