/*
 * Decompiled with CFR 0.152.
 */
package emsl.objects;

import emsl.objects.ReferenceStyle;
import emsl.objects.TextStyle;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Vector;

public class DocumentStyle
implements Serializable {
    private String styleName;
    private Vector textStyles;
    private ReferenceStyle referenceStyle;
    private boolean isReadOnly;

    public DocumentStyle() {
        this.setStyleName("Default Style");
        this.initializeTextStyles();
        this.referenceStyle = new ReferenceStyle();
        this.setReadOnly(false);
    }

    public DocumentStyle(String string) {
        this();
        this.setStyleName(string);
    }

    public Object clone() {
        Serializable serializable;
        DocumentStyle documentStyle = new DocumentStyle();
        documentStyle.setStyleName(this.getStyleName());
        TextStyle textStyle = this.getTextStyle("Base Text Style");
        TextStyle textStyle2 = null;
        if (textStyle != null) {
            textStyle2 = (TextStyle)textStyle.clone();
            documentStyle.setTextStyle(textStyle2);
        }
        Enumeration enumeration = this.textStyles.elements();
        while (enumeration.hasMoreElements()) {
            serializable = (TextStyle)enumeration.nextElement();
            TextStyle textStyle3 = (TextStyle)((TextStyle)serializable).clone();
            if (((TextStyle)serializable).getBaseStyle() == null) continue;
            textStyle3.setBaseStyle(textStyle2);
            documentStyle.setTextStyle(textStyle3);
        }
        serializable = (ReferenceStyle)this.referenceStyle.clone();
        documentStyle.setReferenceStyle((ReferenceStyle)serializable);
        documentStyle.setReadOnly(this.isReadOnly());
        return documentStyle;
    }

    private void initializeTextStyles() {
        this.textStyles = new Vector();
        TextStyle textStyle = new TextStyle("Base Text Style");
        this.setTextStyle(textStyle);
        TextStyle textStyle2 = new TextStyle("Body Text", textStyle);
        this.setTextStyle(textStyle2);
        textStyle2 = new TextStyle("Title, Main Heading", textStyle);
        textStyle2.setAlignment(3);
        textStyle2.setFontSize(18);
        this.setTextStyle(textStyle2);
        textStyle2 = new TextStyle("Title, Sub Heading", textStyle);
        textStyle2.setAlignment(3);
        textStyle2.setFontSize(16);
        this.setTextStyle(textStyle2);
        textStyle2 = new TextStyle("Title, Author", textStyle);
        textStyle2.setAlignment(3);
        textStyle2.setFontStyle(1);
        textStyle2.setFontSize(14);
        this.setTextStyle(textStyle2);
        textStyle2 = new TextStyle("Title, Address", textStyle);
        textStyle2.setAlignment(3);
        textStyle2.setFontStyle(2);
        this.setTextStyle(textStyle2);
        textStyle2 = new TextStyle("Abstract", textStyle);
        textStyle2.setAlignment(4);
        textStyle2.setFontSize(10);
        this.setTextStyle(textStyle2);
        textStyle2 = new TextStyle("Paragraph Heading", textStyle);
        textStyle2.setFontSize(14);
        this.setTextStyle(textStyle2);
        textStyle2 = new TextStyle("Figure Text", textStyle);
        textStyle2.setAlignment(3);
        textStyle2.setFontStyle(2);
        this.setTextStyle(textStyle2);
        textStyle2 = new TextStyle("Reference InLine Marker", textStyle);
        this.setTextStyle(textStyle2);
        textStyle2 = new TextStyle("Reference", textStyle);
        this.setTextStyle(textStyle2);
        textStyle2 = new TextStyle("User Defined 1", textStyle);
        this.setTextStyle(textStyle2);
        textStyle2 = new TextStyle("User Defined 2", textStyle);
        this.setTextStyle(textStyle2);
        textStyle2 = new TextStyle("User Defined 3", textStyle);
        this.setTextStyle(textStyle2);
    }

    public void setStyleName(String string) {
        if (this.isReadOnly()) {
            return;
        }
        if (string == null) {
            string = "NoName";
        }
        this.styleName = string;
    }

    public void setTextStyle(TextStyle textStyle) {
        if (this.isReadOnly()) {
            return;
        }
        TextStyle textStyle2 = this.getTextStyle(textStyle.getStyleName());
        if (textStyle2 != null) {
            this.textStyles.removeElement(textStyle2);
        }
        this.textStyles.addElement(textStyle);
    }

    public void setReferenceStyle(ReferenceStyle referenceStyle) {
        if (this.isReadOnly()) {
            return;
        }
        this.referenceStyle = referenceStyle;
    }

    public String getStyleName() {
        return this.styleName;
    }

    public TextStyle getTextStyle() {
        return this.getTextStyle("Body Text");
    }

    public TextStyle getTextStyle(String string) {
        if (string == null) {
            return null;
        }
        String[] stringArray = this.getTextStyleNames();
        int n = 0;
        while (n < stringArray.length) {
            if (stringArray[n].equals(string)) {
                return (TextStyle)this.textStyles.elementAt(n);
            }
            ++n;
        }
        return null;
    }

    public String[] getTextStyleNames() {
        String[] stringArray = new String[this.textStyles.size()];
        Enumeration enumeration = this.textStyles.elements();
        int n = 0;
        while (enumeration.hasMoreElements()) {
            TextStyle textStyle = (TextStyle)enumeration.nextElement();
            if (textStyle == null) continue;
            stringArray[n++] = textStyle.getStyleName();
        }
        return stringArray;
    }

    public ReferenceStyle getReferenceStyle() {
        return this.referenceStyle;
    }

    public void setReadOnly(boolean bl) {
        this.isReadOnly = bl;
    }

    public boolean isReadOnly() {
        return this.isReadOnly;
    }
}

