/*
 * Decompiled with CFR 0.152.
 */
package emsl.protocol.internal;

import java.awt.Image;
import java.awt.Toolkit;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import sun.awt.image.ByteArrayImageSource;

public class InternalConnection
extends URLConnection {
    private String resourceName;
    private static ClassLoader classLoader = null;
    private boolean debug = false;

    public InternalConnection(URL uRL) throws MalformedURLException, IOException {
        super(uRL);
        if (this.debug) {
            System.out.println("At InternalHashtable Connection constructor");
        }
        if (this.debug) {
            System.out.println("ClassLoader =" + classLoader);
        }
        this.resourceName = uRL.getFile();
        if (this.resourceName.startsWith("/")) {
            this.resourceName = this.resourceName.substring(1);
        }
        if (this.debug) {
            System.out.println("  Argument URL = " + uRL);
        }
        if (this.debug) {
            System.out.println("  Extracted Table Entry = " + this.resourceName);
        }
    }

    public static void setClassLoader(ClassLoader classLoader) {
        InternalConnection.classLoader = classLoader;
    }

    public void connect() throws IOException {
    }

    public Object getContent() throws IOException {
        InputStream inputStream = this.getInputStream();
        if (inputStream == null) {
            if (this.debug) {
                System.out.println("Get content not found " + this.resourceName);
            }
            return null;
        }
        byte[] byArray = new byte[inputStream.available()];
        inputStream.read(byArray);
        try {
            Toolkit toolkit = Toolkit.getDefaultToolkit();
            Image image = toolkit.createImage(byArray);
            if (image != null) {
                if (this.debug) {
                    System.out.println("Data is image " + this.resourceName);
                }
                if (this.debug) {
                    System.out.println("NOTE: InternalConnection.class is using Sun.awt.image package");
                }
                return new ByteArrayImageSource(byArray);
            }
        }
        catch (Exception exception) {}
        if (this.debug) {
            System.out.println("Get content is returning data");
        }
        return new ByteArrayInputStream(byArray);
    }

    public InputStream getInputStream() throws IOException {
        if (classLoader != null) {
            return classLoader.getResourceAsStream(this.resourceName);
        }
        return null;
    }
}

