/*
 * Decompiled with CFR 0.152.
 */
package emsl.system;

import emsl.system.UndoAction;
import emsl.system.UndoClient;
import emsl.system.UndoGroup;
import java.util.Stack;
import java.util.Vector;

public class UndoManager {
    private static final int UNDO_STACK_SIZE = 200;
    private transient Stack undoList;
    private transient Stack redoList;

    public UndoManager(String string) {
        this.resetUndo();
    }

    public void resetUndo() {
        this.undoList = new Stack();
        this.redoList = new Stack();
    }

    public boolean isUndoable() {
        UndoGroup undoGroup = this.getUndoGroup();
        return undoGroup != null;
    }

    public boolean isUndoable(UndoClient undoClient) {
        UndoGroup undoGroup = this.getUndoGroup();
        if (undoGroup == null) {
            return false;
        }
        UndoClient undoClient2 = undoGroup.getUndoClient();
        return undoClient == undoClient2;
    }

    public boolean isRedoable() {
        UndoGroup undoGroup = this.getRedoGroup();
        return undoGroup != null;
    }

    public boolean isRedoable(UndoClient undoClient) {
        UndoGroup undoGroup = this.getRedoGroup();
        if (undoGroup == null) {
            return false;
        }
        UndoClient undoClient2 = undoGroup.getUndoClient();
        return undoClient == undoClient2;
    }

    public String getUndoName() {
        UndoGroup undoGroup = this.getUndoGroup();
        if (undoGroup == null) {
            return null;
        }
        return undoGroup.getGroupName();
    }

    public String getUndoMenuLabel() {
        String string = this.getUndoName();
        if (string == null) {
            return "Undo Not Available";
        }
        return "Undo " + string;
    }

    public String getRedoName() {
        UndoGroup undoGroup = this.getRedoGroup();
        if (undoGroup == null) {
            return null;
        }
        return undoGroup.getGroupName();
    }

    public String getRedoMenuLabel() {
        String string = this.getRedoName();
        if (string == null) {
            return "Redo Not Available";
        }
        return "Redo " + string;
    }

    public void undo() {
        try {
            UndoGroup undoGroup = (UndoGroup)this.undoList.pop();
            UndoClient undoClient = undoGroup.getUndoClient();
            Vector vector = undoGroup.getActionList();
            int n = vector.size() - 1;
            while (n >= 0) {
                UndoAction undoAction = undoGroup.getUndoAction(n);
                if (undoAction != null) {
                    undoClient.undo(undoAction);
                }
                --n;
            }
            this.redoList.push(undoGroup);
            return;
        }
        catch (Exception exception) {
            return;
        }
    }

    public void redo() {
        try {
            UndoGroup undoGroup = (UndoGroup)this.redoList.pop();
            UndoClient undoClient = undoGroup.getUndoClient();
            Vector vector = undoGroup.getActionList();
            int n = 0;
            while (n < vector.size()) {
                UndoAction undoAction = undoGroup.getUndoAction(n);
                if (undoAction != null) {
                    undoClient.redo(undoAction);
                }
                ++n;
            }
            this.undoList.push(undoGroup);
            return;
        }
        catch (Exception exception) {
            return;
        }
    }

    private UndoGroup getUndoGroup() {
        try {
            UndoGroup undoGroup = (UndoGroup)this.undoList.peek();
            return undoGroup;
        }
        catch (Exception exception) {
            return null;
        }
    }

    private UndoGroup getRedoGroup() {
        try {
            UndoGroup undoGroup = (UndoGroup)this.redoList.peek();
            return undoGroup;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public void setUndo(UndoGroup undoGroup) {
        try {
            this.undoList.push(undoGroup);
            if (this.undoList.size() > 200) {
                this.undoList.removeElementAt(0);
            }
            if (this.redoList.size() != 0) {
                this.redoList = new Stack();
                return;
            }
        }
        catch (Exception exception) {}
    }
}

