/*
 * Decompiled with CFR 0.152.
 */
package emsl.text;

import emsl.awt.GUIIcon;
import emsl.inch.BeanPanel;
import emsl.system.UndoAction;
import emsl.system.UndoClient;
import emsl.system.UndoGroup;
import emsl.text.TextPanel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Menu;
import java.awt.MenuItem;
import java.awt.Point;
import java.awt.PopupMenu;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;

public class EditPanel
extends BeanPanel
implements UndoClient,
ActionListener,
MouseListener,
MouseMotionListener {
    private transient GUIIcon resizeIcon = this.initializeIcon("resize.gif", 5);
    private transient GUIIcon menuIcon = this.initializeIcon("menu.gif", 0);
    private transient PopupMenu popUpMenu = new PopupMenu("Options");
    private transient MenuItem undoMenuItem;
    private transient MenuItem redoMenuItem;
    private transient TextPanel textPanel;
    private transient Point clickXY;
    private transient boolean boxOn;
    private transient Rectangle boxBounds;

    public EditPanel() {
        this.popUpMenuCreate();
        this.menuIcon.add(this.popUpMenu);
        this.setLayout(new BorderLayout());
        this.setEditing(true);
        this.textPanel = null;
        this.boxOn = false;
        this.boxBounds = new Rectangle();
        this.addMouseMotionListener(this);
        this.setCursor(new Cursor(0));
        this.setComponent(null);
        this.setBorder(0);
    }

    private GUIIcon initializeIcon(String string, int n) {
        GUIIcon gUIIcon = new GUIIcon(new Dimension(20, 20));
        gUIIcon.setImage(this.getClass(), null, string);
        gUIIcon.setBorder(1);
        gUIIcon.setBackground(Color.lightGray);
        gUIIcon.setCursor(new Cursor(n));
        gUIIcon.addMouseListener(this);
        gUIIcon.addMouseMotionListener(this);
        this.add(gUIIcon);
        return gUIIcon;
    }

    public void popUpMenuCreate() {
        String[] stringArray = this.getEditOptions();
        if (stringArray != null) {
            int n = 0;
            while (n < stringArray.length) {
                this.addMenuItem(this.popUpMenu, stringArray[n]);
                ++n;
            }
            this.addMenuSeparator();
        }
        this.popUpMenuAddClipboard();
    }

    public void popUpMenuAddClipboard() {
        this.undoMenuItem = this.addMenuItem(this.popUpMenu, "Undo");
        this.redoMenuItem = this.addMenuItem(this.popUpMenu, "Redo");
        this.addMenuSeparator();
        this.addMenuItem(this.popUpMenu, "Cut");
        this.addMenuItem(this.popUpMenu, "Copy");
        this.addMenuItem(this.popUpMenu, "Delete");
    }

    public MenuItem addMenuItem(Menu menu, String string) {
        if (menu == null) {
            menu = this.popUpMenu;
        }
        MenuItem menuItem = new MenuItem(string);
        menuItem.addActionListener(this);
        menu.add(menuItem);
        return menuItem;
    }

    public void addMenu(Menu menu) {
        this.popUpMenu.add(menu);
    }

    public void addMenuSeparator() {
        this.popUpMenu.addSeparator();
    }

    public void setEditing(boolean bl) {
        this.resizeIcon.setVisible(bl);
        this.menuIcon.setVisible(bl);
        this.positionHandles(null);
    }

    public boolean isEditing() {
        return this.resizeIcon.isVisible();
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        if (this.clickXY != null) {
            this.endResize();
            this.clickXY = null;
        }
    }

    public void mousePressed(MouseEvent mouseEvent) {
        if (this.clickXY != null) {
            return;
        }
        Object object = mouseEvent.getSource();
        if (object == this.menuIcon) {
            this.textPanel = this.getTextPanel();
            if (this.textPanel == null) {
                return;
            }
            boolean bl = this.textPanel.getTextUndo().getUndoManager().isUndoable(this);
            this.undoMenuItem.setEnabled(bl);
            bl = this.textPanel.getTextUndo().getUndoManager().isRedoable(this);
            this.redoMenuItem.setEnabled(bl);
            this.popUpMenu.show(this.menuIcon, mouseEvent.getX(), mouseEvent.getY());
        }
        if (object == this.resizeIcon) {
            this.clickXY = mouseEvent.getPoint();
            Point point = mouseEvent.getComponent().getLocationOnScreen();
            this.clickXY.x += point.x;
            this.clickXY.y += point.y;
            this.startResize();
        }
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        if (this.clickXY == null) {
            return;
        }
        Point point = mouseEvent.getComponent().getLocationOnScreen();
        Point point2 = mouseEvent.getPoint();
        point2.x += point.x;
        point2.y += point.y;
        Point point3 = new Point(point2.x - this.clickXY.x, point2.y - this.clickXY.y);
        this.resizePanel(point3, mouseEvent.isShiftDown());
    }

    public void mouseMoved(MouseEvent mouseEvent) {
        if (this.clickXY != null) {
            if (mouseEvent.getSource() == this.resizeIcon) {
                return;
            }
            this.endResize();
            this.clickXY = null;
        }
    }

    private void resizePanel(Point point, boolean bl) {
        if (this.boxOn) {
            this.drawBox();
        }
        this.boxOn = false;
        this.boxBounds = this.getScaledPixelBounds();
        int n = this.boxBounds.width + point.x;
        int n2 = this.boxBounds.height + point.y;
        n = Math.max(40, n);
        n2 = Math.max(5, n2);
        if (this.textPanel != null) {
            Dimension dimension = this.textPanel.getSize();
            if (this.boxBounds.x + n >= dimension.width - 2) {
                n = dimension.width - this.boxBounds.x - 2;
            }
            if (this.boxBounds.y + n2 >= dimension.height - 2) {
                n2 = dimension.height - this.boxBounds.y - 2;
            }
        }
        if (bl) {
            n2 = n = Math.min(n, n2);
        }
        this.boxBounds.width = n;
        this.boxBounds.height = n2;
        if (!this.boxOn) {
            this.drawBox();
        }
        this.boxOn = true;
    }

    public void positionHandles(Rectangle rectangle) {
        if (rectangle == null) {
            rectangle = this.getBounds();
        }
        Point point = this.menuIcon.getLocation();
        if (point.x != 1 || point.y != 1) {
            this.menuIcon.setLocation(1, 1);
        }
        Rectangle rectangle2 = this.resizeIcon.getBounds();
        int n = rectangle.width - rectangle2.width - 1;
        int n2 = rectangle.height - rectangle2.height - 1;
        if (rectangle2.x != n || rectangle2.y != n2) {
            this.resizeIcon.setLocation(n, n2);
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (this.getTextPanel() == null) {
            return;
        }
        if (string.equals("Undo")) {
            this.textPanel.getTextUndo().getUndoManager().undo();
        }
        if (string.equals("Redo")) {
            this.textPanel.getTextUndo().getUndoManager().redo();
        }
        if (string.equals("Cut") || string.equals("Copy") || string.equals("Delete")) {
            int n = this.textPanel.getTextData().getCharacterIndex(this);
            if (n < 0) {
                return;
            }
            this.textPanel.getTextSelector().setSelection(n, n);
            this.textPanel.getTextClipboard().actionPerformed(actionEvent);
            this.textPanel.repaint();
            this.textPanel.sendActionEvent("UpdateMenus");
        }
        this.setEditOption(string);
    }

    public void paint(Graphics graphics) {
        this.positionHandles(null);
        super.paint(graphics);
    }

    private void boxOn() {
        if (!this.boxOn) {
            this.drawBox();
        }
        this.boxOn = true;
    }

    private void boxOff() {
        if (this.boxOn) {
            this.drawBox();
        }
        this.boxOn = false;
    }

    private void drawBox() {
        Rectangle rectangle = this.getScaledPixelBounds();
        if (this.boxBounds.width == rectangle.width && this.boxBounds.height == rectangle.height) {
            return;
        }
        Graphics graphics = this.getGraphics();
        if (graphics != null) {
            graphics.setColor(Color.black);
            graphics.setXORMode(Color.white);
            graphics.drawRect(0, 0, this.boxBounds.width, this.boxBounds.height);
        }
        if (this.textPanel != null && (graphics = this.textPanel.getGraphics()) != null) {
            graphics.setColor(Color.black);
            graphics.setXORMode(Color.white);
            graphics.drawRect(this.boxBounds.x, this.boxBounds.y, this.boxBounds.width, this.boxBounds.height);
        }
    }

    private void endResize() {
        if (this.boxOn) {
            this.drawBox();
        }
        this.boxOn = false;
        Rectangle rectangle = new Rectangle(this.getInchBounds());
        this.setScaledPixelBounds(this.boxBounds);
        this.updateSize();
        this.setComponentVisible(true);
        if (this.getTextPanel() == null) {
            return;
        }
        this.textPanel.setEditable(2);
        int n = this.textPanel.getTextData().getCharacterIndex(this);
        if (n < 0) {
            return;
        }
        UndoGroup undoGroup = new UndoGroup(this, "Resize Object");
        UndoAction undoAction = new UndoAction("Resize Object");
        undoAction.setUndoData("OldBounds", rectangle);
        undoAction.setUndoData("NewBounds", new Rectangle(this.getInchBounds()));
        undoGroup.setUndoAction(undoAction);
        this.textPanel.getTextUndo().getUndoManager().setUndo(undoGroup);
        this.textPanel.layoutAfterChange(n);
        this.textPanel.sendActionEvent("Update Menus");
    }

    private void startResize() {
        this.addTextPanelListeners();
        this.setComponentVisible(false);
        this.boxBounds = this.getScaledPixelBounds();
        if (!this.boxOn) {
            this.drawBox();
        }
        this.boxOn = true;
        if (this.getTextPanel() == null) {
            return;
        }
        this.textPanel.setEditable(0);
    }

    public void undo(UndoAction undoAction) {
        String string = undoAction.getUndoName();
        if (!string.equals("Resize Object")) {
            return;
        }
        this.textPanel = this.getTextPanel();
        if (this.getTextPanel() == null) {
            return;
        }
        Rectangle rectangle = (Rectangle)undoAction.getUndoData("OldBounds");
        this.setInchBounds(rectangle);
        this.updateBounds();
        int n = this.textPanel.getTextData().getCharacterIndex(this);
        if (n < 0) {
            return;
        }
        this.textPanel.layoutAfterChange(n - 1);
    }

    public void redo(UndoAction undoAction) {
        String string = undoAction.getUndoName();
        if (!string.equals("Resize Object")) {
            return;
        }
        if (this.getTextPanel() == null) {
            return;
        }
        Rectangle rectangle = (Rectangle)undoAction.getUndoData("NewBounds");
        this.setInchBounds(rectangle);
        this.updateBounds();
        int n = this.textPanel.getTextData().getCharacterIndex(this);
        if (n < 0) {
            return;
        }
        this.textPanel.layoutAfterChange(n - 1);
    }

    private void setComponentVisible(boolean bl) {
        int n = 0;
        while (n < this.getComponentCount()) {
            Component component = this.getComponent(n);
            if (component != this.resizeIcon && component != this.menuIcon) {
                component.setVisible(bl);
            }
            ++n;
        }
    }

    private TextPanel getTextPanel() {
        this.textPanel = null;
        Container container = this.getParent();
        if (container == null) {
            System.out.println("Error : Could not find parent TextPanel of Component ");
            System.out.println("This = " + this);
            return null;
        }
        if (!(container instanceof TextPanel)) {
            System.out.println("Error : Parent of Component is not a TextPanel ");
            System.out.println("Parent = " + container);
            return null;
        }
        this.textPanel = (TextPanel)container;
        return this.textPanel;
    }

    private void addTextPanelListeners() {
        TextPanel textPanel = this.textPanel;
        this.getTextPanel();
        if (this.textPanel == null) {
            return;
        }
        if (this.textPanel == textPanel) {
            return;
        }
        this.textPanel.addMouseMotionListener(this);
        this.textPanel.addMouseListener(this);
    }

    public void copyAttributes(EditPanel editPanel) {
        super.copyAttributes(editPanel);
        editPanel.setEditing(this.isEditing());
    }

    public Object clone() {
        EditPanel editPanel = new EditPanel();
        this.copyAttributes(editPanel);
        return editPanel;
    }
}

