/*
 * Decompiled with CFR 0.152.
 */
package emsl.text;

import emsl.text.TextLine;
import emsl.text.TextObject;
import emsl.text.TextPanel;
import emsl.text.TextWord;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import java.util.Vector;

public class TextSelector {
    public static final int START = 0;
    public static final int END = 1;
    public static final int SELECTION_OFF = -1;
    private TextPanel textPanel;
    private int selectionStart;
    private int selectionEnd;
    private boolean isPainted;
    private Color selectionColor;

    public TextSelector(TextPanel textPanel) {
        this.textPanel = textPanel;
        this.isPainted = false;
        this.selectionOff();
        this.setSelectionColor(Color.green);
    }

    public void selectionOff() {
        this.setSelection(-1, -1);
    }

    public void setSelection(int n, int n2) {
        this.setSelectionStart(n);
        this.setSelectionEnd(n2);
    }

    public void setSelectionStart(int n) {
        if (n == this.selectionStart) {
            return;
        }
        if (this.isPainted) {
            this.paint();
        }
        if (n != -1) {
            if (n > this.textPanel.getTextData().getSize() - 2) {
                n = this.textPanel.getTextData().getSize() - 2;
            }
            if (n <= 1) {
                n = 1;
            }
        }
        this.selectionStart = n;
        this.paint();
    }

    public void setSelectionEnd(int n) {
        if (n == this.selectionEnd) {
            return;
        }
        if (this.isPainted) {
            this.paint();
        }
        if (n != -1) {
            if (n > this.textPanel.getTextData().getSize() - 2) {
                n = this.textPanel.getTextData().getSize() - 2;
            }
            if (n <= 1) {
                n = 1;
            }
        }
        this.selectionEnd = n;
        this.paint();
    }

    public void setSelectionStart(int n, int n2) {
        this.setSelectionStart(this.textPanel.getCharacterAt(n, n2));
    }

    public void setSelectionEnd(int n, int n2) {
        this.setSelectionEnd(this.textPanel.getCharacterAt(n, n2));
    }

    public void selectWord(int n) {
        this.setSelectionStart(this.getWordBoundary(n, 0));
        this.setSelectionEnd(this.getWordBoundary(n, 1));
    }

    public void selectWord(int n, int n2) {
        this.selectWord(this.textPanel.getCharacterAt(n, n2));
    }

    public int getWordBoundary(int n, int n2) {
        Vector vector = this.textPanel.getLineList();
        TextLine textLine = (TextLine)TextObject.getObject(vector, n);
        if (textLine == null) {
            return n;
        }
        Vector vector2 = textLine.getWordList();
        TextWord textWord = (TextWord)TextObject.getObject(vector2, n);
        if (textWord == null) {
            return n;
        }
        if (n2 == 1) {
            return textWord.getEndIndex();
        }
        int n3 = textWord.getStartIndex();
        if (this.textPanel.getTextData().isBreak(n3)) {
            ++n3;
        }
        return n3;
    }

    public void selectLine(int n) {
        this.setSelectionStart(this.getLineBoundary(n, 0));
        this.setSelectionEnd(this.getLineBoundary(n, 1));
    }

    public void selectLine(int n, int n2) {
        this.selectLine(this.textPanel.getCharacterAt(n, n2));
    }

    public int getLineBoundary(int n, int n2) {
        Vector vector = this.textPanel.getLineList();
        TextLine textLine = (TextLine)TextObject.getObject(vector, n);
        if (textLine == null) {
            return n;
        }
        if (n2 == 0) {
            return textLine.getStartIndex();
        }
        return textLine.getEndIndex();
    }

    public void selectParagraph(int n) {
        this.setSelectionStart(this.getParagraphBoundary(n, 0) + 1);
        this.setSelectionEnd(this.getParagraphBoundary(n, 1));
    }

    public void selectParagraph(int n, int n2) {
        this.selectParagraph(this.textPanel.getCharacterAt(n, n2));
    }

    public int getParagraphBoundary(int n, int n2) {
        TextLine textLine = null;
        Vector vector = this.textPanel.getLineList();
        int n3 = TextObject.getObjectIndex(vector, n);
        do {
            if ((textLine = (TextLine)TextObject.getObjectAt(vector, n3)) == null) {
                return n;
            }
            if (n2 == 0) {
                if (textLine.isParagraphStart() || n3 == 0) break;
                --n3;
                continue;
            }
            if (textLine.isParagraphEnd() || n3 == vector.size() - 1) break;
            ++n3;
        } while (textLine != null);
        if (n2 == 0) {
            return textLine.getStartIndex();
        }
        return textLine.getEndIndex();
    }

    public void selectAll() {
        this.setSelectionStart(0);
        this.setSelectionEnd(this.textPanel.getTextData().getSize() - 1);
    }

    public int getSelectionStart() {
        return this.selectionStart;
    }

    public int getSelectionEnd() {
        return this.selectionEnd;
    }

    public boolean isSelected() {
        if (this.getSelectionStart() == -1) {
            return false;
        }
        return this.getSelectionEnd() != -1;
    }

    public void setSelectionColor(Color color) {
        if (this.isPainted) {
            this.paint();
        }
        this.selectionColor = color;
        this.paint();
    }

    public void paintNew() {
        this.isPainted = false;
        this.paint();
    }

    public void paint() {
        if (!this.isSelected()) {
            return;
        }
        int n = Math.min(this.getSelectionStart(), this.getSelectionEnd());
        int n2 = Math.max(this.getSelectionStart(), this.getSelectionEnd());
        n = Math.max(n, this.textPanel.getTextDataStart());
        n2 = Math.min(n2, this.textPanel.getTextDataEnd());
        Rectangle rectangle = this.textPanel.getCharacterBounds(n);
        Rectangle rectangle2 = this.textPanel.getCharacterBounds(n2);
        if (rectangle == null || rectangle2 == null) {
            return;
        }
        Graphics graphics = this.textPanel.getGraphicsContext();
        if (graphics == null) {
            return;
        }
        if (this.selectionColor == null) {
            return;
        }
        graphics.setXORMode(this.selectionColor);
        graphics.setColor(this.textPanel.getBackground());
        Rectangle rectangle3 = this.textPanel.getScaledPixelBounds();
        Insets insets = this.textPanel.getInsets();
        rectangle3.x = insets.left;
        rectangle3.y = insets.top;
        rectangle3.width = rectangle3.width - insets.left - insets.right;
        rectangle3.height = rectangle3.height - insets.top - insets.bottom;
        graphics.setClip(rectangle3);
        Rectangle rectangle4 = this.paintTopBlock(graphics, rectangle, rectangle2);
        Rectangle rectangle5 = this.paintBottomBlock(graphics, rectangle, rectangle2, rectangle4);
        this.paintMiddleBlock(graphics, rectangle4, rectangle5);
        graphics.setPaintMode();
        if (this.isPainted) {
            this.isPainted = false;
            return;
        }
        this.isPainted = true;
    }

    private Rectangle paintTopBlock(Graphics graphics, Rectangle rectangle, Rectangle rectangle2) {
        int n = rectangle.y + rectangle.height;
        int n2 = this.textPanel.getPixelBounds().width;
        if (rectangle.y == rectangle2.y) {
            n2 = rectangle2.x + rectangle2.width;
        }
        Rectangle rectangle3 = this.scaleBlock(rectangle.x, rectangle.y, n2, n);
        graphics.fillRect(rectangle3.x, rectangle3.y, rectangle3.width, rectangle3.height);
        if (rectangle.y == rectangle2.y) {
            return null;
        }
        return rectangle3;
    }

    private Rectangle paintBottomBlock(Graphics graphics, Rectangle rectangle, Rectangle rectangle2, Rectangle rectangle3) {
        if (rectangle3 == null) {
            return null;
        }
        Rectangle rectangle4 = this.scaleBlock(0, rectangle2.y, rectangle2.x + rectangle2.width, rectangle2.y + rectangle2.height);
        if (rectangle3.y + rectangle3.height >= rectangle4.y) {
            int n = rectangle3.y + rectangle3.height - rectangle4.y;
            rectangle4.y += n;
            rectangle4.height -= n;
        }
        graphics.fillRect(rectangle4.x, rectangle4.y, rectangle4.width, rectangle4.height);
        return rectangle4;
    }

    private Rectangle paintMiddleBlock(Graphics graphics, Rectangle rectangle, Rectangle rectangle2) {
        if (rectangle == null || rectangle2 == null) {
            return null;
        }
        int n = rectangle2.y - (rectangle.y + rectangle.height);
        if (n > 0) {
            int n2 = this.textPanel.getScaledPixelBounds().width;
            Rectangle rectangle3 = new Rectangle(0, rectangle.y + rectangle.height, n2, n);
            graphics.fillRect(rectangle3.x, rectangle3.y, rectangle3.width, rectangle3.height);
            return rectangle3;
        }
        return null;
    }

    private Rectangle scaleBlock(int n, int n2, int n3, int n4) {
        int n5 = this.textPanel.getViewScale();
        int n6 = (n3 - n) * n5 / 100;
        int n7 = (n4 - n2) * n5 / 100;
        n = n * n5 / 100;
        n2 = n2 * n5 / 100;
        return new Rectangle(n, n2, n6, n7);
    }
}

