/*
 * Decompiled with CFR 0.152.
 */
package emsl.text;

import emsl.inch.ComponentPanel;
import emsl.inch.InchPanel;
import emsl.objects.FontPlus;
import emsl.objects.TextStyle;
import emsl.text.TextData;
import emsl.text.TextLine;
import emsl.text.TextObject;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.io.Serializable;

public class TextWord
extends TextObject {
    private Object object;
    private TextLine textLine;
    private boolean isEmpty;
    private boolean isFirstWord;
    private int hiddenLetterWidth = 3;

    public TextWord(TextData textData, TextLine textLine, int n, boolean bl) {
        super(textData, n);
        this.isFirstWord = bl;
        this.textLine = textLine;
        this.setStartIndex(n);
        this.isEmpty = true;
        this.extractData();
        this.calculateBounds();
    }

    public int getFlowCoordinate() {
        return this.getX();
    }

    public int getStartIndex() {
        int n = 0;
        if (this.textLine != null) {
            n = this.textLine.getStartIndex();
        }
        return super.getStartIndex() + n;
    }

    public void setStartIndex(int n) {
        int n2 = 0;
        if (this.textLine != null) {
            n2 = this.textLine.getStartIndex();
        }
        super.setStartIndex(n - n2);
    }

    public String getString() {
        if (this.object instanceof String) {
            return (String)this.object;
        }
        return null;
    }

    public String getDisplayString() {
        String string = this.getString();
        if (string == null) {
            return null;
        }
        if (this.isFirstWord && this.getTextData().isBreak(this.getStartIndex()) && true) {
            return string.substring(1);
        }
        return string;
    }

    private boolean isFirstCharacterHidden() {
        return this.isFirstWord && this.getTextData().isBreak(this.getStartIndex());
    }

    public boolean isTab() {
        return this.getTextData().isTab(this.getStartIndex());
    }

    public boolean isComponent() {
        return this.object instanceof ComponentPanel;
    }

    public ComponentPanel getComponent() {
        if (this.isComponent()) {
            return (ComponentPanel)this.object;
        }
        return null;
    }

    public boolean isEmpty() {
        return this.isEmpty;
    }

    public boolean isSplitable() {
        int n = this.getEndIndex() + 1;
        if (this.getTextData().isBreak(n)) {
            return true;
        }
        if (this.getTextData().isComponent(n)) {
            return true;
        }
        if (this.getTextData().isComponent(n - 1)) {
            return true;
        }
        if (this.isTab()) {
            return true;
        }
        return this.getWidthIndex() >= 12;
    }

    private void extractData() {
        if (this.getTextData() == null) {
            return;
        }
        String string = this.getTextData().getWord(this.getStartIndex());
        if (string == null) {
            return;
        }
        if (string.length() <= 0) {
            return;
        }
        this.isEmpty = false;
        this.setWidthIndex(string.length());
        this.setTextStyle(this.getTextData().getTextStyle(this.getStartIndex()));
        this.object = string;
        if (string.charAt(0) == '\u0001') {
            this.object = this.getTextData().getComponent(this.getStartIndex());
        }
    }

    public void calculateBounds() {
        if (this.isComponent()) {
            this.calculateComponentBounds();
            return;
        }
        this.calculateStringBounds();
    }

    private void calculateComponentBounds() {
        ComponentPanel componentPanel = this.getComponent();
        Rectangle rectangle = componentPanel.getPixelBounds();
        this.setWidth(rectangle.width + 2);
        this.setAscent(rectangle.height + 2);
        FontMetrics fontMetrics = this.getTextStyle().getFontMetrics();
        this.setDescent(fontMetrics.getDescent());
        this.setLineSpace(fontMetrics.getLeading());
    }

    private void calculateStringBounds() {
        String string = this.getDisplayString();
        if (string == null) {
            return;
        }
        FontPlus fontPlus = this.getTextStyle().getFontPlus();
        this.setWidth(fontPlus.getWidth(string));
        if (this.isFirstWord && this.getTextData().isBreak(this.getStartIndex()) && true) {
            this.setWidth(this.getWidth() + this.hiddenLetterWidth);
        }
        if (this.isTab()) {
            this.setWidth(36);
        }
        FontMetrics fontMetrics = this.getTextStyle().getFontMetrics();
        this.setAscent(fontMetrics.getAscent());
        this.setDescent(fontMetrics.getDescent());
        if (fontPlus.isSuperScript()) {
            this.setAscent(this.getAscent() + fontPlus.getSuperScriptAscent());
        }
        if (fontPlus.isSubScript()) {
            this.setDescent(this.getDescent() + fontPlus.getSubScriptDescent());
        }
        int n = Math.max(1, fontMetrics.getLeading());
        if (this.getTextStyle().getSpacing() == 3) {
            n *= 2;
        }
        if (this.getTextStyle().getSpacing() == 2) {
            n *= 4;
        }
        this.setLineSpace(n);
    }

    public boolean equals(TextWord textWord) {
        if (textWord == null) {
            return false;
        }
        if (this.isComponent() ? this.getComponent() != textWord.getComponent() : !this.getString().equals(textWord.getString())) {
            return false;
        }
        return this.getTextStyle() == textWord.getTextStyle();
    }

    public int getCharacterAt(int n, int n2) {
        int n3 = 0;
        while (n3 < this.getWidthIndex()) {
            int n4 = this.getStartIndex() + n3;
            Rectangle rectangle = this.getCharacterBounds(n4);
            if (n < rectangle.x) {
                return Math.max(this.getStartIndex(), n4 - 1);
            }
            ++n3;
        }
        return this.getEndIndex();
    }

    public Rectangle getCharacterBounds(int n) {
        Rectangle rectangle = this.getRawCharacterBounds(n);
        if (rectangle == null) {
            return new Rectangle(0, 0, 0, 0);
        }
        if (n != this.getStartIndex()) {
            return rectangle;
        }
        Rectangle rectangle2 = this.textLine.getCharacterBounds(n - 1);
        if (rectangle2 == null) {
            return rectangle;
        }
        if (rectangle2.x > rectangle.x) {
            return rectangle;
        }
        int n2 = rectangle2.x + rectangle2.width;
        int n3 = rectangle.x + rectangle.width - n2;
        rectangle.x = n2;
        rectangle.width = n3;
        return rectangle;
    }

    private Rectangle getRawCharacterBounds(int n) {
        Rectangle rectangle = new Rectangle(this.getX(), this.getY(), this.getWidth(), this.getHeight());
        if (this.isComponent()) {
            return rectangle;
        }
        if (this.isTab()) {
            return rectangle;
        }
        FontMetrics fontMetrics = this.getTextStyle().getFontMetrics();
        rectangle.width = 0;
        int n2 = 0;
        while (n2 < this.getString().length()) {
            char c = this.getString().charAt(n2);
            rectangle.width = fontMetrics.charWidth(c);
            if (n2 == 0 && this.isFirstWord && this.getTextData().isBreak(this.getStartIndex()) && true) {
                rectangle.width = this.hiddenLetterWidth;
            }
            if (this.getStartIndex() + n2 == n) {
                return rectangle;
            }
            rectangle.x += rectangle.width;
            ++n2;
        }
        return null;
    }

    public void setParent(Container container) {
        if (!this.isComponent()) {
            return;
        }
        ComponentPanel componentPanel = this.getComponent();
        if (componentPanel == null) {
            return;
        }
        if (container == componentPanel.getParent()) {
            return;
        }
        componentPanel.setVisible(false);
        container.add(componentPanel);
    }

    public TextStyle paint(Graphics graphics, TextStyle textStyle, int n, int n2, int n3, boolean bl) {
        int n4;
        Rectangle rectangle;
        Serializable serializable;
        TextStyle textStyle2 = this.getTextStyle();
        if (textStyle2 != textStyle) {
            graphics.setColor(textStyle2.getForeground());
            textStyle2.setViewScale(n3);
            FontPlus fontPlus = textStyle2.getScaledFontPlus();
            graphics.setFont(fontPlus.getAWTFont());
        }
        if (this.isFirstWord && this.getTextData().isBreak(this.getStartIndex()) && true) {
            n += this.hiddenLetterWidth;
        }
        int n5 = (n + this.getX()) * n3 / 100;
        boolean bl2 = false;
        if (textStyle2.getFontPlus().isUnderline()) {
            bl2 = true;
        }
        if (textStyle2.getFontPlus().isSuperScript()) {
            serializable = this.getTextStyle().getScaledFontPlus();
            n2 -= ((FontPlus)serializable).getSuperScriptAscent();
        }
        if (textStyle2.getFontPlus().isSubScript()) {
            serializable = this.getTextStyle().getScaledFontPlus();
            n2 += ((FontPlus)serializable).getSubScriptDescent();
        }
        if (this.isComponent()) {
            serializable = this.getComponent();
            ((InchPanel)serializable).setViewScale(n3);
            ((InchPanel)serializable).updateBounds();
            rectangle = ((InchPanel)serializable).getScaledPixelBounds();
            n4 = n3 / 100;
            rectangle.x = n5 + n4;
            rectangle.y = n2 - rectangle.height;
            ((InchPanel)serializable).setScaledPixelBounds(rectangle);
            ((InchPanel)serializable).updateBounds();
            ((Component)serializable).setVisible(true);
        } else {
            graphics.drawString(this.getDisplayString(), n5, n2);
            if (this.getDisplayString().length() <= 0) {
                bl2 = false;
            }
        }
        if (bl) {
            int n6 = this.getEndIndex();
            rectangle = this.getCharacterBounds(n6);
            n4 = (n + rectangle.x + rectangle.width) * n3 / 100;
            if (this.isTab()) {
                graphics.drawString(String.valueOf('\u00bb'), n5, n2);
            }
            if (this.getTextData().isNewPage(n6 + 1)) {
                this.paintNewPage(graphics, n2, n3);
            } else if (this.getTextData().isNewLine(n6 + 1)) {
                graphics.drawString(String.valueOf('\u00b6'), n4, n2);
            }
        }
        if (bl2) {
            Rectangle rectangle2 = this.getCharacterBounds(this.getStartIndex());
            rectangle = this.getCharacterBounds(this.getEndIndex());
            if (!this.isFirstWord) {
                n5 = (n + rectangle2.x) * n3 / 100;
            }
            n4 = (n + rectangle.x + rectangle.width) * n3 / 100;
            graphics.drawLine(n5, n2, n4, n2);
        }
        return textStyle2;
    }

    private void paintNewPage(Graphics graphics, int n, int n2) {
        int n3 = (this.textLine.getX() + 10) * n2 / 100;
        int n4 = (this.textLine.getWidth() - 20) * n2 / 100;
        int n5 = n + 10 * n2 / 100;
        Color color = graphics.getColor();
        graphics.setColor(Color.lightGray);
        graphics.drawLine(n3, n5, n3 + n4, n5);
        graphics.setColor(color);
    }

    public String toString() {
        if (this.isComponent()) {
            return "[Component]";
        }
        return this.getString();
    }
}

