/*
 * Decompiled with CFR 0.152.
 */
package com.idrsolutions.pdf.acroforms.xfa;

import com.idrsolutions.pdf.acroforms.xfa.XFAFormObject;
import com.idrsolutions.pdf.acroforms.xfa.XFAFormObjectv2;
import java.io.ByteArrayInputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import javax.xml.parsers.DocumentBuilderFactory;
import org.jpedal.io.PdfObjectReader;
import org.jpedal.objects.acroforms.utils.ConvertToString;
import org.jpedal.objects.raw.FormObject;
import org.jpedal.objects.raw.FormStream;
import org.jpedal.objects.raw.PdfArrayIterator;
import org.jpedal.objects.raw.PdfDictionary;
import org.jpedal.objects.raw.PdfObject;
import org.jpedal.objects.raw.StreamObject;
import org.jpedal.utils.LogWriter;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XFAFormStream
extends FormStream {
    public static final boolean useNewXFACode = false;
    private static final boolean debugNewXFA = false;
    private static boolean showBug = false;
    private static final boolean debugXFAstream = false;
    private static final boolean showXFAdata = false;
    private boolean calledOnce = false;
    private Node config;
    private Node dataset;
    private Node template;
    private static final int TEMPLATE = -2140765835;
    private static final int SUBFORM = 914524015;
    private static final int PAGESET = 895706747;
    private static final int PAGEAREA = 1366518886;
    private static final int CONTENTAREA = 1437250227;
    private static final int MEDIUM = 876184178;
    private static final int FIELD = 959790186;
    private static final int UI = 17721;
    private static final int BUTTON = 1145336195;
    private static final int FONT = 910114372;
    private static final int CAPTION = 1147957374;
    private static final int VALUE = 826033531;
    private static final int TEXT = 1144342596;
    private static final int HASH_TEXT = 1144342583;
    private static final int PARA = 1076970033;
    private static final int BORDER = 1110730625;
    private static final int TEMPLATEDESIGNER = -874907152;
    private static final int EDGE = 892614453;
    private static final int ACCESS = 859141238;
    private static final int ALLOWMACRO = 1836235416;
    private static final int ANCHORTYPE = 1468117173;
    private static final int COLSPAN = 594767994;
    private static final int COLUMNWIDTHS = -1530815551;
    private static final int H = 56;
    private static final int HALIGN = 1010397007;
    private static final int HAND = 942751284;
    private static final int ID = 14644;
    private static final int IMAGINGBBOX = 1233435312;
    private static final int LAYOUT = 1228898677;
    private static final int LOCALE = 858880116;
    private static final int LONG = 1010777655;
    private static final int MAXH = 1026639896;
    private static final int MAXW = 1026639911;
    private static final int MINH = 1027161624;
    private static final int MINW = 1027161639;
    private static final int NAME = 1043414325;
    private static final int ORIENTATION = 2042021288;
    private static final int PRESENCE = 1971349624;
    private static final int RELEVANT = -2006549895;
    private static final int RESTORESTATE = -978797412;
    private static final int SCOPE = 859783288;
    private static final int SHORT = 943669895;
    private static final int STOCK = 1144992638;
    private static final int STROKE = 1111457401;
    private static final int TRAYIN = 826891648;
    private static final int TRAYOUT = 1231259509;
    private static final int TYPEFACE = 2054845290;
    private static final int USE = 0x454335;
    private static final int USEHREF = 948402283;
    private static final int VALIGN = 1010400591;
    private static final int W = 71;
    private static final int X = 72;
    private static final int Y = 73;
    private Map refToForm = new HashMap();
    private XFAFormObject formObject;
    private LinkedList xfaFormList;
    private String pagenum;
    private int contentX;
    private int contentH;
    private Map valueMap = new HashMap();

    public XFAFormStream(PdfObject pdfObject, PdfObjectReader pdfObjectReader) {
        this.currentPdfFile = pdfObjectReader;
        this.readXFA(pdfObject);
    }

    private Node toDocument(int n, byte[] byArray) {
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        Document document = null;
        try {
            document = documentBuilderFactory.newDocumentBuilder().parse(new ByteArrayInputStream(byArray));
        }
        catch (Exception exception) {
            document = null;
        }
        return document;
    }

    private void readXFA(PdfObject pdfObject) {
        PdfObject pdfObject2 = null;
        PdfArrayIterator pdfArrayIterator = null;
        pdfObject2 = pdfObject.getDictionary(2627089);
        if (pdfObject2 == null && (pdfArrayIterator = pdfObject.getMixedArray(2627089)) != null && pdfArrayIterator.getTokenCount() == 0) {
            pdfArrayIterator = null;
        }
        if (pdfObject2 != null) {
            byte[] byArray = pdfObject2.getDecodedStream();
            this.template = XFAFormStream.xmlToNode(1013350773, byArray);
        } else {
            StreamObject streamObject = null;
            int n = 0;
            while (pdfArrayIterator != null && pdfArrayIterator.hasMoreTokens()) {
                n = pdfArrayIterator.getNextValueAsConstant(true);
                streamObject = new StreamObject(pdfArrayIterator.getNextValueAsString(true));
                this.currentPdfFile.readObject(streamObject);
                byte[] byArray = streamObject.getDecodedStream();
                switch (n) {
                    case 1043741046: {
                        this.config = this.toDocument(1043741046, byArray);
                        break;
                    }
                    case 1130793076: {
                        this.dataset = this.toDocument(1130793076, byArray);
                        break;
                    }
                    case 1013350773: {
                        this.template = this.toDocument(1013350773, byArray);
                        break;
                    }
                    case 1031041382: {
                        break;
                    }
                    case 1951819392: {
                        break;
                    }
                    case 1701743524: {
                        break;
                    }
                    case 1026916721: {
                        break;
                    }
                    case 0x363436: {
                        break;
                    }
                    case 2088075366: {
                        break;
                    }
                }
            }
        }
    }

    private static Node xmlToNode(int n, byte[] byArray) {
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        Document document = null;
        try {
            document = documentBuilderFactory.newDocumentBuilder().parse(new ByteArrayInputStream(byArray));
        }
        catch (Exception exception) {
            document = null;
        }
        switch (n) {
            case 1043741046: {
                NodeList nodeList = document.getElementsByTagName("config");
                for (int i = 0; i < nodeList.getLength(); ++i) {
                    Element element = (Element)nodeList.item(i);
                    String string = element.getAttribute("xmlns");
                    if (string.length() <= 0) continue;
                    return element;
                }
                break;
            }
            case 1130793076: {
                NodeList nodeList = document.getElementsByTagName("xfa:datasets");
                Element element = (Element)nodeList.item(0);
                return element;
            }
            case 1013350773: {
                NodeList nodeList = document.getElementsByTagName("template");
                for (int i = 0; i < nodeList.getLength(); ++i) {
                    Element element = (Element)nodeList.item(i);
                    String string = element.getAttribute("xmlns:xfa");
                    if (string.length() <= 0) continue;
                    return element;
                }
                break;
            }
        }
        return null;
    }

    public boolean hasXFADataSet() {
        return this.dataset != null;
    }

    public FormObject[] createAppearanceString(FormObject[] formObjectArray) {
        int n;
        if (this.calledOnce) {
            return null;
        }
        this.calledOnce = true;
        this.xfaFormList = new LinkedList();
        this.parseStream();
        int n2 = this.xfaFormList.size();
        int n3 = formObjectArray.length < n2 ? formObjectArray.length : n2;
        FormObject[][] formObjectArray2 = new FormObject[n3][2];
        for (n = 0; n < n3; ++n) {
            String string;
            int n4;
            String string2;
            formObjectArray2[n][0] = formObjectArray[n];
            if (formObjectArray[n] != null) {
                string2 = formObjectArray[n].getTextStreamValue(36);
                if (string2 != null) {
                    n4 = string2.lastIndexOf("[0]");
                    int n5 = string2.lastIndexOf(46, n4 - 1);
                    if (n5 != -1) {
                        string2 = n4 != -1 ? string2.substring(n5 + 1, n4) : string2.substring(n5 + 1);
                    } else if (n4 != -1) {
                        string2 = string2.substring(0, n4);
                    }
                }
            } else {
                string2 = null;
            }
            for (n4 = 0; n4 < n2; ++n4) {
                String string3;
                XFAFormObject xFAFormObject = (XFAFormObject)this.xfaFormList.get(n4);
                if (xFAFormObject == null || !(string3 = xFAFormObject.getTextStreamValue(36)).equals(string2)) continue;
                formObjectArray2[n][1] = xFAFormObject;
                break;
            }
            if (string2 == null || (string = (String)this.valueMap.get(string2.toLowerCase())) == null) continue;
            formObjectArray2[n][0].setTextValue(string);
        }
        formObjectArray = new FormObject[n3];
        for (n = 0; n < n3; ++n) {
            if (formObjectArray2[n][1] != null) {
                formObjectArray2[n][1].overwriteWith(formObjectArray2[n][0]);
                formObjectArray[n] = formObjectArray2[n][1];
                if (showBug) {
                    System.out.println("wrong " + n);
                }
            } else {
                formObjectArray[n] = formObjectArray2[n][0];
                if (showBug) {
                    System.out.println("correct " + n);
                }
            }
            if (!showBug) continue;
            System.out.println(n + " " + formObjectArray[n].getTextString());
        }
        return formObjectArray;
    }

    protected void parseStream() {
        ArrayList arrayList = new ArrayList();
        this.parseNode(this.template, arrayList);
        this.setupTemplate(arrayList.iterator());
        ArrayList arrayList2 = new ArrayList();
        this.parseNode(this.dataset, arrayList2);
        this.setupDataSet(arrayList2.iterator());
    }

    private void setupDataSet(Iterator iterator) {
        while (iterator.hasNext()) {
            Node node = (Node)iterator.next();
            String string = node.getNodeName();
            if (!string.equals("xfa:data")) continue;
            this.data(node, iterator);
        }
    }

    private void data(Node node, Iterator iterator) {
        NodeList nodeList = node.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node2 = nodeList.item(i);
            NodeList nodeList2 = node2.getChildNodes();
            if (nodeList2.getLength() <= 0) continue;
            Node node3 = nodeList2.item(0);
            nodeList2 = node3.getChildNodes();
            String string = node3.getNodeName();
            if (nodeList2.getLength() <= 0) continue;
            Node node4 = nodeList2.item(0);
            this.valueMap.put(string.toLowerCase(), node4.getNodeValue());
        }
    }

    private void nextFormObject() {
        if (this.formObject != null) {
            this.xfaFormList.add(this.formObject);
        }
        this.formObject = new XFAFormObject();
    }

    private void parseNode(Node node, ArrayList arrayList) {
        arrayList.add(node);
        NodeList nodeList = node.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            this.parseNode(nodeList.item(i), arrayList);
        }
    }

    private void setupTemplate(Iterator iterator) {
        while (iterator.hasNext()) {
            Node node;
            NamedNodeMap namedNodeMap;
            Node node2 = (Node)iterator.next();
            String string = node2.getNodeName();
            if (string.equals("field")) {
                this.field(node2, iterator);
                continue;
            }
            if (string.equals("pageArea")) {
                namedNodeMap = node2.getAttributes();
                node = namedNodeMap.getNamedItem("id");
                this.pagenum = node.getNodeValue();
                this.pagenum = this.pagenum.substring(this.pagenum.indexOf("Page") + 4);
                continue;
            }
            if (string.equals("contentArea")) {
                namedNodeMap = node2.getAttributes();
                if (namedNodeMap == null) continue;
                node = namedNodeMap.getNamedItem("x");
                if (node != null) {
                    this.contentX = this.resolveMeasurementToPoints(node.getNodeValue());
                }
                if ((node = namedNodeMap.getNamedItem("h")) == null) continue;
                this.contentH = this.resolveMeasurementToPoints(node.getNodeValue());
                continue;
            }
            if (!string.equals("#document") && !string.equals("templateDesigner")) continue;
        }
        this.nextFormObject();
    }

    private int resolveMeasurementToPoints(String string) {
        int n = 0;
        if (string.endsWith("pt")) {
            n = new Double(string.substring(0, string.indexOf("pt"))).intValue();
        } else if (string.endsWith("in")) {
            n = (int)(72.0 * Double.parseDouble(string.substring(0, string.indexOf("in"))));
        } else if (string.endsWith("cm")) {
            n = (int)(28.35 * Double.parseDouble(string.substring(0, string.indexOf("cm"))));
        } else if (string.endsWith("mm")) {
            n = (int)(2.835 * Double.parseDouble(string.substring(0, string.indexOf("mm"))));
        } else {
            LogWriter.writeFormLog("UNIMPLEMENTED type of y size=" + string, false);
        }
        return n;
    }

    private void field(Node node, Iterator iterator) {
        Node node2;
        this.nextFormObject();
        this.formObject.setPageNumber(this.pagenum);
        NamedNodeMap namedNodeMap = node.getAttributes();
        if (namedNodeMap != null) {
            node2 = namedNodeMap.getNamedItem("x");
            if (node2 != null) {
                this.formObject.setX(this.contentX + this.resolveMeasurementToPoints(node2.getNodeValue()));
            }
            if ((node2 = namedNodeMap.getNamedItem("y")) != null) {
                this.formObject.setY(this.contentH - this.resolveMeasurementToPoints(node2.getNodeValue()));
            }
            if ((node2 = namedNodeMap.getNamedItem("w")) != null) {
                this.formObject.setWidth(this.resolveMeasurementToPoints(node2.getNodeValue()));
            }
            if ((node2 = namedNodeMap.getNamedItem("h")) != null) {
                this.formObject.setHeight(this.resolveMeasurementToPoints(node2.getNodeValue()));
            }
            if ((node2 = namedNodeMap.getNamedItem("name")) != null) {
                this.formObject.setFieldName(node2.getNodeValue());
            } else {
                this.formObject.setFieldName("");
            }
        }
        node2 = null;
        while (iterator.hasNext() && !(node2 = (Node)iterator.next()).getNodeName().equals("ui")) {
            node2 = null;
        }
        if (node2 == null) {
            System.out.println("ERROR ERROR  ERROR no ui in field=" + ConvertToString.convertDocumentToString(node));
        } else {
            Node node3 = null;
            String string = null;
            while (iterator.hasNext()) {
                node3 = (Node)iterator.next();
                string = node3.getNodeName();
                if (string.equals("checkButton")) {
                    this.checkButton(node3, iterator);
                    continue;
                }
                if (string.equals("button")) {
                    this.button(node3, iterator);
                    continue;
                }
                if (string.equals("choiceList")) {
                    this.choiceList(node3, iterator);
                    continue;
                }
                if (string.equals("textEdit")) {
                    this.textEdit(node3, iterator);
                    continue;
                }
                LogWriter.writeFormLog("node not implemented nodename=" + string, false);
            }
        }
    }

    private void textEdit(Node node, Iterator iterator) {
        this.formObject.setType(9288, true);
        this.formObject.setFlag(12, true);
        this.formObject.setFlag(13, false);
        String string = node.getNodeName();
        String string2 = node.getNodeValue();
        NamedNodeMap namedNodeMap = node.getAttributes();
        if (namedNodeMap != null) {
            // empty if block
        }
        while (iterator.hasNext()) {
            Object object;
            Node node2 = (Node)iterator.next();
            String string3 = node2.getNodeName();
            if (string3.equals("templateDesigner")) continue;
            if (string3.equals("field")) {
                this.field(node2, iterator);
                continue;
            }
            if (string3.equals("value") || string3.equals("caption")) continue;
            if (string3.equals("text")) {
                if (!iterator.hasNext()) continue;
                object = (Node)iterator.next();
                continue;
            }
            if (string3.equals("para")) {
                object = node2.getAttributes();
                Node node3 = object.getNamedItem("hAlign");
                if (node3 != null) {
                    this.formObject.setHorizontalAlign(node3.getNodeValue());
                }
                if ((node3 = object.getNamedItem("vAlign")) == null) continue;
                this.formObject.setVerticalAllign(node3.getNodeValue());
                continue;
            }
            if (string3.equals("font")) {
                object = node2.getAttributes().getNamedItem("typeface");
                if (object == null) continue;
            }
            if (string3.equals("edge")) {
                object = node2.getAttributes().getNamedItem("stroke");
                if (object == null) continue;
                this.formObject.setBorderStroke(object.getNodeValue());
                continue;
            }
            if (string3.equals("border") || string3.equals("margin") || string3.equals("proto")) continue;
            LogWriter.writeFormLog("node name not implemented in textEdit name=" + string3, false);
        }
    }

    private void choiceList(Node node, Iterator iterator) {
        Node node2;
        this.formObject.setType(4920, true);
        this.formObject.setFlag(17, false);
        String string = node.getNodeName();
        String string2 = node.getNodeValue();
        NamedNodeMap namedNodeMap = node.getAttributes();
        if (namedNodeMap != null && (node2 = namedNodeMap.getNamedItem("open")) != null) {
            this.formObject.setChoiceOpening(node2.getNodeValue());
        }
        while (iterator.hasNext()) {
            Object object;
            node2 = (Node)iterator.next();
            String string3 = node2.getNodeName();
            if (string3.equals("templateDesigner")) continue;
            if (string3.equals("field")) {
                this.field(node2, iterator);
                continue;
            }
            if (string3.equals("value") || string3.equals("caption") || string3.equals("items")) continue;
            if (string3.equals("text")) {
                if (!iterator.hasNext()) continue;
                object = (Node)iterator.next();
                this.formObject.setTextValue(object.getNodeValue());
                continue;
            }
            if (string3.equals("para")) {
                object = node2.getAttributes();
                Node node3 = object.getNamedItem("hAlign");
                if (node3 != null) {
                    this.formObject.setHorizontalAlign(node3.getNodeValue());
                }
                if ((node3 = object.getNamedItem("vAlign")) == null) continue;
                this.formObject.setVerticalAllign(node3.getNodeValue());
                continue;
            }
            if (string3.equals("font")) {
                object = node2.getAttributes().getNamedItem("typeface");
                if (object == null) continue;
            }
            if (string3.equals("edge")) {
                object = node2.getAttributes().getNamedItem("stroke");
                if (object == null) continue;
                this.formObject.setBorderStroke(object.getNodeValue());
                continue;
            }
            if (string3.equals("border") || string3.equals("margin") || string3.equals("draw") || string3.equals("rectangle")) continue;
            LogWriter.writeFormLog("node name not implemented in choiceList name=" + string3, false);
        }
    }

    private void button(Node node, Iterator iterator) {
        this.formObject.setType(1197118, true);
        this.formObject.setFlag(16, true);
        String string = node.getNodeName();
        String string2 = node.getNodeValue();
        NamedNodeMap namedNodeMap = node.getAttributes();
        if (namedNodeMap != null) {
            // empty if block
        }
        while (iterator.hasNext()) {
            Node node2;
            Object object;
            Node node3 = (Node)iterator.next();
            String string3 = node3.getNodeName();
            if (string3.equals("templateDesigner")) continue;
            if (string3.equals("field")) {
                this.field(node3, iterator);
                continue;
            }
            if (string3.equals("edge")) {
                object = node3.getAttributes().getNamedItem("stroke");
                if (object == null) continue;
                this.formObject.setBorderStroke(object.getNodeValue());
                continue;
            }
            if (string3.equals("caption") || string3.equals("value")) continue;
            if (string3.equals("text")) {
                if (!iterator.hasNext()) continue;
                object = (Node)iterator.next();
                this.formObject.setNormalCaption(object.getNodeValue());
                continue;
            }
            if (string3.equals("para")) {
                object = node3.getAttributes();
                node2 = object.getNamedItem("hAlign");
                if (node2 != null) {
                    this.formObject.setHorizontalAlign(node2.getNodeValue());
                }
                if ((node2 = object.getNamedItem("vAlign")) == null) continue;
                this.formObject.setVerticalAllign(node2.getNodeValue());
                continue;
            }
            if (string3.equals("font")) {
                object = node3.getAttributes().getNamedItem("typeface");
                if (object == null) continue;
            }
            if (string3.equals("border") || string3.equals("fill")) continue;
            if (string3.equals("color")) {
                object = node3.getAttributes().getNamedItem("value");
                if (object == null) continue;
                this.formObject.setBackgroundColor(object.getNodeValue());
                continue;
            }
            if (string3.equals("bind")) continue;
            if (string3.equals("event")) {
                object = node3.getAttributes().getNamedItem("activity");
                this.formObject.setEventAction(object.getNodeValue());
                continue;
            }
            if (string3.equals("script")) {
                object = node3.getAttributes();
                if (object != null && (node2 = object.getNamedItem("contentType")) != null) {
                    this.formObject.setScriptType(node2.getNodeValue());
                }
                if (!iterator.hasNext() || (node2 = (Node)iterator.next()) == null) continue;
                this.formObject.setScript(node2.getNodeValue());
                continue;
            }
            if (string3.equals("submit")) {
                Node node4;
                Node node5;
                object = node3.getAttributes();
                node2 = object.getNamedItem("format");
                if (node2 != null) {
                    this.formObject.setSubmitFormat(node2.getNodeValue());
                }
                if ((node5 = object.getNamedItem("target")) != null) {
                    this.formObject.setSubmitURL(node5.getNodeValue());
                }
                if ((node4 = object.getNamedItem("textEncoding")) == null) continue;
                this.formObject.setSubmitTextEncoding(node4.getNodeValue());
                continue;
            }
            LogWriter.writeFormLog("node name not implemented in button name=" + string3, false);
        }
    }

    private void checkButton(Node node, Iterator iterator) {
        this.formObject.setType(4920, true);
        this.formObject.setFlag(17, true);
        String string = node.getNodeName();
        String string2 = node.getNodeValue();
        NamedNodeMap namedNodeMap = node.getAttributes();
        if (namedNodeMap != null) {
            // empty if block
        }
        while (iterator.hasNext()) {
            Object object;
            Node node2 = (Node)iterator.next();
            String string3 = node2.getNodeName();
            if (string3.equals("templateDesigner")) continue;
            if (string3.equals("field")) {
                this.field(node2, iterator);
                continue;
            }
            if (string3.equals("value") || string3.equals("caption")) continue;
            if (string3.equals("text")) {
                if (!iterator.hasNext()) continue;
                object = (Node)iterator.next();
                this.formObject.setTextValue(object.getNodeValue());
                continue;
            }
            if (string3.equals("integer")) {
                if (!iterator.hasNext()) continue;
                object = (Node)iterator.next();
                this.formObject.setIntegerValue(object.getNodeValue());
                continue;
            }
            if (string3.equals("para")) {
                object = node2.getAttributes();
                Node node3 = object.getNamedItem("hAlign");
                if (node3 != null) {
                    this.formObject.setHorizontalAlign(node3.getNodeValue());
                }
                if ((node3 = object.getNamedItem("vAlign")) == null) continue;
                this.formObject.setVerticalAllign(node3.getNodeValue());
                continue;
            }
            if (string3.equals("font")) {
                object = node2.getAttributes().getNamedItem("typeface");
                if (object == null) continue;
            }
            if (string3.equals("edge")) {
                object = node2.getAttributes().getNamedItem("stroke");
                if (object == null) continue;
                this.formObject.setBorderStroke(object.getNodeValue());
                continue;
            }
            if (string3.equals("border") || string3.equals("fill") || string3.equals("margin") || string3.equals("event") || string3.equals("items") || string3.equals("exclGroup") || string3.equals("proto")) continue;
            LogWriter.writeFormLog("node name not implemented in checkbutton name=" + string3, false);
        }
    }

    private int stringToInt(String string) {
        byte[] byArray = string.getBytes();
        return PdfDictionary.generateChecksum(0, byArray.length, byArray);
    }

    protected void setupTemplate2(Node node) {
        this.callNode(node.getChildNodes(), null);
    }

    private void evalNode(Node node, boolean bl) {
    }

    private Object process(int n, Node node) {
        if (node == null) {
            return null;
        }
        switch (n) {
            case 56: 
            case 71: 
            case 72: 
            case 73: 
            case 943669895: 
            case 1010777655: {
                return this.convertMeasurementToScreenSize(node.getNodeValue());
            }
            case 14644: {
                return node.getNodeValue();
            }
            case 858880116: {
                if (node.getNodeValue() == null || node.getNodeValue().equals("ambient")) break;
                return node.getNodeValue();
            }
            case 1228898677: {
                int n2 = -2072477065;
                String string = node.getNodeValue();
                if (string != null) {
                    n2 = this.stringToInt(string);
                }
                return n2;
            }
            case 1043414325: {
                return node.getNodeValue();
            }
            case 1144992638: {
                return node.getNodeValue();
            }
            case 2054845290: {
                return node.getNodeValue();
            }
            case 1010397007: {
                int n3 = 1010120260;
                String string = node.getNodeValue();
                if (string != null) {
                    n3 = this.stringToInt(string);
                }
                return n3;
            }
            case 1010400591: {
                int n4 = 1010120260;
                String string = node.getNodeValue();
                if (string != null) {
                    n4 = this.stringToInt(string);
                }
                return n4;
            }
            case 942751284: {
                int n5 = 893793598;
                String string = node.getNodeValue();
                if (string != null) {
                    n5 = this.stringToInt(string);
                }
                return n5;
            }
            case 1111457401: {
                int n6 = 1060911479;
                String string = node.getNodeValue();
                if (string != null) {
                    n6 = this.stringToInt(string);
                }
                return n6;
            }
        }
        return null;
    }

    private Float convertMeasurementToScreenSize(String string) {
        String string2;
        int n;
        int n2;
        String[] stringArray = new String[]{"in", "cm", "mm", "pt", "em", "%"};
        for (n2 = 0; n2 < string.length() && (Character.isDigit((char)(n = string.charAt(n2))) || n == 46); ++n2) {
        }
        n = 0;
        if (n2 != string.length()) {
            string2 = string.substring(n2);
            for (int i = 0; i < stringArray.length; ++i) {
                if (!string2.equals(stringArray[i])) continue;
                n = i;
                break;
            }
        }
        string2 = string.substring(0, n2);
        float f = Float.parseFloat(string2);
        float f2 = 0.0f;
        switch (n) {
            case 1: {
                f2 = f * 10.0f;
                break;
            }
            case 2: {
                f2 = f;
                break;
            }
            case 3: {
                f2 = f * 0.35277778f;
                break;
            }
            default: {
                f2 = f * 25.4f;
            }
        }
        return Float.valueOf(f2);
    }

    private void callNode(NodeList nodeList, XFAFormObjectv2 xFAFormObjectv2) {
        block20: for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            int n = this.stringToInt(node.getNodeName());
            switch (n) {
                case -2140765835: {
                    this.template(node);
                    continue block20;
                }
                case 914524015: {
                    this.subform(node, xFAFormObjectv2);
                    continue block20;
                }
                case 895706747: {
                    this.pageSet(node, xFAFormObjectv2);
                    continue block20;
                }
                case 1366518886: {
                    this.pageArea(node, xFAFormObjectv2);
                    continue block20;
                }
                case 1437250227: {
                    this.contentArea(node, xFAFormObjectv2);
                    continue block20;
                }
                case 876184178: {
                    this.medium(node, xFAFormObjectv2);
                    continue block20;
                }
                case 959790186: {
                    this.field(node, xFAFormObjectv2);
                    continue block20;
                }
                case 17721: {
                    this.ui(node, xFAFormObjectv2);
                    continue block20;
                }
                case 1145336195: {
                    this.button(node, xFAFormObjectv2);
                    continue block20;
                }
                case 910114372: {
                    this.font(node, xFAFormObjectv2);
                    continue block20;
                }
                case 1147957374: {
                    this.caption(node, xFAFormObjectv2);
                    continue block20;
                }
                case 826033531: {
                    this.value(node, xFAFormObjectv2);
                    continue block20;
                }
                case 1144342596: {
                    this.text(node, xFAFormObjectv2);
                    continue block20;
                }
                case 1144342583: {
                    continue block20;
                }
                case 1076970033: {
                    this.para(node, xFAFormObjectv2);
                    continue block20;
                }
                case 1110730625: {
                    this.border(node, xFAFormObjectv2);
                    continue block20;
                }
                case -874907152: {
                    continue block20;
                }
                case 892614453: {
                    this.edge(node, xFAFormObjectv2);
                    continue block20;
                }
            }
        }
    }

    private void medium(Node node, XFAFormObjectv2 xFAFormObjectv2) {
        if (node.hasAttributes()) {
            NamedNodeMap namedNodeMap = node.getAttributes();
            Float f = (Float)this.process(1010777655, namedNodeMap.getNamedItem("long"));
            Float f2 = (Float)this.process(943669895, namedNodeMap.getNamedItem("short"));
            String string = (String)this.process(1144992638, namedNodeMap.getNamedItem("stock"));
        }
        if (node.hasChildNodes()) {
            this.callNode(node.getChildNodes(), xFAFormObjectv2);
        }
    }

    private void contentArea(Node node, XFAFormObjectv2 xFAFormObjectv2) {
        if (node.hasAttributes()) {
            NamedNodeMap namedNodeMap = node.getAttributes();
            float f = ((Float)this.process(56, namedNodeMap.getNamedItem("h"))).floatValue();
            float f2 = ((Float)this.process(71, namedNodeMap.getNamedItem("w"))).floatValue();
            float f3 = ((Float)this.process(72, namedNodeMap.getNamedItem("x"))).floatValue();
            float f4 = ((Float)this.process(73, namedNodeMap.getNamedItem("y"))).floatValue();
            xFAFormObjectv2.setFloatArray(573911876, new float[]{f3, f4, f3 + f2, f4 + f});
        }
        if (node.hasChildNodes()) {
            this.callNode(node.getChildNodes(), xFAFormObjectv2);
        }
    }

    private void template(Node node) {
        if (node.hasAttributes()) {
            NamedNodeMap namedNodeMap = node.getAttributes();
        }
        if (node.hasChildNodes()) {
            this.callNode(node.getChildNodes(), null);
        }
    }

    private void subform(Node node, XFAFormObjectv2 xFAFormObjectv2) {
        Object object;
        XFAFormObjectv2 xFAFormObjectv22 = new XFAFormObjectv2();
        if (xFAFormObjectv2 != null) {
            xFAFormObjectv22.overwriteWith(xFAFormObjectv2);
            object = xFAFormObjectv2.getObjectRefAsString();
            xFAFormObjectv22.setParent((String)object);
            this.refToForm.put(object, xFAFormObjectv2);
        }
        if (node.hasAttributes()) {
            Float f;
            object = node.getAttributes();
            String string = (String)this.process(1043414325, object.getNamedItem("name"));
            if (string != null) {
                xFAFormObjectv22.setFieldName(string);
            }
            Integer n = (Integer)this.process(1228898677, object.getNamedItem("layout"));
            String string2 = (String)this.process(858880116, object.getNamedItem("locale"));
            Float f2 = (Float)this.process(56, object.getNamedItem("h"));
            if (f2 != null) {
                xFAFormObjectv22.setHeight(f2.floatValue());
            }
            if ((f = (Float)this.process(71, object.getNamedItem("w"))) != null) {
                xFAFormObjectv22.setWidth(f.floatValue());
            }
        }
        if (node.hasChildNodes()) {
            this.callNode(node.getChildNodes(), xFAFormObjectv22);
        }
    }

    private void pageSet(Node node, XFAFormObjectv2 xFAFormObjectv2) {
        if (node.hasAttributes()) {
            NamedNodeMap namedNodeMap = node.getAttributes();
        }
        if (node.hasChildNodes()) {
            this.callNode(node.getChildNodes(), xFAFormObjectv2);
        }
    }

    private void pageArea(Node node, XFAFormObjectv2 xFAFormObjectv2) {
        if (node.hasAttributes()) {
            NamedNodeMap namedNodeMap = node.getAttributes();
            String string = (String)this.process(14644, namedNodeMap.getNamedItem("id"));
            String string2 = (String)this.process(1043414325, namedNodeMap.getNamedItem("name"));
        }
        if (node.hasChildNodes()) {
            this.callNode(node.getChildNodes(), xFAFormObjectv2);
        }
    }

    private void field(Node node, XFAFormObjectv2 xFAFormObjectv2) {
        xFAFormObjectv2.setTextValue(node.getTextContent());
        if (node.hasAttributes()) {
            NamedNodeMap namedNodeMap = node.getAttributes();
            String string = (String)this.process(1043414325, namedNodeMap.getNamedItem("name"));
            xFAFormObjectv2.setFieldName(string);
            float f = ((Float)this.process(56, namedNodeMap.getNamedItem("h"))).floatValue();
            float f2 = ((Float)this.process(71, namedNodeMap.getNamedItem("w"))).floatValue();
            float f3 = ((Float)this.process(72, namedNodeMap.getNamedItem("x"))).floatValue();
            float f4 = ((Float)this.process(73, namedNodeMap.getNamedItem("y"))).floatValue();
            xFAFormObjectv2.setFloatArray(573911876, new float[]{f3, f4, f3 + f2, f4 + f});
        }
        if (node.hasChildNodes()) {
            this.callNode(node.getChildNodes(), xFAFormObjectv2);
        }
    }

    private void ui(Node node, XFAFormObjectv2 xFAFormObjectv2) {
        if (node.hasAttributes()) {
            NamedNodeMap namedNodeMap = node.getAttributes();
        }
        if (node.hasChildNodes()) {
            this.callNode(node.getChildNodes(), xFAFormObjectv2);
        }
    }

    private void button(Node node, XFAFormObjectv2 xFAFormObjectv2) {
        if (node.hasAttributes()) {
            NamedNodeMap namedNodeMap = node.getAttributes();
        }
        if (node.hasChildNodes()) {
            this.callNode(node.getChildNodes(), xFAFormObjectv2);
        }
    }

    private void font(Node node, XFAFormObjectv2 xFAFormObjectv2) {
        if (node.hasAttributes()) {
            NamedNodeMap namedNodeMap = node.getAttributes();
            String string = (String)this.process(2054845290, namedNodeMap.getNamedItem("typeface"));
            xFAFormObjectv2.setFontStyle(string);
        }
        if (node.hasChildNodes()) {
            this.callNode(node.getChildNodes(), xFAFormObjectv2);
        }
    }

    private void caption(Node node, XFAFormObjectv2 xFAFormObjectv2) {
        xFAFormObjectv2.setNormalCaption(node.getTextContent());
        if (node.hasAttributes()) {
            NamedNodeMap namedNodeMap = node.getAttributes();
        }
        if (node.hasChildNodes()) {
            this.callNode(node.getChildNodes(), xFAFormObjectv2);
        }
    }

    private void value(Node node, XFAFormObjectv2 xFAFormObjectv2) {
        xFAFormObjectv2.setValue(node.getTextContent());
        if (node.hasAttributes()) {
            NamedNodeMap namedNodeMap = node.getAttributes();
        }
        if (node.hasChildNodes()) {
            this.callNode(node.getChildNodes(), xFAFormObjectv2);
        }
    }

    private void text(Node node, XFAFormObjectv2 xFAFormObjectv2) {
        xFAFormObjectv2.setTextValue(node.getTextContent());
        if (node.hasAttributes()) {
            NamedNodeMap namedNodeMap = node.getAttributes();
        }
        if (node.hasChildNodes()) {
            this.callNode(node.getChildNodes(), xFAFormObjectv2);
        }
    }

    private void para(Node node, XFAFormObjectv2 xFAFormObjectv2) {
        if (node.hasAttributes()) {
            NamedNodeMap namedNodeMap = node.getAttributes();
            int n = (Integer)this.process(1010397007, namedNodeMap.getNamedItem("hAlign"));
            int n2 = (Integer)this.process(1010400591, namedNodeMap.getNamedItem("vAlign"));
            xFAFormObjectv2.setHorizontalAlignment(n);
            xFAFormObjectv2.setVerticalAlignment(n2);
        }
        if (node.hasChildNodes()) {
            this.callNode(node.getChildNodes(), xFAFormObjectv2);
        }
    }

    private void border(Node node, XFAFormObjectv2 xFAFormObjectv2) {
        if (node.hasAttributes()) {
            NamedNodeMap namedNodeMap = node.getAttributes();
            int n = (Integer)this.process(942751284, namedNodeMap.getNamedItem("hand"));
            xFAFormObjectv2.setHandedness(n);
        }
        if (node.hasChildNodes()) {
            this.callNode(node.getChildNodes(), xFAFormObjectv2);
        }
    }

    private void edge(Node node, XFAFormObjectv2 xFAFormObjectv2) {
        if (node.hasAttributes()) {
            NamedNodeMap namedNodeMap = node.getAttributes();
            int n = (Integer)this.process(1111457401, namedNodeMap.getNamedItem("stroke"));
            xFAFormObjectv2.setStroke(n);
        }
        if (node.hasChildNodes()) {
            this.callNode(node.getChildNodes(), xFAFormObjectv2);
        }
    }
}

