/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal;

import java.awt.image.BufferedImage;
import org.jpedal.PdfDecoder;
import org.jpedal.objects.raw.PageObject;
import org.jpedal.objects.raw.PdfObject;
import org.jpedal.parser.PdfStreamDecoder;
import org.jpedal.render.DynamicVectorRenderer;
import org.jpedal.utils.LogWriter;

public class ThumbnailDecoder {
    private PdfDecoder decode_pdf;
    private PdfStreamDecoder imageDecoder = null;
    private boolean stopDecoding = false;

    public ThumbnailDecoder(PdfDecoder pdfDecoder) {
        this.decode_pdf = pdfDecoder;
    }

    public final synchronized BufferedImage getPageAsThumbnail(int n, int n2) {
        this.stopDecoding = false;
        BufferedImage bufferedImage = null;
        DynamicVectorRenderer dynamicVectorRenderer = null;
        if (dynamicVectorRenderer != null) {
            dynamicVectorRenderer.setObjectStoreRef(this.decode_pdf.objectStoreRef);
        } else {
            dynamicVectorRenderer = new DynamicVectorRenderer(n, true, 1000, this.decode_pdf.objectStoreRef);
            dynamicVectorRenderer.setHiResImageForDisplayMode(this.decode_pdf.useHiResImageForDisplay);
            try {
                if (n > this.decode_pdf.getPageCount()) {
                    LogWriter.writeLog("Page " + n + " out of bounds");
                } else {
                    int n3 = this.decode_pdf.pageData.getMediaBoxX(n);
                    int n4 = this.decode_pdf.pageData.getMediaBoxY(n);
                    int n5 = this.decode_pdf.pageData.getMediaBoxWidth(n);
                    int n6 = this.decode_pdf.pageData.getMediaBoxHeight(n);
                    String string = (String)this.decode_pdf.pagesReferences.get(new Integer(n));
                    if (string != null) {
                        PageObject pageObject = new PageObject(string);
                        this.decode_pdf.currentPdfFile.readObject(pageObject);
                        PdfObject pdfObject = ((PdfObject)pageObject).getDictionary(2004251818);
                        if (pageObject != null) {
                            PdfObject pdfObject2;
                            this.imageDecoder = new PdfStreamDecoder(this.decode_pdf.useHiResImageForDisplay, null, this.decode_pdf.globalResources);
                            this.imageDecoder.setExternalImageRender(this.decode_pdf.customImageHandler);
                            if (this.stopDecoding) {
                                this.imageDecoder = null;
                                return null;
                            }
                            this.imageDecoder.setName(this.decode_pdf.filename);
                            this.imageDecoder.setStore(this.decode_pdf.objectStoreRef);
                            if (this.stopDecoding) {
                                this.imageDecoder = null;
                                return null;
                            }
                            this.imageDecoder.init(true, true, this.decode_pdf.renderMode, 0, this.decode_pdf.pageData, n, dynamicVectorRenderer, this.decode_pdf.currentPdfFile);
                            if (this.decode_pdf.globalResources != null) {
                                this.decode_pdf.currentPdfFile.checkResolved(this.decode_pdf.globalResources);
                                this.imageDecoder.readResources(this.decode_pdf.globalResources, true);
                                pdfObject2 = this.decode_pdf.globalResources.getDictionary(-2089186617);
                                if (pdfObject2 != null) {
                                    this.decode_pdf.PropertiesObj = pdfObject2;
                                }
                            }
                            if (pdfObject != null) {
                                this.decode_pdf.currentPdfFile.checkResolved(pdfObject);
                                this.imageDecoder.readResources(pdfObject, true);
                                pdfObject2 = pdfObject.getDictionary(-2089186617);
                                if (pdfObject2 != null) {
                                    this.decode_pdf.PropertiesObj = pdfObject2;
                                }
                            }
                            this.decode_pdf.setupPage(this.imageDecoder, true);
                            if (this.stopDecoding) {
                                this.imageDecoder = null;
                                return null;
                            }
                            dynamicVectorRenderer.init(n5, n6, this.decode_pdf.pageData.getRotation(n));
                            this.imageDecoder.decodePageContent(pageObject, n3, n4, null, null);
                        }
                    }
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            this.imageDecoder = null;
        }
        if (!this.stopDecoding) {
            bufferedImage = this.decode_pdf.getImageFromRenderer(n2, dynamicVectorRenderer, n);
        }
        return bufferedImage;
    }
}

