/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.examples.simpleviewer.gui.swing;

import java.awt.Cursor;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.io.File;
import java.util.Date;
import javax.swing.ImageIcon;
import javax.swing.JFileChooser;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import javax.swing.filechooser.FileFilter;
import org.jpedal.PdfDecoder;
import org.jpedal.examples.simpleviewer.SimpleViewer;
import org.jpedal.examples.simpleviewer.Values;
import org.jpedal.examples.simpleviewer.gui.SwingGUI;
import org.jpedal.examples.simpleviewer.gui.swing.SwingMouseHandler;
import org.jpedal.exception.PdfException;
import org.jpedal.render.DynamicVectorRenderer;
import org.jpedal.utils.Messages;

public final class SwingMouseSelection
implements MouseListener,
MouseMotionListener {
    private PdfDecoder decode_pdf;
    private int clickCount = 0;
    private long lastTime = -1L;
    protected static boolean activateMultipageHighlight = false;
    private SwingGUI currentGUI;
    private Values commonValues;
    public Rectangle area = null;
    public int id = -1;
    public int lastId = -1;
    private JPopupMenu rightClick = new JPopupMenu();
    private boolean menuCreated = false;
    private AutoScrollThread scrollThread = new AutoScrollThread();
    private SwingMouseHandler smh;
    JMenuItem copy;
    JMenuItem selectAll;
    JMenuItem deselectall;
    JMenu extract;
    JMenuItem extractText;
    JMenuItem extractImage;
    ImageIcon snapshotIcon;
    JMenuItem snapShot;
    JMenuItem find;

    public SwingMouseSelection(PdfDecoder pdfDecoder, Values values, SwingMouseHandler swingMouseHandler) {
        this.decode_pdf = pdfDecoder;
        this.smh = swingMouseHandler;
        this.currentGUI = (SwingGUI)pdfDecoder.getExternalHandler(11);
        this.commonValues = values;
        if (SwingUtilities.isEventDispatchThread()) {
            this.scrollThread.init();
        } else {
            Runnable runnable = new Runnable(){

                public void run() {
                    SwingMouseSelection.this.scrollThread.init();
                }
            };
            SwingUtilities.invokeLater(runnable);
        }
    }

    public void setupMouse() {
        this.decode_pdf.addMouseMotionListener(this);
        this.decode_pdf.addMouseListener(this);
        this.currentGUI.setCursor(3);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void mouseClicked(MouseEvent mouseEvent) {
        if (this.decode_pdf.getDisplayView() != 1 && !activateMultipageHighlight) return;
        long l = new Date().getTime();
        if (this.lastTime + 500L < l) {
            this.clickCount = 0;
        }
        this.lastTime = l;
        if (mouseEvent.getButton() == 1) {
            int n;
            if (this.clickCount != 4) {
                ++this.clickCount;
            }
            int[] nArray = this.smh.getCursorLocation();
            this.id = this.decode_pdf.getDynamicRenderer().isInsideImage(nArray[0], nArray[1]);
            if (this.lastId != this.id && this.id != -1) {
                this.area = this.decode_pdf.getDynamicRenderer().getArea(this.id);
                if (this.area != null) {
                    int n2 = this.area.height;
                    int n3 = this.area.width;
                    n = this.area.x;
                    int n4 = this.area.y;
                    this.decode_pdf.getDynamicRenderer().needsHorizontalInvert = false;
                    this.decode_pdf.getDynamicRenderer().needsVerticalInvert = false;
                    if (n3 < 0) {
                        this.decode_pdf.getDynamicRenderer().needsHorizontalInvert = true;
                        n3 = -n3;
                        n -= n3;
                    }
                    if (n2 < 0) {
                        this.decode_pdf.getDynamicRenderer().needsVerticalInvert = true;
                        n2 = -n2;
                        n4 -= n2;
                    }
                    if (this.decode_pdf.isImageExtractionAllowed()) {
                        this.decode_pdf.setHighlightedImage(new int[]{n, n4, n3, n2});
                    }
                }
                this.lastId = this.id;
            } else {
                if (this.decode_pdf.isImageExtractionAllowed()) {
                    this.decode_pdf.setHighlightedImage(null);
                }
                this.lastId = -1;
            }
            if (this.id != -1 || !DynamicVectorRenderer.textBasedHighlight || this.clickCount <= 1) return;
            switch (this.clickCount) {
                case 1: {
                    return;
                }
                case 2: {
                    Rectangle[] rectangleArray = this.decode_pdf.getLineAreas(this.commonValues.getCurrentPage());
                    Rectangle rectangle = new Rectangle(nArray[0], nArray[1], 1, 1);
                    if (rectangleArray == null) return;
                    for (n = 0; n != rectangleArray.length; ++n) {
                        if (!rectangleArray[n].intersects(rectangle)) continue;
                        this.currentGUI.setRectangle(rectangleArray[n]);
                        this.decode_pdf.updateCursorBoxOnScreen(rectangleArray[n], PdfDecoder.highlightColor);
                        this.decode_pdf.addHighlights(new Rectangle[]{rectangleArray[n]}, false, this.commonValues.getCurrentPage());
                    }
                    return;
                }
                case 3: {
                    Rectangle rectangle = this.decode_pdf.setFoundParagraph(nArray[0], nArray[1], this.commonValues.getCurrentPage());
                    if (rectangle == null) return;
                    this.currentGUI.setRectangle(rectangle);
                    this.decode_pdf.updateCursorBoxOnScreen(rectangle, PdfDecoder.highlightColor);
                    return;
                }
                case 4: {
                    this.currentGUI.currentCommands.executeCommand(26, null);
                }
            }
            return;
        }
        if (mouseEvent.getButton() != 2 && mouseEvent.getButton() != 3) return;
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
        this.scrollThread.setAutoScroll(false, 0, 0, 0);
    }

    public void mousePressed(MouseEvent mouseEvent) {
        if ((this.decode_pdf.getDisplayView() == 1 || activateMultipageHighlight) && mouseEvent.getButton() == 1) {
            this.currentGUI.setRectangle(null);
            this.decode_pdf.updateCursorBoxOnScreen(null, null);
            this.decode_pdf.setHighlightedImage(null);
            this.decode_pdf.clearHighlights();
            this.decode_pdf.grabFocus();
            float f = this.currentGUI.getScaling();
            SwingMouseSelection swingMouseSelection = this;
            int n = swingMouseSelection.currentGUI.getPDFDisplayInset();
            int n2 = this.currentGUI.getRotation();
            int n3 = (int)((float)(this.currentGUI.AdjustForAlignment(mouseEvent.getX()) - n) / f);
            int n4 = (int)((float)(mouseEvent.getY() - n) / f);
            if (this.commonValues.maxViewY != 0) {
                n3 = (int)((double)((float)n3 - (float)this.commonValues.dx * f) / this.commonValues.viewportScale);
                n4 = (int)(((double)this.currentGUI.mediaH - (double)((float)this.currentGUI.mediaH - (float)n4 / f - (float)this.commonValues.dy) / this.commonValues.viewportScale) * (double)f);
            }
            if (n2 == 90) {
                this.commonValues.m_y1 = n3 + this.currentGUI.cropY;
                this.commonValues.m_x1 = n4 + this.currentGUI.cropX;
            } else if (n2 == 180) {
                this.commonValues.m_x1 = this.currentGUI.mediaW - (n3 + this.currentGUI.mediaW - this.currentGUI.cropW - this.currentGUI.cropX);
                this.commonValues.m_y1 = n4 + this.currentGUI.cropY;
            } else if (n2 == 270) {
                this.commonValues.m_y1 = this.currentGUI.mediaH - (n3 + this.currentGUI.mediaH - this.currentGUI.cropH - this.currentGUI.cropY);
                this.commonValues.m_x1 = this.currentGUI.mediaW - (n4 + this.currentGUI.mediaW - this.currentGUI.cropW - this.currentGUI.cropX);
            } else {
                this.commonValues.m_x1 = n3 + this.currentGUI.cropX;
                this.commonValues.m_y1 = this.currentGUI.mediaH - (n4 + this.currentGUI.mediaH - this.currentGUI.cropH - this.currentGUI.cropY);
            }
        }
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        if (this.decode_pdf.getDisplayView() == 1 || activateMultipageHighlight) {
            if (mouseEvent.getButton() == 1) {
                this.decode_pdf.repaintArea(new Rectangle(this.commonValues.m_x1 - this.currentGUI.cropX, this.commonValues.m_y2 + this.currentGUI.cropY, this.commonValues.m_x2 - this.commonValues.m_x1 + this.currentGUI.cropX, this.commonValues.m_y1 - this.commonValues.m_y2 + this.currentGUI.cropY), this.currentGUI.mediaH);
                this.decode_pdf.repaint();
                if (this.decode_pdf.isExtractingAsImage()) {
                    this.currentGUI.setRectangle(null);
                    this.decode_pdf.updateCursorBoxOnScreen(null, null);
                    this.decode_pdf.clearHighlights();
                    this.decode_pdf.setHighlightedImage(null);
                    this.decode_pdf.setCursor(Cursor.getPredefinedCursor(0));
                    this.currentGUI.currentCommands.extractSelectedScreenAsImage();
                    this.decode_pdf.setExtractingAsImage(false);
                }
            } else if (mouseEvent.getButton() == 3 && this.currentGUI.getProperties().getValue("allowRightClick").toLowerCase().equals("true")) {
                if (!this.menuCreated) {
                    this.createRightClickMenu();
                }
                if (this.decode_pdf.getHighlightImage() == null) {
                    this.extractImage.setEnabled(false);
                } else {
                    this.extractImage.setEnabled(true);
                }
                if (this.decode_pdf.getHighlightedAreas(this.commonValues.getCurrentPage()) == null) {
                    this.extractText.setEnabled(false);
                    this.find.setEnabled(false);
                    this.copy.setEnabled(false);
                } else {
                    this.extractText.setEnabled(true);
                    this.find.setEnabled(true);
                    this.copy.setEnabled(true);
                }
                if (this.decode_pdf != null && this.decode_pdf.isOpen()) {
                    this.rightClick.show(this.decode_pdf, mouseEvent.getX(), mouseEvent.getY());
                }
            }
        }
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        int[] nArray = this.smh.updateXY(mouseEvent);
        this.commonValues.m_x2 = nArray[0];
        this.commonValues.m_y2 = nArray[1];
    }

    public void mouseMoved(MouseEvent mouseEvent) {
        int[] nArray = this.smh.updateXY(mouseEvent);
        int n = nArray[0];
        int n2 = nArray[1];
        this.decode_pdf.getObjectUnderneath(n, n2);
    }

    private void createRightClickMenu() {
        this.copy = new JMenuItem(Messages.getMessage("PdfRightClick.copy"));
        this.selectAll = new JMenuItem(Messages.getMessage("PdfRightClick.selectAll"));
        this.deselectall = new JMenuItem(Messages.getMessage("PdfRightClick.deselectAll"));
        this.extract = new JMenu(Messages.getMessage("PdfRightClick.extract"));
        this.extractText = new JMenuItem(Messages.getMessage("PdfRightClick.extractText"));
        this.extractImage = new JMenuItem(Messages.getMessage("PdfRightClick.extractImage"));
        this.snapshotIcon = new ImageIcon(this.getClass().getResource("/org/jpedal/examples/simpleviewer/res/snapshot_menu.gif"));
        this.snapShot = new JMenuItem(Messages.getMessage("PdfRightClick.snapshot"), this.snapshotIcon);
        this.find = new JMenuItem(Messages.getMessage("PdfRightClick.find"));
        this.rightClick.add(this.copy);
        this.copy.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ((SwingMouseSelection)SwingMouseSelection.this).currentGUI.currentCommands.executeCommand(25, null);
            }
        });
        this.rightClick.addSeparator();
        this.rightClick.add(this.selectAll);
        this.selectAll.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ((SwingMouseSelection)SwingMouseSelection.this).currentGUI.currentCommands.executeCommand(26, null);
            }
        });
        this.rightClick.add(this.deselectall);
        this.deselectall.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ((SwingMouseSelection)SwingMouseSelection.this).currentGUI.currentCommands.executeCommand(27, null);
            }
        });
        this.rightClick.addSeparator();
        this.rightClick.add(this.extract);
        this.extract.add(this.extractText);
        this.extractText.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (SwingMouseSelection.this.decode_pdf.getDisplayView() == 1) {
                    ((SwingMouseSelection)SwingMouseSelection.this).currentGUI.currentCommands.extractSelectedText();
                } else if (SimpleViewer.showMessages) {
                    JOptionPane.showMessageDialog(SwingMouseSelection.this.currentGUI.getFrame(), "Text Extraction is only avalible in single page display mode");
                }
            }
        });
        this.extract.add(this.extractImage);
        this.extractImage.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (SwingMouseSelection.this.decode_pdf.getHighlightImage() == null) {
                    if (SimpleViewer.showMessages) {
                        JOptionPane.showMessageDialog(SwingMouseSelection.this.decode_pdf, "No image has been selected for extraction.", "No image selected", 0);
                    }
                } else if (SwingMouseSelection.this.decode_pdf.getDisplayView() == 1) {
                    JFileChooser jFileChooser = new JFileChooser();
                    FileFilter fileFilter = new FileFilter(){

                        public boolean accept(File file) {
                            return file.isDirectory() || file.getName().toLowerCase().endsWith(".jpg") || file.getName().toLowerCase().endsWith(".jpeg");
                        }

                        public String getDescription() {
                            return "JPG (*.jpg)";
                        }
                    };
                    FileFilter fileFilter2 = new FileFilter(){

                        public boolean accept(File file) {
                            return file.isDirectory() || file.getName().toLowerCase().endsWith(".png");
                        }

                        public String getDescription() {
                            return "PNG (*.png)";
                        }
                    };
                    FileFilter fileFilter3 = new FileFilter(){

                        public boolean accept(File file) {
                            return file.isDirectory() || file.getName().toLowerCase().endsWith(".tif") || file.getName().toLowerCase().endsWith(".tiff");
                        }

                        public String getDescription() {
                            return "TIF (*.tiff)";
                        }
                    };
                    jFileChooser.addChoosableFileFilter(fileFilter3);
                    jFileChooser.addChoosableFileFilter(fileFilter2);
                    jFileChooser.addChoosableFileFilter(fileFilter);
                    jFileChooser.showSaveDialog(null);
                    File file = jFileChooser.getSelectedFile();
                    boolean bl = false;
                    if (file != null) {
                        String string = file.getAbsolutePath();
                        String string2 = jFileChooser.getFileFilter().getDescription().substring(0, 3).toLowerCase();
                        if (string.indexOf(46) != -1) {
                            String string3 = string.substring(string.indexOf(46) + 1).toLowerCase();
                            if (string3.equals("jpg") || string3.equals("jpeg")) {
                                string2 = "jpg";
                            } else if (string3.equals("png")) {
                                string2 = "png";
                            } else if (string3.equals("tif") || string3.equals("tiff")) {
                                string2 = "tiff";
                            } else {
                                if (SimpleViewer.showMessages) {
                                    JOptionPane.showMessageDialog(null, "Sorry, we can not currently save images to ." + string3 + " files.");
                                }
                                bl = true;
                            }
                        }
                        if (string2.equals("tif")) {
                            string2 = "tiff";
                        }
                        if (string2.equals("all")) {
                            string2 = "png";
                        }
                        if (!string.toLowerCase().endsWith('.' + string2)) {
                            string = string + '.' + string2;
                        }
                        if (!bl) {
                            SwingMouseSelection.this.decode_pdf.getDynamicRenderer().saveImage(SwingMouseSelection.this.id, string, string2);
                        }
                    }
                }
            }
        });
        this.extract.add(this.snapShot);
        this.snapShot.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ((SwingMouseSelection)SwingMouseSelection.this).currentGUI.currentCommands.executeCommand(13, null);
            }
        });
        this.rightClick.addSeparator();
        this.rightClick.add(this.find);
        this.find.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                int n;
                int n2;
                int n3;
                Rectangle rectangle = SwingMouseSelection.this.decode_pdf.getCursorBoxOnScreen();
                if (rectangle == null) {
                    if (SimpleViewer.showMessages) {
                        JOptionPane.showMessageDialog(SwingMouseSelection.this.decode_pdf, "There is no text selected.\nPlease highlight the text you wish to search.", "No Text selected", 0);
                    }
                    return;
                }
                String string = SwingMouseSelection.this.currentGUI.showInputDialog(Messages.getMessage("PdfViewerMessage.GetUserInput"));
                if (string == null || string.length() < 1) {
                    return;
                }
                int n4 = rectangle.x;
                int n5 = rectangle.x + rectangle.width;
                int n6 = rectangle.y;
                int n7 = rectangle.y + rectangle.height;
                if (n6 < n7) {
                    n3 = n7;
                    n7 = n6;
                    n6 = n3;
                }
                if (n4 > n5) {
                    n3 = n5;
                    n5 = n4;
                    n4 = n3;
                }
                if (n4 < ((SwingMouseSelection)SwingMouseSelection.this).currentGUI.cropX) {
                    n4 = ((SwingMouseSelection)SwingMouseSelection.this).currentGUI.cropX;
                }
                if (n4 > ((SwingMouseSelection)SwingMouseSelection.this).currentGUI.mediaW - ((SwingMouseSelection)SwingMouseSelection.this).currentGUI.cropX) {
                    n4 = ((SwingMouseSelection)SwingMouseSelection.this).currentGUI.mediaW - ((SwingMouseSelection)SwingMouseSelection.this).currentGUI.cropX;
                }
                if (n5 < ((SwingMouseSelection)SwingMouseSelection.this).currentGUI.cropX) {
                    n5 = ((SwingMouseSelection)SwingMouseSelection.this).currentGUI.cropX;
                }
                if (n5 > ((SwingMouseSelection)SwingMouseSelection.this).currentGUI.mediaW - ((SwingMouseSelection)SwingMouseSelection.this).currentGUI.cropX) {
                    n5 = ((SwingMouseSelection)SwingMouseSelection.this).currentGUI.mediaW - ((SwingMouseSelection)SwingMouseSelection.this).currentGUI.cropX;
                }
                if (n6 < ((SwingMouseSelection)SwingMouseSelection.this).currentGUI.cropY) {
                    n6 = ((SwingMouseSelection)SwingMouseSelection.this).currentGUI.cropY;
                }
                if (n6 > ((SwingMouseSelection)SwingMouseSelection.this).currentGUI.mediaH - ((SwingMouseSelection)SwingMouseSelection.this).currentGUI.cropY) {
                    n6 = ((SwingMouseSelection)SwingMouseSelection.this).currentGUI.mediaH - ((SwingMouseSelection)SwingMouseSelection.this).currentGUI.cropY;
                }
                if (n7 < ((SwingMouseSelection)SwingMouseSelection.this).currentGUI.cropY) {
                    n7 = ((SwingMouseSelection)SwingMouseSelection.this).currentGUI.cropY;
                }
                if (n7 > ((SwingMouseSelection)SwingMouseSelection.this).currentGUI.mediaH - ((SwingMouseSelection)SwingMouseSelection.this).currentGUI.cropY) {
                    n7 = ((SwingMouseSelection)SwingMouseSelection.this).currentGUI.mediaH - ((SwingMouseSelection)SwingMouseSelection.this).currentGUI.cropY;
                }
                n3 = 0;
                int n8 = SwingMouseSelection.this.currentGUI.showConfirmDialog(Messages.getMessage("PdfViewercase.message"), null, 0);
                if (n8 == 0) {
                    n3 |= 2;
                }
                if ((n2 = SwingMouseSelection.this.currentGUI.showConfirmDialog(Messages.getMessage("PdfViewerfindAll.message"), null, 0)) == 1) {
                    n3 |= 4;
                }
                if ((n = SwingMouseSelection.this.currentGUI.showConfirmDialog(Messages.getMessage("PdfViewerfindHyphen.message"), null, 0)) == 0) {
                    n3 |= 8;
                }
                if (string != null) {
                    try {
                        float[] fArray = (n3 & 8) == 8 ? SwingMouseSelection.this.decode_pdf.getGroupingObject().findTextInRectangleAcrossLines(n4, n6, n5, n7, SwingMouseSelection.this.commonValues.getCurrentPage(), string, n3) : SwingMouseSelection.this.decode_pdf.getGroupingObject().findTextInRectangle(n4, n6, n5, n7, SwingMouseSelection.this.commonValues.getCurrentPage(), string, n3);
                        if (fArray != null) {
                            if (fArray.length < 3) {
                                SwingMouseSelection.this.currentGUI.showMessageDialog(Messages.getMessage("PdfViewerMessage.Found") + ' ' + fArray[0] + ',' + fArray[1]);
                            } else {
                                StringBuffer stringBuffer = new StringBuffer();
                                String string2 = Messages.getMessage("PdfViewerMessage.FoundAt");
                                for (int i = 0; i < fArray.length; i += 5) {
                                    stringBuffer.append(string2).append(' ');
                                    stringBuffer.append(fArray[i]);
                                    stringBuffer.append(',');
                                    stringBuffer.append(fArray[i + 1]);
                                    stringBuffer.append('\n');
                                    string2 = fArray[i + 4] == -101.0f ? Messages.getMessage("PdfViewerMessage.FoundAtHyphen") : Messages.getMessage("PdfViewerMessage.FoundAt");
                                }
                                SwingMouseSelection.this.currentGUI.showMessageDialog(stringBuffer.toString());
                            }
                        } else {
                            SwingMouseSelection.this.currentGUI.showMessageDialog(Messages.getMessage("PdfViewerMessage.NotFound"));
                        }
                    }
                    catch (PdfException pdfException) {
                        pdfException.printStackTrace();
                    }
                }
            }
        });
        this.menuCreated = true;
        this.decode_pdf.add(this.rightClick);
    }

    class AutoScrollThread
    implements Runnable {
        Thread scroll = new Thread(this);
        boolean autoScroll = false;
        int x = 0;
        int y = 0;
        int interval = 0;
        int usedX;
        int usedY;

        public void setAutoScroll(boolean bl, int n, int n2, int n3) {
            this.autoScroll = bl;
            this.x = SwingMouseSelection.this.currentGUI.AdjustForAlignment(n);
            this.y = n2;
            this.interval = n3;
        }

        public void init() {
            this.scroll.start();
        }

        public void run() {
            while (Thread.currentThread().equals(this.scroll)) {
                if (this.autoScroll) {
                    final Rectangle rectangle = new Rectangle(this.x - this.interval, this.y - this.interval, this.interval * 2, this.interval * 2);
                    Rectangle rectangle2 = SwingMouseSelection.this.decode_pdf.getVisibleRect();
                    if (!rectangle2.contains(rectangle)) {
                        if (SwingUtilities.isEventDispatchThread()) {
                            SwingMouseSelection.this.decode_pdf.scrollRectToVisible(rectangle);
                        } else {
                            Runnable runnable = new Runnable(){

                                public void run() {
                                    SwingMouseSelection.this.decode_pdf.scrollRectToVisible(rectangle);
                                }
                            };
                            SwingUtilities.invokeLater(runnable);
                        }
                        if (this.x - this.interval * 2 < ((SwingMouseSelection)SwingMouseSelection.this).decode_pdf.getVisibleRect().x) {
                            this.x -= this.interval;
                        } else if (this.x + this.interval * 2 > ((SwingMouseSelection)SwingMouseSelection.this).decode_pdf.getVisibleRect().x + ((SwingMouseSelection)SwingMouseSelection.this).decode_pdf.getVisibleRect().width) {
                            this.x += this.interval;
                        }
                        if (this.y - this.interval * 2 < ((SwingMouseSelection)SwingMouseSelection.this).decode_pdf.getVisibleRect().y) {
                            this.y -= this.interval;
                        } else if (this.y + this.interval * 2 > ((SwingMouseSelection)SwingMouseSelection.this).decode_pdf.getVisibleRect().y + ((SwingMouseSelection)SwingMouseSelection.this).decode_pdf.getVisibleRect().height) {
                            this.y += this.interval;
                        }
                    }
                    this.usedX = this.x;
                    this.usedY = this.y;
                }
                try {
                    Thread.sleep(250L);
                }
                catch (InterruptedException interruptedException) {
                    break;
                }
            }
        }
    }
}

