/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.fonts.tt;

import java.util.Hashtable;
import org.jpedal.fonts.StandardFonts;
import org.jpedal.fonts.tt.FontFile2;
import org.jpedal.fonts.tt.Glyf;
import org.jpedal.fonts.tt.Table;
import org.jpedal.utils.LogWriter;

public class CMAP
extends Table {
    private int[][] glyphIndexToChar;
    private int[] glyphToIndex;
    private boolean hasSix = false;
    private int winScore = 0;
    private int macScore = 0;
    int segCount = 0;
    int fontMapping = 0;
    int[] endCode;
    int[] startCode;
    int[] idDelta;
    int[] idRangeOffset;
    int[] glyphIdArray;
    int[] f6glyphIdArray;
    int[] offset;
    private int[] CMAPformats;
    private boolean maybeWinEncoded = false;
    int[] platformID;
    private static Hashtable exceptions = new Hashtable();
    private int formatToUse;
    private int encodingToUse = 0;
    private static boolean WINchecked;

    public CMAP(FontFile2 fontFile2, int n, Glyf glyf) {
        if (n == 0) {
            LogWriter.writeLog("No CMAP table found");
        } else {
            int n2;
            fontFile2.getNextUint16();
            int n3 = fontFile2.getNextUint16();
            int[] nArray = new int[n3];
            this.platformID = new int[n3];
            int[] nArray2 = new int[n3];
            this.CMAPformats = new int[n3];
            this.glyphIndexToChar = new int[n3][256];
            this.glyphToIndex = new int[256];
            for (n2 = 0; n2 < n3; ++n2) {
                this.platformID[n2] = fontFile2.getNextUint16();
                nArray2[n2] = fontFile2.getNextUint16();
                nArray[n2] = fontFile2.getNextUint32();
            }
            for (n2 = 0; n2 < n3; ++n2) {
                int n4;
                int n5;
                int n6;
                int n7;
                fontFile2.selectTable(2);
                fontFile2.skip(nArray[n2]);
                this.CMAPformats[n2] = fontFile2.getNextUint16();
                int n8 = fontFile2.getNextUint16();
                fontFile2.getNextUint16();
                if (this.CMAPformats[n2] == 6) {
                    this.hasSix = true;
                }
                if (this.CMAPformats[n2] == 0 && n8 == 262) {
                    StandardFonts.checkLoaded(2);
                    StandardFonts.checkLoaded(0);
                    for (n7 = 0; n7 < 256; ++n7) {
                        this.glyphIndexToChar[n2][n7] = n6 = fontFile2.getNextUint8();
                        this.glyphToIndex[n6] = n7;
                        if (n6 <= 0) continue;
                        n5 = StandardFonts.isValidMacEncoding(n7) ? 1 : 0;
                        if (n5 != (n4 = (int)(StandardFonts.isValidWinEncoding(n7) ? 1 : 0))) {
                            this.maybeWinEncoded = true;
                        }
                        if (n5 != 0) {
                            ++this.macScore;
                        }
                        if (n4 == 0) continue;
                        ++this.winScore;
                    }
                    continue;
                }
                if (this.CMAPformats[n2] == 4) {
                    this.segCount = fontFile2.getNextUint16() / 2;
                    fontFile2.getNextUint16();
                    fontFile2.getNextUint16();
                    fontFile2.getNextUint16();
                    this.endCode = new int[this.segCount];
                    for (n5 = 0; n5 < this.segCount; ++n5) {
                        this.endCode[n5] = fontFile2.getNextUint16();
                    }
                    fontFile2.getNextUint16();
                    this.startCode = new int[this.segCount];
                    for (n5 = 0; n5 < this.segCount; ++n5) {
                        this.startCode[n5] = fontFile2.getNextUint16();
                    }
                    this.idDelta = new int[this.segCount];
                    for (n5 = 0; n5 < this.segCount; ++n5) {
                        this.idDelta[n5] = fontFile2.getNextUint16();
                    }
                    this.idRangeOffset = new int[this.segCount];
                    for (n5 = 0; n5 < this.segCount; ++n5) {
                        this.idRangeOffset[n5] = fontFile2.getNextUint16();
                    }
                    this.offset = new int[this.segCount];
                    n4 = 0;
                    for (n7 = 0; n7 < this.segCount; ++n7) {
                        if (this.idDelta[n7] != 0) continue;
                        this.offset[n7] = n4;
                        n5 = 1 + this.endCode[n7] - this.startCode[n7];
                        if (this.startCode[n7] == this.endCode[n7] && this.idRangeOffset[n7] == 0) {
                            n5 = 0;
                        }
                        n4 += n5;
                    }
                    n7 = (n8 - 16 - this.segCount * 8) / 2;
                    this.glyphIdArray = new int[n7];
                    for (n6 = 0; n6 < n7; ++n6) {
                        this.glyphIdArray[n6] = fontFile2.getNextUint16();
                    }
                    continue;
                }
                if (this.CMAPformats[n2] == 6) {
                    n5 = fontFile2.getNextUint16();
                    n4 = fontFile2.getNextUint16();
                    this.f6glyphIdArray = new int[n5 + n4];
                    for (n7 = 0; n7 < n4; ++n7) {
                        this.f6glyphIdArray[n7 + n5] = fontFile2.getNextUint16();
                    }
                    continue;
                }
                this.CMAPformats[n2] = -1;
            }
        }
    }

    public int convertIndexToCharacterCode(String string, int n, boolean bl, boolean bl2, String[] stringArray) {
        int n2 = -1;
        int n3 = n;
        int n4 = this.CMAPformats[this.formatToUse];
        if ((this.fontMapping == 1 || !bl && this.fontMapping == 4) && string != null && !string.equals("notdef")) {
            n = StandardFonts.getAdobeMap(string);
        } else if (this.fontMapping == 2) {
            StandardFonts.checkLoaded(this.encodingToUse);
            if (this.encodingToUse == 0) {
                Object var10_9 = null;
                if (string != null) {
                    var10_9 = exceptions.get(string);
                }
                if (var10_9 == null) {
                    if (string != null && !bl2) {
                        n = StandardFonts.lookupCharacterIndex(string, this.encodingToUse);
                    }
                } else if (stringArray == null || stringArray[n] == null) {
                    try {
                        n = Integer.parseInt(var10_9);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if (string != null) {
                    if (!WINchecked) {
                        StandardFonts.checkLoaded(2);
                        WINchecked = true;
                    }
                    n2 = StandardFonts.lookupCharacterIndex(string, 2);
                }
            } else if (string != null) {
                n = StandardFonts.lookupCharacterIndex(string, this.encodingToUse);
            }
        }
        int n5 = -1;
        if (bl && n4 > 0 && n4 != 6) {
            n += 61440;
        }
        if (n4 == 0) {
            if (n > 255) {
                n = 0;
            }
            if ((n5 = this.glyphIndexToChar[this.formatToUse][n]) == 0 && n2 != -1) {
                n5 = this.glyphIndexToChar[this.formatToUse][n2];
            }
            if (n5 == 0 && n == 128 && this.endCode != null && string.equals("Euro")) {
                n5 = this.getFormat4Value(8364, false, n5);
            }
        } else if (n4 == 4) {
            n5 = this.getFormat4Value(n, false, n5);
        }
        if (n5 == -1 && this.hasSix) {
            n = n3;
            n4 = 6;
        }
        if (n4 == 6) {
            n5 = n >= this.f6glyphIdArray.length ? 0 : this.f6glyphIdArray[n];
        }
        return n5;
    }

    private int getFormat4Value(int n, boolean bl, int n2) {
        for (int i = 0; i < this.segCount; ++i) {
            if (bl) {
                System.out.println("Segtable=" + i + " start=" + this.startCode[i] + " " + n + " end=" + this.endCode[i] + " idRangeOffset[i]=" + this.idRangeOffset[i] + " offset[i]=" + this.offset[i] + " idRangeOffset[i]=" + this.idRangeOffset[i] + " idDelta[i]=" + this.idDelta[i]);
            }
            if (this.endCode[i] < n || this.startCode[i] > n) continue;
            if (this.idRangeOffset[i] == 0) {
                if (bl) {
                    System.out.println("xxx=" + (this.idDelta[i] + n));
                }
                n2 = (this.idDelta[i] + n) % 65536;
                i = this.segCount;
                continue;
            }
            int n3 = this.offset[i] + (n - this.startCode[i]);
            n2 = this.glyphIdArray[n3];
            if (bl) {
                System.out.println("value=" + n2 + " idx=" + n3 + " glyphIdArrays=" + this.glyphIdArray[0] + " " + this.glyphIdArray[1] + " " + this.glyphIdArray[2] + " offset[i]=" + this.offset[i] + " index=" + n + " startCode[" + i + "]=" + this.startCode[i] + " i=" + i);
            }
            i = this.segCount;
        }
        return n2;
    }

    public void setEncodingToUse(boolean bl, int n, boolean bl2, boolean bl3) {
        int n2;
        int n3;
        this.formatToUse = -1;
        int n4 = this.platformID.length;
        if (!(bl2 || this.macScore >= 207 || this.glyphToIndex != null && this.macScore > 90 && !this.maybeWinEncoded || this.glyphToIndex != null && this.macScore > 205 && this.glyphToIndex[138] != 0 && this.glyphToIndex[228] == 0)) {
            if (n4 > 0 && this.winScore > this.macScore) {
                this.encodingToUse = 2;
            }
            if (this.macScore > 80 && bl && n == 2 && this.winScore >= this.macScore) {
                this.encodingToUse = 2;
            }
        }
        for (n3 = 0; n3 < n4; ++n3) {
            if (this.platformID[n3] != 3 || this.CMAPformats[n3] != 1) continue;
            this.formatToUse = n3;
            this.fontMapping = 1;
            n3 = n4;
        }
        if (this.formatToUse == -1 && !bl3 && (!bl2 || this.CMAPformats.length == 1 && this.CMAPformats[0] == 0)) {
            for (n3 = 0; n3 < n4; ++n3) {
                if (this.platformID[n3] != 1 || this.CMAPformats[n3] != 0) continue;
                this.formatToUse = n3;
                this.fontMapping = bl || n == 2 ? 2 : 3;
                n3 = n4;
            }
        }
        n3 = 0;
        if (this.formatToUse == -1) {
            for (n2 = 0; n2 < n4; ++n2) {
                if (this.CMAPformats[n2] != 6) continue;
                this.formatToUse = n2;
                if (!bl && n == 2) {
                    this.fontMapping = 2;
                    StandardFonts.checkLoaded(0);
                } else {
                    this.fontMapping = 6;
                }
                n3 = 1;
                n2 = n4;
            }
        }
        if (this.formatToUse == -1 || n3 != 0) {
            for (n2 = 0; n2 < n4; ++n2) {
                if (this.CMAPformats[n2] != 4) continue;
                this.formatToUse = n2;
                this.fontMapping = 4;
                n2 = n4;
            }
        }
        if (n == 5) {
            this.fontMapping = 2;
        }
        if (this.encodingToUse == 2 && this.macScore == this.winScore && this.glyphIndexToChar[this.formatToUse][146] == 0 && this.glyphIndexToChar[this.formatToUse][213] != 0) {
            this.encodingToUse = 0;
        }
        if (this.encodingToUse == 2 && this.macScore == this.winScore && this.glyphIndexToChar[this.formatToUse][228] == 0 && this.glyphIndexToChar[this.formatToUse][138] != 0) {
            this.encodingToUse = 0;
        }
    }

    static {
        String[] stringArray = new String[]{"notequal", "173", "infinity", "176", "lessequal", "178", "greaterequal", "179", "partialdiff", "182", "summation", "183", "product", "184", "pi", "185", "integral", "186", "Omega", "189", "radical", "195", "approxequal", "197", "Delta", "198", "lozenge", "215", "Euro", "219", "apple", "240"};
        for (int i = 0; i < stringArray.length; i += 2) {
            exceptions.put(stringArray[i], stringArray[i + 1]);
        }
    }
}

