/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.io;

import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.util.Hashtable;
import java.util.Map;
import org.jpedal.objects.raw.PdfObject;

public class LinearizedHintTable {
    PdfObject linearObj;
    PdfObject hintObj;
    Map startRefs = new Hashtable();
    Map endRefs = new Hashtable();
    static final int[] mask = new int[]{255, 127, 63, 31, 15, 7, 3, 1};
    static final int[] shift = new int[]{0, 8, 16, 24};
    int[] pageObjectCount = null;
    int[] obj = null;
    int[] pageLength;
    long[] pageStart;
    FileChannel fos = null;
    boolean finishedReading = false;

    public LinearizedHintTable(FileChannel fileChannel) {
        this.fos = fileChannel;
    }

    public void readTable(PdfObject pdfObject, PdfObject pdfObject2, int n, long l) {
        this.hintObj = pdfObject;
        this.linearObj = pdfObject2;
        byte[] byArray = pdfObject.getDecodedStream();
        int n2 = pdfObject2.getInt(30);
        this.parseHintTable(n2, n, l, byArray);
    }

    private void parseHintTable(int n, int n2, long l, byte[] byArray) {
        int n3;
        int n4 = 0;
        this.pageObjectCount = new int[n + 1];
        this.obj = new int[n + 1];
        this.pageStart = new long[n + 1];
        this.pageLength = new int[n + 1];
        int[] nArray = new int[n + 1];
        int[] nArray2 = new int[n + 1];
        int[] nArray3 = new int[n + 1];
        int n5 = ((byArray[n4] & 0xFF) << 24) + ((byArray[n4 + 1] & 0xFF) << 16) + ((byArray[n4 + 2] & 0xFF) << 8) + (byArray[n4 + 3] & 0xFF);
        long l2 = ((byArray[n4 += 4] & 0xFF) << 24) + ((byArray[n4 + 1] & 0xFF) << 16) + ((byArray[n4 + 2] & 0xFF) << 8) + (byArray[n4 + 3] & 0xFF);
        int n6 = ((byArray[n4 += 4] & 0xFF) << 8) + (byArray[n4 + 1] & 0xFF);
        int n7 = ((byArray[n4 += 2] & 0xFF) << 24) + ((byArray[n4 + 1] & 0xFF) << 16) + ((byArray[n4 + 2] & 0xFF) << 8) + (byArray[n4 + 3] & 0xFF);
        int n8 = ((byArray[n4 += 4] & 0xFF) << 8) + (byArray[n4 + 1] & 0xFF);
        l2 = ((byArray[n4 += 2] & 0xFF) << 24) + ((byArray[n4 + 1] & 0xFF) << 16) + ((byArray[n4 + 2] & 0xFF) << 8) + (byArray[n4 + 3] & 0xFF);
        l2 = ((byArray[n4 += 4] & 0xFF) << 8) + (byArray[n4 + 1] & 0xFF);
        l2 = ((byArray[n4 += 2] & 0xFF) << 24) + ((byArray[n4 + 1] & 0xFF) << 16) + ((byArray[n4 + 2] & 0xFF) << 8) + (byArray[n4 + 3] & 0xFF);
        l2 = ((byArray[n4 += 4] & 0xFF) << 8) + (byArray[n4 + 1] & 0xFF);
        int n9 = ((byArray[n4 += 2] & 0xFF) << 8) + (byArray[n4 + 1] & 0xFF);
        int n10 = ((byArray[n4 += 2] & 0xFF) << 8) + (byArray[n4 + 1] & 0xFF);
        int n11 = ((byArray[n4 += 2] & 0xFF) << 8) + (byArray[n4 + 1] & 0xFF);
        int n12 = ((byArray[n4 += 2] & 0xFF) << 8) + (byArray[n4 + 1] & 0xFF);
        int n13 = (n4 += 2) << 3;
        int n14 = 0;
        for (n3 = 0; n3 < n; ++n3) {
            this.pageObjectCount[n3 + 1] = n5 + this.getBitsFromByteStream(n13, n6, byArray);
            n14 += this.pageObjectCount[n3 + 1];
            n13 += n6;
        }
        this.obj[1] = n2;
        this.obj[2] = 1;
        for (n3 = 3; n3 < n; ++n3) {
            this.obj[n3] = this.obj[n3 - 1] + this.pageObjectCount[n3];
        }
        n13 = n13 + 7 >> 3 << 3;
        for (n3 = 0; n3 < n; ++n3) {
            this.pageLength[n3 + 1] = n7 + this.getBitsFromByteStream(n13, n8, byArray);
            n13 += n8;
        }
        for (n3 = 0; n3 < n; ++n3) {
            this.pageStart[n3 + 1] = n3 == 0 ? l : this.pageStart[n3] + (long)this.pageLength[n3];
        }
        n13 = n13 + 7 >> 3 << 3;
        for (n3 = 0; n3 < n; ++n3) {
            nArray[n3 + 1] = this.getBitsFromByteStream(n13, n9, byArray);
            n13 += n8;
        }
        n13 = n13 + 7 >> 3 << 3;
        for (n3 = 1; n3 < n; ++n3) {
            nArray2[n3 + 1] = this.getBitsFromByteStream(n13, n10, byArray);
            n13 += n8;
        }
    }

    private int getBitsFromByteStream(int n, int n2, byte[] byArray) {
        int n3 = 0;
        int n4 = n >> 3;
        int n5 = n & 7;
        int n6 = (n2 + n5 >> 3) + 1;
        int n7 = (n6 << 3) - n5 - n2;
        if (n5 == 0) {
            n7 = (n6 << 3) - n2 & 7;
        }
        if (n6 > 4) {
            return 0;
        }
        for (int i = 0; i < n6; ++i) {
            int n8 = byArray[n4 + i] & 0xFF;
            if (i == 0) {
                n8 &= mask[n5];
            }
            n3 += n8 << shift[n6 - (i + 1)];
        }
        return n3 >>= n7;
    }

    private void parseSharedObjectHintTable(int n, int n2, byte[] byArray) {
        int n3 = n2;
        int[] nArray = new int[n + 1];
        System.out.println("-----header----");
        int n4 = ((byArray[n3] & 0xFF) << 24) + ((byArray[n3 + 1] & 0xFF) << 16) + ((byArray[n3 + 2] & 0xFF) << 8) + (byArray[n3 + 3] & 0xFF);
        System.out.println("firstSharedObject=" + n4 + " ( " + byArray[n3] + " " + byArray[n3 + 1] + " " + byArray[n3 + 2] + " " + byArray[n3 + 3] + " )");
        int n5 = ((byArray[n3 += 4] & 0xFF) << 24) + ((byArray[n3 + 1] & 0xFF) << 16) + ((byArray[n3 + 2] & 0xFF) << 8) + (byArray[n3 + 3] & 0xFF);
        System.out.println("firstSharedObjectOffset=" + n5 + " ( " + byArray[n3] + " " + byArray[n3 + 1] + " " + byArray[n3 + 2] + " " + byArray[n3 + 3] + " )");
        int n6 = ((byArray[n3 += 4] & 0xFF) << 24) + ((byArray[n3 + 1] & 0xFF) << 16) + ((byArray[n3 + 2] & 0xFF) << 8) + (byArray[n3 + 3] & 0xFF);
        System.out.println("numberOfSharedObjectsOnFirstPage=" + n6 + " ( " + byArray[n3] + " " + byArray[n3 + 1] + " " + byArray[n3 + 2] + " " + byArray[n3 + 3] + " )");
        int n7 = ((byArray[n3 += 4] & 0xFF) << 24) + ((byArray[n3 + 1] & 0xFF) << 16) + ((byArray[n3 + 2] & 0xFF) << 8) + (byArray[n3 + 3] & 0xFF);
        System.out.println("numberOfSharedEntries=" + n7 + " ( " + byArray[n3] + " " + byArray[n3 + 1] + " " + byArray[n3 + 2] + " " + byArray[n3 + 3] + " )");
        int n8 = ((byArray[n3 += 4] & 0xFF) << 8) + (byArray[n3 + 1] & 0xFF);
        System.out.println("bitsNeededForSharedObjectGroup=" + n8 + " ( " + byArray[n3] + " " + byArray[n3 + 1] + " )");
        int n9 = ((byArray[n3 += 2] & 0xFF) << 24) + ((byArray[n3 + 1] & 0xFF) << 16) + ((byArray[n3 + 2] & 0xFF) << 8) + (byArray[n3 + 3] & 0xFF);
        System.out.println("smallestSharedGroupObjectSize=" + n9 + " ( " + byArray[n3] + " " + byArray[n3 + 1] + " " + byArray[n3 + 2] + " " + byArray[n3 + 3] + " )");
        int n10 = ((byArray[n3 += 4] & 0xFF) << 8) + (byArray[n3 + 1] & 0xFF);
        System.out.println("smallestSharedGroupObjectLength=" + n10 + " ( " + byArray[n3] + " " + byArray[n3 + 1] + " )");
        n3 += 2;
    }

    public int getPageObjectRef(int n) {
        if (this.obj == null || this.obj.length <= n) {
            return -1;
        }
        return this.obj[n];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized byte[] getObjData(int n) {
        if (this.finishedReading) {
            return null;
        }
        Integer n2 = new Integer(n);
        if (!this.startRefs.containsKey(n2) || !this.endRefs.containsKey(n2)) {
            return null;
        }
        int n3 = (Integer)this.startRefs.get(n2);
        int n4 = (Integer)this.endRefs.get(n2);
        int n5 = n4 - n3 + 1;
        long l = 0L;
        try {
            if (this.fos.isOpen()) {
                l = this.fos.size() - (long)(2 * n5);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            l = 0L;
        }
        if (l < (long)n4 || n4 - n3 < 1) {
            return null;
        }
        byte[] byArray = null;
        try {
            FileChannel fileChannel = this.fos;
            synchronized (fileChannel) {
                ByteBuffer byteBuffer = ByteBuffer.allocateDirect(n5);
                this.fos.read(byteBuffer, n3);
                byteBuffer.clear();
                byArray = new byte[byteBuffer.capacity()];
                byteBuffer.get(byArray, 0, byArray.length);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            byArray = null;
        }
        return byArray;
    }

    public void storeOffset(int n, int n2, int n3) {
        this.startRefs.put(new Integer(n), new Integer(n2));
        this.endRefs.put(new Integer(n), new Integer(n3));
    }

    public void setFinishedReading() {
        this.finishedReading = true;
    }
}

