/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.objects.raw;

import java.awt.Color;
import java.awt.Font;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import org.jpedal.color.DeviceCMYKColorSpace;
import org.jpedal.io.PdfReader;
import org.jpedal.objects.acroforms.actions.ActionHandler;
import org.jpedal.objects.raw.MKObject;
import org.jpedal.objects.raw.PdfArrayIterator;
import org.jpedal.objects.raw.PdfDictionary;
import org.jpedal.objects.raw.PdfObject;
import org.jpedal.utils.MEUtils;

public class FormObject
extends PdfObject {
    private int formType = -1;
    private int rawRotation = 0;
    private boolean isKid = false;
    private String Filter = null;
    private String Location = null;
    private String M;
    private String Reason;
    private String SubFilter;
    private byte[] rawFilter;
    private byte[] rawLocation;
    private byte[] rawM;
    private byte[] rawReason;
    private byte[] rawSubFilter;
    private Color cColor;
    private String contents;
    private boolean show = false;
    private Map OptValues = null;
    private boolean popupBuilt = false;
    private Object popupObj;
    public static final int READONLY_ID = 1;
    public static final int REQUIRED_ID = 2;
    public static final int NOEXPORT_ID = 3;
    public static final int MULTILINE_ID = 12;
    public static final int PASSWORD_ID = 13;
    public static final int NOTOGGLETOOFF_ID = 14;
    public static final int RADIO_ID = 15;
    public static final int PUSHBUTTON_ID = 16;
    public static final int COMBO_ID = 17;
    public static final int EDIT_ID = 18;
    public static final int SORT_ID = 19;
    public static final int FILESELECT_ID = 20;
    public static final int MULTISELECT_ID = 21;
    public static final int DONOTSPELLCHECK_ID = 22;
    public static final int DONOTSCROLL_ID = 23;
    public static final int COMB_ID = 24;
    public static final int RICHTEXT_ID = 25;
    public static final int RADIOINUNISON_ID = 25;
    public static final int COMMITONSELCHANGE_ID = 26;
    private String[] OptString = null;
    protected boolean isXFAObject = false;
    private String parentRef;
    private String selectedItem;
    private boolean textColorChanged = false;
    private float[] textColor;
    private Font textFont;
    private int textSize = -1;
    private String textString = null;
    private boolean appearancesUsed = false;
    private boolean offsetDownIcon = false;
    private boolean noDownIcon = false;
    private boolean invertDownIcon = false;
    private String onState;
    private String currentState;
    private String normalOnState;
    private BufferedImage normalOffImage = null;
    private BufferedImage normalOnImage;
    private BufferedImage rolloverOffImage = null;
    private BufferedImage rolloverOnImage;
    private BufferedImage downOffImage = null;
    private BufferedImage downOnImage;
    public static final int POPUP = 1;
    public static final boolean newfieldnameRead = true;
    private String layerName = null;
    private ActionHandler formHandler;
    private boolean[] Farray = null;
    protected Rectangle BBox = null;
    protected float[] C;
    protected float[] RD;
    protected float[] Rect;
    protected boolean[] flags = new boolean[32];
    boolean Open = true;
    boolean H_Boolean = true;
    protected int F = -1;
    protected int Ff = -1;
    protected int MaxLen = -1;
    protected int W = -1;
    protected int Q = -1;
    int SigFlags = -1;
    int StructParent = -1;
    protected int TI = -1;
    protected PdfObject A;
    private int popupFlag = 0;
    protected PdfObject AA;
    protected PdfObject AP = null;
    protected PdfObject Cdict;
    private PdfObject BI;
    protected PdfObject BS;
    protected PdfObject D;
    protected PdfObject IF;
    private PdfObject MK;
    private PdfObject DC;
    private PdfObject DP;
    private PdfObject DS;
    private PdfObject E;
    private PdfObject Fdict;
    private PdfObject Fo;
    private PdfObject FS;
    private PdfObject JS;
    private PdfObject K;
    private PdfObject Nobj;
    private PdfObject Next;
    private PdfObject O;
    private PdfObject PC;
    private PdfObject PI;
    private PdfObject PO;
    private PdfObject Popup;
    private PdfObject PV;
    private PdfObject R;
    private PdfObject Sig;
    private PdfObject Sound;
    private PdfObject U;
    private PdfObject V;
    private PdfObject Win;
    private PdfObject WP;
    private PdfObject WS;
    private PdfObject X;
    protected int[] ByteRange;
    protected int[] I;
    protected byte[] rawAS;
    protected byte[] rawCert;
    protected byte[] rawContactInfo;
    protected byte[] rawContents;
    protected byte[] rawDstring;
    protected byte[] rawDA;
    protected byte[] rawDV;
    protected byte[] rawFstring;
    protected byte[] rawJS;
    protected byte[] rawH;
    protected byte[] rawN;
    protected byte[] rawNM;
    protected byte[] rawPstring;
    protected byte[] rawRC;
    protected byte[] rawS;
    protected byte[] rawSubj;
    protected byte[] rawT;
    protected byte[] rawTM;
    protected byte[] rawTU;
    protected byte[] rawURI;
    protected byte[] rawV;
    protected int FT = -1;
    protected String AS;
    protected String Cert;
    protected String ContactInfo;
    protected String Contents;
    protected String Dstring;
    protected String DA;
    protected String DV;
    protected String Fstring;
    protected String JSString;
    protected String H;
    protected String N;
    protected String NM;
    protected String Pstring;
    protected String RC;
    protected String S;
    protected String Subj;
    protected String T;
    protected String TM;
    protected String TU;
    protected String URI;
    protected String Vstring;
    private byte[][] Border;
    private byte[][] DmixedArray;
    private byte[][] Fields;
    private byte[][] State;
    private byte[][] rawXFAasArray;
    protected PdfObject Bl;
    protected PdfObject OC;
    protected PdfObject Off;
    protected PdfObject On;
    protected PdfObject P;
    private PdfObject XFAasStream;
    protected Object[] Opt;
    protected Object[] Reference;
    protected byte[][] Kids;
    private boolean formChanged = false;
    public int display = -1;

    public FormObject(String string) {
        super(string);
        this.objType = 373244477;
    }

    public FormObject(String string, boolean bl) {
        super(string);
        this.objType = 373244477;
        this.includeParent = bl;
    }

    public FormObject(int n, int n2) {
        super(n, n2);
        this.objType = 373244477;
    }

    public FormObject(int n) {
        super(n);
        this.objType = 373244477;
    }

    public FormObject() {
        this.objType = 373244477;
    }

    public FormObject(String string, ActionHandler actionHandler, int n) {
        super(string);
        this.formHandler = actionHandler;
        this.objType = 373244477;
        this.rawRotation = n;
    }

    public FormObject(String string, ActionHandler actionHandler) {
        super(string);
        this.formHandler = actionHandler;
        this.objType = 373244477;
    }

    public FormObject(String string, int n) {
        super(string);
        this.objType = 373244477;
        this.parentType = n;
    }

    public ActionHandler getHandler() {
        return this.formHandler;
    }

    public void setHandler(ActionHandler actionHandler) {
        this.formHandler = actionHandler;
    }

    private void copyMK(PdfObject pdfObject) {
        int n = pdfObject.getDictionary(7451).getInt(9248);
        if (n != -1) {
            this.getDictionary(7451).setIntNumber(9248, n);
        }
        int n2 = pdfObject.getDictionary(7451).getInt(34);
        this.getDictionary(7451).setIntNumber(34, n2);
        int[] nArray = new int[]{4371, 4881, 8723};
        for (int i = 0; i < nArray.length; ++i) {
            byte[] byArray = pdfObject.getDictionary(7451).getTextStreamValueAsByte(nArray[i]);
            if (byArray == null) continue;
            this.getDictionary(7451).setTextStreamValue(nArray[i], byArray);
        }
        int[] nArray2 = new int[]{4627, 4631};
        for (int i = 0; i < nArray2.length; ++i) {
            float[] fArray = pdfObject.getDictionary(7451).getFloatArray(nArray2[i]);
            if (fArray == null) continue;
            this.getDictionary(7451).setFloatArray(nArray2[i], fArray);
        }
    }

    public boolean getBoolean(int n) {
        switch (n) {
            case 524301630: {
                return this.Open;
            }
            case 24: {
                return this.H_Boolean;
            }
        }
        return super.getBoolean(n);
    }

    public void setBoolean(int n, boolean bl) {
        switch (n) {
            case 524301630: {
                this.Open = bl;
                break;
            }
            case 24: {
                this.H_Boolean = bl;
                break;
            }
            default: {
                super.setBoolean(n, bl);
            }
        }
    }

    public void setActionFlag(int n) {
        this.popupFlag = n;
    }

    public int getActionFlag() {
        return this.popupFlag;
    }

    public PdfObject getDictionary(int n) {
        switch (n) {
            case 17: {
                return this.A;
            }
            case 4369: {
                return this.AA;
            }
            case 4384: {
                if (this.AP == null) {
                    this.AP = new FormObject();
                }
                return this.AP;
            }
            case 4633: {
                return this.BI;
            }
            case 4668: {
                return this.Bl;
            }
            case 4643: {
                return this.BS;
            }
            case 19: {
                return this.Cdict;
            }
            case 20: {
                return this.D;
            }
            case 5139: {
                return this.DC;
            }
            case 5152: {
                return this.DP;
            }
            case 5155: {
                return this.DS;
            }
            case 21: {
                return this.E;
            }
            case 22: {
                return this.Fdict;
            }
            case 5695: {
                return this.Fo;
            }
            case 5667: {
                return this.FS;
            }
            case 6691: {
                return this.JS;
            }
            case 6422: {
                return this.IF;
            }
            case 27: {
                return this.K;
            }
            case 7451: {
                if (this.MK == null) {
                    this.MK = new MKObject();
                }
                return this.MK;
            }
            case 30: {
                return this.Nobj;
            }
            case 506808388: {
                return this.Next;
            }
            case 31: {
                return this.O;
            }
            case 7955: {
                return this.OC;
            }
            case 2045494: {
                return this.Off;
            }
            case 7998: {
                return this.On;
            }
            case 32: {
                return this.P;
            }
            case 8211: {
                return this.PC;
            }
            case 8217: {
                return this.PI;
            }
            case 8223: {
                return this.PO;
            }
            case 1061176672: {
                return this.Popup;
            }
            case 8230: {
                return this.PV;
            }
            case 34: {
                return this.R;
            }
            case 2308407: {
                return this.Sig;
            }
            case 1061502534: {
                return this.Sound;
            }
            case 37: {
                return this.U;
            }
            case 38: {
                return this.V;
            }
            case 2570558: {
                return this.Win;
            }
            case 10016: {
                return this.WP;
            }
            case 10019: {
                return this.WS;
            }
            case 40: {
                return this.X;
            }
            case 2627089: {
                return this.XFAasStream;
            }
        }
        return super.getDictionary(n);
    }

    public void setIntNumber(int n, int n2) {
        block0 : switch (n) {
            case 22: {
                this.F = n2;
                break;
            }
            case 5686: {
                this.Ff = n2;
                this.commandFf(this.Ff);
                break;
            }
            case 33: {
                switch (n2) {
                    case 0: {
                        this.Q = 2;
                        break block0;
                    }
                    case 1: {
                        this.Q = 0;
                        break block0;
                    }
                    case 2: {
                        this.Q = 4;
                        break block0;
                    }
                }
                this.Q = 2;
                break;
            }
            case 1209815663: {
                this.MaxLen = n2;
                break;
            }
            case 1144088180: {
                if (this.MK == null) {
                    this.MK = new MKObject();
                }
                if (this.rawRotation == 0) {
                    this.MK.setIntNumber(34, n2);
                    break;
                }
                int n3 = this.rawRotation - n2;
                if (n3 < 0) {
                    n3 = 360 + n3;
                }
                this.MK.setIntNumber(34, n3);
                break;
            }
            case 1600810585: {
                this.SigFlags = n2;
                break;
            }
            case -1732403014: {
                this.StructParent = n2;
                break;
            }
            case 9241: {
                this.TI = n2;
                break;
            }
            case 39: {
                this.W = n2;
                break;
            }
            default: {
                super.setIntNumber(n, n2);
            }
        }
    }

    public int getInt(int n) {
        switch (n) {
            case 22: {
                return this.F;
            }
            case 5686: {
                return this.Ff;
            }
            case 1209815663: {
                return this.MaxLen;
            }
            case 33: {
                return this.Q;
            }
            case 1600810585: {
                return this.SigFlags;
            }
            case -1732403014: {
                return this.StructParent;
            }
            case 9241: {
                return this.TI;
            }
            case 39: {
                return this.W;
            }
        }
        return super.getInt(n);
    }

    public void setDictionary(int n, PdfObject pdfObject) {
        pdfObject.setID(n);
        if (this.currentKey != null) {
            this.setOtherValues(n, pdfObject);
            return;
        }
        switch (n) {
            case 17: {
                this.A = pdfObject;
                break;
            }
            case 4369: {
                this.AA = pdfObject;
                break;
            }
            case 4384: {
                this.AP = pdfObject;
                if (this.MK != null || this.AP == null || this.AP.getDictionary(30) == null) break;
                this.MK = this.AP.getDictionary(30).getDictionary(7451);
                break;
            }
            case 4633: {
                this.BI = pdfObject;
                break;
            }
            case 4668: {
                this.Bl = pdfObject;
                break;
            }
            case 4643: {
                this.BS = pdfObject;
                break;
            }
            case 19: {
                this.Cdict = pdfObject;
                break;
            }
            case 20: {
                this.D = pdfObject;
                break;
            }
            case 5139: {
                this.DC = pdfObject;
                break;
            }
            case 5152: {
                this.DP = pdfObject;
                break;
            }
            case 5155: {
                this.DS = pdfObject;
                break;
            }
            case 21: {
                this.E = pdfObject;
                break;
            }
            case 22: {
                this.Fdict = pdfObject;
                break;
            }
            case 5695: {
                this.Fo = pdfObject;
                break;
            }
            case 5667: {
                this.FS = pdfObject;
                break;
            }
            case 6422: {
                this.IF = pdfObject;
                break;
            }
            case 6691: {
                this.JS = pdfObject;
                break;
            }
            case 27: {
                this.K = pdfObject;
                break;
            }
            case 7451: {
                this.MK = pdfObject;
                break;
            }
            case 30: {
                this.Nobj = pdfObject;
                break;
            }
            case 506808388: {
                this.Next = pdfObject;
                break;
            }
            case 31: {
                this.O = pdfObject;
                break;
            }
            case 7955: {
                this.OC = pdfObject;
                break;
            }
            case 2045494: {
                this.Off = pdfObject;
                break;
            }
            case 7998: {
                this.On = pdfObject;
                break;
            }
            case 32: {
                this.P = pdfObject;
                break;
            }
            case 8211: {
                this.PC = pdfObject;
                break;
            }
            case 8217: {
                this.PI = pdfObject;
                break;
            }
            case 8223: {
                this.PO = pdfObject;
                break;
            }
            case 1061176672: {
                this.Popup = pdfObject;
                break;
            }
            case 8230: {
                this.PV = pdfObject;
                break;
            }
            case 34: {
                this.R = pdfObject;
                break;
            }
            case 2308407: {
                this.Sig = pdfObject;
                break;
            }
            case 1061502534: {
                this.Sound = pdfObject;
                break;
            }
            case 37: {
                this.U = pdfObject;
                break;
            }
            case 38: {
                this.V = pdfObject;
                break;
            }
            case 2570558: {
                this.Win = pdfObject;
                break;
            }
            case 10016: {
                this.WP = pdfObject;
                break;
            }
            case 10019: {
                this.WS = pdfObject;
                break;
            }
            case 40: {
                this.X = pdfObject;
                break;
            }
            case 2627089: {
                this.XFAasStream = pdfObject;
                break;
            }
            default: {
                super.setDictionary(n, pdfObject);
            }
        }
    }

    public int setConstant(int n, int n2, int n3, byte[] byArray) {
        int n4 = -1;
        int n5 = 0;
        int n6 = 0;
        try {
            for (int i = n3 - 1; i > -1; --i) {
                int n7 = byArray[n2 + i];
                n5 += (n7 -= 48) << n6;
                n6 += 8;
            }
            switch (n5) {
                default: 
            }
            n4 = super.setConstant(n, n5);
            if (n4 == -1 && debug) {
                byte[] byArray2 = new byte[n3];
                System.arraycopy(byArray, n2, byArray2, 0, n3);
                System.out.println("key=" + new String(byArray2) + " " + n5 + " not implemented in setConstant in " + this);
                System.out.println("final public static int " + new String(byArray2) + "=" + n5 + ";");
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        switch (n) {
            default: 
        }
        super.setConstant(n, n5);
        return n4;
    }

    public int getNameAsConstant(int n) {
        byte[] byArray = null;
        switch (n) {
            case 5668: {
                return this.FT;
            }
            case 24: {
                byArray = this.rawH;
                break;
            }
            case 30: {
                byArray = this.rawN;
                break;
            }
            case 35: {
                byArray = this.rawS;
                break;
            }
            default: {
                return super.getNameAsConstant(n);
            }
        }
        if (byArray == null) {
            return super.getNameAsConstant(n);
        }
        return PdfDictionary.generateChecksum(0, byArray.length, byArray);
    }

    public int getParameterConstant(int n) {
        switch (n) {
            case 1147962727: {
                if (this.FT != -1) {
                    return this.FT;
                }
                return super.getParameterConstant(n);
            }
        }
        return super.getParameterConstant(n);
    }

    public PdfArrayIterator getMixedArray(int n) {
        switch (n) {
            case 1110722433: {
                return new PdfArrayIterator(this.Border);
            }
            case 20: {
                return new PdfArrayIterator(this.DmixedArray);
            }
            case 339034948: {
                return new PdfArrayIterator(this.DmixedArray);
            }
            case 893143676: {
                return new PdfArrayIterator(this.Fields);
            }
            case 1144079448: {
                return new PdfArrayIterator(this.State);
            }
            case 2627089: {
                return new PdfArrayIterator(this.rawXFAasArray);
            }
        }
        return super.getMixedArray(n);
    }

    public byte[] getTextStreamValueAsByte(int n) {
        switch (n) {
            case 322257476: {
                return this.rawCert;
            }
            case 1568843969: {
                return this.rawContactInfo;
            }
            case 1216184967: {
                return this.rawContents;
            }
        }
        return super.getTextStreamValueAsByte(n);
    }

    public double[] getDoubleArray(int n) {
        switch (n) {
            default: 
        }
        return super.getDoubleArray(n);
    }

    public void setDoubleArray(int n, double[] dArray) {
        switch (n) {
            default: 
        }
        super.setDoubleArray(n, dArray);
    }

    public int[] getIntArray(int n) {
        switch (n) {
            case 25: {
                return FormObject.deepCopy(this.I);
            }
            case 2055367785: {
                return FormObject.deepCopy(this.ByteRange);
            }
        }
        return super.getIntArray(n);
    }

    public void setIntArray(int n, int[] nArray) {
        switch (n) {
            case 25: {
                this.I = nArray;
                break;
            }
            case 2055367785: {
                this.ByteRange = nArray;
                break;
            }
            default: {
                super.setIntArray(n, nArray);
            }
        }
    }

    public void setMixedArray(int n, byte[][] byArray) {
        switch (n) {
            case 1110722433: {
                this.Border = byArray;
                break;
            }
            case 339034948: {
                this.DmixedArray = byArray;
                break;
            }
            case 893143676: {
                this.Fields = byArray;
                break;
            }
            case 1144079448: {
                this.State = byArray;
                break;
            }
            case 2627089: {
                this.rawXFAasArray = byArray;
                break;
            }
            default: {
                super.setMixedArray(n, byArray);
            }
        }
    }

    public float[] getFloatArray(int n) {
        switch (n) {
            case 19: {
                return this.C;
            }
            case 573911876: {
                return this.Rect;
            }
            case 8724: {
                return this.RD;
            }
        }
        return super.getFloatArray(n);
    }

    public void setFloatArray(int n, float[] fArray) {
        switch (n) {
            case 19: {
                this.C = fArray;
                break;
            }
            case 8724: {
                this.RD = fArray;
                break;
            }
            case 573911876: {
                this.Rect = fArray;
                break;
            }
            default: {
                super.setFloatArray(n, fArray);
            }
        }
    }

    public void setName(int n, byte[] byArray) {
        switch (n) {
            case 4387: {
                this.rawAS = byArray;
                break;
            }
            case 5158: {
                this.rawDV = byArray;
                break;
            }
            case 1011108731: {
                this.rawFilter = byArray;
                break;
            }
            case -2122953826: {
                this.rawSubFilter = byArray;
                break;
            }
            case 5668: {
                this.FT = PdfDictionary.generateChecksum(0, byArray.length, byArray);
                break;
            }
            case 24: {
                this.rawH = byArray;
                break;
            }
            case 30: {
                this.rawN = byArray;
                break;
            }
            case 35: {
                this.rawS = byArray;
                break;
            }
            default: {
                super.setName(n, byArray);
            }
        }
    }

    public void setObjectArray(int n, Object[] objectArray) {
        switch (n) {
            case 2048068: {
                this.Opt = objectArray;
                break;
            }
            case 1786013849: {
                this.Reference = objectArray;
                break;
            }
            default: {
                super.setObjectArray(n, objectArray);
            }
        }
    }

    public Object[] getObjectArray(int n) {
        switch (n) {
            case 2048068: {
                return this.Opt;
            }
            case 1786013849: {
                return this.Reference;
            }
        }
        return super.getObjectArray(n);
    }

    public byte[][] getStringArray(int n) {
        switch (n) {
            default: 
        }
        return super.getStringArray(n);
    }

    public void setStringArray(int n, byte[][] byArray) {
        switch (n) {
            default: 
        }
        super.setStringArray(n, byArray);
    }

    public void setTextStreamValue(int n, byte[] byArray) {
        switch (n) {
            case 322257476: {
                this.rawCert = byArray;
                break;
            }
            case 1568843969: {
                this.rawContactInfo = byArray;
                break;
            }
            case 1216184967: {
                this.rawContents = byArray;
                break;
            }
            case 20: {
                this.rawDstring = byArray;
                break;
            }
            case 5137: {
                this.rawDA = byArray;
                break;
            }
            case 5158: {
                this.rawDV = byArray;
                break;
            }
            case 22: {
                this.rawFstring = byArray;
                break;
            }
            case 6691: {
                this.rawJS = byArray;
                break;
            }
            case 1618506351: {
                this.rawLocation = byArray;
                break;
            }
            case 29: {
                this.rawM = byArray;
                break;
            }
            case 32: {
                this.rawPstring = byArray;
                break;
            }
            case 8723: {
                this.rawRC = byArray;
                break;
            }
            case 826499443: {
                this.rawReason = byArray;
                break;
            }
            case 7709: {
                this.rawNM = byArray;
                break;
            }
            case 591737402: {
                this.rawSubj = byArray;
                break;
            }
            case 36: {
                this.rawT = byArray;
                this.T = null;
                break;
            }
            case 9245: {
                this.rawTM = byArray;
                break;
            }
            case 9253: {
                this.rawTU = byArray;
                break;
            }
            case 2433561: {
                this.rawURI = byArray;
                break;
            }
            case 38: {
                this.rawV = byArray;
                this.Vstring = null;
                break;
            }
            default: {
                super.setTextStreamValue(n, byArray);
            }
        }
    }

    public void setTextStreamValue(int n, String string) {
        switch (n) {
            case 38: {
                this.Vstring = string;
                break;
            }
            case 36: {
                this.setTextStreamValue(n, string.getBytes());
                break;
            }
            default: {
                super.setTextStreamValue(n, string);
            }
        }
    }

    public String getName(int n) {
        switch (n) {
            case 4387: {
                if (this.AS == null && this.rawAS != null) {
                    this.AS = new String(this.rawAS);
                }
                return this.AS;
            }
            case 5668: {
                return null;
            }
            case 24: {
                if (this.H == null && this.rawH != null) {
                    this.H = new String(this.rawH);
                }
                return this.H;
            }
            case 1011108731: {
                if (this.Filter == null && this.rawFilter != null) {
                    this.Filter = new String(this.rawFilter);
                }
                return this.Filter;
            }
            case -2122953826: {
                if (this.SubFilter == null && this.rawSubFilter != null) {
                    this.SubFilter = new String(this.rawSubFilter);
                }
                return this.SubFilter;
            }
            case 30: {
                if (this.N == null && this.rawN != null) {
                    this.N = new String(this.rawN);
                }
                return this.N;
            }
            case 35: {
                if (this.S == null && this.rawS != null) {
                    this.S = new String(this.rawS);
                }
                return this.S;
            }
        }
        return super.getName(n);
    }

    public String getTextStreamValue(int n) {
        switch (n) {
            case 322257476: {
                if (this.Cert == null && this.rawCert != null) {
                    this.Cert = PdfReader.getTextString(this.rawCert, false);
                }
                return this.Cert;
            }
            case 1568843969: {
                if (this.ContactInfo == null && this.rawContactInfo != null) {
                    this.ContactInfo = PdfReader.getTextString(this.rawContactInfo, false);
                }
                return this.ContactInfo;
            }
            case 1216184967: {
                if (this.Contents == null && this.rawContents != null) {
                    this.Contents = PdfReader.getTextString(this.rawContents, true);
                }
                return this.Contents;
            }
            case 20: {
                if (this.Dstring == null && this.rawDstring != null) {
                    this.Dstring = PdfReader.getTextString(this.rawDstring, false);
                }
                return this.Dstring;
            }
            case 5137: {
                if (this.DA == null && this.rawDA != null) {
                    this.DA = PdfReader.getTextString(this.rawDA, false);
                }
                return this.DA;
            }
            case 5158: {
                if (this.DV == null && this.rawDV != null) {
                    this.DV = PdfReader.getTextString(this.rawDV, true);
                }
                return this.DV;
            }
            case 22: {
                if (this.Fstring == null && this.rawFstring != null) {
                    this.Fstring = PdfReader.getTextString(this.rawFstring, false);
                }
                return this.Fstring;
            }
            case 6691: {
                if (this.JSString == null && this.rawJS != null) {
                    this.JSString = PdfReader.getTextString(this.rawJS, true);
                }
                return this.JSString;
            }
            case 7709: {
                if (this.NM == null && this.rawNM != null) {
                    this.NM = PdfReader.getTextString(this.rawNM, false);
                }
                return this.NM;
            }
            case 1618506351: {
                if (this.Location == null && this.rawLocation != null) {
                    this.Location = new String(this.rawLocation);
                }
                return this.Location;
            }
            case 29: {
                if (this.M == null && this.rawM != null) {
                    this.M = new String(this.rawM);
                }
                return this.M;
            }
            case 32: {
                if (this.Pstring == null && this.rawPstring != null) {
                    this.Pstring = PdfReader.getTextString(this.rawPstring, false);
                }
                return this.Pstring;
            }
            case 8723: {
                if (this.RC == null && this.rawRC != null) {
                    this.RC = new String(this.rawRC);
                }
                return this.RC;
            }
            case 826499443: {
                if (this.Reason == null && this.rawReason != null) {
                    this.Reason = new String(this.rawReason);
                }
                return this.Reason;
            }
            case 591737402: {
                if (this.Subj == null && this.rawSubj != null) {
                    this.Subj = PdfReader.getTextString(this.rawSubj, false);
                }
                return this.Subj;
            }
            case 36: {
                if (this.T == null && this.rawT != null) {
                    this.T = PdfReader.getTextString(this.rawT, false);
                }
                return this.T;
            }
            case 9245: {
                if (this.TM == null && this.rawTM != null) {
                    this.TM = PdfReader.getTextString(this.rawTM, false);
                }
                return this.TM;
            }
            case 9253: {
                if (this.TU == null && this.rawTU != null) {
                    this.TU = PdfReader.getTextString(this.rawTU, false);
                }
                return this.TU;
            }
            case 2433561: {
                if (this.URI == null && this.rawURI != null) {
                    this.URI = PdfReader.getTextString(this.rawURI, false);
                }
                return this.URI;
            }
            case 38: {
                if (this.Vstring == null && this.rawV != null) {
                    this.Vstring = PdfReader.getTextString(this.rawV, true);
                }
                return this.Vstring;
            }
        }
        return super.getTextStreamValue(n);
    }

    public String getStringValue(int n, int n2) {
        byte[] byArray = null;
        switch (n2) {
            case 0: {
                if (byArray != null) {
                    return new String(byArray);
                }
                return null;
            }
            case 1: {
                if (byArray != null) {
                    return new String(byArray);
                }
                return null;
            }
            case 2: {
                if (byArray != null) {
                    int n3 = byArray.length;
                    if (n3 > 6 && byArray[6] == 43) {
                        int n4 = n3 - 7;
                        byte[] byArray2 = new byte[n4];
                        System.arraycopy(byArray, 7, byArray2, 0, n4);
                        return new String(byArray2);
                    }
                    return new String(byArray);
                }
                return null;
            }
        }
        throw new RuntimeException("Value not defined in getName(int,mode) in " + this);
    }

    public byte[][] getKeyArray(int n) {
        switch (n) {
            case 456733763: {
                return FormObject.deepCopy(this.Kids);
            }
        }
        return super.getKeyArray(n);
    }

    public void setKeyArray(int n, byte[][] byArray) {
        switch (n) {
            case 456733763: {
                this.Kids = byArray;
                break;
            }
            default: {
                super.setKeyArray(n, byArray);
            }
        }
    }

    public boolean decompressStreamWhenRead() {
        return true;
    }

    public static String resolveType(int n) {
        if (n == 1197118) {
            return "Button";
        }
        if (n == 4920) {
            return "Choice";
        }
        if (n == 9288) {
            return "Text";
        }
        if (n == 1061176672) {
            return "Popup";
        }
        if (n == 1160865142) {
            return "Square";
        }
        if (n == 607471684) {
            return "Text Annot";
        }
        return null;
    }

    private void commandFf(int n) {
        boolean[] blArray = new boolean[32];
        blArray[1] = (n & 1) == 1;
        blArray[2] = (n & 2) == 2;
        blArray[3] = (n & 4) == 4;
        blArray[12] = (n & 0x1000) == 4096;
        blArray[13] = (n & 0x2000) == 8192;
        blArray[14] = (n & 0x4000) == 16384;
        blArray[15] = (n & 0x8000) == 32768;
        blArray[16] = (n & 0x10000) == 65536;
        blArray[17] = (n & 0x20000) == 131072;
        blArray[18] = (n & 0x40000) == 262144;
        blArray[19] = (n & 0x80000) == 524288;
        blArray[20] = (n & 0x100000) == 0x100000;
        blArray[21] = (n & 0x200000) == 0x200000;
        blArray[22] = (n & 0x400000) == 0x400000;
        blArray[23] = (n & 0x800000) == 0x800000;
        blArray[24] = (n & 0x1000000) == 0x1000000;
        blArray[25] = (n & 0x2000000) == 0x2000000;
        blArray[25] = (n & 0x2000000) == 0x2000000;
        blArray[26] = (n & 0x4000000) == 0x4000000;
        this.flags = blArray;
    }

    protected void setFlags(boolean[] blArray) {
        this.flags = blArray;
    }

    protected static Color generateColorFromString(float[] fArray) {
        int n = 0;
        if (fArray != null) {
            n = fArray.length;
        }
        Color color = null;
        if (n == 0) {
            color = new Color(0, 0, 0, 0);
        } else if (n == 1) {
            float f;
            if (debug) {
                System.out.println("{stream} CHECK gray color=" + fArray[0]);
            }
            color = (f = fArray[0]) <= 1.0f ? new Color(f, f, f) : new Color((int)f, (int)f, (int)f);
        } else if (n == 3) {
            if (debug) {
                System.out.println("rgb color=" + fArray[0] + ' ' + fArray[1] + ' ' + fArray[2]);
            }
            color = fArray[0] <= 1.0f && fArray[1] <= 1.0f && fArray[2] <= 1.0f ? new Color(fArray[0], fArray[1], fArray[2]) : new Color((int)fArray[0], (int)fArray[1], (int)fArray[2]);
        } else if (n == 4) {
            DeviceCMYKColorSpace deviceCMYKColorSpace = new DeviceCMYKColorSpace();
            deviceCMYKColorSpace.setColor(fArray, 3);
            color = (Color)((Object)deviceCMYKColorSpace.getColor());
        }
        return color;
    }

    public static Color generateColor(float[] fArray) {
        int n = -1;
        if (fArray != null) {
            n = fArray.length;
        }
        Color color = null;
        if (n == 0) {
            color = new Color(0, 0, 0, 0);
        } else if (n == 1) {
            float f = fArray[0];
            color = f <= 1.0f ? new Color(f, f, f) : new Color((int)f, (int)f, (int)f);
        } else if (n == 3) {
            if (debug) {
                System.out.println("rgb color=" + fArray[0] + ' ' + fArray[1] + ' ' + fArray[2]);
            }
            float f = fArray[0];
            float f2 = fArray[1];
            float f3 = fArray[2];
            color = f <= 1.0f && f2 <= 1.0f && f3 <= 1.0f ? new Color(f, f2, f3) : new Color((int)f, (int)f2, (int)f3);
        } else if (n == 4) {
            DeviceCMYKColorSpace deviceCMYKColorSpace = new DeviceCMYKColorSpace();
            deviceCMYKColorSpace.setColor(new float[]{fArray[3], fArray[2], fArray[1], fArray[0]}, 4);
            color = (Color)((Object)deviceCMYKColorSpace.getColor());
        }
        return color;
    }

    public boolean isXFAObject() {
        return this.isXFAObject;
    }

    protected FormObject duplicate() {
        FormObject formObject = new FormObject();
        formObject.parentRef = this.parentRef;
        formObject.flags = this.flags;
        formObject.I = this.I;
        formObject.selectedItem = this.selectedItem;
        formObject.ref = this.ref;
        formObject.AA = this.AA;
        formObject.AP = this.AP;
        formObject.BS = this.BS;
        formObject.C = this.C;
        formObject.D = this.D;
        formObject.F = this.F;
        formObject.Ff = this.Ff;
        formObject.OC = this.OC;
        formObject.Opt = this.Opt;
        formObject.Q = this.Q;
        formObject.MaxLen = this.MaxLen;
        formObject.rawAS = this.rawAS;
        formObject.rawDA = this.rawDA;
        formObject.rawDV = this.rawDV;
        formObject.rawJS = this.rawJS;
        formObject.FT = this.FT;
        formObject.rawNM = this.rawNM;
        formObject.Rect = this.Rect;
        formObject.TI = this.TI;
        formObject.copyMK(this);
        formObject.rawT = this.rawT;
        formObject.rawTM = this.rawTM;
        formObject.rawTU = this.rawTU;
        formObject.rawV = this.rawV;
        formObject.textColor = this.textColor;
        formObject.textFont = this.textFont;
        formObject.textSize = this.textSize;
        formObject.textString = this.textString;
        formObject.appearancesUsed = this.appearancesUsed;
        formObject.offsetDownIcon = this.offsetDownIcon;
        formObject.noDownIcon = this.noDownIcon;
        formObject.invertDownIcon = this.invertDownIcon;
        formObject.onState = this.onState;
        formObject.currentState = this.currentState;
        formObject.normalOffImage = this.normalOffImage;
        formObject.normalOnImage = this.normalOnImage;
        formObject.rolloverOffImage = this.rolloverOffImage;
        formObject.rolloverOnImage = this.rolloverOnImage;
        formObject.downOffImage = this.downOffImage;
        formObject.downOnImage = this.downOnImage;
        formObject.pageNumber = this.pageNumber;
        formObject.cColor = this.cColor;
        formObject.contents = this.contents;
        formObject.show = this.show;
        formObject.layerName = this.layerName;
        return formObject;
    }

    public void copyInheritedValuesFromParent(FormObject formObject) {
        if (this.pageNumber == -1 && formObject.pageNumber != -1) {
            this.pageNumber = formObject.pageNumber;
        }
        this.formHandler = formObject.formHandler;
        if (this.AA == null) {
            this.AA = formObject.AA;
        }
        if (this.C == null) {
            this.C = formObject.C;
        }
        if (this.D == null) {
            this.D = formObject.D;
        }
        if (this.F == -1) {
            this.F = formObject.F;
        }
        if (this.Ff == -1) {
            this.Ff = formObject.Ff;
        }
        if (this.OC == null) {
            this.OC = formObject.OC;
        }
        if (this.Opt == null) {
            this.Opt = formObject.Opt;
        }
        if (this.Q == -1) {
            this.Q = formObject.Q;
        }
        if (this.MaxLen == -1) {
            this.MaxLen = formObject.MaxLen;
        }
        if (this.rawAS == null) {
            this.rawAS = formObject.rawAS;
        }
        if (this.rawDA == null) {
            this.rawDA = formObject.rawDA;
        }
        if (this.rawDV == null) {
            this.rawDV = formObject.rawDV;
        }
        if (this.rawJS == null) {
            this.rawJS = formObject.rawJS;
        }
        if (this.FT == -1) {
            this.FT = formObject.FT;
        }
        if (this.rawNM == null) {
            this.rawNM = formObject.rawNM;
        }
        if (this.rawT == null) {
            this.rawT = formObject.rawT;
        }
        if (this.Rect == null) {
            this.Rect = formObject.Rect;
        }
        if (this.TI == -1) {
            this.TI = formObject.TI;
        }
        if (this.rawTM == null) {
            this.rawTM = formObject.rawTM;
        }
        if (this.rawTU == null) {
            this.rawTU = formObject.rawTU;
        }
        if (this.rawV == null) {
            this.rawV = formObject.rawV;
        }
    }

    public String getPDFRef() {
        return this.getObjectRefAsString();
    }

    public int getAlignment() {
        if (this.Q == -1) {
            this.Q = 2;
        }
        return this.Q;
    }

    public boolean hasColorChanged() {
        return this.textColorChanged;
    }

    public void resetColorChanged() {
        this.textColorChanged = false;
    }

    public void setTextColor(float[] fArray) {
        if (fArray.length > 0 && Float.isNaN(fArray[0])) {
            float[] fArray2 = new float[fArray.length - 1];
            System.arraycopy(fArray, 1, fArray2, 0, fArray.length - 1);
            fArray = fArray2;
        }
        this.textColor = fArray;
        this.textColorChanged = true;
    }

    protected void setTextFont(Font font) {
        this.textFont = font;
    }

    protected void setTextSize(int n) {
        this.textSize = n;
    }

    public void setChildOnState(String string) {
        this.onState = string;
    }

    public void setCurrentState(String string) {
        this.currentState = string;
    }

    public void setTextValue(String string) {
        if (string == null) {
            string = "";
        }
        this.textString = string;
    }

    public void setSelectedItem(String string) {
        this.selectedItem = string;
    }

    public void setFieldName(String string) {
        this.T = null;
        this.setTextStreamValue(36, string.getBytes());
    }

    public void setParent(String string) {
        this.parentRef = string;
    }

    public String getParentRef() {
        if (this.parentRef == null && this.includeParent) {
            return this.getStringKey(1110793845);
        }
        return this.parentRef;
    }

    private static boolean[] calcFarray(int n) {
        if (n == 0) {
            return new boolean[9];
        }
        boolean[] blArray = new boolean[9];
        int[] nArray = new int[]{0, 1, 2, 4, 8, 16, 32, 64, 128, 256};
        for (int i = 1; i < 9; ++i) {
            if ((n & nArray[i]) != nArray[i]) continue;
            blArray[i - 1] = true;
        }
        return blArray;
    }

    public void setTopIndex(int[] nArray) {
        if (nArray == null) {
            this.TI = -1;
        } else if (nArray.length > 0) {
            this.TI = nArray[0];
        }
        this.I = nArray;
    }

    public Rectangle getBoundingRectangle() {
        float[] fArray = this.getFloatArray(573911876);
        if (fArray != null) {
            float f;
            float f2 = fArray[0];
            float f3 = fArray[1];
            float f4 = fArray[2];
            float f5 = fArray[3];
            if (f2 > f4) {
                f = f2;
                f2 = f4;
                f4 = f;
            }
            if (f3 > f5) {
                f = f3;
                f3 = f5;
                f5 = f;
            }
            this.BBox = new Rectangle((int)(f2 + 0.5f), (int)(f3 + 0.5f), (int)(f4 - f2), (int)(f5 - f3));
        } else {
            this.BBox = new Rectangle(0, 0, 0, 0);
        }
        return this.BBox;
    }

    public void setType(int n, boolean bl) {
        if (bl) {
            this.FT = n;
        }
    }

    public void setFlag(int n, boolean bl) {
        this.flags[n - 1] = bl;
    }

    public boolean[] getFieldFlags() {
        return this.flags;
    }

    public void setNormalOnState(String string) {
        this.normalOnState = string;
    }

    public boolean isAppearanceUsed() {
        return this.appearancesUsed;
    }

    public void setAppearanceImage(BufferedImage bufferedImage, int n, int n2) {
        if (bufferedImage == null) {
            bufferedImage = FormObject.getOpaqueImage();
        }
        switch (n) {
            case 20: {
                if (n2 == 7998) {
                    this.downOnImage = bufferedImage;
                    break;
                }
                if (n2 == 2045494) {
                    this.downOffImage = bufferedImage;
                    break;
                }
                throw new RuntimeException("Unknown status use PdfDictionary.On or PdfDictionary.Off");
            }
            case 30: {
                if (n2 == 7998) {
                    this.normalOnImage = bufferedImage;
                    break;
                }
                if (n2 == 2045494) {
                    this.normalOffImage = bufferedImage;
                    break;
                }
                throw new RuntimeException("Unknown status use PdfDictionary.On or PdfDictionary.Off");
            }
            case 34: {
                if (n2 == 7998) {
                    this.rolloverOnImage = bufferedImage;
                    break;
                }
                if (n2 == 2045494) {
                    this.rolloverOffImage = bufferedImage;
                    break;
                }
                throw new RuntimeException("Unknown status use PdfDictionary.On or PdfDictionary.Off");
            }
            default: {
                throw new RuntimeException("Unknown type use PdfDictionary.D, PdfDictionary.N or PdfDictionary.R");
            }
        }
        this.appearancesUsed = true;
    }

    public void setBorderColor(String string) {
        if (string != null) {
            this.getDictionary(7451).setFloatArray(4627, FormObject.generateFloatFromString(string));
        }
    }

    public void setBackgroundColor(String string) {
        if (string != null) {
            this.getDictionary(7451).setFloatArray(4631, FormObject.generateFloatFromString(string));
        }
    }

    private static float[] generateFloatFromString(String string) {
        if (debug) {
            System.out.println("CHECK generateColorFromString=" + string);
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, "[()] ,");
        float[] fArray = new float[stringTokenizer.countTokens()];
        int n = 0;
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            if (debug) {
                System.out.println("token" + (n + 1) + '=' + string2 + " " + string);
            }
            fArray[n] = Float.parseFloat(string2);
            ++n;
        }
        if (n == 0) {
            return null;
        }
        return fArray;
    }

    public void setNormalCaption(String string) {
        if (string != null) {
            this.getDictionary(7451).setTextStreamValue(4881, string.getBytes());
        }
    }

    protected void setOffsetDownApp() {
        this.offsetDownIcon = true;
    }

    protected void setNoDownIcon() {
        this.noDownIcon = true;
    }

    protected void setInvertForDownIcon() {
        this.invertDownIcon = true;
    }

    public boolean hasNormalOff() {
        return this.normalOffImage != null;
    }

    public boolean hasRolloverOff() {
        return this.rolloverOffImage != null;
    }

    public boolean hasDownOff() {
        return this.downOffImage != null;
    }

    public boolean hasDownImage() {
        return this.downOnImage != null || this.hasDownOff();
    }

    public boolean hasRolloverOn() {
        return this.rolloverOnImage != null;
    }

    public boolean hasNormalOn() {
        return this.normalOnImage != null;
    }

    public void overwriteWith(FormObject formObject) {
        if (formObject == null) {
            return;
        }
        if (formObject.parentRef != null) {
            this.parentRef = formObject.parentRef;
        }
        if (formObject.flags != null) {
            this.flags = formObject.flags;
        }
        if (formObject.I != null) {
            this.I = formObject.I;
        }
        if (formObject.selectedItem != null) {
            this.selectedItem = formObject.selectedItem;
        }
        if (formObject.ref != null) {
            this.ref = formObject.ref;
        }
        if (formObject.textColor != null) {
            this.textColor = formObject.textColor;
        }
        if (formObject.textFont != null) {
            this.textFont = formObject.textFont;
        }
        if (formObject.textSize != -1) {
            this.textSize = formObject.textSize;
        }
        if (formObject.textString != null) {
            this.textString = formObject.textString;
        }
        if (formObject.appearancesUsed) {
            this.appearancesUsed = formObject.appearancesUsed;
        }
        if (formObject.offsetDownIcon) {
            this.offsetDownIcon = formObject.offsetDownIcon;
        }
        if (formObject.noDownIcon) {
            this.noDownIcon = formObject.noDownIcon;
        }
        if (formObject.invertDownIcon) {
            this.invertDownIcon = formObject.invertDownIcon;
        }
        if (formObject.onState != null) {
            this.onState = formObject.onState;
        }
        if (formObject.currentState != null) {
            this.currentState = formObject.currentState;
        }
        if (formObject.normalOffImage != null) {
            this.normalOffImage = formObject.normalOffImage;
        }
        if (formObject.normalOnImage != null) {
            this.normalOnImage = formObject.normalOnImage;
        }
        if (formObject.rolloverOffImage != null) {
            this.rolloverOffImage = formObject.rolloverOffImage;
        }
        if (formObject.rolloverOnImage != null) {
            this.rolloverOnImage = formObject.rolloverOnImage;
        }
        if (formObject.downOffImage != null) {
            this.downOffImage = formObject.downOffImage;
        }
        if (formObject.downOnImage != null) {
            this.downOnImage = formObject.downOnImage;
        }
        if (formObject.pageNumber != -1) {
            this.pageNumber = formObject.pageNumber;
        }
        if (formObject.cColor != null) {
            this.cColor = formObject.cColor;
        }
        if (formObject.contents != null) {
            this.contents = formObject.contents;
        }
        if (formObject.show) {
            this.show = formObject.show;
        }
        this.AA = formObject.AA;
        this.AP = formObject.AP;
        this.BS = formObject.BS;
        this.C = formObject.C;
        this.D = formObject.D;
        this.F = formObject.F;
        this.Ff = formObject.Ff;
        this.Opt = formObject.Opt;
        this.OC = formObject.OC;
        this.rawAS = formObject.rawAS;
        this.Q = formObject.Q;
        this.MaxLen = formObject.MaxLen;
        this.rawDA = formObject.rawDA;
        this.rawDV = formObject.rawDV;
        this.FT = formObject.FT;
        this.rawJS = formObject.rawJS;
        this.rawNM = formObject.rawNM;
        this.rawT = formObject.rawT;
        this.Rect = formObject.Rect;
        this.rawTM = formObject.rawTM;
        this.rawTU = formObject.rawTU;
        this.rawV = formObject.rawV;
        this.TI = formObject.TI;
        this.copyMK(formObject);
    }

    public Object getPopupObj() {
        return this.popupObj;
    }

    public String getCurrentState() {
        return this.currentState;
    }

    public String getOnState() {
        return this.onState;
    }

    public boolean[] getCharacteristics() {
        if (this.Farray == null) {
            this.Farray = this.F == -1 ? new boolean[9] : FormObject.calcFarray(this.F);
        }
        return this.Farray;
    }

    public int getTextSize() {
        return this.textSize;
    }

    public Map getValuesMap() {
        Object[] objectArray;
        if (this.Opt != null && this.OptValues == null && (objectArray = this.getObjectArray(2048068)) != null) {
            int n = objectArray.length;
            for (int i = 0; i < n; ++i) {
                if (!(objectArray[i] instanceof Object[])) continue;
                Object[] objectArray2 = (Object[])objectArray[i];
                String string = PdfReader.getTextString((byte[])objectArray2[0], false);
                String string2 = PdfReader.getTextString((byte[])objectArray2[1], false);
                if (this.OptValues == null) {
                    this.OptValues = new HashMap();
                }
                this.OptValues.put(string, string2);
            }
        }
        return this.OptValues;
    }

    public String[] getItemsList() {
        Object[] objectArray;
        if (this.OptString == null && (objectArray = this.getObjectArray(2048068)) != null) {
            int n = objectArray.length;
            this.OptString = new String[n];
            for (int i = 0; i < n; ++i) {
                if (objectArray[i] instanceof Object[]) {
                    Object[] objectArray2 = (Object[])objectArray[i];
                    this.OptString[i] = PdfReader.getTextString((byte[])objectArray2[1], false);
                    continue;
                }
                if (!(objectArray[i] instanceof byte[])) continue;
                this.OptString[i] = PdfReader.getTextString((byte[])objectArray[i], false);
            }
        }
        return this.OptString;
    }

    public String getSelectedItem() {
        if (this.selectedItem == null) {
            this.selectedItem = this.getTextStreamValue(38);
        }
        if (this.selectedItem == null && this.I != null) {
            String[] stringArray = this.getItemsList();
            int n = this.I[0];
            if (stringArray != null && n > -1 && n < stringArray.length) {
                return stringArray[n];
            }
            return null;
        }
        return this.selectedItem;
    }

    public int[] getTopIndex() {
        if (this.I == null && this.TI != -1) {
            this.I = new int[1];
            this.I[0] = this.TI;
        }
        return this.I;
    }

    public String getTextString() {
        if (this.textString == null) {
            this.textString = this.getTextStreamValue(38);
        }
        if (this.textString == null && this.getTextStreamValue(5158) != null) {
            return this.getTextStreamValue(5158);
        }
        if (this.textString != null) {
            this.textString = MEUtils.replaceAll(this.textString, "\r", "\n").trim();
        }
        return this.textString;
    }

    public int getTextPosition() {
        return this.getDictionary(7451).getInt(9248);
    }

    public String getNormalOnState() {
        return this.normalOnState;
    }

    public BufferedImage getNormalOffImage() {
        return this.normalOffImage;
    }

    public BufferedImage getNormalOnImage() {
        return this.normalOnImage;
    }

    public boolean hasNoDownIcon() {
        return this.noDownIcon;
    }

    public boolean hasOffsetDownIcon() {
        return this.offsetDownIcon;
    }

    public boolean hasInvertDownIcon() {
        return this.invertDownIcon;
    }

    public BufferedImage getDownOffImage() {
        return this.downOffImage;
    }

    public BufferedImage getDownOnImage() {
        return this.downOnImage;
    }

    public BufferedImage getRolloverOffImage() {
        return this.rolloverOffImage;
    }

    public BufferedImage getRolloverOnImage() {
        return this.rolloverOnImage;
    }

    public Font getTextFont() {
        return this.textFont;
    }

    public Color getTextColor() {
        return FormObject.generateColor(this.textColor);
    }

    public Color getBorderColor() {
        return FormObject.generateColor(this.getDictionary(7451).getFloatArray(4627));
    }

    public boolean isPopupBuilt() {
        return this.popupBuilt;
    }

    public void setPopupBuilt(Object object) {
        if (object == null) {
            return;
        }
        this.popupObj = object;
        this.popupBuilt = true;
    }

    public String getLayerName() {
        PdfObject pdfObject;
        if (this.layerName == null && (pdfObject = this.getDictionary(7955)) != null) {
            this.layerName = pdfObject.getName(506543413);
        }
        return this.layerName;
    }

    public boolean hasValueChanged() {
        return this.formChanged;
    }

    public void setFormChanged() {
        this.formChanged = true;
    }

    public void resetFormChanged() {
        this.formChanged = false;
    }

    public String getValue() {
        int n = this.getParameterConstant(1147962727);
        switch (n) {
            case 9288: {
                if (this.textString == null) {
                    this.textString = this.getTextStreamValue(38);
                }
                if (this.textString == null) {
                    return "";
                }
                return this.textString;
            }
            case 4920: {
                if (this.selectedItem == null) {
                    this.selectedItem = this.getTextStreamValue(38);
                }
                return this.selectedItem;
            }
            case 1197118: {
                return this.getDictionary(7451).getTextStreamValue(4881);
            }
            case 2308407: {
                return this.getDictionary(7451).getTextStreamValue(4881);
            }
        }
        return this.getDictionary(7451).getTextStreamValue(4881);
    }

    public void setValue(String string) {
        boolean bl = this.formChanged;
        String string2 = null;
        int n = this.getParameterConstant(1147962727);
        switch (n) {
            case 9288: {
                String string3 = this.getTextStreamValue(38);
                if (string3 != null && string3.equals(string) || this.textString != null && this.textString.equals(string)) break;
                if (string == null) {
                    string = "";
                }
                this.textString = string;
                this.formChanged = true;
                break;
            }
            case 4920: {
                if (this.selectedItem == null) {
                    this.selectedItem = this.getTextStreamValue(38);
                }
                if (this.selectedItem != null && this.selectedItem.equals(string)) break;
                this.selectedItem = string;
                this.formChanged = true;
                break;
            }
            case 1197118: {
                string2 = this.getDictionary(7451).getTextStreamValue(4881);
                if (string2 != null && string2.equals(string)) break;
                this.getDictionary(7451).setTextStreamValue(4881, string.getBytes());
                this.formChanged = true;
                break;
            }
            default: {
                string2 = this.getDictionary(7451).getTextStreamValue(4881);
                if (string2 != null && string2.equals(string)) break;
                this.getDictionary(7451).setTextStreamValue(4881, string.getBytes());
                this.formChanged = true;
            }
        }
        if (this.formChanged && !bl) {
            this.formHandler.C(this);
        }
    }

    public void setLineWidth(int n) {
        if (this.BS == null) {
            this.BS = new FormObject();
        }
        this.BS.setIntNumber(39, n);
    }

    public void setBorderWidth(int n) {
        this.setLineWidth(n);
    }

    public static boolean willCommit() {
        return true;
    }

    public boolean hasDisplayChanged() {
        boolean bl;
        boolean bl2 = bl = this.display != -1;
        return bl;
    }

    public Object getTarget() {
        return this;
    }

    public String buttonGetCaption() {
        return this.buttonGetCaption(0);
    }

    public String buttonGetCaption(int n) {
        switch (n) {
            case 1: {
                return this.getDictionary(7451).getTextStreamValue(4371);
            }
            case 2: {
                return this.getDictionary(7451).getTextStreamValue(8723);
            }
        }
        return this.getDictionary(7451).getTextStreamValue(4881);
    }

    public void buttonSetCaption(String string) {
        this.buttonSetCaption(string, 0);
    }

    public void buttonSetCaption(String string, int n) {
        switch (n) {
            case 1: {
                this.getDictionary(7451).setTextStreamValue(4371, string.getBytes());
                break;
            }
            case 2: {
                this.getDictionary(7451).setTextStreamValue(8723, string.getBytes());
                break;
            }
            default: {
                this.getDictionary(7451).setTextStreamValue(4881, string.getBytes());
            }
        }
    }

    public Object getfillColor() {
        return FormObject.generateColor(this.getDictionary(7451).getFloatArray(4631));
    }

    public boolean isKid() {
        return this.isKid;
    }

    public void setKid(boolean bl) {
        this.isKid = bl;
    }

    public void setFormType(int n) {
        this.formType = n;
    }

    public int getFormType() {
        return this.formType;
    }

    public static BufferedImage getOpaqueImage() {
        return new BufferedImage(20, 20, 2);
    }
}

