/*
 * Decompiled with CFR 0.152.
 */
package it.flavianopetrocchi.jpdfbookmarks;

import it.flavianopetrocchi.jpdfbookmarks.JPdfBookmarks;
import it.flavianopetrocchi.jpdfbookmarks.MyHyperlinkListener;
import it.flavianopetrocchi.jpdfbookmarks.Res;
import it.flavianopetrocchi.linklabel.LinkLabel;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Desktop;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import org.jdesktop.layout.GroupLayout;

public class AboutBox
extends JDialog {
    private URI homePage;
    private Color nonFocusedColor = new Color(0, 0, 255);
    private MyHyperlinkListener linksListener;
    private JButton btnClose;
    private JLabel gplv3Label;
    private JScrollPane jScrollPane1;
    private JPanel leftPanel;
    private JLabel progIconLabel;
    private JPanel rightPanel;
    private JTextField txtBlog;
    private JTextField txtHomepage;
    private JTextPane txtLibraries;
    private JTextField txtMail;

    public AboutBox(Frame frame, boolean bl) {
        super(frame, bl);
        try {
            this.homePage = new URI("http://flavianopetrocchi.blogspot.com");
        }
        catch (URISyntaxException uRISyntaxException) {
            // empty catch block
        }
        this.initComponents();
        Cursor cursor = Cursor.getPredefinedCursor(12);
        this.txtMail.setCursor(cursor);
        this.txtHomepage.setCursor(cursor);
        this.txtBlog.setCursor(cursor);
        this.btnClose.requestFocusInWindow();
        this.linksListener = new MyHyperlinkListener(this);
        this.txtLibraries.addHyperlinkListener(this.linksListener);
    }

    private void initComponents() {
        this.rightPanel = new JPanel();
        JLabel jLabel = new JLabel();
        JLabel jLabel2 = new JLabel();
        JLabel jLabel3 = new JLabel();
        JLabel jLabel4 = new JLabel();
        JLabel jLabel5 = new JLabel();
        JLabel jLabel6 = new JLabel();
        JLabel jLabel7 = new JLabel();
        JLabel jLabel8 = new JLabel();
        this.txtHomepage = new LinkLabel(this.homePage);
        this.txtMail = new LinkLabel(this.homePage);
        this.txtBlog = new LinkLabel(this.homePage);
        JLabel jLabel9 = new JLabel();
        JLabel jLabel10 = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        this.txtLibraries = new JTextPane();
        JLabel jLabel11 = new JLabel();
        JLabel jLabel12 = new JLabel();
        this.leftPanel = new JPanel();
        this.progIconLabel = new JLabel();
        this.btnClose = new JButton();
        this.gplv3Label = new JLabel();
        this.setDefaultCloseOperation(2);
        this.setTitle("JPdfBookmarks");
        this.setModal(true);
        this.rightPanel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                AboutBox.this.txtHomepageMouseClicked(mouseEvent);
            }
        });
        jLabel.setFont(jLabel.getFont().deriveFont(jLabel.getFont().getStyle() | 1, jLabel.getFont().getSize() + 4));
        jLabel.setText("JPdfBookmarks");
        ResourceBundle resourceBundle = ResourceBundle.getBundle("it/flavianopetrocchi/jpdfbookmarks/locales/localizedText");
        jLabel2.setText(resourceBundle.getString("APP_DESCRIPTION"));
        jLabel3.setFont(jLabel3.getFont().deriveFont(jLabel3.getFont().getStyle() | 1));
        jLabel3.setText(resourceBundle.getString("VERSION_LABEL"));
        jLabel4.setFont(jLabel4.getFont().deriveFont(jLabel4.getFont().getStyle() | 1));
        jLabel4.setText(resourceBundle.getString("AUTHOR_LABEL"));
        jLabel5.setFont(jLabel5.getFont().deriveFont(jLabel5.getFont().getStyle() | 1));
        jLabel5.setText(resourceBundle.getString("EMAIL_LABEL"));
        jLabel6.setText(JPdfBookmarks.getVersion());
        jLabel7.setText("Flaviano Petrocchi");
        jLabel8.setFont(jLabel8.getFont().deriveFont(jLabel8.getFont().getStyle() | 1));
        jLabel8.setText(resourceBundle.getString("SITE_LABEL"));
        this.txtHomepage.setEditable(false);
        this.txtHomepage.setFont(this.txtHomepage.getFont());
        this.txtHomepage.setForeground(new Color(0, 0, 255));
        this.txtHomepage.setText(" http://sourceforge.net/projects/jpdfbookmarks/");
        this.txtHomepage.setBorder(BorderFactory.createMatteBorder(0, 0, 1, 0, new Color(0, 0, 255)));
        this.txtHomepage.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                AboutBox.this.txtHomepageMouseClicked(mouseEvent);
            }
        });
        this.txtHomepage.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                AboutBox.this.txtHomepageActionPerformed(actionEvent);
            }
        });
        this.txtHomepage.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent focusEvent) {
                AboutBox.this.txtHomepageFocusGained(focusEvent);
            }

            @Override
            public void focusLost(FocusEvent focusEvent) {
                AboutBox.this.txtHomepageFocusLost(focusEvent);
            }
        });
        this.txtMail.setEditable(false);
        this.txtMail.setForeground(new Color(0, 0, 255));
        this.txtMail.setText(" flavianopetrocchi@gmail.com ");
        this.txtMail.setBorder(BorderFactory.createMatteBorder(0, 0, 1, 0, new Color(0, 0, 255)));
        this.txtMail.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                AboutBox.this.txtMailMouseClicked(mouseEvent);
            }
        });
        this.txtMail.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                AboutBox.this.txtMailActionPerformed(actionEvent);
            }
        });
        this.txtMail.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent focusEvent) {
                AboutBox.this.txtMailFocusGained(focusEvent);
            }

            @Override
            public void focusLost(FocusEvent focusEvent) {
                AboutBox.this.txtMailFocusLost(focusEvent);
            }
        });
        this.txtBlog.setEditable(false);
        this.txtBlog.setFont(this.txtBlog.getFont());
        this.txtBlog.setForeground(new Color(0, 0, 255));
        this.txtBlog.setText(" http://flavianopetrocchi.blogspot.com ");
        this.txtBlog.setBorder(BorderFactory.createMatteBorder(0, 0, 1, 0, new Color(0, 0, 255)));
        this.txtBlog.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                AboutBox.this.txtBlogMouseClicked(mouseEvent);
            }
        });
        this.txtBlog.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                AboutBox.this.txtBlogActionPerformed(actionEvent);
            }
        });
        this.txtBlog.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent focusEvent) {
                AboutBox.this.txtBlogFocusGained(focusEvent);
            }

            @Override
            public void focusLost(FocusEvent focusEvent) {
                AboutBox.this.txtBlogFocusLost(focusEvent);
            }
        });
        jLabel9.setFont(jLabel9.getFont().deriveFont(jLabel9.getFont().getStyle() | 1));
        jLabel9.setText("Blog:");
        jLabel10.setText(resourceBundle.getString("ABOUT_LIBRARIES"));
        this.txtLibraries.setContentType("text/html");
        this.txtLibraries.setEditable(false);
        this.txtLibraries.setText("<!DOCTYPE html PUBLIC \"-//W3C//DTD HTML 4.01//EN\" \"http://www.w3.org/TR/html4/strict.dtd\">\n<html>\n<head>\n</head>\n<body>\n<span style=\"font-weight: bold;\">Apache Commons CLI</span><br>\nCopyright 2001-2009 The Apache Software Foundation <br>\n<a href=\"http://commons.apache.org/cli/\">http://commons.apache.org/cli/</a><br>\nApache License Version 2.0, January 2004<br>\n<a href=\"http://www.apache.org/licenses/\">http://www.apache.org/licenses/</a><br>\n<br>\n<span style=\"font-weight: bold;\">iText-2.1.7</span><br>\nCopyright 1999, 2000, 2001, 2002 by Bruno Lowagie.<br>\n<a href=\"http://www.lowagie.com/iText/\">http://www.lowagie.com/iText/</a><br>\nGNU LIBRARY GENERAL PUBLIC LICENSE Version 2 (or later version)<br>\n<a href=\"http://www.gnu.org/licenses\">http://www.gnu.org/licenses</a>/<br>\nPatched with some custom code in SimpleBookmark.java (patch available under GPL)<br>\n<br>\n<b>Bouncy Castle Crypto APIs<br>\n</b>Copyright (c) 2000 - 2009 The Legion Of The Bouncy Castle<br>\n<a href=\"http://www.bouncycastle.org\">http://www.bouncycastle.org</a>\n<br>\nAdaptation of the <a\n href=\"http://opensource.org/licenses/mit-license.php\">MIT\nX11 License</a><br>\n<a href=\"http://www.bouncycastle.org/licence.html\">http://www.bouncycastle.org/licence.html</a><br>\n<span style=\"font-weight: bold;\"></span><br>\n<span style=\"font-weight: bold;\">JPedal</span><br>\n(C) Copyright 1997-2008, IDRsolutions and Contributors.<br>\n<a href=\"http://www.jpedal.org\">http://www.jpedal.org</a><br>\nGNU Lesser General Public License Version 2.1 (or later version)<br>\n<a href=\"http://www.gnu.org/licenses/\">http://www.gnu.org/licenses/</a><br>\n<br>\nIcons are from the <span style=\"font-weight: bold;\">\"Tango\nDesktop Project\"</span><br>\n<a href=\"http://tango.freedesktop.org/Tango_Desktop_Project\">http://tango.freedesktop.org/Tango_Desktop_Project</a>\n</body>\n</html>\n");
        this.jScrollPane1.setViewportView(this.txtLibraries);
        jLabel11.setFont(jLabel11.getFont().deriveFont(jLabel11.getFont().getStyle() | 1));
        jLabel11.setText(resourceBundle.getString("LICENSE_LABEL"));
        jLabel12.setText("GNU General Public License Version 3");
        GroupLayout groupLayout = new GroupLayout(this.rightPanel);
        this.rightPanel.setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(1).add(groupLayout.createSequentialGroup().addContainerGap().add(jLabel3).addPreferredGap(0).add(jLabel6).add(373, 373, 373)).add(groupLayout.createSequentialGroup().add(10, 10, 10).add(jLabel10, -1, 470, Short.MAX_VALUE).addContainerGap(20, Short.MAX_VALUE)).add(groupLayout.createSequentialGroup().add(10, 10, 10).add(jLabel).addContainerGap(390, Short.MAX_VALUE)).add(groupLayout.createSequentialGroup().add(10, 10, 10).add(jLabel2, -1, 470, Short.MAX_VALUE).addContainerGap(20, Short.MAX_VALUE)).add(groupLayout.createSequentialGroup().addContainerGap().add(groupLayout.createParallelGroup(1).add(jLabel5).add(jLabel8).add(jLabel9).add(jLabel11).add(jLabel4)).addPreferredGap(0).add(groupLayout.createParallelGroup(1).add(jLabel12).add(jLabel7).add(this.txtMail, -2, -1, -2).add(this.txtHomepage, -2, -1, -2).add(this.txtBlog, -2, -1, -2)).addContainerGap(205, Short.MAX_VALUE)).add(groupLayout.createSequentialGroup().addContainerGap().add(this.jScrollPane1, -1, 480, Short.MAX_VALUE).addContainerGap()));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(1).add(groupLayout.createSequentialGroup().addContainerGap().add(jLabel).addPreferredGap(0).add(jLabel2).add(18, 18, 18).add(groupLayout.createParallelGroup(3).add(jLabel3).add(jLabel6)).addPreferredGap(0).add(groupLayout.createParallelGroup(3).add(jLabel4).add(jLabel7)).add(5, 5, 5).add(groupLayout.createParallelGroup(3).add(jLabel11).add(jLabel12)).addPreferredGap(0).add(groupLayout.createParallelGroup(3).add(jLabel5).add(this.txtMail, -2, -1, -2)).addPreferredGap(0).add(groupLayout.createParallelGroup(3).add(jLabel8).add(this.txtHomepage, -2, -1, -2)).addPreferredGap(0).add(groupLayout.createParallelGroup(3).add(jLabel9).add(this.txtBlog, -2, -1, -2)).addPreferredGap(1).add(jLabel10).addPreferredGap(0).add(this.jScrollPane1, -1, 211, Short.MAX_VALUE)));
        this.progIconLabel.setHorizontalAlignment(0);
        this.progIconLabel.setIcon(new ImageIcon(this.getClass().getResource("/it/flavianopetrocchi/jpdfbookmarks/gfx/jpdfbookmarks.png")));
        this.btnClose.setMnemonic(ResourceBundle.getBundle("it/flavianopetrocchi/jpdfbookmarks/locales/localizedText").getString("ACTION_CLOSE_MNEMONIC").charAt(0));
        this.btnClose.setText(resourceBundle.getString("ACTION_CLOSE"));
        this.btnClose.setToolTipText("Close this dialog");
        this.btnClose.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                AboutBox.this.btnCloseActionPerformed(actionEvent);
            }
        });
        this.gplv3Label.setHorizontalAlignment(0);
        this.gplv3Label.setIcon(new ImageIcon(this.getClass().getResource("/it/flavianopetrocchi/jpdfbookmarks/gfx/gplv3-127x51.png")));
        GroupLayout groupLayout2 = new GroupLayout(this.leftPanel);
        this.leftPanel.setLayout(groupLayout2);
        groupLayout2.setHorizontalGroup(groupLayout2.createParallelGroup(1).add(groupLayout2.createSequentialGroup().addContainerGap().add(groupLayout2.createParallelGroup(1).add(this.btnClose, -1, 162, Short.MAX_VALUE).add(this.progIconLabel, -1, 162, Short.MAX_VALUE).add(this.gplv3Label, -1, 162, Short.MAX_VALUE))));
        groupLayout2.setVerticalGroup(groupLayout2.createParallelGroup(1).add(groupLayout2.createSequentialGroup().addContainerGap().add(this.progIconLabel, -2, 179, -2).add(18, 18, 18).add(this.gplv3Label).addPreferredGap(0, 155, Short.MAX_VALUE).add(this.btnClose).addContainerGap()));
        GroupLayout groupLayout3 = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(groupLayout3);
        groupLayout3.setHorizontalGroup(groupLayout3.createParallelGroup(1).add(groupLayout3.createSequentialGroup().add(this.leftPanel, -2, -1, -2).addPreferredGap(0).add(this.rightPanel, -1, -1, Short.MAX_VALUE)));
        groupLayout3.setVerticalGroup(groupLayout3.createParallelGroup(1).add(2, this.leftPanel, -1, -1, Short.MAX_VALUE).add(groupLayout3.createSequentialGroup().add(11, 11, 11).add(this.rightPanel, -1, -1, Short.MAX_VALUE).add(11, 11, 11)));
        this.pack();
    }

    private void btnCloseActionPerformed(ActionEvent actionEvent) {
        this.setVisible(false);
    }

    private void txtMailActionPerformed(ActionEvent actionEvent) {
        this.mail(this.txtMail.getText().trim());
    }

    private void txtHomepageMouseClicked(MouseEvent mouseEvent) {
        this.linksListener.goToWebLink(this.txtHomepage.getText().trim());
    }

    private void txtMailMouseClicked(MouseEvent mouseEvent) {
        this.mail(this.txtMail.getText().trim());
    }

    private void txtMailFocusGained(FocusEvent focusEvent) {
        this.setFocusedColor((JComponent)focusEvent.getSource());
    }

    private void txtMailFocusLost(FocusEvent focusEvent) {
        this.setNonFocusedColor((JComponent)focusEvent.getSource());
    }

    private void txtHomepageFocusGained(FocusEvent focusEvent) {
        this.setFocusedColor((JComponent)focusEvent.getSource());
    }

    private void txtHomepageFocusLost(FocusEvent focusEvent) {
        this.setNonFocusedColor((JComponent)focusEvent.getSource());
    }

    private void txtHomepageActionPerformed(ActionEvent actionEvent) {
        this.linksListener.goToWebLink(((JTextField)actionEvent.getSource()).getText().trim());
    }

    private void txtBlogActionPerformed(ActionEvent actionEvent) {
        this.linksListener.goToWebLink(((JTextField)actionEvent.getSource()).getText().trim());
    }

    private void txtBlogMouseClicked(MouseEvent mouseEvent) {
        this.linksListener.goToWebLink(((JTextField)mouseEvent.getSource()).getText().trim());
    }

    private void txtBlogFocusGained(FocusEvent focusEvent) {
        this.setFocusedColor((JComponent)focusEvent.getSource());
    }

    private void txtBlogFocusLost(FocusEvent focusEvent) {
        this.setNonFocusedColor((JComponent)focusEvent.getSource());
    }

    private void setFocusedColor(JComponent jComponent) {
        jComponent.setBorder(BorderFactory.createMatteBorder(1, 1, 1, 1, this.nonFocusedColor));
    }

    private void setNonFocusedColor(JComponent jComponent) {
        jComponent.setBorder(BorderFactory.createMatteBorder(0, 0, 1, 0, this.nonFocusedColor));
    }

    private void mail(String string) {
        int n = JOptionPane.showConfirmDialog(this, Res.getString("MSG_LAUNCH_MAIL_CLIENT"), "JPdfBookmarks", 2);
        if (n != 0) {
            return;
        }
        Desktop desktop = Desktop.getDesktop();
        try {
            desktop.mail(new URI("mailto:" + string));
        }
        catch (URISyntaxException uRISyntaxException) {
            JOptionPane.showMessageDialog(this, Res.getString("ERROR_WRONG_URI"), "JPdfBookmarks", 0);
        }
        catch (IOException iOException) {
            JOptionPane.showMessageDialog(this, Res.getString("ERROR_LAUNCHING_BROWSER"), "JPdfBookmarks", 0);
        }
    }

    public static void main(String[] stringArray) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                AboutBox aboutBox = new AboutBox((Frame)new JFrame(), true);
                aboutBox.addWindowListener(new WindowAdapter(){

                    @Override
                    public void windowClosing(WindowEvent windowEvent) {
                        System.exit(0);
                    }
                });
                aboutBox.setVisible(true);
            }
        });
    }
}

