/*
 * Decompiled with CFR 0.152.
 */
package it.flavianopetrocchi.jpdfbookmarks;

import it.flavianopetrocchi.colors.ColorsListPanel;
import it.flavianopetrocchi.jpdfbookmarks.AboutBox;
import it.flavianopetrocchi.jpdfbookmarks.ActionsDialog;
import it.flavianopetrocchi.jpdfbookmarks.BookmarksTree;
import it.flavianopetrocchi.jpdfbookmarks.CursorToolkit;
import it.flavianopetrocchi.jpdfbookmarks.Dumper;
import it.flavianopetrocchi.jpdfbookmarks.ExtendedUndoManager;
import it.flavianopetrocchi.jpdfbookmarks.FitType;
import it.flavianopetrocchi.jpdfbookmarks.GoToPageDialog;
import it.flavianopetrocchi.jpdfbookmarks.IPdfView;
import it.flavianopetrocchi.jpdfbookmarks.JPdfBookmarks;
import it.flavianopetrocchi.jpdfbookmarks.LeftPanel;
import it.flavianopetrocchi.jpdfbookmarks.OptionsDlg;
import it.flavianopetrocchi.jpdfbookmarks.PageChangedEvent;
import it.flavianopetrocchi.jpdfbookmarks.PageChangedListener;
import it.flavianopetrocchi.jpdfbookmarks.PageOffsetDialog;
import it.flavianopetrocchi.jpdfbookmarks.Prefs;
import it.flavianopetrocchi.jpdfbookmarks.ProxyAuthenticator;
import it.flavianopetrocchi.jpdfbookmarks.RenderingStartEvent;
import it.flavianopetrocchi.jpdfbookmarks.RenderingStartListener;
import it.flavianopetrocchi.jpdfbookmarks.Res;
import it.flavianopetrocchi.jpdfbookmarks.TextCopiedEvent;
import it.flavianopetrocchi.jpdfbookmarks.TextCopiedListener;
import it.flavianopetrocchi.jpdfbookmarks.UnboablePageOffset;
import it.flavianopetrocchi.jpdfbookmarks.UndoableCellEdit;
import it.flavianopetrocchi.jpdfbookmarks.UndoableDeleteBookmark;
import it.flavianopetrocchi.jpdfbookmarks.UndoableLoadBookmarks;
import it.flavianopetrocchi.jpdfbookmarks.UndoableMultiSetDestFromView;
import it.flavianopetrocchi.jpdfbookmarks.UndoableMultiSetLaunchLink;
import it.flavianopetrocchi.jpdfbookmarks.UndoableMultiSetWebLink;
import it.flavianopetrocchi.jpdfbookmarks.UndoablePasteBookmarks;
import it.flavianopetrocchi.jpdfbookmarks.UndoableRenameAction;
import it.flavianopetrocchi.jpdfbookmarks.UndoableSetDestination;
import it.flavianopetrocchi.jpdfbookmarks.UnifiedFileOperator;
import it.flavianopetrocchi.jpdfbookmarks.ViewChangedEvent;
import it.flavianopetrocchi.jpdfbookmarks.ViewChangedListener;
import it.flavianopetrocchi.jpdfbookmarks.WrapFlowLayout;
import it.flavianopetrocchi.jpdfbookmarks.bookmark.Bookmark;
import it.flavianopetrocchi.jpdfbookmarks.bookmark.BookmarkSelection;
import it.flavianopetrocchi.jpdfbookmarks.bookmark.BookmarkType;
import it.flavianopetrocchi.jpdfbookmarks.bookmark.IBookmarksConverter;
import it.flavianopetrocchi.labelvertical.VerticalLabel;
import it.flavianopetrocchi.labelvertical.VerticalLabelUI;
import it.flavianopetrocchi.linklabel.LinkLabel;
import it.flavianopetrocchi.mousedraggabletree.MouseDraggableTree;
import it.flavianopetrocchi.mousedraggabletree.TreeNodeMovedEvent;
import it.flavianopetrocchi.mousedraggabletree.TreeNodeMovedListener;
import it.flavianopetrocchi.mousedraggabletree.UndoableNodeMoved;
import it.flavianopetrocchi.mousedraggabletree.Visitor;
import it.flavianopetrocchi.utilities.FileOperationEvent;
import it.flavianopetrocchi.utilities.FileOperationListener;
import it.flavianopetrocchi.utilities.IntegerTextField;
import it.flavianopetrocchi.utilities.SimpleFileFilter;
import it.flavianopetrocchi.utilities.Ut;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Window;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.FlavorEvent;
import java.awt.datatransfer.FlavorListener;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Serializable;
import java.net.Authenticator;
import java.net.HttpURLConnection;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.SocketAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.CellEditor;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JColorChooser;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JProgressBar;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;
import javax.swing.TransferHandler;
import javax.swing.UIManager;
import javax.swing.colorchooser.AbstractColorChooserPanel;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.event.UndoableEditEvent;
import javax.swing.event.UndoableEditListener;
import javax.swing.filechooser.FileFilter;
import javax.swing.filechooser.FileNameExtensionFilter;
import javax.swing.plaf.LabelUI;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.UndoableEdit;
import javax.swing.undo.UndoableEditSupport;

class JPdfBookmarksGui
extends JFrame
implements FileOperationListener,
PageChangedListener,
ViewChangedListener,
TreeExpansionListener,
UndoableEditListener,
TreeSelectionListener,
CellEditorListener,
RenderingStartListener,
TextCopiedListener,
TreeNodeMovedListener {
    private static Clipboard localClipboard = new Clipboard("JPdfBookmarks");
    private DropTarget dropTarget;
    private static final DataFlavor bookmarksFlavor = new DataFlavor(BookmarkSelection.class, "BookmarkSelection");
    private final int ZOOM_STEP = 10;
    private int windowState;
    private JSplitPane centralSplit;
    private String title = "JPdfBookmarks";
    private Prefs userPrefs = new Prefs();
    private int numPages = 0;
    private JScrollPane bookmarksScroller;
    private BookmarksTree bookmarksTree;
    private DefaultTreeModel bookmarksTreeModel;
    private JTabbedPane leftTabbedPane;
    private UnifiedFileOperator fileOperator;
    private IPdfView viewPanel;
    private JToolBar navigationToolbar;
    private ButtonGroup zoomMenuItemsGroup;
    private JRadioButtonMenuItem rbFitWidth;
    private JRadioButtonMenuItem rbFitHeight;
    private JRadioButtonMenuItem rbFitPage;
    private JRadioButtonMenuItem rbFitNative;
    private JRadioButtonMenuItem rbTopLeftZoom;
    private JRadioButtonMenuItem rbFitRect;
    private JRadioButtonMenuItem bookmarksButton;
    private JRadioButtonMenuItem thumbnailsButton;
    private JCheckBoxMenuItem cbBold;
    private JCheckBoxMenuItem cbItalic;
    private JCheckBoxMenuItem cbEditMenuBold;
    private JCheckBoxMenuItem cbEditMenuItalic;
    private JCheckBoxMenuItem cbShowOnOpen;
    private JCheckBoxMenuItem cbSelectText;
    private JCheckBoxMenuItem cbConnectToClipboard;
    private ButtonGroup zoomButtonsGroup;
    private JToggleButton tbShowOnOpen;
    private JToggleButton tbFitWidth;
    private JToggleButton tbFitHeight;
    private JToggleButton tbFitPage;
    private JToggleButton tbFitNative;
    private JToggleButton tbTopLeftZoom;
    private JToggleButton tbFitRect;
    private JToggleButton tbBold;
    private JToggleButton tbItalic;
    private JLabel lblPageOfPages;
    private JLabel lblMouseOverNode;
    private JLabel lblSelectedNode;
    private JLabel lblCurrentView;
    private JLabel lblPercent;
    private JLabel lblStatus;
    private IntegerTextField txtGoToPage;
    private IntegerTextField txtZoom;
    private ExtendedUndoManager undoManager;
    private UndoableEditSupport undoSupport;
    private JPopupMenu treeMenu;
    private JPopupMenu toolbarsPanelsMenu;
    private JColorChooser colorChooser;
    private JProgressBar progressBar;
    private Box busyPanel;
    private JCheckBox checkInheritTop;
    private JCheckBox checkInheritLeft;
    private JCheckBox checkInheritZoom;
    private VerticalLabel lblInheritLeft;
    private JMenu openRecent;
    private JToggleButton tbSelectText;
    private JToggleButton tbConnectToClipboard;
    private JPanel bookmarksPanel;
    private JPanel bookmarksToolbarsPanel = new JPanel();
    private HashMap<String, JToolBar> mainToolbars = new HashMap();
    private HashMap<String, JToolBar> bookmarksToolbars = new HashMap();
    private JPanel mainToolbarsPanel = new JPanel(new WrapFlowLayout(0));
    private MouseAdapter mouseAdapter;
    private ToolbarsPopupListener toolbarsPopupListener = new ToolbarsPopupListener();
    private LeftPanel leftPanel;
    private ButtonGroup leftPanelMenuGroup;
    private Action quitAction;
    private Action openAction;
    private Action saveAction;
    private Action saveAsAction;
    private Action closeAction;
    private Action dumpAction;
    private Action loadAction;
    private Action goNextPageAction;
    private Action goLastPageAction;
    private Action goPreviousPageAction;
    private Action goFirstPageAction;
    private Action goToPageAction;
    private Action fitWidthAction;
    private Action fitContentWidthAction;
    private Action fitHeightAction;
    private Action fitContentHeightAction;
    private Action fitNativeAction;
    private Action fitPageAction;
    private Action fitContentAction;
    private Action topLeftZoomAction;
    private Action fitRectAction;
    private Action zoomInAction;
    private Action zoomOutAction;
    private Action undoAction;
    private Action redoAction;
    private Action expandAllAction;
    private Action collapseAllAction;
    private Action addSiblingAction;
    private Action addChildAction;
    private Action setBoldAction;
    private Action setItalicAction;
    private Action deleteAction;
    private Action renameAction;
    private Action changeColorAction;
    private Action setDestFromViewAction;
    private Action showOnOpenAction;
    private Action addWebLinkAction;
    private Action addLaunchLinkAction;
    private Action showActionsDialog;
    private Action applyPageOffset;
    private Action optionsDialogAction;
    private Action checkUpdatesAction;
    private Action readOnlineManualAction;
    private Action donateToProject;
    private Action goToAuthorBlog;
    private Action selectText;
    private Action connectToClipboard;
    private Action cutAction;
    private Action copyAction;
    private Action pasteAction;
    private Action openLinkedPdf;
    private Action extractLinks;
    private Action copyBookmarkFromViewAction;
    private int dividerLocation;

    private void saveWindowState() {
        this.userPrefs.setWindowState(this.windowState);
        if (this.windowState == 6) {
            this.userPrefs.setLocation(null);
            this.userPrefs.setSize(null);
        } else {
            this.userPrefs.setLocation(this.getLocation());
            this.userPrefs.setSize(this.getSize());
        }
        this.userPrefs.setCollapsingPanelState(this.leftPanel.getPanelState());
        this.userPrefs.setSplitterLocation(this.leftPanel.getDividerLocation());
        this.userPrefs.setPanelToShow((String)this.leftPanel.getComboBoxSelector().getSelectedItem());
    }

    private void loadWindowState() {
        Ut.changeLAF((String)this.userPrefs.getLAF(), (Component)this);
        this.setSize(this.userPrefs.getSize());
        this.setLocation(this.userPrefs.getLocation());
        this.setExtendedState(this.userPrefs.getWindowState());
    }

    public JPdfBookmarksGui() {
        this.setDefaultCloseOperation(0);
        Authenticator.setDefault(new ProxyAuthenticator(this, true));
        localClipboard.addFlavorListener(new FlavorListener(){

            @Override
            public void flavorsChanged(FlavorEvent flavorEvent) {
                JPdfBookmarksGui.this.flavorsChanged();
            }
        });
        this.undoManager = new ExtendedUndoManager();
        this.undoSupport = new UndoableEditSupport(this);
        this.setTitle(this.title);
        this.setIconImage(Res.getIcon(this.getClass(), "gfx/jpdfbookmarks.png").getImage());
        this.loadWindowState();
        this.fileOperator = new UnifiedFileOperator();
        this.viewPanel = this.fileOperator.getViewPanel();
        this.viewPanel.addTextCopiedListener(this);
        this.initComponents();
        this.fileOperator.addFileOperationListener(this);
        this.viewPanel.addPageChangedListener(this);
        this.viewPanel.addViewChangedListener(this);
        this.undoSupport.addUndoableEditListener(this.undoManager);
        this.undoSupport.addUndoableEditListener(this);
        WindowAdapter windowAdapter = new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                JPdfBookmarksGui.this.saveWindowState();
                JPdfBookmarksGui.this.exitApplication();
            }

            @Override
            public void windowStateChanged(WindowEvent windowEvent) {
                JPdfBookmarksGui.this.windowState = JPdfBookmarksGui.this.getExtendedState();
            }

            @Override
            public void windowOpened(WindowEvent windowEvent) {
                if (JPdfBookmarksGui.this.userPrefs.getCheckUpdatesOnStart()) {
                    JPdfBookmarksGui.this.checkUpdates(true);
                }
            }
        };
        this.addWindowListener(windowAdapter);
        this.addWindowStateListener(windowAdapter);
    }

    public final void flavorsChanged() {
        DataFlavor[] dataFlavorArray;
        for (DataFlavor dataFlavor : dataFlavorArray = localClipboard.getAvailableDataFlavors()) {
            if (!dataFlavor.equals(bookmarksFlavor) || this.fileOperator == null || this.fileOperator.getFilePath() == null) continue;
            this.pasteAction.setEnabled(true);
        }
    }

    public boolean askCloseWithoutSave() {
        if (!this.fileOperator.getFileChanged() || this.fileOperator.isReadonly()) {
            return true;
        }
        JPdfBookmarksGui jPdfBookmarksGui = this.getState() != 1 ? this : null;
        int n = JOptionPane.showConfirmDialog(jPdfBookmarksGui, Res.getString("ASK_SAVE_CHANGES"), this.title, 1, 1);
        switch (n) {
            case 0: {
                return this.fileOperator.save((Bookmark)this.bookmarksTreeModel.getRoot());
            }
            case 1: {
                return true;
            }
            case 2: {
                return false;
            }
        }
        return true;
    }

    private void exitApplication() {
        if (!this.askCloseWithoutSave()) {
            return;
        }
        this.fileOperator.close();
        Frame[] frameArray = JFrame.getFrames();
        if (frameArray.length == 1) {
            this.saveWindowState();
            System.exit(0);
        } else {
            this.dispose();
        }
    }

    public void fileOperation(FileOperationEvent fileOperationEvent) {
        if (fileOperationEvent.getOperation() == FileOperationEvent.Operation.FILE_OPENED || fileOperationEvent.getOperation() == FileOperationEvent.Operation.FILE_READONLY) {
            this.setTitle(this.title + ": " + fileOperationEvent.getPathToFile());
            this.userPrefs.setLastDirectory(fileOperationEvent.getPathToFile());
            this.userPrefs.addRecentFile(fileOperationEvent.getPathToFile());
            this.createRecentFilesItems();
            this.lblPageOfPages.setText(String.format(" / %d ", this.viewPanel.getNumPages()));
            Ut.enableComponents((boolean)true, (JComponent[])new JComponent[]{this.lblPageOfPages, this.txtGoToPage, this.txtZoom, this.lblPercent});
            Ut.enableActions((boolean)true, (Action[])new Action[]{this.closeAction, this.fitWidthAction, this.fitHeightAction, this.fitPageAction, this.fitNativeAction, this.zoomInAction, this.zoomOutAction, this.goToPageAction, this.fitRectAction, this.expandAllAction, this.collapseAllAction, this.topLeftZoomAction, this.addSiblingAction, this.showOnOpenAction, this.dumpAction, this.loadAction, this.selectText, this.connectToClipboard, this.openLinkedPdf, this.copyBookmarkFromViewAction});
            if (fileOperationEvent.getOperation() == FileOperationEvent.Operation.FILE_OPENED) {
                Ut.enableActions((boolean)true, (Action[])new Action[]{this.saveAsAction, this.extractLinks});
            }
            this.tbShowOnOpen.setSelected(this.fileOperator.getShowBookmarksOnOpen());
            this.cbShowOnOpen.setSelected(this.fileOperator.getShowBookmarksOnOpen());
            switch (this.viewPanel.getFitType()) {
                case FitWidth: {
                    this.tbFitWidth.setSelected(true);
                    this.rbFitWidth.setSelected(true);
                    break;
                }
                case FitHeight: {
                    this.tbFitHeight.setSelected(true);
                    this.rbFitHeight.setSelected(true);
                    break;
                }
                case FitPage: {
                    this.tbFitPage.setSelected(true);
                    this.rbFitPage.setSelected(true);
                    break;
                }
                case FitNative: {
                    this.tbFitNative.setSelected(true);
                    this.rbFitNative.setSelected(true);
                    break;
                }
                case FitRect: {
                    this.tbFitRect.setSelected(true);
                    this.rbFitRect.setSelected(true);
                }
            }
            this.flavorsChanged();
            if (fileOperationEvent.getOperation() == FileOperationEvent.Operation.FILE_READONLY) {
                JOptionPane.showMessageDialog(this, Res.getString("MSG_READONLY"), "JPdfBookmarks", 2);
                this.setTitle(this.getTitle() + " - " + Res.getString("READONLY"));
            }
        } else if (fileOperationEvent.getOperation() == FileOperationEvent.Operation.FILE_CLOSED) {
            this.setTitle(this.title);
            this.txtGoToPage.setText("0");
            this.lblPageOfPages.setText(" / 0 ");
            this.txtZoom.setText("0");
            Ut.enableComponents((boolean)false, (JComponent[])new JComponent[]{this.lblPageOfPages, this.txtGoToPage, this.txtZoom, this.lblPercent});
            Ut.enableActions((boolean)false, (Action[])new Action[]{this.saveAsAction, this.closeAction, this.fitWidthAction, this.fitHeightAction, this.fitPageAction, this.fitNativeAction, this.zoomInAction, this.zoomOutAction, this.goFirstPageAction, this.goPreviousPageAction, this.goNextPageAction, this.goLastPageAction, this.goToPageAction, this.expandAllAction, this.collapseAllAction, this.topLeftZoomAction, this.fitRectAction, this.addSiblingAction, this.addChildAction, this.deleteAction, this.undoAction, this.redoAction, this.showOnOpenAction, this.setBoldAction, this.setItalicAction, this.renameAction, this.setDestFromViewAction, this.changeColorAction, this.dumpAction, this.loadAction, this.addWebLinkAction, this.addLaunchLinkAction, this.saveAction, this.applyPageOffset, this.selectText, this.connectToClipboard, this.showActionsDialog, this.openLinkedPdf, this.copyBookmarkFromViewAction, this.extractLinks});
            this.lblMouseOverNode.setText(" ");
            this.lblSelectedNode.setText(" ");
            this.lblCurrentView.setText(" ");
            this.setEmptyBookmarksTree();
            this.updateThumbnailsPanel(null);
            this.leftPanel.setPanelState(this.leftPanel.getPanelState());
            this.undoManager.die();
        } else if (fileOperationEvent.getOperation() == FileOperationEvent.Operation.FILE_CHANGED) {
            if (this.fileOperator.getFileChanged() && !this.fileOperator.isReadonly()) {
                this.setTitle(this.title + ": " + fileOperationEvent.getPathToFile() + " *");
                Ut.enableActions((boolean)true, (Action[])new Action[]{this.saveAction});
            }
        } else if (fileOperationEvent.getOperation() == FileOperationEvent.Operation.FILE_SAVED) {
            this.setTitle(this.title + ": " + fileOperationEvent.getPathToFile());
            this.userPrefs.setLastDirectory(fileOperationEvent.getPathToFile());
            this.userPrefs.addRecentFile(fileOperationEvent.getPathToFile());
            this.createRecentFilesItems();
            Ut.enableActions((boolean)false, (Action[])new Action[]{this.saveAction});
        }
    }

    @Override
    public void pageChanged(PageChangedEvent pageChangedEvent) {
        int n = pageChangedEvent.getCurrentPage();
        this.txtGoToPage.setInteger(n);
        if (pageChangedEvent.hasPrevious()) {
            Ut.enableActions((boolean)true, (Action[])new Action[]{this.goPreviousPageAction, this.goFirstPageAction});
        } else {
            Ut.enableActions((boolean)false, (Action[])new Action[]{this.goPreviousPageAction, this.goFirstPageAction});
        }
        if (pageChangedEvent.hasNext()) {
            Ut.enableActions((boolean)true, (Action[])new Action[]{this.goNextPageAction, this.goLastPageAction});
        } else {
            Ut.enableActions((boolean)false, (Action[])new Action[]{this.goNextPageAction, this.goLastPageAction});
        }
    }

    private void enableInheritChecks(boolean bl, boolean bl2, boolean bl3) {
        this.checkInheritTop.setEnabled(bl);
        this.checkInheritLeft.setEnabled(bl2);
        this.lblInheritLeft.setEnabled(bl2);
        this.checkInheritZoom.setEnabled(bl3);
    }

    @Override
    public void viewChanged(ViewChangedEvent viewChangedEvent) {
        FitType fitType = viewChangedEvent.getFitType();
        float f = viewChangedEvent.getScale();
        int n = Math.round(f * 100.0f);
        Bookmark bookmark = viewChangedEvent.getBookmark();
        this.lblCurrentView.setText(Res.getString("CURRENT_VIEW") + ": " + bookmark.getDescription(this.userPrefs.getUseThousandths()));
        this.txtZoom.setInteger(n);
        switch (fitType) {
            case FitWidth: {
                this.enableInheritChecks(true, false, false);
                this.tbFitWidth.setSelected(true);
                this.rbFitWidth.setSelected(true);
                break;
            }
            case FitHeight: {
                this.enableInheritChecks(false, true, false);
                this.tbFitHeight.setSelected(true);
                this.rbFitHeight.setSelected(true);
                break;
            }
            case FitPage: {
                this.enableInheritChecks(false, false, false);
                this.tbFitPage.setSelected(true);
                this.rbFitPage.setSelected(true);
                break;
            }
            case FitNative: {
                this.enableInheritChecks(true, true, true);
                this.tbFitNative.setSelected(true);
                this.rbFitNative.setSelected(true);
                break;
            }
            case TopLeftZoom: {
                this.enableInheritChecks(true, true, true);
                this.tbTopLeftZoom.setSelected(true);
                this.rbTopLeftZoom.setSelected(true);
                break;
            }
            case FitRect: {
                this.enableInheritChecks(false, false, false);
                this.tbFitRect.setSelected(true);
                this.rbFitRect.setSelected(true);
            }
        }
    }

    @Override
    public void treeExpanded(TreeExpansionEvent treeExpansionEvent) {
        TreePath treePath = treeExpansionEvent.getPath();
        Bookmark bookmark = (Bookmark)treePath.getLastPathComponent();
        if (!bookmark.isOpened()) {
            bookmark.setOpened(true);
            this.fileOperator.setFileChanged(true);
        }
        this.recreateNodesOpenedState();
    }

    @Override
    public void treeCollapsed(TreeExpansionEvent treeExpansionEvent) {
        TreePath treePath = treeExpansionEvent.getPath();
        Bookmark bookmark = (Bookmark)treePath.getLastPathComponent();
        if (bookmark.isOpened()) {
            bookmark.setOpened(false);
            this.fileOperator.setFileChanged(true);
        }
    }

    @Override
    public void undoableEditHappened(UndoableEditEvent undoableEditEvent) {
        UndoableEdit undoableEdit;
        UndoableEdit[] undoableEditArray = this.undoManager.getUndoableEdits();
        if (undoableEditArray.length > 0 && (undoableEdit = undoableEditArray[0]) instanceof UndoableNodeMoved) {
            this.recreateNodesOpenedState();
        }
        this.updateUndoRedoPresentation();
        this.fileOperator.setFileChanged(true);
    }

    @Override
    public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
        Bookmark bookmark = this.getSelectedBookmark();
        Ut.enableActions((bookmark != null ? 1 : 0) != 0, (Action[])new Action[]{this.setBoldAction, this.setItalicAction, this.changeColorAction, this.applyPageOffset, this.deleteAction, this.renameAction, this.setDestFromViewAction, this.cutAction, this.copyAction, this.addWebLinkAction, this.addLaunchLinkAction});
        TreePath[] treePathArray = this.bookmarksTree.getSelectionPaths();
        Ut.enableActions((bookmark != null && treePathArray.length == 1 ? 1 : 0) != 0, (Action[])new Action[]{this.addChildAction, this.showActionsDialog});
        if (bookmark != null) {
            this.updateStyleButtons(bookmark);
        }
    }

    private Bookmark getSelectedBookmark() {
        TreePath treePath = this.bookmarksTree.getSelectionPath();
        if (treePath == null) {
            return null;
        }
        Bookmark bookmark = null;
        try {
            bookmark = (Bookmark)treePath.getLastPathComponent();
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        return bookmark;
    }

    @Override
    public void editingStopped(ChangeEvent changeEvent) {
        Bookmark bookmark = this.getSelectedBookmark();
        if (bookmark == null) {
            return;
        }
        String string = bookmark.getTitle().trim();
        CellEditor cellEditor = (CellEditor)changeEvent.getSource();
        String string2 = cellEditor.getCellEditorValue().toString().trim();
        UndoableCellEdit undoableCellEdit = new UndoableCellEdit(this.bookmarksTreeModel, bookmark, string2);
        undoableCellEdit.doEdit();
        if (!string.equals(string2) && !string.equals(Res.getString("DEFAULT_TITLE").trim())) {
            this.undoSupport.postEdit(undoableCellEdit);
        }
    }

    @Override
    public void editingCanceled(ChangeEvent changeEvent) {
    }

    @Override
    public void renderingStart(RenderingStartEvent renderingStartEvent) {
        this.lblStatus.setText("Rendering page " + renderingStartEvent.getPageNumber() + " wait ...");
        this.setCursor(Cursor.getPredefinedCursor(3));
    }

    @Override
    public void textCopied(TextCopiedEvent textCopiedEvent) {
        String string = textCopiedEvent.getText();
        if (string == null) {
            string = "";
        }
        this.lblStatus.setText(Res.getString("EXTRACTED") + ": " + string);
    }

    public void treeNodeMoved(TreeNodeMovedEvent treeNodeMovedEvent) {
        this.recreateNodesOpenedState();
    }

    private JPanel createThumbnailsPanel() {
        return new JPanel();
    }

    private void openLinkedPdf() {
        File file = this.pdfFileChooser();
        if (file != null && file.isFile()) {
            try {
                JPdfBookmarksGui jPdfBookmarksGui = this.alreadyOpenedIn(file.getCanonicalFile());
                if (jPdfBookmarksGui != null) {
                    jPdfBookmarksGui.requestFocus();
                } else {
                    new JPdfBookmarks().launchNewGuiInstance(file.getCanonicalPath(), null);
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private File pdfFileChooser() {
        File file = null;
        JFileChooser jFileChooser = new JFileChooser(this.userPrefs.getLastDirectory());
        FileNameExtensionFilter fileNameExtensionFilter = new FileNameExtensionFilter("Pdf File", "pdf");
        jFileChooser.setFileSelectionMode(0);
        jFileChooser.setFileFilter(fileNameExtensionFilter);
        if (jFileChooser.showOpenDialog(this) == 0) {
            file = jFileChooser.getSelectedFile();
        }
        return file;
    }

    private void openDialog() {
        if (!this.askCloseWithoutSave()) {
            return;
        }
        this.fileOperator.close();
        File file = this.pdfFileChooser();
        if (file != null && file.isFile()) {
            this.openFileAsync(file, null);
        }
    }

    private void setProgressBar(String string) {
        this.lblStatus.setText(string);
        this.busyPanel.add(this.progressBar);
        this.busyPanel.repaint();
    }

    private void removeProgressBar() {
        this.lblStatus.setText(" ");
        this.busyPanel.remove(this.progressBar);
        this.busyPanel.repaint();
    }

    public void openFileAsync(final File file, final Bookmark bookmark) {
        this.setProgressBar(Res.getString("WAIT_LOADING_FILE"));
        CursorToolkit.startWaitCursor(this.tbBold);
        SwingWorker<Bookmark, Void> swingWorker = new SwingWorker<Bookmark, Void>(){

            @Override
            protected Bookmark doInBackground() throws Exception {
                JPdfBookmarksGui.this.fileOperator.open(file);
                Bookmark bookmark2 = JPdfBookmarksGui.this.fileOperator.getRootBookmark();
                return bookmark2;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected void done() {
                Bookmark bookmark2 = null;
                try {
                    bookmark2 = (Bookmark)this.get();
                    JPdfBookmarksGui.this.bookmarksTree.setRootVisible(false);
                    JPdfBookmarksGui.this.bookmarksTree.setEditable(true);
                    if (bookmark2 != null) {
                        JPdfBookmarksGui.this.bookmarksTreeModel.setRoot((TreeNode)bookmark2);
                        JPdfBookmarksGui.this.recreateNodesOpenedState();
                    } else {
                        JPdfBookmarksGui.this.bookmarksTreeModel.setRoot((TreeNode)new Bookmark());
                    }
                    JPdfBookmarksGui.this.bookmarksTree.treeDidChange();
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            if (bookmark != null) {
                                JPdfBookmarksGui.this.followBookmarkInView(bookmark);
                            } else {
                                JPdfBookmarksGui.this.viewPanel.goToFirstPage();
                            }
                        }
                    });
                    JPdfBookmarksGui.this.updateThumbnailsPanel(JPdfBookmarksGui.this.fileOperator.getViewPanel().getThumbnails());
                }
                catch (Exception exception) {
                    JPdfBookmarksGui.this.showErrorMessage(Res.getString("ERROR_OPENING_FILE") + " " + file.getName());
                }
                finally {
                    CursorToolkit.stopWaitCursor(JPdfBookmarksGui.this.tbBold);
                    JPdfBookmarksGui.this.removeProgressBar();
                }
            }
        };
        swingWorker.execute();
    }

    private void updateThumbnailsPanel(JScrollPane jScrollPane) {
        this.leftPanel.updateThumbnails(jScrollPane);
    }

    private void recreateNodesOpenedState() {
        this.bookmarksTree.visitAllNodes((Visitor)new Visitor<Bookmark>(){

            public void process(Bookmark bookmark) {
                TreePath treePath = new TreePath(bookmark.getPath());
                if (bookmark.isOpened() && JPdfBookmarksGui.this.bookmarksTree.isVisible(treePath)) {
                    JPdfBookmarksGui.this.bookmarksTree.expandPath(treePath);
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void undo() {
        try {
            this.undoManager.undo();
            this.fileOperator.setFileChanged(true);
        }
        catch (CannotUndoException cannotUndoException) {
        }
        finally {
            this.updateUndoRedoPresentation();
            this.bookmarksTreeModel.nodeStructureChanged((TreeNode)this.bookmarksTreeModel.getRoot());
            this.recreateNodesOpenedState();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void redo() {
        try {
            this.undoManager.redo();
            this.fileOperator.setFileChanged(true);
        }
        catch (CannotUndoException cannotUndoException) {
        }
        finally {
            this.updateUndoRedoPresentation();
            this.bookmarksTreeModel.nodeStructureChanged((TreeNode)this.bookmarksTreeModel.getRoot());
            this.recreateNodesOpenedState();
        }
    }

    private void adjustInheritValues(Bookmark bookmark) {
        if (this.checkInheritTop.isSelected()) {
            bookmark.setTop(-1);
        }
        if (this.checkInheritLeft.isSelected()) {
            bookmark.setLeft(-1);
        }
        if (this.checkInheritZoom.isSelected()) {
            bookmark.setZoom(0.0f);
        }
    }

    private void addSibling() {
        Bookmark bookmark;
        Bookmark bookmark2 = this.viewPanel.getBookmarkFromView();
        this.adjustInheritValues(bookmark2);
        Bookmark bookmark3 = this.getSelectedBookmark();
        if (bookmark3 == null) {
            bookmark = (Bookmark)this.bookmarksTreeModel.getRoot();
            bookmark.add((MutableTreeNode)bookmark2);
        } else {
            bookmark = (Bookmark)bookmark3.getParent();
            int n = bookmark.getIndex((TreeNode)bookmark3);
            bookmark.insert((MutableTreeNode)bookmark2, n + 1);
        }
        this.bookmarksTreeModel.nodeStructureChanged((TreeNode)bookmark);
        this.recreateNodesOpenedState();
        this.bookmarksTree.startEditingAtPath(new TreePath(bookmark2.getPath()));
        this.fileOperator.setFileChanged(true);
    }

    private void addChild() {
        Bookmark bookmark = this.viewPanel.getBookmarkFromView();
        this.adjustInheritValues(bookmark);
        Bookmark bookmark2 = this.getSelectedBookmark();
        if (bookmark2 != null) {
            bookmark2.add((MutableTreeNode)bookmark);
            this.bookmarksTreeModel.nodeStructureChanged((TreeNode)bookmark2);
            this.recreateNodesOpenedState();
            this.bookmarksTree.startEditingAtPath(new TreePath(bookmark.getPath()));
        }
        this.fileOperator.setFileChanged(true);
    }

    private int askAddOrReplace() {
        int n;
        Object[] objectArray = new Object[]{Res.getString("REPLACE_CURRENT"), Res.getString("ADD_TO_CURRENT"), Res.getString("CANCEL")};
        int n2 = n = JOptionPane.showOptionDialog(this, Res.getString("ADD_TO_CURRENT_OR_REPLACE"), "JPdfBookmarks", 1, 3, null, objectArray, objectArray[0]);
        switch (n) {
            case 0: {
                n2 = 0;
                break;
            }
            case 1: {
                n2 = 1;
                break;
            }
            case 2: {
                n2 = 2;
            }
        }
        return n2;
    }

    private void setDestFromView() {
        int n;
        Bookmark bookmark = this.viewPanel.getBookmarkFromView();
        this.adjustInheritValues(bookmark);
        int n2 = this.askAddOrReplace();
        if (n2 == 2) {
            return;
        }
        boolean bl = false;
        if (this.bookmarksTree.getSelectionPaths().length > 1 && (n = JOptionPane.showConfirmDialog(this, Res.getString("KEEP_PAGE_NUMBERS"), "JPdfBookmarks", 0)) == 0) {
            bl = true;
        }
        UndoableMultiSetDestFromView undoableMultiSetDestFromView = new UndoableMultiSetDestFromView((JTree)((Object)this.bookmarksTree), n2, bookmark, bl);
        undoableMultiSetDestFromView.doEdit();
        this.undoSupport.postEdit(undoableMultiSetDestFromView);
        this.fileOperator.setFileChanged(true);
    }

    private void setLaunchLink() {
        JFileChooser jFileChooser = new JFileChooser();
        jFileChooser.setFileSelectionMode(0);
        jFileChooser.setCurrentDirectory(this.fileOperator.getFile().getParentFile());
        jFileChooser.setDialogTitle(Res.getString("LAUNCH_LINK_DIALOG_TITLE"));
        if (jFileChooser.showSaveDialog(this) != 0) {
            return;
        }
        File file = jFileChooser.getSelectedFile();
        if (file == null) {
            return;
        }
        File file2 = Ut.createRelativePath((File)this.fileOperator.getFile(), (File)file);
        String string = Ut.onWindowsReplaceBackslashWithSlash((String)file2.toString());
        int n = this.askAddOrReplace();
        if (n == 2) {
            return;
        }
        UndoableMultiSetLaunchLink undoableMultiSetLaunchLink = new UndoableMultiSetLaunchLink((JTree)((Object)this.bookmarksTree), n, string);
        undoableMultiSetLaunchLink.doEdit();
        this.undoSupport.postEdit(undoableMultiSetLaunchLink);
        this.fileOperator.setFileChanged(true);
    }

    private void setWebLink() {
        String string = JOptionPane.showInputDialog(this, (Object)(Res.getString("INPUT_WEB_ADDRESS") + ": "));
        if (string == null) {
            return;
        }
        int n = this.askAddOrReplace();
        if (n == 2) {
            return;
        }
        UndoableMultiSetWebLink undoableMultiSetWebLink = new UndoableMultiSetWebLink((JTree)((Object)this.bookmarksTree), n, string);
        undoableMultiSetWebLink.doEdit();
        this.undoSupport.postEdit(undoableMultiSetWebLink);
        this.fileOperator.setFileChanged(true);
        this.goToWebLinkAsking(string);
    }

    private void launchFile(String string) {
        int n = JOptionPane.showConfirmDialog(this, String.format(Res.getString("MSG_LAUNCH_FILE"), string), this.title, 2);
        if (n != 0) {
            return;
        }
        Desktop desktop = Desktop.getDesktop();
        try {
            desktop.open(new File(string).getCanonicalFile().getAbsoluteFile());
        }
        catch (Exception exception) {
            this.showErrorMessage(Res.getString("ERR_LAUNCHING_FILE") + " " + string + ".");
        }
    }

    private void goToWebLinkAsking(String string) {
        int n;
        if (!this.userPrefs.getNeverAskWebAccess() && (n = JOptionPane.showConfirmDialog(this, Res.getString("MSG_LAUNCH_BROWSER"), this.title, 2)) != 0) {
            return;
        }
        this.goToWebLink(string);
    }

    private void goToWebLink(String string) {
        Desktop desktop = Desktop.getDesktop();
        try {
            desktop.browse(new URI(string));
        }
        catch (URISyntaxException uRISyntaxException) {
            this.showErrorMessage(Res.getString("ERROR_WRONG_URI"));
        }
        catch (IOException iOException) {
            this.showErrorMessage(Res.getString("ERROR_LAUNCHING_BROWSER"));
        }
    }

    private void cut() {
        this.copy(true);
        this.delete();
    }

    private void copyBookmarkFromView() {
        Bookmark bookmark = this.viewPanel.getBookmarkFromView();
        if (bookmark != null) {
            ArrayList<Bookmark> arrayList = new ArrayList<Bookmark>();
            arrayList.add(bookmark);
            BookmarkSelection bookmarkSelection = new BookmarkSelection(arrayList, bookmarksFlavor, false, this.fileOperator.getFile());
            localClipboard.setContents((Transferable)bookmarkSelection, (ClipboardOwner)bookmarkSelection);
            this.flavorsChanged();
        }
    }

    private void copy(boolean bl) {
        ArrayList<Bookmark> arrayList = this.getSelectedBookmarks();
        if (arrayList != null && !arrayList.isEmpty()) {
            BookmarkSelection bookmarkSelection = new BookmarkSelection(arrayList, bookmarksFlavor, bl, this.fileOperator.getFile());
            localClipboard.setContents((Transferable)bookmarkSelection, (ClipboardOwner)bookmarkSelection);
            this.flavorsChanged();
        }
    }

    private void paste() {
        Transferable transferable = localClipboard.getContents(this);
        if (transferable != null && transferable.isDataFlavorSupported(bookmarksFlavor)) {
            try {
                Bookmark bookmark;
                Object object2;
                Serializable serializable;
                BookmarkSelection bookmarkSelection = (BookmarkSelection)transferable.getTransferData(bookmarksFlavor);
                ArrayList arrayList = bookmarkSelection.getBookmarks();
                if (!this.fileOperator.getFile().equals(bookmarkSelection.getFile())) {
                    serializable = Ut.createRelativePath((File)this.fileOperator.getFile(), (File)bookmarkSelection.getFile());
                    for (Object object2 : arrayList) {
                        object2.setRemoteFilePathWithChildren((File)serializable);
                    }
                }
                if ((serializable = this.bookmarksTree.getSelectionPath()) != null) {
                    object2 = (Bookmark)((TreePath)serializable).getLastPathComponent();
                    bookmark = (Bookmark)object2.getParent();
                    int n = bookmark.getIndex((TreeNode)object2);
                    for (Bookmark bookmark2 : arrayList) {
                        bookmark.insert((MutableTreeNode)bookmark2, n + 1);
                        ++n;
                    }
                } else {
                    bookmark = (Bookmark)this.bookmarksTreeModel.getRoot();
                    for (Bookmark bookmark3 : arrayList) {
                        bookmark.add((MutableTreeNode)bookmark3);
                    }
                }
                object2 = new UndoablePasteBookmarks(this.bookmarksTreeModel, arrayList);
                ((UndoablePasteBookmarks)object2).doEdit();
                this.undoSupport.postEdit((UndoableEdit)object2);
                this.fileOperator.setFileChanged(true);
                this.bookmarksTreeModel.nodeStructureChanged((TreeNode)bookmark);
                this.recreateNodesOpenedState();
            }
            catch (UnsupportedFlavorException unsupportedFlavorException) {
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private ArrayList<Bookmark> getSelectedBookmarks() {
        TreePath[] treePathArray;
        ArrayList<Bookmark> arrayList = new ArrayList<Bookmark>();
        for (TreePath treePath : treePathArray = this.bookmarksTree.getSelectionPaths()) {
            arrayList.add((Bookmark)treePath.getLastPathComponent());
        }
        return arrayList;
    }

    private void delete() {
        UndoableDeleteBookmark undoableDeleteBookmark = new UndoableDeleteBookmark(this.bookmarksTreeModel, this.getSelectedBookmarks());
        undoableDeleteBookmark.doEdit();
        this.recreateNodesOpenedState();
        this.undoSupport.postEdit(undoableDeleteBookmark);
    }

    private void setBold(boolean bl) {
        TreePath[] treePathArray;
        for (TreePath treePath : treePathArray = this.bookmarksTree.getSelectionPaths()) {
            Bookmark bookmark = (Bookmark)treePath.getLastPathComponent();
            bookmark.setBold(bl);
        }
        this.bookmarksTree.updateTree(new MouseListener[]{this.mouseAdapter});
        this.valueChanged(null);
        this.fileOperator.setFileChanged(true);
    }

    private void setItalic(boolean bl) {
        TreePath[] treePathArray;
        for (TreePath treePath : treePathArray = this.bookmarksTree.getSelectionPaths()) {
            Bookmark bookmark = (Bookmark)treePath.getLastPathComponent();
            bookmark.setItalic(bl);
        }
        this.bookmarksTree.updateTree(new MouseListener[]{this.mouseAdapter});
        this.valueChanged(null);
        this.fileOperator.setFileChanged(true);
    }

    private void changeColor() {
        this.colorChooser = new JColorChooser();
        ColorsListPanel colorsListPanel = new ColorsListPanel();
        colorsListPanel.setName(Res.getString("BROWSERS_KNOWN_COLORS"));
        this.colorChooser.addChooserPanel((AbstractColorChooserPanel)colorsListPanel);
        this.colorChooser.setColor(this.getSelectedBookmark().getColor());
        JColorChooser.createDialog(this, Res.getString("ACTION_CHANGE_COLOR"), true, this.colorChooser, new ColorChooserListener(), null).setVisible(true);
        this.fileOperator.setFileChanged(true);
    }

    private void rename() {
        if (this.bookmarksTree.getSelectionCount() > 1) {
            String string = (String)JOptionPane.showInputDialog((Component)((Object)this.bookmarksTree), Res.getString("INSERT_NEW_TITLE"), "JPdfBookmarks", -1, null, null, this.getSelectedBookmark().getTitle());
            if (string != null && string.length() > 0) {
                UndoableRenameAction undoableRenameAction = new UndoableRenameAction((JTree)((Object)this.bookmarksTree), string);
                undoableRenameAction.doEdit();
                this.bookmarksTreeModel.nodeStructureChanged((TreeNode)this.bookmarksTreeModel.getRoot());
                this.recreateNodesOpenedState();
                this.undoSupport.postEdit(undoableRenameAction);
            }
        } else {
            this.bookmarksTree.startEditingAtPath(this.bookmarksTree.getSelectionPath());
        }
    }

    public void showErrorMessage(String string) {
        JOptionPane.showMessageDialog(this, string, this.title, 0);
    }

    private void saveAsync() {
        this.setProgressBar(Res.getString("WAIT_SAVING_FILE"));
        CursorToolkit.startWaitCursor(this.tbBold);
        new AsyncSaveAs(this.fileOperator.getFile(), this.viewPanel.getBookmarkFromView()).execute();
    }

    private void saveAsAsync() {
        int n;
        JFileChooser jFileChooser = new JFileChooser();
        jFileChooser.setFileSelectionMode(0);
        jFileChooser.setFileFilter((FileFilter)new SimpleFileFilter("pdf", "PDF File"));
        jFileChooser.setCurrentDirectory(this.fileOperator.getFile().getParentFile());
        if (jFileChooser.showSaveDialog(this) != 0) {
            return;
        }
        File file = jFileChooser.getSelectedFile();
        if (file == null) {
            return;
        }
        String string = file.getAbsolutePath();
        if (!string.endsWith(".pdf")) {
            string = string + ".pdf";
            file = new File(string);
        }
        if (file.exists() && (n = JOptionPane.showConfirmDialog(this, Res.getString("WARNING_OVERWRITE"), this.title, 0, 2)) != 0) {
            return;
        }
        this.setProgressBar(Res.getString("WAIT_SAVING_FILE"));
        CursorToolkit.startWaitCursor(this.tbBold);
        new AsyncSaveAs(file, this.viewPanel.getBookmarkFromView()).execute();
    }

    private void close() {
        if (!this.askCloseWithoutSave()) {
            return;
        }
        this.fileOperator.close();
    }

    private void load() {
        JFileChooser jFileChooser = new JFileChooser();
        jFileChooser.setFileSelectionMode(0);
        jFileChooser.setFileFilter((FileFilter)new SimpleFileFilter("txt", "Text Files"));
        jFileChooser.setCurrentDirectory(this.fileOperator.getFile().getParentFile());
        jFileChooser.setDialogTitle(Res.getString("LOAD_DIALOG_TITLE"));
        if (jFileChooser.showOpenDialog(this) != 0) {
            return;
        }
        File file = jFileChooser.getSelectedFile();
        if (file == null || !file.isFile()) {
            return;
        }
        try {
            IBookmarksConverter iBookmarksConverter = Bookmark.getBookmarksConverter();
            if (iBookmarksConverter == null) {
                this.showErrorMessage(Res.getString("ERROR_BOOKMARKS_CONVERTER_NOT_FOUND"));
                throw new Exception();
            }
            iBookmarksConverter.open(this.fileOperator.getFilePath(), this.fileOperator.getPassword());
            Bookmark bookmark = Bookmark.outlineFromFile((IBookmarksConverter)iBookmarksConverter, (String)file.getAbsolutePath(), (String)this.userPrefs.getIndentationString(), (String)this.userPrefs.getPageSeparator(), (String)this.userPrefs.getAttributesSeparator(), (String)this.userPrefs.getCharsetEncoding());
            iBookmarksConverter.close();
            UndoableLoadBookmarks undoableLoadBookmarks = new UndoableLoadBookmarks(this.bookmarksTreeModel, this.bookmarksTree, bookmark);
            undoableLoadBookmarks.doEdit();
            this.undoSupport.postEdit(undoableLoadBookmarks);
            this.fileOperator.setFileChanged(true);
            this.recreateNodesOpenedState();
        }
        catch (Exception exception) {
            System.out.println(exception.getMessage());
            this.showErrorMessage(Res.getString("ERROR_LOADING_TEXT_FILE"));
        }
    }

    private JPanel newVersionAvailable(boolean bl) {
        JPanel jPanel = new JPanel(new FlowLayout());
        if (bl) {
            jPanel.add(new JLabel(Res.getString("NEW_VERSION_AVAILABLE")));
            try {
                LinkLabel linkLabel = new LinkLabel(new URI("http://flavianopetrocchi.blogspot.com/2008/07/jpsdbookmarks-download-page.html"), " " + Res.getString("DOWNLOAD_PAGE"));
                linkLabel.setUnderlineVisible(false);
                linkLabel.setBorder(null);
                linkLabel.init();
                jPanel.add((Component)linkLabel);
            }
            catch (URISyntaxException uRISyntaxException) {
                this.showErrorMessage(Res.getString("ERROR_CHECKING_UPDATES"));
            }
        } else {
            jPanel.add(new JLabel(Res.getString("NO_NEW_VERSION_AVAILABLE")));
        }
        return jPanel;
    }

    private void checkUpdates(boolean bl) {
        LastVersionWebChecker lastVersionWebChecker = new LastVersionWebChecker(bl);
        lastVersionWebChecker.execute();
    }

    private void dump() {
        int n;
        JFileChooser jFileChooser = new JFileChooser();
        jFileChooser.setFileSelectionMode(0);
        jFileChooser.setFileFilter((FileFilter)new SimpleFileFilter("txt", "Text Files"));
        jFileChooser.setCurrentDirectory(this.fileOperator.getFile().getParentFile());
        jFileChooser.setDialogTitle(Res.getString("DUMP_DIALOG_TITLE"));
        if (jFileChooser.showSaveDialog(this) != 0) {
            return;
        }
        File file = jFileChooser.getSelectedFile();
        if (file == null) {
            return;
        }
        String string = file.getName();
        if (!string.endsWith(".txt")) {
            string = file.getParent() + File.separatorChar + string + ".txt";
            file = new File(string);
        }
        if (file.exists() && (n = JOptionPane.showConfirmDialog(this, Res.getString("WARNING_OVERWRITE"), this.title, 0, 2)) != 0) {
            return;
        }
        Dumper dumper = new Dumper(null, this.userPrefs.getIndentationString(), this.userPrefs.getPageSeparator(), this.userPrefs.getAttributesSeparator());
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)fileOutputStream, this.userPrefs.getCharsetEncoding());
            dumper.printBookmarksIterative(outputStreamWriter, (Bookmark)this.bookmarksTreeModel.getRoot());
            outputStreamWriter.close();
            Desktop desktop = Desktop.getDesktop();
            try {
                desktop.open(file);
            }
            catch (Exception exception) {
                this.showErrorMessage(Res.getString("ERR_LAUNCHING_FILE") + " " + file + ".");
            }
        }
        catch (Exception exception) {
            JOptionPane.showMessageDialog(this, Res.getString("ERROR_SAVING_FILE"), this.title, 2);
            return;
        }
    }

    private void applyPageOffsetDialog() {
        Bookmark bookmark = this.bookmarksTree.getSelectionPaths();
        int n = -1;
        int n2 = this.viewPanel.getNumPages();
        for (TreePath treePath : bookmark) {
            Bookmark bookmark2 = (Bookmark)treePath.getLastPathComponent();
            int n3 = bookmark2.getPageNumber();
            if (n3 > n) {
                n = n3;
            }
            if (n3 >= n2) continue;
            n2 = n3;
        }
        Bookmark bookmark3 = this.getSelectedBookmark();
        PageOffsetDialog pageOffsetDialog = new PageOffsetDialog((Frame)this, this.viewPanel.getCurrentPage() - bookmark3.getPageNumber(), this.viewPanel.getNumPages() - n, -n2 + 1);
        pageOffsetDialog.setVisible(true);
        if (pageOffsetDialog.operationNotAborted()) {
            UnboablePageOffset unboablePageOffset = new UnboablePageOffset(this.bookmarksTreeModel, (TreePath[])bookmark, pageOffsetDialog.getOffsetValue());
            unboablePageOffset.doEdit();
            this.recreateNodesOpenedState();
            this.undoSupport.postEdit(unboablePageOffset);
        }
    }

    private void goToPageDialog() {
        GoToPageDialog goToPageDialog = new GoToPageDialog((Frame)this, this.viewPanel.getCurrentPage(), this.viewPanel.getNumPages());
        goToPageDialog.setVisible(true);
        if (goToPageDialog.operationNotAborted()) {
            this.viewPanel.goToPage(goToPageDialog.getPage());
        }
    }

    private void createActions() {
        this.extractLinks = new ActionBuilder("ACTION_EXTRACT_LINKS", "ACTION_EXTRACT_LINKS_DESCR", null, "extract-links.png", false){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JPdfBookmarksGui.this.extractLinksFromPage();
            }
        };
        this.cutAction = new ActionBuilder("ACTION_CUT", "ACTION_CUT_DESCR", "ctrl X", "edit-cut.png", false){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JPdfBookmarksGui.this.cut();
            }
        };
        this.copyAction = new ActionBuilder("ACTION_COPY", "ACTION_COPY_DESCR", "ctrl C", "edit-copy.png", false){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JPdfBookmarksGui.this.copy(false);
            }
        };
        this.copyBookmarkFromViewAction = new ActionBuilder("ACTION_COPY_BOOKMARK_FROM_VIEW", "ACTION_COPY_BOOKMARK_FROM_VIEW_DESCR", "ctrl shift c", "copy-linked.png", false){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JPdfBookmarksGui.this.copyBookmarkFromView();
            }
        };
        this.pasteAction = new ActionBuilder("ACTION_PASTE", "ACTION_PASTE_DESCR", "ctrl V", "edit-paste.png", false){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JPdfBookmarksGui.this.paste();
            }
        };
        this.quitAction = new ActionBuilder("ACTION_QUIT", "ACTION_QUIT_DESCR", "alt F4", "system-log-out.png", true){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JPdfBookmarksGui.this.exitApplication();
            }
        };
        this.openAction = new ActionBuilder("ACTION_OPEN", "ACTION_OPEN_DESCR", "ctrl O", "document-open.png", true){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JPdfBookmarksGui.this.openDialog();
            }
        };
        this.openLinkedPdf = new ActionBuilder("ACTION_OPEN_LINKED_PDF", "ACTION_OPEN_LINKED_PDF_DESCR", "ctrl alt O", "open-linked-pdf.png", false){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JPdfBookmarksGui.this.openLinkedPdf();
            }
        };
        this.saveAction = new ActionBuilder("ACTION_SAVE", "ACTION_SAVE_DESCR", "ctrl S", "document-save.png", false){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JPdfBookmarksGui.this.saveAsync();
            }
        };
        this.saveAsAction = new ActionBuilder("ACTION_SAVE_AS", "ACTION_SAVE_AS_DESCR", "ctrl A", "document-save-as.png", false){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JPdfBookmarksGui.this.saveAsAsync();
            }
        };
        this.closeAction = new ActionBuilder("ACTION_CLOSE", "ACTION_CLOSE_DESCR", "ctrl F4", "process-stop.png", false){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JPdfBookmarksGui.this.close();
            }
        };
        this.showOnOpenAction = new ActionBuilder("ACTION_SHOW_ON_OPEN", "ACTION_SHOW_ON_OPEN_DESCR", null, "show-on-open.png", false){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (actionEvent.getSource().equals(JPdfBookmarksGui.this.tbShowOnOpen)) {
                    JPdfBookmarksGui.this.cbShowOnOpen.setSelected(JPdfBookmarksGui.this.tbShowOnOpen.isSelected());
                    JPdfBookmarksGui.this.fileOperator.setShowBookmarksOnOpen(JPdfBookmarksGui.this.tbShowOnOpen.isSelected());
                } else {
                    JPdfBookmarksGui.this.tbShowOnOpen.setSelected(JPdfBookmarksGui.this.cbShowOnOpen.isSelected());
                    JPdfBookmarksGui.this.fileOperator.setShowBookmarksOnOpen(JPdfBookmarksGui.this.cbShowOnOpen.isSelected());
                }
            }
        };
        this.dumpAction = new ActionBuilder("ACTION_DUMP", "ACTION_DUMP_DESCR", "ctrl alt D", "dump.png", false){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JPdfBookmarksGui.this.dump();
            }
        };
        this.loadAction = new ActionBuilder("ACTION_LOAD", "ACTION_LOAD_DESCR", "ctrl alt L", "load.png", false){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JPdfBookmarksGui.this.load();
            }
        };
        this.undoAction = new ActionBuilder("ACTION_UNDO", "ACTION_UNDO_DESCR", "ctrl Z", "edit-undo.png", false){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JPdfBookmarksGui.this.undo();
            }
        };
        this.redoAction = new ActionBuilder("ACTION_REDO", "ACTION_REDO_DESCR", "ctrl shift Z", "edit-redo.png", false){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JPdfBookmarksGui.this.redo();
            }
        };
        this.addSiblingAction = new ActionBuilder("ACTION_ADD_SIBLING", "ACTION_ADD_SIBLING_DESCR", "ctrl alt S", "add-sibling.png", false){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JPdfBookmarksGui.this.addSibling();
            }
        };
        this.addChildAction = new ActionBuilder("ACTION_ADD_CHILD", "ACTION_ADD_CHILD_DESCR", "ctrl alt F", "add-child.png", false){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JPdfBookmarksGui.this.addChild();
            }
        };
        this.addWebLinkAction = new ActionBuilder("ACTION_ADD_WEB_LINK", "ACTION_ADD_WEB_LINK_DESCR", "ctrl alt W", "bookmark-web.png", false){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JPdfBookmarksGui.this.setWebLink();
            }
        };
        this.addLaunchLinkAction = new ActionBuilder("ACTION_ADD_LAUNCH_LINK", "ACTION_ADD_LAUNCH_LINK_DESCR", "ctrl alt H", "bookmark-launch.png", false){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JPdfBookmarksGui.this.setLaunchLink();
            }
        };
        this.deleteAction = new ActionBuilder("ACTION_DELETE", "ACTION_DELETE_DESCR", "ctrl DELETE", "user-trash.png", false){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JPdfBookmarksGui.this.delete();
            }
        };
        this.setBoldAction = new ActionBuilder("ACTION_SET_BOLD", "ACTION_SET_BOLD_DESCR", "ctrl G", "format-text-bold.png", false){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                AbstractButton abstractButton = (AbstractButton)actionEvent.getSource();
                JPdfBookmarksGui.this.setBold(abstractButton.isSelected());
            }
        };
        this.setItalicAction = new ActionBuilder("ACTION_SET_ITALIC", "ACTION_SET_ITALIC_DESCR", "ctrl I", "format-text-italic.png", false){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                AbstractButton abstractButton = (AbstractButton)actionEvent.getSource();
                JPdfBookmarksGui.this.setItalic(abstractButton.isSelected());
            }
        };
        this.changeColorAction = new ActionBuilder("ACTION_CHANGE_COLOR", "ACTION_CHANGE_COLOR_DESCR", null, "applications-graphics.png", false){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JPdfBookmarksGui.this.changeColor();
            }
        };
        this.renameAction = new ActionBuilder("ACTION_RENAME", "ACTION_RENAME_DESCR", "ctrl F2", "edit-select-all.png", false){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JPdfBookmarksGui.this.rename();
            }
        };
        this.setDestFromViewAction = new ActionBuilder("ACTION_DEST_FROM_VIEW", "ACTION_DEST_FROM_VIEW_DESCR", "ctrl alt A", "dest-from-view.png", false){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JPdfBookmarksGui.this.setDestFromView();
            }
        };
        this.applyPageOffset = new ActionBuilder("ACTION_PAGE_OFFSET", "ACTION_PAGE_OFFSET_DESCR", null, "page-offset.png", false){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JPdfBookmarksGui.this.applyPageOffsetDialog();
            }
        };
        this.selectText = new ActionBuilder("ACTION_SELECT_TEXT", "ACTION_SELECT_TEXT_DESCR", "ctrl alt T", "select-text.png", false){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (actionEvent.getSource().equals(JPdfBookmarksGui.this.tbSelectText)) {
                    JPdfBookmarksGui.this.cbSelectText.setSelected(JPdfBookmarksGui.this.tbSelectText.isSelected());
                } else {
                    JPdfBookmarksGui.this.tbSelectText.setSelected(JPdfBookmarksGui.this.cbSelectText.isSelected());
                }
                JPdfBookmarksGui.this.viewPanel.setTextSelectionMode(JPdfBookmarksGui.this.tbSelectText.isSelected());
            }
        };
        this.connectToClipboard = new ActionBuilder("ACTION_CONNECT_CLIPBOARD", "ACTION_CONNECT_CLIPBOARD_DESCR", "ctrl alt C", "system-clip.png", false){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (actionEvent.getSource().equals(JPdfBookmarksGui.this.tbConnectToClipboard)) {
                    JPdfBookmarksGui.this.cbConnectToClipboard.setSelected(JPdfBookmarksGui.this.tbConnectToClipboard.isSelected());
                } else {
                    JPdfBookmarksGui.this.tbConnectToClipboard.setSelected(JPdfBookmarksGui.this.cbConnectToClipboard.isSelected());
                }
                JPdfBookmarksGui.this.viewPanel.setConnectToClipboard(JPdfBookmarksGui.this.tbConnectToClipboard.isSelected());
            }
        };
        this.goNextPageAction = new ActionBuilder("ACTION_GO_NEXT", "ACTION_GO_NEXT_DESCR", "ctrl alt RIGHT", "go-next.png", false){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JPdfBookmarksGui.this.viewPanel.goToNextPage();
            }
        };
        this.goFirstPageAction = new ActionBuilder("ACTION_GO_FIRST", "ACTION_GO_FIRST_DESCR", "ctrl alt HOME", "go-first.png", false){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JPdfBookmarksGui.this.viewPanel.goToFirstPage();
            }
        };
        this.goLastPageAction = new ActionBuilder("ACTION_GO_LAST", "ACTION_GO_LAST_DESCR", "ctrl alt END", "go-last.png", false){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JPdfBookmarksGui.this.viewPanel.goToLastPage();
            }
        };
        this.goPreviousPageAction = new ActionBuilder("ACTION_GO_PREV", "ACTION_GO_PREV_DESCR", "ctrl alt LEFT", "go-previous.png", false){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JPdfBookmarksGui.this.viewPanel.goToPreviousPage();
            }
        };
        this.goToPageAction = new ActionBuilder("ACTION_GO_PAGE", "ACTION_GO_PAGE_DESCR", "ctrl alt INSERT", null, false){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JPdfBookmarksGui.this.goToPageDialog();
            }
        };
        this.fitRectAction = new ActionBuilder("ACTION_FIT_RECT", "ACTION_FIT_RECT_DESCR", "ctrl R", "fit-rect.png", false){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (actionEvent.getSource() instanceof JToggleButton) {
                    JPdfBookmarksGui.this.rbFitRect.setSelected(true);
                } else {
                    JPdfBookmarksGui.this.tbFitRect.setSelected(true);
                }
                JPdfBookmarksGui.this.viewPanel.setFitRect(null);
            }
        };
        this.fitWidthAction = new ActionBuilder("ACTION_FIT_WIDTH", "ACTION_FIT_WIDTH_DESCR", "ctrl W", "fit-width.png", false){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (actionEvent.getSource() instanceof JToggleButton) {
                    JPdfBookmarksGui.this.rbFitWidth.setSelected(true);
                } else {
                    JPdfBookmarksGui.this.tbFitWidth.setSelected(true);
                }
                JPdfBookmarksGui.this.viewPanel.setFitWidth(-1);
            }
        };
        this.fitHeightAction = new ActionBuilder("ACTION_FIT_HEIGHT", "ACTION_FIT_HEIGHT_DESCR", "ctrl H", "fit-height.png", false){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (actionEvent.getSource() instanceof JToggleButton) {
                    JPdfBookmarksGui.this.rbFitHeight.setSelected(true);
                } else {
                    JPdfBookmarksGui.this.tbFitHeight.setSelected(true);
                }
                JPdfBookmarksGui.this.viewPanel.setFitHeight(-1);
            }
        };
        this.fitNativeAction = new ActionBuilder("ACTION_FIT_NATIVE", "ACTION_FIT_NATIVE_DESCR", "ctrl N", "fit-native.png", false){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (actionEvent.getSource() instanceof JToggleButton) {
                    JPdfBookmarksGui.this.rbFitNative.setSelected(true);
                } else {
                    JPdfBookmarksGui.this.tbFitNative.setSelected(true);
                }
                JPdfBookmarksGui.this.viewPanel.setFitNative();
            }
        };
        this.fitPageAction = new ActionBuilder("ACTION_FIT_PAGE", "ACTION_FIT_PAGE_DESCR", "ctrl G", "fit-page.png", false){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (actionEvent.getSource() instanceof JToggleButton) {
                    JPdfBookmarksGui.this.rbFitPage.setSelected(true);
                } else {
                    JPdfBookmarksGui.this.tbFitPage.setSelected(true);
                }
                JPdfBookmarksGui.this.viewPanel.setFitPage();
            }
        };
        this.topLeftZoomAction = new ActionBuilder("ACTION_TOP_LEFT_ZOOM", "ACTION_TOP_LEFT_ZOOM_DESCR", null, "top-left-zoom.png", false){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (actionEvent.getSource() instanceof JToggleButton) {
                    JPdfBookmarksGui.this.rbTopLeftZoom.setSelected(true);
                } else {
                    JPdfBookmarksGui.this.tbTopLeftZoom.setSelected(true);
                }
                JPdfBookmarksGui.this.viewPanel.setTopLeftZoom(-1, -1, 0.0f);
            }
        };
        this.zoomInAction = new ActionBuilder("ACTION_ZOOM_IN", "ACTION_ZOOM_IN_DESCR", "alt +", "zoom-in.png", false){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                float f = (float)(JPdfBookmarksGui.this.txtZoom.getInteger() + 10) / 100.0f;
                JPdfBookmarksGui.this.viewPanel.setTopLeftZoom(-1, -1, f);
            }
        };
        this.zoomOutAction = new ActionBuilder("ACTION_ZOOM_OUT", "ACTION_ZOOM_OUT_DESCR", "alt -", "zoom-out.png", false){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                float f = (float)(JPdfBookmarksGui.this.txtZoom.getInteger() - 10) / 100.0f;
                JPdfBookmarksGui.this.viewPanel.setTopLeftZoom(-1, -1, f);
            }
        };
        this.expandAllAction = new ActionBuilder("ACTION_EXPAND_ALL", "ACTION_EXPAND_ALL_DESCR", "ctrl E", null, false){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JPdfBookmarksGui.this.expandAllNodes();
            }
        };
        this.collapseAllAction = new ActionBuilder("ACTION_COLLAPSE_ALL", "ACTION_COLLAPSE_ALL_DESCR", "ctrl P", null, false){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JPdfBookmarksGui.this.collapseAllNodes();
            }
        };
        this.optionsDialogAction = new ActionBuilder("ACTION_OPTIONS_DIALOG", "ACTION_OPTIONS_DIALOG_DESCR", "ctrl alt O", "preferences-system.png", true){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                OptionsDlg optionsDlg = new OptionsDlg((Frame)JPdfBookmarksGui.this, true);
                optionsDlg.setLocationRelativeTo(JPdfBookmarksGui.this);
                optionsDlg.setVisible(true);
            }
        };
        this.showActionsDialog = new ActionBuilder("ACTION_ACTIONS_DIALOG", "ACTION_ACTIONS_DIALOG_DESCR", "ctrl alt N", "actions-dialog.png", false){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ActionsDialog actionsDialog = new ActionsDialog((Frame)JPdfBookmarksGui.this, true, JPdfBookmarksGui.this.getSelectedBookmark());
                actionsDialog.setLocationRelativeTo(JPdfBookmarksGui.this);
                actionsDialog.setVisible(true);
                JPdfBookmarksGui.this.fileOperator.setFileChanged(actionsDialog.isBookmarkModified());
            }
        };
        this.checkUpdatesAction = new ActionBuilder("ACTION_CHECK_UPDATES", "ACTION_CHECK_UPDATES_DESCR", null, "system-software-update.png", true){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JPdfBookmarksGui.this.checkUpdates(false);
            }
        };
        this.readOnlineManualAction = new ActionBuilder("ACTION_READ_MANUAL", "ACTION_READ_MANUAL_DESCR", null, "help-browser.png", true){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JPdfBookmarksGui.this.goToWebLink("http://sourceforge.net/apps/mediawiki/jpdfbookmarks/");
            }
        };
        this.donateToProject = new ActionBuilder("ACTION_DONATE", "ACTION_DONATE_DESCR", null, "donate-icon.png", true){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JPdfBookmarksGui.this.goToWebLink("http://sourceforge.net/donate/index.php?group_id=297580");
            }
        };
        this.goToAuthorBlog = new ActionBuilder("ACTION_GO_TO_BLOG", "ACTION_GO_TO_BLOG_DESCR", null, "internet-web-browser.png", true){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JPdfBookmarksGui.this.goToWebLink("http://flavianopetrocchi.blogspot.com");
            }
        };
    }

    private void extractLinksFromPage() {
        ArrayList<Bookmark> arrayList = this.fileOperator.getLinksOnPage(this.viewPanel.getCurrentPage());
        if (arrayList.isEmpty()) {
            JOptionPane.showMessageDialog(this, Res.getString("NO_LINKS_FOUND"), "JPdfBookmarks", 1);
            return;
        }
        Bookmark bookmark = null;
        for (Bookmark bookmark2 : arrayList) {
            Bookmark bookmark3 = this.getSelectedBookmark();
            if (bookmark3 == null) {
                bookmark = (Bookmark)this.bookmarksTreeModel.getRoot();
                bookmark.add((MutableTreeNode)bookmark2);
                continue;
            }
            bookmark = (Bookmark)bookmark3.getParent();
            int n = bookmark.getIndex((TreeNode)bookmark3);
            bookmark.insert((MutableTreeNode)bookmark2, n + 1);
        }
        UndoablePasteBookmarks undoablePasteBookmarks = new UndoablePasteBookmarks(this.bookmarksTreeModel, arrayList);
        undoablePasteBookmarks.doEdit();
        this.undoSupport.postEdit(undoablePasteBookmarks);
        this.fileOperator.setFileChanged(true);
        this.bookmarksTreeModel.nodeStructureChanged((TreeNode)this.bookmarksTreeModel.getRoot());
        this.recreateNodesOpenedState();
        this.fileOperator.setFileChanged(true);
    }

    private void expandAllNodes() {
        for (int i = 0; i < this.bookmarksTree.getRowCount(); ++i) {
            this.bookmarksTree.expandRow(i);
        }
    }

    private void collapseAllNodes() {
        this.expandAllNodes();
        Bookmark bookmark = (Bookmark)this.bookmarksTreeModel.getRoot();
        if (bookmark != null) {
            Enumeration enumeration = bookmark.postorderEnumeration();
            if (enumeration.hasMoreElements()) {
                enumeration.nextElement();
            }
            while (enumeration.hasMoreElements()) {
                Bookmark bookmark2 = (Bookmark)enumeration.nextElement();
                TreePath treePath = new TreePath(bookmark2.getPath());
                this.bookmarksTree.collapseRow(this.bookmarksTree.getRowForPath(treePath));
            }
        }
    }

    private void updateStyleButtons(Bookmark bookmark) {
        this.cbBold.setSelected(bookmark.isBold());
        this.cbEditMenuBold.setSelected(bookmark.isBold());
        this.tbBold.setSelected(bookmark.isBold());
        this.cbItalic.setSelected(bookmark.isItalic());
        this.cbEditMenuItalic.setSelected(bookmark.isItalic());
        this.tbItalic.setSelected(bookmark.isItalic());
    }

    private void updateUndoRedoPresentation() {
        UndoableEdit[] undoableEditArray;
        this.undoAction.setEnabled(this.undoManager.canUndo());
        this.redoAction.setEnabled(this.undoManager.canRedo());
        String string = "";
        String string2 = "";
        UndoableEdit[] undoableEditArray2 = this.undoManager.getUndoableEdits();
        if (undoableEditArray2.length > 0) {
            undoableEditArray = undoableEditArray2[0];
            string2 = this.getUndoablePresentation((UndoableEdit)undoableEditArray);
        }
        this.undoAction.putValue("Name", Res.getString("ACTION_UNDO") + " " + string2);
        undoableEditArray = this.undoManager.getRedoableEdits();
        if (undoableEditArray.length > 0) {
            UndoableEdit undoableEdit = undoableEditArray[0];
            string = this.getUndoablePresentation(undoableEdit);
        }
        this.redoAction.putValue("Name", Res.getString("ACTION_REDO") + " " + string);
    }

    private String getUndoablePresentation(UndoableEdit undoableEdit) {
        String string = "";
        if (undoableEdit instanceof UndoableNodeMoved) {
            string = Res.getString("MOVE_EDIT");
        } else if (undoableEdit instanceof UndoableCellEdit) {
            string = Res.getString("CELL_EDIT");
        } else if (undoableEdit instanceof UndoableDeleteBookmark) {
            string = Res.getString("ACTION_DELETE");
        } else if (undoableEdit instanceof UndoableSetDestination) {
            string = Res.getString("ACTION_DEST_FROM_VIEW");
        } else if (undoableEdit instanceof UnboablePageOffset) {
            string = Res.getString("UNDOABLE_OFFSET");
        } else if (undoableEdit instanceof UndoableLoadBookmarks) {
            string = Res.getString("UNDOABLE_LOAD_BOOKMARKS");
        }
        return string;
    }

    private void createRecentFilesItems() {
        String[] stringArray;
        this.openRecent.removeAll();
        for (String string : stringArray = this.userPrefs.getRecentFiles()) {
            File file;
            if (string.equals("") || !(file = new File(string)).exists()) continue;
            JMenuItem jMenuItem = new JMenuItem(file.getName());
            jMenuItem.setToolTipText(file.getAbsolutePath());
            jMenuItem.addActionListener(new RecentFileListener(file));
            this.openRecent.add(jMenuItem);
        }
    }

    private JMenuBar createMenus() {
        JMenuBar jMenuBar = new JMenuBar();
        JMenu jMenu = new JMenu(Res.getString("MENU_FILE"));
        jMenu.setMnemonic(Res.mnemonicFromRes("MENU_FILE_MNEMONIC"));
        JMenuItem jMenuItem = jMenu.add(this.openAction);
        jMenuItem.setMnemonic(Res.mnemonicFromRes("MENU_OPEN_MNEMONIC"));
        jMenuItem = jMenu.add(this.openLinkedPdf);
        jMenuItem.setMnemonic(Res.mnemonicFromRes("MENU_OPEN_LINKED_PDF_MENMONIC"));
        this.openRecent = new JMenu(Res.getString("MENU_OPEN_RECENT"));
        this.openRecent.setMnemonic(Res.mnemonicFromRes("MENU_OPEN_RECENT_MNEMONIC"));
        this.createRecentFilesItems();
        jMenu.add(this.openRecent);
        jMenuItem = jMenu.add(this.saveAction);
        jMenuItem.setMnemonic(Res.mnemonicFromRes("MENU_SAVE_MNEMONIC"));
        jMenuItem = jMenu.add(this.saveAsAction);
        jMenuItem.setMnemonic(Res.mnemonicFromRes("MENU_SAVE_AS_MNEMONIC"));
        jMenuItem = jMenu.add(this.closeAction);
        jMenuItem.setMnemonic(Res.mnemonicFromRes("MENU_CLOSE_MNEMONIC"));
        jMenu.addSeparator();
        jMenuItem = jMenu.add(this.quitAction);
        jMenuItem.setMnemonic(Res.mnemonicFromRes("MENU_QUIT_MNEMONIC"));
        jMenuBar.add(jMenu);
        JMenu jMenu2 = new JMenu(Res.getString("MENU_EDIT"));
        jMenu2.setMnemonic(Res.mnemonicFromRes("MENU_EDIT_MNEMONIC"));
        jMenuItem = jMenu2.add(this.undoAction);
        jMenuItem.setMnemonic(Res.mnemonicFromRes("MENU_UNDO_MNEMONIC"));
        jMenuItem = jMenu2.add(this.redoAction);
        jMenuItem.setMnemonic(Res.mnemonicFromRes("MENU_REDO_MNEMONIC"));
        jMenu2.addSeparator();
        jMenu2.add(this.cutAction);
        jMenu2.add(this.copyAction);
        jMenu2.add(this.pasteAction);
        jMenu2.add(this.copyBookmarkFromViewAction);
        jMenu2.addSeparator();
        jMenuItem = jMenu2.add(this.addSiblingAction);
        jMenuItem.setMnemonic(Res.mnemonicFromRes("MENU_ADD_SIBLING_MNEMONIC"));
        jMenuItem = jMenu2.add(this.addChildAction);
        jMenuItem.setMnemonic(Res.mnemonicFromRes("MENU_ADD_CHILD_MNEMONIC"));
        jMenu2.addSeparator();
        jMenuItem = jMenu2.add(this.renameAction);
        jMenuItem.setMnemonic(Res.mnemonicFromRes("MENU_RENAME_MNEMONIC"));
        jMenuItem = jMenu2.add(this.deleteAction);
        jMenuItem.setMnemonic(Res.mnemonicFromRes("MENU_DELETE_MNEMONIC"));
        jMenu2.addSeparator();
        this.cbEditMenuBold = new JCheckBoxMenuItem(this.setBoldAction);
        this.cbEditMenuBold.setMnemonic(Res.mnemonicFromRes("MENU_SET_BOLD_MNEMONIC"));
        jMenu2.add(this.cbEditMenuBold);
        this.cbEditMenuItalic = new JCheckBoxMenuItem(this.setItalicAction);
        this.cbEditMenuItalic.setMnemonic(Res.mnemonicFromRes("MENU_SET_ITALIC_MNEMONIC"));
        jMenu2.add(this.cbEditMenuItalic);
        jMenuItem = jMenu2.add(this.changeColorAction);
        jMenuItem.setMnemonic(Res.mnemonicFromRes("MENU_CHANGE_COLOR_MNEMONIC"));
        jMenu2.addSeparator();
        jMenuItem = jMenu2.add(this.addWebLinkAction);
        jMenuItem.setMnemonic(Res.mnemonicFromRes("MENU_ADD_WEB_LINK_MNEMONIC"));
        jMenuItem = jMenu2.add(this.addLaunchLinkAction);
        jMenuItem.setMnemonic(Res.mnemonicFromRes("MENU_ADD_LAUNCH_LINK_MNEMONIC"));
        jMenuItem = jMenu2.add(this.setDestFromViewAction);
        jMenuItem.setMnemonic(Res.mnemonicFromRes("MENU_SET_DESTINATION_MNEMONIC"));
        jMenuItem = jMenu2.add(this.showActionsDialog);
        jMenuItem.setMnemonic(Res.mnemonicFromRes("MENU_ACTIONS_DIALOG_MNEMONIC"));
        jMenuBar.add(jMenu2);
        JMenu jMenu3 = new JMenu(Res.getString("MENU_VIEW"));
        jMenu3.setMnemonic(Res.mnemonicFromRes("MENU_VIEW_MNEMONIC"));
        jMenuItem = jMenu3.add(this.goFirstPageAction);
        jMenuItem.setMnemonic(Res.mnemonicFromRes("MENU_GO_FIRST_MNEMONIC"));
        jMenuItem = jMenu3.add(this.goPreviousPageAction);
        jMenuItem.setMnemonic(Res.mnemonicFromRes("MENU_GO_PREV_MNEMONIC"));
        jMenuItem = jMenu3.add(this.goNextPageAction);
        jMenuItem.setMnemonic(Res.mnemonicFromRes("MENU_GO_NEXT_MNEMONIC"));
        jMenuItem = jMenu3.add(this.goLastPageAction);
        jMenuItem.setMnemonic(Res.mnemonicFromRes("MENU_GO_LAST_MNEMONIC"));
        jMenuItem = jMenu3.add(this.goToPageAction);
        jMenuItem.setMnemonic(Res.mnemonicFromRes("MENU_GO_TO_PAGE_MNEMONIC"));
        jMenu3.addSeparator();
        this.zoomMenuItemsGroup = new ButtonGroup();
        this.rbFitWidth = new JRadioButtonMenuItem(this.fitWidthAction);
        this.rbFitWidth.setMnemonic(Res.mnemonicFromRes("MENU_FIT_WIDTH_MNEMONIC"));
        jMenu3.add(this.rbFitWidth);
        this.zoomMenuItemsGroup.add(this.rbFitWidth);
        this.rbFitHeight = new JRadioButtonMenuItem(this.fitHeightAction);
        this.rbFitHeight.setMnemonic(Res.mnemonicFromRes("MENU_FIT_HEIGHT_MNEMONIC"));
        jMenu3.add(this.rbFitHeight);
        this.zoomMenuItemsGroup.add(this.rbFitHeight);
        this.rbFitPage = new JRadioButtonMenuItem(this.fitPageAction);
        this.rbFitPage.setMnemonic(Res.mnemonicFromRes("MENU_FIT_PAGE_MNEMONIC"));
        jMenu3.add(this.rbFitPage);
        this.zoomMenuItemsGroup.add(this.rbFitPage);
        this.rbFitNative = new JRadioButtonMenuItem(this.fitNativeAction);
        this.rbFitNative.setMnemonic(Res.mnemonicFromRes("MENU_FIT_NATIVE_MNEMONIC"));
        jMenu3.add(this.rbFitNative);
        this.zoomMenuItemsGroup.add(this.rbFitNative);
        this.rbTopLeftZoom = new JRadioButtonMenuItem(this.topLeftZoomAction);
        this.rbTopLeftZoom.setMnemonic(Res.mnemonicFromRes("MENU_TOP_LEFT_ZOOM_MNEMONIC"));
        jMenu3.add(this.rbTopLeftZoom);
        this.zoomMenuItemsGroup.add(this.rbTopLeftZoom);
        this.rbFitRect = new JRadioButtonMenuItem(this.fitRectAction);
        this.rbFitRect.setMnemonic(Res.mnemonicFromRes("MENU_FIT_RECT_MNEMONIC"));
        jMenu3.add(this.rbFitRect);
        this.zoomMenuItemsGroup.add(this.rbFitRect);
        jMenu3.addSeparator();
        jMenu3.add(this.expandAllAction).setMnemonic(Res.mnemonicFromRes("MENU_EXPAND_ALL_MNEMONIC"));
        jMenu3.add(this.collapseAllAction).setMnemonic(Res.mnemonicFromRes("MENU_COLLAPSE_ALL_MNEMONIC"));
        jMenu3.addSeparator();
        JCheckBoxMenuItem jCheckBoxMenuItem = new JCheckBoxMenuItem(Res.getString("MENU_SHOW_NAVIGATION_PANEL"));
        jCheckBoxMenuItem.setAccelerator(KeyStroke.getKeyStroke(120, 0));
        if (this.userPrefs.getCollapsingPanelState() == 1) {
            jCheckBoxMenuItem.setState(true);
        } else {
            jCheckBoxMenuItem.setState(false);
        }
        jCheckBoxMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                int n = JPdfBookmarksGui.this.leftPanel.getPanelState();
                if (n == 0) {
                    JPdfBookmarksGui.this.leftPanel.setPanelState(1);
                } else {
                    JPdfBookmarksGui.this.leftPanel.setPanelState(0);
                }
            }
        });
        jMenu3.add(jCheckBoxMenuItem);
        this.leftPanelMenuGroup = new ButtonGroup();
        this.bookmarksButton = new JRadioButtonMenuItem(Res.getString("SHOW_BOOKMARKS"));
        this.bookmarksButton.setAccelerator(KeyStroke.getKeyStroke(118, 0));
        this.thumbnailsButton = new JRadioButtonMenuItem(Res.getString("SHOW_THUMBNAILS"));
        this.thumbnailsButton.setAccelerator(KeyStroke.getKeyStroke(118, 64));
        if (this.userPrefs.getPanelToShow().equals(Res.getString("THUMBNAILS_TAB_TITLE"))) {
            this.thumbnailsButton.setSelected(true);
        } else {
            this.bookmarksButton.setSelected(true);
        }
        this.bookmarksButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (JPdfBookmarksGui.this.leftPanel != null) {
                    JPdfBookmarksGui.this.leftPanel.selectPanelToShow(Res.getString("BOOKMARKS_TAB_TITLE"));
                }
            }
        });
        this.thumbnailsButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (JPdfBookmarksGui.this.leftPanel != null) {
                    JPdfBookmarksGui.this.leftPanel.selectPanelToShow(Res.getString("THUMBNAILS_TAB_TITLE"));
                }
            }
        });
        this.leftPanelMenuGroup.add(this.bookmarksButton);
        this.leftPanelMenuGroup.add(this.thumbnailsButton);
        jMenu3.add(this.bookmarksButton);
        jMenu3.add(this.thumbnailsButton);
        jMenuBar.add(jMenu3);
        JMenu jMenu4 = new JMenu(Res.getString("MENU_TOOLS"));
        jMenu4.setMnemonic(Res.mnemonicFromRes("MENU_TOOLS_MNEMONIC"));
        JMenu jMenu5 = new JMenu(Res.getString("MENU_LAF"));
        jMenu5.setMnemonic(Res.mnemonicFromRes("MENU_LAF_MNEMONIC"));
        ButtonGroup buttonGroup = new ButtonGroup();
        String string = UIManager.getLookAndFeel().getName();
        UIManager.LookAndFeelInfo[] lookAndFeelInfoArray = UIManager.getInstalledLookAndFeels();
        for (UIManager.LookAndFeelInfo object2 : lookAndFeelInfoArray) {
            JRadioButtonMenuItem jRadioButtonMenuItem = new JRadioButtonMenuItem(object2.getName());
            buttonGroup.add(jRadioButtonMenuItem);
            jMenu5.add(jRadioButtonMenuItem);
            if (string.equals(object2.getName())) {
                jRadioButtonMenuItem.setSelected(true);
            }
            jRadioButtonMenuItem.addActionListener(new ActionListenerSetLAF(object2.getClassName()));
        }
        this.cbSelectText = new JCheckBoxMenuItem(this.selectText);
        this.cbSelectText.setSelected(false);
        jMenu4.add(this.cbSelectText);
        this.cbConnectToClipboard = new JCheckBoxMenuItem(this.connectToClipboard);
        this.cbConnectToClipboard.setSelected(false);
        jMenu4.add(this.cbConnectToClipboard);
        jMenu4.addSeparator();
        this.cbShowOnOpen = new JCheckBoxMenuItem(this.showOnOpenAction);
        this.cbShowOnOpen.setMnemonic(Res.mnemonicFromRes("MENU_SHOW_ON_OPEN_MNEMONIC"));
        jMenu4.add(this.cbShowOnOpen);
        jMenu4.addSeparator();
        jMenuItem = jMenu4.add(this.dumpAction);
        jMenuItem.setMnemonic(Res.mnemonicFromRes("MENU_DUMP_MNEMONIC"));
        jMenuItem = jMenu4.add(this.loadAction);
        jMenuItem.setMnemonic(Res.mnemonicFromRes("MENU_LOAD_MNEMONIC"));
        jMenu4.addSeparator();
        jMenuItem = jMenu4.add(this.applyPageOffset);
        jMenuItem.setMnemonic(Res.mnemonicFromRes("MENU_PAGE_OFFSET_MNEMONIC"));
        JCheckBoxMenuItem jCheckBoxMenuItem2 = new JCheckBoxMenuItem(Res.getString("MENU_CONVERT_NAMED_DEST"));
        jCheckBoxMenuItem2.setToolTipText(Res.getString("MENU_CONVERT_NAMED_DEST_DESCR"));
        jCheckBoxMenuItem2.setMnemonic(Res.mnemonicFromRes("MENU_CONVERT_NAMED_DEST_MNEMONIC"));
        jCheckBoxMenuItem2.setSelected(this.userPrefs.getConvertNamedDestinations());
        jCheckBoxMenuItem2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JCheckBoxMenuItem jCheckBoxMenuItem = (JCheckBoxMenuItem)actionEvent.getSource();
                JPdfBookmarksGui.this.userPrefs.setConvertNamedDestinations(jCheckBoxMenuItem.isSelected());
                JOptionPane.showMessageDialog(JPdfBookmarksGui.this, Res.getString("CONVERT_NAMED_DEST_MSG"), JPdfBookmarksGui.this.title, 2);
            }
        });
        jMenu4.addSeparator();
        jMenuItem = jMenu4.add(this.optionsDialogAction);
        jMenuItem.setMnemonic(Res.mnemonicFromRes("MENU_OPTIONS_MNEMONIC"));
        jMenuBar.add(jMenu4);
        JMenu jMenu6 = new JMenu(Res.getString("MENU_WINDOW"));
        jMenu6.setMnemonic(Res.mnemonicFromRes("MENU_WINDOW_MNEMONIC"));
        jMenu6.add(jMenu5);
        jMenuBar.add(jMenu6);
        JMenu jMenu7 = new JMenu(Res.getString("MENU_HELP"));
        jMenu7.setMnemonic(Res.mnemonicFromRes("MENU_HELP_MNEMONIC"));
        jMenuItem = jMenu7.add(this.checkUpdatesAction);
        jMenuItem.setMnemonic(Res.mnemonicFromRes("MENU_CHECK_UPDATES_MNEMONIC"));
        jMenuItem = jMenu7.add(this.goToAuthorBlog);
        jMenuItem.setMnemonic(Res.mnemonicFromRes("MENU_GO_TO_BLOG_MNEMONIC"));
        jMenuItem = jMenu7.add(this.readOnlineManualAction);
        jMenuItem.setMnemonic(Res.mnemonicFromRes("MENU_READ_MANUAL_MNEMONIC"));
        jMenuItem = jMenu7.add(this.donateToProject);
        jMenuItem.setMnemonic(Res.mnemonicFromRes("MENU_DONATE_MNEMONIC"));
        jMenu7.addSeparator();
        jMenuItem = new JMenuItem(Res.getString("MENU_ABOUT_BOX") + " ...");
        jMenuItem.setMnemonic(Res.mnemonicFromRes("MENU_ABOUT_BOX_MNEMONIC"));
        jMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                AboutBox aboutBox = new AboutBox((Frame)JPdfBookmarksGui.this, true);
                aboutBox.setLocationRelativeTo(JPdfBookmarksGui.this);
                aboutBox.setVisible(true);
            }
        });
        jMenu7.add(jMenuItem);
        jMenuBar.add(jMenu7);
        this.toolbarsPanelsMenu = new JPopupMenu();
        JMenuItem jMenuItem2 = new JMenuItem(Res.getString("TAB_TOOLBARS_MANAGER") + "...");
        jMenuItem2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                OptionsDlg optionsDlg = new OptionsDlg((Frame)JPdfBookmarksGui.this, true);
                optionsDlg.setLocationRelativeTo(JPdfBookmarksGui.this);
                optionsDlg.setVisibleTab(2);
                optionsDlg.setVisible(true);
            }
        });
        this.toolbarsPanelsMenu.add(jMenuItem2);
        return jMenuBar;
    }

    private void createTreeMenu() {
        this.treeMenu = new JPopupMenu();
        JMenuItem jMenuItem = this.treeMenu.add(this.addSiblingAction);
        jMenuItem.setMnemonic(Res.mnemonicFromRes("MENU_ADD_SIBLING_MNEMONIC"));
        jMenuItem = this.treeMenu.add(this.addChildAction);
        jMenuItem.setMnemonic(Res.mnemonicFromRes("MENU_ADD_CHILD_MNEMONIC"));
        this.treeMenu.addSeparator();
        this.treeMenu.add(this.cutAction);
        this.treeMenu.add(this.copyAction);
        this.treeMenu.add(this.pasteAction);
        jMenuItem = this.treeMenu.add(this.renameAction);
        jMenuItem.setMnemonic(Res.mnemonicFromRes("MENU_RENAME_MNEMONIC"));
        jMenuItem = this.treeMenu.add(this.deleteAction);
        jMenuItem.setMnemonic(Res.mnemonicFromRes("MENU_DELETE_MNEMONIC"));
        this.treeMenu.addSeparator();
        this.cbBold = new JCheckBoxMenuItem(this.setBoldAction);
        this.cbBold.setMnemonic(Res.mnemonicFromRes("MENU_SET_BOLD_MNEMONIC"));
        this.treeMenu.add(this.cbBold);
        this.cbItalic = new JCheckBoxMenuItem(this.setItalicAction);
        this.cbItalic.setMnemonic(Res.mnemonicFromRes("MENU_SET_ITALIC_MNEMONIC"));
        this.treeMenu.add(this.cbItalic);
        jMenuItem = this.treeMenu.add(this.changeColorAction);
        jMenuItem.setMnemonic(Res.mnemonicFromRes("MENU_CHANGE_COLOR_MNEMONIC"));
        this.treeMenu.addSeparator();
        jMenuItem = this.treeMenu.add(this.addWebLinkAction);
        jMenuItem.setMnemonic(Res.mnemonicFromRes("MENU_ADD_WEB_LINK_MNEMONIC"));
        jMenuItem = this.treeMenu.add(this.addLaunchLinkAction);
        jMenuItem.setMnemonic(Res.mnemonicFromRes("MENU_ADD_LAUNCH_LINK_MNEMONIC"));
        jMenuItem = this.treeMenu.add(this.setDestFromViewAction);
        jMenuItem.setMnemonic(Res.mnemonicFromRes("MENU_SET_DESTINATION_MNEMONIC"));
        jMenuItem = this.treeMenu.add(this.showActionsDialog);
        jMenuItem.setMnemonic(Res.mnemonicFromRes("MENU_ACTIONS_DIALOG_MNEMONIC"));
    }

    private JPanel createToolbarsPanel() {
        JToolBar jToolBar = new JToolBar();
        jToolBar.add(this.openAction);
        jToolBar.add(this.openLinkedPdf);
        jToolBar.add(this.saveAction);
        jToolBar.add(this.saveAsAction);
        jToolBar.add(this.closeAction);
        this.mainToolbars.put("SHOW_FILE_TB", jToolBar);
        JToolBar jToolBar2 = new JToolBar();
        jToolBar2.add(this.undoAction);
        jToolBar2.add(this.redoAction);
        jToolBar2.addSeparator();
        jToolBar2.add(this.cutAction);
        jToolBar2.add(this.copyAction);
        jToolBar2.add(this.pasteAction);
        jToolBar2.add(this.copyBookmarkFromViewAction);
        this.mainToolbars.put("SHOW_UNDO_TB", jToolBar2);
        this.navigationToolbar = new JToolBar();
        JButton jButton = this.navigationToolbar.add(this.goFirstPageAction);
        jButton = this.navigationToolbar.add(this.goPreviousPageAction);
        this.mainToolbars.put("SHOW_NAVIGATION_TB", this.navigationToolbar);
        this.txtGoToPage = new IntegerTextField(4);
        this.txtGoToPage.setText("0");
        this.txtGoToPage.setEnabled(false);
        this.txtGoToPage.setHorizontalAlignment(0);
        this.txtGoToPage.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JPdfBookmarksGui.this.viewPanel.goToPage(JPdfBookmarksGui.this.txtGoToPage.getInteger());
            }
        });
        this.navigationToolbar.add((Component)this.txtGoToPage);
        this.lblPageOfPages = new JLabel(String.format(" / %5d", this.numPages));
        this.lblPageOfPages.setEnabled(false);
        this.navigationToolbar.add(this.lblPageOfPages);
        jButton = this.navigationToolbar.add(this.goNextPageAction);
        jButton = this.navigationToolbar.add(this.goLastPageAction);
        JToolBar jToolBar3 = new JToolBar();
        this.mainToolbars.put("SHOW_FITTYPE_TB", jToolBar3);
        this.zoomButtonsGroup = new ButtonGroup();
        this.tbFitWidth = new JToggleButton(this.fitWidthAction);
        this.tbFitWidth.setText("");
        jToolBar3.add(this.tbFitWidth);
        this.zoomButtonsGroup.add(this.tbFitWidth);
        this.tbFitHeight = new JToggleButton(this.fitHeightAction);
        this.tbFitHeight.setText("");
        jToolBar3.add(this.tbFitHeight);
        this.zoomButtonsGroup.add(this.tbFitHeight);
        this.tbFitPage = new JToggleButton(this.fitPageAction);
        this.tbFitPage.setText("");
        jToolBar3.add(this.tbFitPage);
        this.zoomButtonsGroup.add(this.tbFitPage);
        this.tbFitNative = new JToggleButton(this.fitNativeAction);
        this.tbFitNative.setText("");
        jToolBar3.add(this.tbFitNative);
        this.zoomButtonsGroup.add(this.tbFitNative);
        this.tbTopLeftZoom = new JToggleButton(this.topLeftZoomAction);
        this.tbTopLeftZoom.setText("");
        jToolBar3.add(this.tbTopLeftZoom);
        this.zoomButtonsGroup.add(this.tbTopLeftZoom);
        this.tbFitRect = new JToggleButton(this.fitRectAction);
        this.tbFitRect.setText("");
        jToolBar3.add(this.tbFitRect);
        this.zoomButtonsGroup.add(this.tbFitRect);
        JToolBar jToolBar4 = new JToolBar();
        this.mainToolbars.put("SHOW_ZOOM_TB", jToolBar4);
        jButton = jToolBar4.add(this.zoomInAction);
        this.txtZoom = new IntegerTextField(4);
        this.txtZoom.setText("0");
        this.txtZoom.setEnabled(false);
        this.txtZoom.setHorizontalAlignment(0);
        this.txtZoom.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                float f = (float)JPdfBookmarksGui.this.txtZoom.getInteger() / 100.0f;
                JPdfBookmarksGui.this.viewPanel.setTopLeftZoom(-1, -1, f);
            }
        });
        jToolBar4.add((Component)this.txtZoom);
        this.lblPercent = new JLabel(" % ");
        this.lblPercent.setEnabled(false);
        jToolBar4.add(this.lblPercent);
        jButton = jToolBar4.add(this.zoomOutAction);
        JToolBar jToolBar5 = new JToolBar();
        this.mainToolbars.put("SHOW_OTHERS_TB", jToolBar5);
        this.tbSelectText = new JToggleButton(this.selectText);
        this.tbSelectText.setText("");
        jToolBar5.add(this.tbSelectText);
        this.tbConnectToClipboard = new JToggleButton(this.connectToClipboard);
        this.tbConnectToClipboard.setText("");
        jToolBar5.add(this.tbConnectToClipboard);
        jToolBar5.addSeparator();
        this.tbShowOnOpen = new JToggleButton(this.showOnOpenAction);
        this.tbShowOnOpen.setText("");
        jToolBar5.add(this.tbShowOnOpen);
        jToolBar5.add(this.dumpAction);
        jToolBar5.add(this.loadAction);
        jToolBar5.add(this.applyPageOffset);
        jToolBar5.add(this.extractLinks);
        JToolBar jToolBar6 = new JToolBar();
        this.mainToolbars.put("SHOW_WEB_TB", jToolBar6);
        jToolBar6.add(this.checkUpdatesAction);
        jToolBar6.add(this.goToAuthorBlog);
        jToolBar6.add(this.readOnlineManualAction);
        jButton = jToolBar6.add(this.donateToProject);
        jButton.setVerticalTextPosition(0);
        jButton.setHorizontalTextPosition(4);
        jButton.setText(jButton.getToolTipText());
        this.mainToolbarsPanel.add(jToolBar);
        this.mainToolbarsPanel.add(jToolBar2);
        this.mainToolbarsPanel.add(jToolBar3);
        this.mainToolbarsPanel.add(jToolBar4);
        this.mainToolbarsPanel.add(this.navigationToolbar);
        this.mainToolbarsPanel.add(jToolBar5);
        this.mainToolbarsPanel.add(jToolBar6);
        this.mainToolbarsPanel.addMouseListener(this.toolbarsPopupListener);
        return this.mainToolbarsPanel;
    }

    public void updateToolbars() {
        Object object;
        for (Map.Entry<String, JToolBar> iterator : this.mainToolbars.entrySet()) {
            JToolBar jToolBar = iterator.getValue();
            object = iterator.getKey();
            jToolBar.setVisible(this.userPrefs.getShowToolbar((String)object));
        }
        boolean bl = false;
        for (JToolBar jToolBar : this.mainToolbars.values()) {
            if (!jToolBar.isVisible()) continue;
            bl = true;
            break;
        }
        this.mainToolbarsPanel.setVisible(bl);
        for (Map.Entry<String, JToolBar> entry : this.bookmarksToolbars.entrySet()) {
            object = entry.getValue();
            String string = entry.getKey();
            ((JComponent)object).setVisible(this.userPrefs.getShowToolbar(string));
        }
        bl = false;
        for (JToolBar jToolBar : this.bookmarksToolbars.values()) {
            if (!jToolBar.isVisible()) continue;
            bl = true;
            break;
        }
        this.bookmarksToolbarsPanel.setVisible(bl);
    }

    private JPanel createStatusBar() {
        JPanel jPanel = new JPanel(new GridLayout(1, 4));
        jPanel.setBorder(BorderFactory.createEmptyBorder(2, 5, 2, 5));
        this.busyPanel = Box.createHorizontalBox();
        this.busyPanel.setBorder(BorderFactory.createEtchedBorder());
        this.lblStatus = new JLabel(" ");
        this.progressBar = new JProgressBar();
        this.progressBar.setIndeterminate(true);
        this.busyPanel.add(this.lblStatus);
        this.busyPanel.add(Box.createHorizontalGlue());
        jPanel.add((Component)this.busyPanel, 0);
        this.lblMouseOverNode = new JLabel(" ");
        this.lblMouseOverNode.setBorder(BorderFactory.createEtchedBorder());
        jPanel.add((Component)this.lblMouseOverNode, 1);
        this.lblSelectedNode = new JLabel(" ");
        this.lblSelectedNode.setBorder(BorderFactory.createEtchedBorder());
        jPanel.add((Component)this.lblSelectedNode, 2);
        this.lblCurrentView = new JLabel(" ");
        this.lblCurrentView.setBorder(BorderFactory.createEtchedBorder());
        jPanel.add((Component)this.lblCurrentView, 3);
        return jPanel;
    }

    private void setEmptyBookmarksTree() {
        DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode(Res.getString("NO_PDF_LOADED"));
        this.bookmarksTreeModel = new DefaultTreeModel(defaultMutableTreeNode);
        this.bookmarksTree = new BookmarksTree();
        this.bookmarksTree.setToggleClickCount(0);
        ActionMap actionMap = this.bookmarksTree.getActionMap();
        actionMap.put(TransferHandler.getCutAction().getValue("Name"), TransferHandler.getCutAction());
        actionMap.put(TransferHandler.getCopyAction().getValue("Name"), TransferHandler.getCopyAction());
        actionMap.put(TransferHandler.getPasteAction().getValue("Name"), TransferHandler.getPasteAction());
        this.bookmarksTree.getSelectionModel().setSelectionMode(4);
        this.bookmarksTree.setShowsRootHandles(true);
        this.bookmarksTree.setRootVisible(true);
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.add((Component)((Object)this.bookmarksTree), "Center");
        this.bookmarksScroller.setViewportView(jPanel);
        this.mouseAdapter = new MouseOverTree();
        this.bookmarksTree.addMouseMotionListener(this.mouseAdapter);
        this.bookmarksTree.addMouseListener(this.mouseAdapter);
        this.bookmarksTree.addKeyListener(new KeysOverTree());
        this.bookmarksTree.addTreeSelectionListener(this);
        this.bookmarksTree.addTreeExpansionListener(this);
        this.bookmarksTree.addTreeNodeMovedListener(this);
        this.bookmarksTree.getCellEditor().addCellEditorListener(this);
        this.bookmarksTree.addUndoableEditListener(this.undoManager);
        this.undoManager.addUndoableEditListener(this);
        this.bookmarksTree.setModel(this.bookmarksTreeModel);
        this.bookmarksTree.treeDidChange();
    }

    private JPanel createBookmarksPanel() {
        this.bookmarksPanel = new JPanel(new BorderLayout());
        this.bookmarksScroller = new JScrollPane();
        this.setEmptyBookmarksTree();
        this.bookmarksPanel.add((Component)this.bookmarksScroller, "Center");
        this.bookmarksToolbarsPanel.setLayout(new BoxLayout(this.bookmarksToolbarsPanel, 1));
        this.bookmarksPanel.add((Component)this.bookmarksToolbarsPanel, "West");
        JToolBar jToolBar = new JToolBar(1);
        this.bookmarksToolbars.put("SHOW_ADD_TB", jToolBar);
        jToolBar.add(this.addSiblingAction);
        jToolBar.add(this.addChildAction);
        jToolBar.setMaximumSize(jToolBar.getPreferredSize());
        JToolBar jToolBar2 = new JToolBar(1);
        this.bookmarksToolbars.put("SHOW_CHANGE_TB", jToolBar2);
        jToolBar2.add(this.renameAction);
        jToolBar2.add(this.deleteAction);
        jToolBar2.setMaximumSize(jToolBar2.getPreferredSize());
        JToolBar jToolBar3 = new JToolBar(1);
        this.bookmarksToolbars.put("SHOW_STYLE_TB", jToolBar3);
        this.tbBold = new JToggleButton(this.setBoldAction);
        this.tbBold.setText("");
        jToolBar3.add(this.tbBold);
        this.tbItalic = new JToggleButton(this.setItalicAction);
        this.tbItalic.setText("");
        jToolBar3.add(this.tbItalic);
        jToolBar3.add(this.changeColorAction);
        jToolBar3.setMaximumSize(jToolBar3.getPreferredSize());
        JToolBar jToolBar4 = new JToolBar(1);
        this.bookmarksToolbars.put("SHOW_SETDEST_TB", jToolBar4);
        jToolBar4.add(this.addWebLinkAction);
        jToolBar4.add(this.addLaunchLinkAction);
        jToolBar4.add(this.setDestFromViewAction);
        jToolBar4.add(this.showActionsDialog);
        jToolBar4.setMaximumSize(jToolBar4.getPreferredSize());
        this.bookmarksToolbarsPanel.add(jToolBar);
        this.bookmarksToolbarsPanel.add(jToolBar2);
        this.bookmarksToolbarsPanel.add(jToolBar3);
        this.bookmarksToolbarsPanel.add(jToolBar4);
        this.bookmarksToolbarsPanel.addMouseListener(this.toolbarsPopupListener);
        return this.bookmarksPanel;
    }

    private void initComponents() {
        UIManager.put("Tree.leafIcon", Res.getIcon(this.getClass(), "gfx16/bookmark.png"));
        UIManager.put("Tree.openIcon", Res.getIcon(this.getClass(), "gfx16/bookmark.png"));
        UIManager.put("Tree.closedIcon", Res.getIcon(this.getClass(), "gfx16/bookmarks.png"));
        this.createActions();
        JMenuBar jMenuBar = this.createMenus();
        this.setJMenuBar(jMenuBar);
        this.createTreeMenu();
        JPanel jPanel = this.createToolbarsPanel();
        this.add((Component)jPanel, "North");
        this.centralSplit = new JSplitPane(1, false);
        this.leftPanel = new LeftPanel(this.centralSplit);
        this.leftPanel.addBookmarksPanel(this.createBookmarksPanel());
        this.leftPanel.addThumbnailsPanel(this.createThumbnailsPanel());
        this.leftPanel.getComboBoxSelector().addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                String string = (String)itemEvent.getItem();
                if (string.equals(Res.getString("BOOKMARKS_TAB_TITLE"))) {
                    JPdfBookmarksGui.this.bookmarksButton.setSelected(true);
                } else {
                    JPdfBookmarksGui.this.thumbnailsButton.setSelected(true);
                }
            }
        });
        this.leftPanel.getComboBoxSelector().setSelectedItem(this.userPrefs.getPanelToShow());
        JPanel jPanel2 = new JPanel(new BorderLayout());
        jPanel2.add((Component)((Object)this.viewPanel), "Center");
        Color color = new Color(230, 163, 4);
        JPanel jPanel3 = new JPanel(new BorderLayout());
        jPanel3.setBackground(color);
        String string = Res.getString("INHERIT_TOP");
        this.checkInheritTop = new JCheckBox();
        this.checkInheritTop.setBorder(BorderFactory.createEmptyBorder(0, 2, 1, 2));
        this.checkInheritTop.setBackground(color);
        this.checkInheritTop.setText(string);
        this.checkInheritTop.setMnemonic(Res.mnemonicFromRes("INHERIT_TOP_MNEMONIC"));
        this.checkInheritTop.setHorizontalTextPosition(2);
        this.checkInheritTop.setEnabled(false);
        jPanel3.add((Component)this.checkInheritTop, "East");
        jPanel2.add((Component)jPanel3, "North");
        Box box = Box.createVerticalBox();
        box.setOpaque(true);
        box.setBackground(color);
        box.add(Box.createVerticalGlue());
        String string2 = Res.getString("INHERIT_LEFT");
        this.lblInheritLeft = new VerticalLabel(string2, false);
        this.lblInheritLeft.setBackground(color);
        box.add((Component)this.lblInheritLeft);
        box.add(Box.createVerticalStrut(4));
        this.checkInheritLeft = new JCheckBox();
        this.checkInheritLeft.setBorder(BorderFactory.createEmptyBorder(0, 1, 3, 2));
        this.checkInheritLeft.setBackground(color);
        this.checkInheritLeft.setEnabled(false);
        box.add(this.checkInheritLeft);
        this.lblInheritLeft.setDisplayedMnemonic(Res.mnemonicFromRes("INHERIT_LEFT_MNEMONIC"));
        this.lblInheritLeft.setLabelFor((Component)this.checkInheritLeft);
        this.lblInheritLeft.setEnabled(false);
        jPanel2.add((Component)box, "West");
        this.checkInheritZoom = new JCheckBox();
        this.checkInheritZoom.setBorder(BorderFactory.createEmptyBorder(0, 1, 0, 2));
        this.checkInheritZoom.setBackground(color);
        this.checkInheritZoom.setText(Res.getString("INHERIT_ZOOM"));
        this.checkInheritZoom.setHorizontalTextPosition(4);
        this.checkInheritZoom.setMnemonic(Res.mnemonicFromRes("INHERIT_ZOOM_MNEMONIC"));
        this.checkInheritZoom.setEnabled(false);
        jPanel3.add((Component)this.checkInheritZoom, "West");
        this.centralSplit.setLeftComponent((Component)((Object)this.leftPanel));
        this.centralSplit.setRightComponent(jPanel2);
        this.centralSplit.setOneTouchExpandable(true);
        this.leftPanel.setDividerLocation(this.userPrefs.getSplitterLocation());
        this.leftPanel.setPanelState(this.userPrefs.getCollapsingPanelState());
        this.dropTarget = new DropTarget(this.centralSplit, new SplitDropListener());
        this.centralSplit.setDropTarget(this.dropTarget);
        this.add((Component)this.centralSplit, "Center");
        this.add((Component)this.createStatusBar(), "South");
        this.updateToolbars();
    }

    private void followBookmarkInView(Bookmark bookmark) {
        if (bookmark == null) {
            return;
        }
        this.bookmarksTree.setLastFollowedBookmark(bookmark);
        this.lblSelectedNode.setText(Res.getString("SELECTED_BOOKMARK") + ": " + bookmark.getDescription(this.userPrefs.getUseThousandths()));
        if (bookmark.isRemoteDestination()) {
            Bookmark bookmark2 = new Bookmark();
            bookmark2.cloneDestination(bookmark);
            bookmark2.setRemoteDestination(false);
            File file = this.fileOperator.getFile();
            try {
                File file2 = file.getAbsoluteFile();
                File file3 = Ut.createAbsolutePath((File)file2, (File)new File(bookmark.getRemoteFilePath()));
                JPdfBookmarksGui jPdfBookmarksGui = this.alreadyOpenedIn(file3.getCanonicalFile());
                if (jPdfBookmarksGui != null) {
                    jPdfBookmarksGui.requestFocus();
                    jPdfBookmarksGui.followBookmarkInView(bookmark2);
                } else {
                    JPanel jPanel = new JPanel();
                    jPanel.setLayout(new BoxLayout(jPanel, 1));
                    jPanel.add(new JLabel(Res.getString("BOOKMARK_TO_REMOTE_FILE")));
                    jPanel.add(Box.createRigidArea(new Dimension(0, 5)));
                    jPanel.add(new JLabel(bookmark.getDescription(true)));
                    jPanel.add(Box.createRigidArea(new Dimension(0, 5)));
                    jPanel.add(new JLabel(Res.getString("ASK_OPEN_IN_NEW_WINDOW")));
                    int n = JOptionPane.showConfirmDialog(this, jPanel, this.title, 0);
                    if (n == 0) {
                        String string = file2.getParent() + File.separator + bookmark.getRemoteFilePath();
                        file = new File(string);
                        String string2 = file.getCanonicalPath();
                        new JPdfBookmarks().launchNewGuiInstance(string2, bookmark2);
                    }
                }
            }
            catch (IOException iOException) {}
        } else if (bookmark.getType() == BookmarkType.Named) {
            this.followBookmarkInView(bookmark.getNamedTarget());
        } else if (bookmark.getType() == BookmarkType.Uri) {
            this.goToWebLinkAsking(bookmark.getUri());
        } else if (bookmark.getType() == BookmarkType.Launch) {
            this.launchFile(bookmark.getFileToLaunch());
        } else if (bookmark.getType() != BookmarkType.Unknown) {
            int n = bookmark.getPageNumber();
            this.viewPanel.goToPage(n);
            switch (bookmark.getType()) {
                case FitWidth: {
                    this.checkInheritTop.setSelected(bookmark.getTop() < 0);
                    this.viewPanel.setFitWidth(bookmark.getTop());
                    break;
                }
                case FitHeight: {
                    this.checkInheritLeft.setSelected(bookmark.getLeft() < 0);
                    this.viewPanel.setFitHeight(bookmark.getLeft());
                    break;
                }
                case FitPage: {
                    this.viewPanel.setFitPage();
                    break;
                }
                case FitRect: {
                    this.viewPanel.setFitRect(bookmark.getTop(), bookmark.getLeft(), bookmark.getBottom(), bookmark.getRight());
                    break;
                }
                case TopLeft: 
                case TopLeftZoom: {
                    this.checkInheritTop.setSelected(bookmark.getTop() < 0);
                    this.checkInheritLeft.setSelected(bookmark.getLeft() < 0);
                    this.checkInheritZoom.setSelected(bookmark.getZoom() <= 0.0f);
                    this.viewPanel.setTopLeftZoom(bookmark.getTop(), bookmark.getLeft(), bookmark.getZoom());
                }
            }
        }
        if (!bookmark.isRemoteDestination()) {
            for (File file : bookmark.getChainedBookmarks()) {
                this.followBookmarkInView((Bookmark)file);
            }
        }
        this.bookmarksTree.repaint();
    }

    private JPdfBookmarksGui alreadyOpenedIn(File file) {
        Window[] windowArray;
        JPdfBookmarksGui jPdfBookmarksGui = null;
        for (Window window : windowArray = Window.getOwnerlessWindows()) {
            File file2;
            if (!(window instanceof JPdfBookmarksGui)) continue;
            JPdfBookmarksGui jPdfBookmarksGui2 = (JPdfBookmarksGui)window;
            if (jPdfBookmarksGui2.fileOperator == null || (file2 = jPdfBookmarksGui2.fileOperator.getFile()) == null || !file2.equals(file)) continue;
            jPdfBookmarksGui = jPdfBookmarksGui2;
        }
        return jPdfBookmarksGui;
    }

    private class SplitDropListener
    implements DropTargetListener {
        @Override
        public void dragEnter(DropTargetDragEvent dropTargetDragEvent) {
        }

        @Override
        public void dragOver(DropTargetDragEvent dropTargetDragEvent) {
        }

        @Override
        public void dropActionChanged(DropTargetDragEvent dropTargetDragEvent) {
        }

        @Override
        public void dragExit(DropTargetEvent dropTargetEvent) {
        }

        private List textURIListToFileList(String string) {
            ArrayList<File> arrayList = new ArrayList<File>(1);
            StringTokenizer stringTokenizer = new StringTokenizer(string, "\r\n");
            while (stringTokenizer.hasMoreTokens()) {
                String string2 = stringTokenizer.nextToken();
                if (string2.startsWith("#")) continue;
                try {
                    URI uRI = new URI(string2);
                    File file = new File(uRI);
                    arrayList.add(file);
                }
                catch (URISyntaxException uRISyntaxException) {
                }
                catch (IllegalArgumentException illegalArgumentException) {}
            }
            return arrayList;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void drop(DropTargetDropEvent dropTargetDropEvent) {
            int n = dropTargetDropEvent.getDropAction();
            dropTargetDropEvent.acceptDrop(n);
            try {
                Object object;
                Transferable transferable = dropTargetDropEvent.getTransferable();
                DataFlavor dataFlavor = null;
                try {
                    dataFlavor = new DataFlavor("text/uri-list;class=java.lang.String");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    // empty catch block
                }
                List list = null;
                if (transferable.isDataFlavorSupported(DataFlavor.javaFileListFlavor)) {
                    list = (List)transferable.getTransferData(DataFlavor.javaFileListFlavor);
                } else if (transferable.isDataFlavorSupported(dataFlavor)) {
                    object = (String)transferable.getTransferData(dataFlavor);
                    list = this.textURIListToFileList((String)object);
                }
                if (list != null && (object = list.iterator()).hasNext()) {
                    File file = (File)object.next();
                    if (!JPdfBookmarksGui.this.askCloseWithoutSave()) {
                        return;
                    }
                    JPdfBookmarksGui.this.fileOperator.close();
                    if (file != null && file.isFile()) {
                        JPdfBookmarksGui.this.openFileAsync(file, null);
                        return;
                    }
                    JPdfBookmarksGui.this.showErrorMessage(Res.getString("ERROR_OPENING_FILE") + " " + file.getName());
                    return;
                }
            }
            catch (UnsupportedFlavorException unsupportedFlavorException) {
            }
            catch (IOException iOException) {
            }
            finally {
                dropTargetDropEvent.dropComplete(true);
            }
        }
    }

    private class KeysOverTree
    extends KeyAdapter {
        private KeysOverTree() {
        }

        @Override
        public void keyReleased(KeyEvent keyEvent) {
            super.keyReleased(keyEvent);
            int n = keyEvent.getKeyCode();
            int[] nArray = JPdfBookmarksGui.this.userPrefs.getNumClicks() > 1 ? new int[]{10, 32} : new int[]{37, 39, 38, 40, 36, 35, 34, 33};
            for (int n2 : nArray) {
                if (n2 != n) continue;
                TreePath treePath = JPdfBookmarksGui.this.bookmarksTree.getLeadSelectionPath();
                Bookmark bookmark = (Bookmark)treePath.getLastPathComponent();
                if (bookmark == null) break;
                JPdfBookmarksGui.this.followBookmarkInView(bookmark);
                break;
            }
            if (JPdfBookmarksGui.this.deleteAction.isEnabled() && n == 127) {
                JPdfBookmarksGui.this.delete();
            }
            if (keyEvent.isControlDown() && n == 67 && JPdfBookmarksGui.this.copyAction.isEnabled()) {
                JPdfBookmarksGui.this.copy(false);
            }
            if (keyEvent.isControlDown() && n == 86 && JPdfBookmarksGui.this.pasteAction.isEnabled()) {
                JPdfBookmarksGui.this.paste();
            }
            if (keyEvent.isControlDown() && n == 88 && JPdfBookmarksGui.this.cutAction.isEnabled()) {
                JPdfBookmarksGui.this.cut();
            }
        }
    }

    private class MouseOverTree
    extends MouseAdapter {
        private TreePath mousePressedPath;

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            super.mousePressed(mouseEvent);
            this.mousePressedPath = JPdfBookmarksGui.this.bookmarksTree.getPathForLocation(mouseEvent.getX(), mouseEvent.getY());
            if (mouseEvent.isPopupTrigger()) {
                TreePath[] treePathArray = JPdfBookmarksGui.this.bookmarksTree.getSelectionPaths();
                if (this.mousePressedPath != null) {
                    boolean bl = true;
                    if (treePathArray != null) {
                        for (TreePath treePath : treePathArray) {
                            if (!treePath.equals(this.mousePressedPath)) continue;
                            bl = false;
                        }
                    }
                    if (bl) {
                        JPdfBookmarksGui.this.bookmarksTree.setSelectionPath(this.mousePressedPath);
                    }
                }
                JPdfBookmarksGui.this.treeMenu.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
            }
        }

        @Override
        public void mouseExited(MouseEvent mouseEvent) {
            super.mouseExited(mouseEvent);
            JPdfBookmarksGui.this.lblMouseOverNode.setText(" ");
        }

        @Override
        public void mouseMoved(MouseEvent mouseEvent) {
            super.mouseMoved(mouseEvent);
            if (!(mouseEvent.getSource() instanceof MouseDraggableTree)) {
                return;
            }
            MouseDraggableTree mouseDraggableTree = (MouseDraggableTree)mouseEvent.getSource();
            TreePath treePath = mouseDraggableTree.getPathForLocation(mouseEvent.getX(), mouseEvent.getY());
            if (treePath == null) {
                JPdfBookmarksGui.this.lblMouseOverNode.setText(" ");
                return;
            }
            Object object = treePath.getLastPathComponent();
            if (object != null && object instanceof Bookmark) {
                Bookmark bookmark = (Bookmark)object;
                String string = bookmark.getDescription(JPdfBookmarksGui.this.userPrefs.getUseThousandths());
                JPdfBookmarksGui.this.lblMouseOverNode.setText(Res.getString("MOUSE_OVER_BOOKMARK") + ": " + string);
            }
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
            super.mouseReleased(mouseEvent);
            TreePath treePath = JPdfBookmarksGui.this.bookmarksTree.getPathForLocation(mouseEvent.getX(), mouseEvent.getY());
            TreePath[] treePathArray = JPdfBookmarksGui.this.bookmarksTree.getSelectionPaths();
            if (mouseEvent.isPopupTrigger()) {
                JPdfBookmarksGui.this.treeMenu.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
                if (treePath != null) {
                    boolean bl = true;
                    if (treePathArray != null) {
                        for (TreePath treePath2 : treePathArray) {
                            if (!treePath2.equals(treePath)) continue;
                            bl = false;
                        }
                    }
                    if (bl) {
                        JPdfBookmarksGui.this.bookmarksTree.setSelectionPath(treePath);
                    }
                }
            } else if (!(JPdfBookmarksGui.this.bookmarksTree.isDragging() || treePath == null || mouseEvent.isControlDown() || mouseEvent.isAltDown() || mouseEvent.isShiftDown() || mouseEvent.getClickCount() < JPdfBookmarksGui.this.userPrefs.getNumClicks())) {
                Bookmark bookmark = null;
                try {
                    bookmark = (Bookmark)treePath.getLastPathComponent();
                }
                catch (ClassCastException classCastException) {
                    // empty catch block
                }
                if (bookmark != null) {
                    JPdfBookmarksGui.this.followBookmarkInView(bookmark);
                }
            }
        }
    }

    private class ActionListenerSetLAF
    implements ActionListener {
        private String laf;

        public ActionListenerSetLAF(String string) {
            this.laf = string;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            Ut.changeLAF((String)this.laf, (Component)JPdfBookmarksGui.this);
            JPdfBookmarksGui.this.leftPanel.updateComponentsUI();
            JPdfBookmarksGui.this.lblInheritLeft.setUI((LabelUI)new VerticalLabelUI(false));
            JPdfBookmarksGui.this.userPrefs.setLAF(this.laf);
            JPdfBookmarksGui.this.bookmarksTree.updateTree(new MouseListener[]{JPdfBookmarksGui.this.mouseAdapter});
        }
    }

    private class ToolbarsPopupListener
    extends MouseAdapter {
        private ToolbarsPopupListener() {
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            this.maybeShowPopup(mouseEvent);
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
            this.maybeShowPopup(mouseEvent);
        }

        private void maybeShowPopup(MouseEvent mouseEvent) {
            if (mouseEvent.isPopupTrigger()) {
                JPdfBookmarksGui.this.toolbarsPanelsMenu.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
            }
        }
    }

    private class RecentFileListener
    implements ActionListener {
        private File f;

        public RecentFileListener(File file) {
            this.f = file;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (!JPdfBookmarksGui.this.askCloseWithoutSave()) {
                return;
            }
            JPdfBookmarksGui.this.fileOperator.close();
            if (this.f != null && this.f.isFile()) {
                JPdfBookmarksGui.this.openFileAsync(this.f, null);
            } else {
                JPdfBookmarksGui.this.showErrorMessage(Res.getString("ERROR_OPENING_FILE") + " " + this.f.getName());
            }
        }
    }

    private class LastVersionWebChecker
    extends SwingWorker<Boolean, Void> {
        boolean quietMode = false;

        public LastVersionWebChecker(boolean bl) {
            this.quietMode = bl;
        }

        @Override
        protected Boolean doInBackground() throws Exception {
            Serializable serializable;
            Proxy proxy = Proxy.NO_PROXY;
            if (JPdfBookmarksGui.this.userPrefs.getUseProxy()) {
                serializable = new InetSocketAddress(JPdfBookmarksGui.this.userPrefs.getProxyAddress(), JPdfBookmarksGui.this.userPrefs.getProxyPort());
                String string = JPdfBookmarksGui.this.userPrefs.getProxyType();
                proxy = new Proxy(Proxy.Type.valueOf(string), (SocketAddress)serializable);
            }
            serializable = null;
            boolean bl = false;
            serializable = new URL("http://jpdfbookmarks.altervista.org/version/jpdfbookmarks.properties");
            HttpURLConnection httpURLConnection = (HttpURLConnection)serializable.openConnection(proxy);
            Properties properties = new Properties();
            InputStreamReader inputStreamReader = new InputStreamReader(httpURLConnection.getInputStream());
            properties.load(inputStreamReader);
            String string = properties.getProperty("VERSION");
            String[] stringArray = string.split("\\.");
            String[] stringArray2 = JPdfBookmarks.getVersion().split("\\.");
            for (int i = 0; i < stringArray.length; ++i) {
                int n;
                int n2 = Integer.parseInt(stringArray[i]);
                if (n2 > (n = Integer.parseInt(stringArray2[i]))) {
                    bl = true;
                    break;
                }
                if (n > n2) break;
            }
            ((Reader)inputStreamReader).close();
            httpURLConnection.disconnect();
            return bl;
        }

        @Override
        protected void done() {
            block3: {
                boolean bl = false;
                try {
                    bl = (Boolean)this.get();
                    if (bl || !this.quietMode) {
                        JOptionPane.showMessageDialog(JPdfBookmarksGui.this, JPdfBookmarksGui.this.newVersionAvailable(bl), "JPdfBookmarks", 1);
                    }
                }
                catch (Exception exception) {
                    if (this.quietMode) break block3;
                    JPdfBookmarksGui.this.showErrorMessage(Res.getString("ERROR_CHECKING_UPDATES"));
                }
            }
        }
    }

    private class AsyncSaveAs
    extends SwingWorker {
        File f;
        Bookmark currentView;

        public AsyncSaveAs(File file, Bookmark bookmark) {
            this.f = file;
            this.currentView = bookmark;
        }

        protected Object doInBackground() throws Exception {
            JPdfBookmarksGui.this.fileOperator.saveAs((Bookmark)JPdfBookmarksGui.this.bookmarksTreeModel.getRoot(), this.f.getAbsolutePath());
            return null;
        }

        @Override
        protected void done() {
            JPdfBookmarksGui.this.followBookmarkInView(this.currentView);
            CursorToolkit.stopWaitCursor(JPdfBookmarksGui.this.tbBold);
            JPdfBookmarksGui.this.removeProgressBar();
        }
    }

    private class ColorChooserListener
    implements ActionListener {
        private ColorChooserListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            TreePath[] treePathArray;
            for (TreePath treePath : treePathArray = JPdfBookmarksGui.this.bookmarksTree.getSelectionPaths()) {
                Bookmark bookmark = (Bookmark)treePath.getLastPathComponent();
                bookmark.setColor(JPdfBookmarksGui.this.colorChooser.getColor());
            }
        }
    }

    abstract class ActionBuilder
    extends AbstractAction {
        public ActionBuilder(String string, String string2, String string3, String string4, boolean bl) {
            super(Res.getString(string));
            String string5 = null;
            if (string2 != null) {
                string5 = Res.getString(string2);
            }
            if (string3 != null) {
                this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(string3));
                string5 = string5 + " [" + string3.toUpperCase() + "]";
            }
            if (string5 != null) {
                this.putValue("ShortDescription", string5);
            }
            if (string4 != null) {
                this.putValue("SmallIcon", Res.getIcon(this.getClass(), "gfx16/" + string4));
                this.putValue("SwingLargeIconKey", Res.getIcon(this.getClass(), "gfx22/" + string4));
            }
            this.setEnabled(bl);
        }
    }
}

