/*
 * Decompiled with CFR 0.152.
 */
package it.flavianopetrocchi.jpdfbookmarks;

import it.flavianopetrocchi.jpdfbookmarks.Res;
import java.awt.Component;
import java.awt.Desktop;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import javax.swing.JOptionPane;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;

public class MyHyperlinkListener
implements HyperlinkListener {
    private Component parent;

    public MyHyperlinkListener(Component component) {
        this.parent = component;
    }

    @Override
    public void hyperlinkUpdate(HyperlinkEvent hyperlinkEvent) {
        if (hyperlinkEvent.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
            this.goToWebLink(hyperlinkEvent.getURL().toString());
        }
    }

    public void goToWebLink(String string) {
        int n = JOptionPane.showConfirmDialog(this.parent, Res.getString("MSG_LAUNCH_BROWSER"), "JPdfBookmarks", 2);
        if (n != 0) {
            return;
        }
        Desktop desktop = Desktop.getDesktop();
        try {
            desktop.browse(new URI(string));
        }
        catch (URISyntaxException uRISyntaxException) {
            JOptionPane.showMessageDialog(this.parent, Res.getString("ERROR_WRONG_URI"), "JPdfBookmarks", 0);
        }
        catch (IOException iOException) {
            JOptionPane.showMessageDialog(this.parent, Res.getString("ERROR_LAUNCHING_BROWSER"), "JPdfBookmarks", 0);
        }
    }
}

