/*
 * Decompiled with CFR 0.152.
 */
package jpdftweak;

import java.awt.Color;
import java.awt.Component;
import java.awt.Frame;
import java.io.PrintWriter;
import java.io.StringWriter;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.UIManager;
import jpdftweak.cli.CommandLineInterface;
import jpdftweak.gui.MainForm;

public class Main {
    public static final String VERSION = "1.1";

    public static void main(String[] stringArray) {
        String string = Main.findMissingLibName();
        if (stringArray.length == 0) {
            try {
                UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (string != null) {
                JOptionPane.showMessageDialog(null, "The required file lib/" + string + ".jar could not be loaded.\nVerify that the file is present and your download was not corrupted.", "JPDFTweak", 0);
                return;
            }
            Thread.setDefaultUncaughtExceptionHandler(new Thread.UncaughtExceptionHandler(){

                public void uncaughtException(Thread thread, Throwable throwable) {
                    throwable.printStackTrace();
                    JDialog jDialog = new JDialog((Frame)null, "An unexpected error occurred while running jPDF Tweak.");
                    StringWriter stringWriter = new StringWriter();
                    PrintWriter printWriter = new PrintWriter(stringWriter);
                    printWriter.write("Please send this error report to <schierlm@users.sourceforge.net>.\nTry to provide specific information about when this error occured.\n\njPDF Tweak version: 1.1\nJava version: " + System.getProperty("java.version") + " (" + System.getProperty("java.vendor") + ")\n" + "Operating System: " + System.getProperty("os.name") + " (" + System.getProperty("os.version") + ", " + System.getProperty("os.arch") + ")\n\n");
                    throwable.printStackTrace(new PrintWriter(stringWriter));
                    JTextArea jTextArea = new JTextArea(stringWriter.toString(), 20, 80);
                    jTextArea.setBackground(new Color(255, 187, 187));
                    jTextArea.setEditable(false);
                    jDialog.add((Component)new JScrollPane(jTextArea), "Center");
                    jDialog.pack();
                    jDialog.setLocationRelativeTo(null);
                    jDialog.setVisible(true);
                }
            });
            new MainForm();
        } else {
            if (string != null) {
                System.out.println("The required file lib/" + string + ".jar could not be loaded.");
                System.out.println("Verify that the file is present and your download was not corrupted.");
                return;
            }
            try {
                new CommandLineInterface(stringArray);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    private static String findMissingLibName() {
        String string = null;
        try {
            string = "itext";
            Class.forName("com.itextpdf.text.DocumentException");
            string = "forms";
            Class.forName("com.jgoodies.forms.layout.FormLayout");
            string = "bcprov";
            Class.forName("org.bouncycastle.asn1.ASN1OctetString");
            string = "bcmail";
            Class.forName("org.bouncycastle.cms.CMSEnvelopedData");
            string = "bctsp";
            Class.forName("org.bouncycastle.tsp.TSPException");
            string = null;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return string;
    }
}

