/*
 * Decompiled with CFR 0.152.
 */
package jpdftweak.core;

import java.util.Arrays;
import jpdftweak.core.IntegerList;
import jpdftweak.core.PdfInputFile;

public class PdfPageRange {
    private final PdfInputFile inputFile;
    private final int from;
    private final int to;
    private final boolean includeOdd;
    private final boolean includeEven;
    private final IntegerList emptyBefore;

    public PdfPageRange(PdfInputFile pdfInputFile, int n, int n2, boolean bl, boolean bl2, IntegerList integerList) {
        this.inputFile = pdfInputFile;
        if (n < 0) {
            n += pdfInputFile.getPageCount() + 1;
        }
        if (n2 < 0) {
            n2 += pdfInputFile.getPageCount() + 1;
        }
        this.from = n;
        this.to = n2;
        this.includeOdd = bl;
        this.includeEven = bl2;
        this.emptyBefore = integerList;
    }

    public PdfInputFile getInputFile() {
        return this.inputFile;
    }

    public int[] getPages(int n) {
        int n2 = this.emptyBefore.getValue()[n % this.emptyBefore.getValue().length];
        int[] nArray = new int[n2 + Math.abs(this.to - this.from) + 1];
        Arrays.fill(nArray, 0, n2, -1);
        int n3 = n2;
        int n4 = this.from;
        while (true) {
            if (n4 % 2 == 0 && this.includeEven || n4 % 2 == 1 && this.includeOdd) {
                nArray[n3++] = n4;
            }
            if (n4 == this.to) break;
            n4 += this.from > this.to ? -1 : 1;
        }
        if (n3 != nArray.length) {
            int[] nArray2 = new int[n3];
            System.arraycopy(nArray, 0, nArray2, 0, n3);
            return nArray2;
        }
        return nArray;
    }
}

