/*
 * Decompiled with CFR 0.152.
 */
package jpdftweak.gui.tabs;

import com.itextpdf.text.DocumentException;
import com.itextpdf.text.exceptions.BadPasswordException;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.DefaultCellEditor;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import jpdftweak.core.IntegerList;
import jpdftweak.core.PdfBookmark;
import jpdftweak.core.PdfInputFile;
import jpdftweak.core.PdfPageRange;
import jpdftweak.core.PdfTweak;
import jpdftweak.gui.MainForm;
import jpdftweak.gui.PasswordInputBox;
import jpdftweak.gui.TableComponent;
import jpdftweak.gui.TableComponentModel;
import jpdftweak.gui.tabs.Tab;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InputTab
extends Tab {
    private JTextField filename;
    private JTextField interleaveSize;
    private JCheckBox multiFiles;
    private JCheckBox batchProcessing;
    private JCheckBox interleave;
    private TableComponent fileCombination;
    private JButton selectfile;
    private List<PdfInputFile> inputFiles = new ArrayList<PdfInputFile>();
    private JComboBox filesCombo;
    private final MainForm mf;
    private int batchTaskSelection = -1;
    private boolean useTempFiles = false;

    public InputTab(MainForm mainForm) {
        super((LayoutManager)new FormLayout("f:p, f:p:g, f:p, f:p, f:p, f:p", "f:p, f:p, f:p:g"));
        this.mf = mainForm;
        CellConstraints cellConstraints = new CellConstraints();
        this.add((Component)new JLabel("Filename"), cellConstraints.xy(1, 1));
        this.filename = new JTextField();
        this.add((Component)this.filename, cellConstraints.xyw(2, 1, 3));
        this.filename.setEditable(false);
        this.selectfile = new JButton("Select...");
        this.add((Component)this.selectfile, cellConstraints.xy(5, 1));
        this.selectfile.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                InputTab.this.selectFile();
            }
        });
        JButton jButton = new JButton("Clear");
        this.add((Component)jButton, cellConstraints.xy(6, 1));
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                InputTab.this.filesCombo.removeAllItems();
                for (PdfInputFile pdfInputFile : InputTab.this.inputFiles) {
                    pdfInputFile.close();
                }
                InputTab.this.inputFiles.clear();
                InputTab.this.mf.setInputFile(null);
                InputTab.this.fileCombination.clear();
                InputTab.this.selectfile.setEnabled(true);
                InputTab.this.multiFiles.setEnabled(!InputTab.this.batchProcessing.isSelected());
                InputTab.this.batchProcessing.setEnabled(!InputTab.this.multiFiles.isSelected());
                InputTab.this.updateFileName();
            }
        });
        this.multiFiles = new JCheckBox("Multiple file input / Select pages");
        this.add((Component)this.multiFiles, cellConstraints.xyw(1, 2, 2));
        ActionListener actionListener = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (InputTab.this.multiFiles.isSelected()) {
                    InputTab.this.batchProcessing.setEnabled(false);
                    InputTab.this.selectfile.setEnabled(true);
                    InputTab.this.fileCombination.setEnabled(true);
                    InputTab.this.interleave.setEnabled(true);
                    InputTab.this.interleaveSize.setEnabled(InputTab.this.interleave.isSelected());
                } else if (InputTab.this.batchProcessing.isSelected()) {
                    InputTab.this.multiFiles.setEnabled(false);
                    InputTab.this.selectfile.setEnabled(true);
                } else {
                    InputTab.this.batchProcessing.setEnabled(true);
                    InputTab.this.multiFiles.setEnabled(true);
                    InputTab.this.selectfile.setEnabled(InputTab.this.inputFiles.size() == 0);
                    InputTab.this.fileCombination.setEnabled(false);
                    InputTab.this.interleave.setEnabled(false);
                    InputTab.this.interleaveSize.setEnabled(false);
                }
            }
        };
        this.multiFiles.addActionListener(actionListener);
        this.interleave = new JCheckBox("Interleave documents in blocks of");
        this.add((Component)this.interleave, cellConstraints.xy(3, 2));
        this.interleave.setEnabled(false);
        this.interleave.addActionListener(actionListener);
        this.interleaveSize = new JTextField("1", 10);
        this.add((Component)this.interleaveSize, cellConstraints.xy(4, 2));
        this.interleaveSize.setEnabled(false);
        this.batchProcessing = new JCheckBox("Batch processing");
        this.add((Component)this.batchProcessing, cellConstraints.xyw(5, 2, 2));
        this.batchProcessing.addActionListener(actionListener);
        this.filesCombo = new JComboBox();
        this.fileCombination = new TableComponent(new String[]{"File", "From Page", "To Page", "Include Odd", "Include Even", "Empty Before"}, new Class[]{PdfInputFile.class, Integer.class, Integer.class, Boolean.class, Boolean.class, IntegerList.class}, new Object[]{null, 1, -1, true, true, new IntegerList("0")});
        this.add((Component)this.fileCombination, cellConstraints.xyw(1, 3, 6));
        this.fileCombination.setEnabled(false);
        this.fileCombination.getTable().getColumnModel().getColumn(0).setPreferredWidth(300);
        this.fileCombination.getTable().getColumnModel().getColumn(0).setCellEditor(new DefaultCellEditor(this.filesCombo));
        this.fileCombination.setRowListener(new TableComponentModel.RowListener(){

            public void rowChanged(int n, int n2) {
                Object[] objectArray;
                if (n2 < 3) {
                    Object[] objectArray2 = InputTab.this.fileCombination.getRow(n);
                    PdfInputFile pdfInputFile = (PdfInputFile)objectArray2[0];
                    if (objectArray2[1] == null) {
                        objectArray2[1] = 1;
                    }
                    if (objectArray2[2] == null) {
                        objectArray2[2] = -1;
                    }
                    int n3 = (Integer)objectArray2[1];
                    int n4 = (Integer)objectArray2[2];
                    int n5 = pdfInputFile == null ? 1 : pdfInputFile.getPageCount();
                    boolean bl = false;
                    if (n3 > n5) {
                        objectArray2[1] = n2 == 0 ? 1 : n5;
                        bl = true;
                    }
                    if (n3 < -n5) {
                        objectArray2[1] = n2 == 0 ? 1 : -n5;
                        bl = true;
                    }
                    if (n3 == 0) {
                        objectArray2[1] = 1;
                        bl = true;
                    }
                    if (n4 > n5) {
                        objectArray2[2] = n2 == 0 ? -1 : n5;
                        bl = true;
                    }
                    if (n4 < -n5) {
                        objectArray2[2] = n2 == 0 ? -1 : -n5;
                        bl = true;
                    }
                    if (n4 == 0) {
                        objectArray2[2] = -1;
                        bl = true;
                    }
                    if (bl && n2 != 0) {
                        SwingUtilities.invokeLater(new Runnable(){

                            public void run() {
                                JOptionPane.showMessageDialog(InputTab.this.mf, "Entered value out of range. Value has been adjusted.", "JPDFTweak", 2);
                            }
                        });
                    }
                } else if (n2 == 5 && (objectArray = InputTab.this.fileCombination.getRow(n))[5] == null) {
                    objectArray[5] = new IntegerList("0");
                }
            }
        });
        this.updateFileName();
    }

    private void updateFileName() {
        String string = this.inputFiles.size() == 0 ? "(No file selected)" : (this.inputFiles.size() == 1 ? this.inputFiles.get(0).getFile().getName() : "(" + this.inputFiles.size() + " files selected)");
        this.filename.setText(string);
    }

    protected void selectFile() {
        JFileChooser jFileChooser = this.mf.getPdfChooser();
        if (this.multiFiles.isSelected() || this.batchProcessing.isSelected()) {
            jFileChooser.setMultiSelectionEnabled(true);
        }
        if (jFileChooser.showOpenDialog(this.mf) != 0) {
            jFileChooser.setMultiSelectionEnabled(false);
            return;
        }
        File[] fileArray = new File[]{jFileChooser.getSelectedFile()};
        if (this.multiFiles.isSelected() || this.batchProcessing.isSelected()) {
            fileArray = jFileChooser.getSelectedFiles();
            jFileChooser.setMultiSelectionEnabled(false);
        }
        for (File file : fileArray) {
            PdfInputFile pdfInputFile;
            try {
                try {
                    pdfInputFile = new PdfInputFile(file, "");
                }
                catch (BadPasswordException badPasswordException) {
                    try {
                        char[] cArray = PasswordInputBox.askForPassword(this.mf);
                        if (cArray == null) break;
                        String string = new String(cArray);
                        pdfInputFile = new PdfInputFile(file, string);
                    }
                    catch (BadPasswordException badPasswordException2) {
                        JOptionPane.showMessageDialog(this.mf, "Bad owner password", "Cannot open input file", 2);
                        break;
                    }
                }
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
                JOptionPane.showMessageDialog(this.mf, iOException.getMessage(), "Error reading input file", 0);
                return;
            }
            this.inputFiles.add(pdfInputFile);
            if (this.inputFiles.size() == 1) {
                this.mf.setInputFile(pdfInputFile);
            }
            this.filesCombo.addItem(pdfInputFile);
            this.fileCombination.addRow(pdfInputFile, 1, pdfInputFile.getPageCount(), true, true, new IntegerList("0"), false);
        }
        if (!this.multiFiles.isSelected() && !this.batchProcessing.isSelected() && this.inputFiles.size() > 0) {
            this.selectfile.setEnabled(false);
        }
        if (this.inputFiles.size() > 1) {
            if (this.batchProcessing.isSelected()) {
                this.batchProcessing.setEnabled(false);
            } else {
                this.multiFiles.setSelected(true);
                this.multiFiles.setEnabled(false);
            }
        }
        this.updateFileName();
    }

    @Override
    public String getTabName() {
        return "Input";
    }

    @Override
    public void checkRun() throws IOException {
        this.fileCombination.checkRun("input file");
        if (this.inputFiles.size() == 0) {
            throw new IOException("No input file selected");
        }
        if (this.multiFiles.isSelected()) {
            int n = 0;
            boolean bl = this.interleave.isSelected();
            for (PdfPageRange pdfPageRange : this.getPageRanges()) {
                int[] nArray = pdfPageRange.getPages(n);
                if (nArray.length == 0) {
                    throw new IOException("At least one input file page range contains no pages");
                }
                if (bl) continue;
                n += nArray.length;
            }
            if (bl) {
                try {
                    int n2 = Integer.parseInt(this.interleaveSize.getText());
                    if (n2 < 1) {
                        throw new NumberFormatException();
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    throw new IOException("Invalid interleave block size");
                }
            }
        }
    }

    @Override
    public PdfTweak run(PdfTweak pdfTweak) throws DocumentException, IOException {
        if (this.batchProcessing.isSelected()) {
            this.inputFiles.get(this.batchTaskSelection).reopen();
            return new PdfTweak(this.inputFiles.get(this.batchTaskSelection), this.useTempFiles);
        }
        if (this.multiFiles.isSelected()) {
            for (PdfInputFile pdfInputFile : this.inputFiles) {
                pdfInputFile.reopen();
            }
            List<PdfPageRange> list = this.getPageRanges();
            int n = 0;
            if (this.interleave.isSelected()) {
                n = Integer.parseInt(this.interleaveSize.getText());
            }
            return new PdfTweak(this.inputFiles.get(0), list, this.useTempFiles, n);
        }
        this.inputFiles.get(0).reopen();
        return new PdfTweak(this.inputFiles.get(0), this.useTempFiles);
    }

    public List<PdfBookmark> loadBookmarks() {
        if (this.inputFiles.size() == 0) {
            return new ArrayList<PdfBookmark>();
        }
        if (this.multiFiles.isSelected()) {
            List<PdfPageRange> list = this.getPageRanges();
            return PdfBookmark.buildBookmarks(list);
        }
        return this.inputFiles.get(0).getBookmarks(1);
    }

    private List<PdfPageRange> getPageRanges() {
        ArrayList<PdfPageRange> arrayList = new ArrayList<PdfPageRange>();
        for (int i = 0; i < this.fileCombination.getRowCount(); ++i) {
            Object[] objectArray = this.fileCombination.getRow(i);
            if (objectArray[0] == null) continue;
            PdfInputFile pdfInputFile = (PdfInputFile)objectArray[0];
            int n = (Integer)objectArray[1];
            int n2 = (Integer)objectArray[2];
            boolean bl = (Boolean)objectArray[3];
            boolean bl2 = (Boolean)objectArray[4];
            IntegerList integerList = (IntegerList)objectArray[5];
            arrayList.add(new PdfPageRange(pdfInputFile, n, n2, bl, bl2, integerList));
        }
        return arrayList;
    }

    public int getBatchLength() {
        if (this.batchProcessing.isSelected()) {
            return this.inputFiles.size();
        }
        return 1;
    }

    public void selectBatchTask(int n) {
        this.batchTaskSelection = n;
    }

    public void setUseTempFiles(boolean bl) {
        this.useTempFiles = bl;
    }
}

