/*
 * Decompiled with CFR 0.152.
 */
package jpdftweak.gui.tabs;

import com.itextpdf.text.DocumentException;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JColorChooser;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import jpdftweak.core.PdfInputFile;
import jpdftweak.core.PdfTweak;
import jpdftweak.gui.MainForm;
import jpdftweak.gui.TableComponent;
import jpdftweak.gui.tabs.PageNumberTab;
import jpdftweak.gui.tabs.Tab;

public class WatermarkTab
extends Tab {
    private MainForm mainForm;
    private JCheckBox pdfWatermark;
    private JCheckBox textWatermark;
    private JCheckBox pageNumbers;
    private JCheckBox watermarkUseColor;
    private JCheckBox useMask;
    private JCheckBox differentPageNumbers;
    private JTextField filename;
    private JTextField pgnoSize;
    private JTextField pgnoHOffset;
    private JTextField pgnoVOffset;
    private JTextField maskText;
    private JTextField watermarkText;
    private JTextField watermarkSize;
    private JTextField watermarkOpacity;
    private JComboBox pgnoHRef;
    private JComboBox pgnoVRef;
    private JButton fileButton;
    private JButton watermarkColor;
    private JButton load;
    private TableComponent pageNumberRanges;

    public WatermarkTab(MainForm mainForm) {
        super((LayoutManager)new FormLayout("f:p, f:p:g, 80dlu, f:p", "f:p, f:p, 10dlu, f:p, f:p, f:p, f:p, f:p, 10dlu, f:p, f:p, f:p, f:p, f:p, f:p, f:p, f:p:g"));
        this.mainForm = mainForm;
        CellConstraints cellConstraints = new CellConstraints();
        this.pdfWatermark = new JCheckBox("Add first page of PDF as background watermark");
        this.add((Component)this.pdfWatermark, cellConstraints.xyw(1, 1, 4));
        this.pdfWatermark.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                WatermarkTab.this.updatePDFWatermarkEnabled();
            }
        });
        this.add((Component)new JLabel("Filename: "), cellConstraints.xy(1, 2));
        this.filename = new JTextField("");
        this.add((Component)this.filename, cellConstraints.xyw(2, 2, 2));
        this.filename.setEditable(false);
        this.fileButton = new JButton("...");
        this.add((Component)this.fileButton, cellConstraints.xy(4, 2));
        this.fileButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JFileChooser jFileChooser = WatermarkTab.this.mainForm.getPdfChooser();
                if (jFileChooser.showOpenDialog(WatermarkTab.this.mainForm) == 0) {
                    WatermarkTab.this.filename.setText(jFileChooser.getSelectedFile().getAbsolutePath());
                }
            }
        });
        this.add((Component)new JSeparator(), cellConstraints.xyw(1, 3, 4));
        this.textWatermark = new JCheckBox("Add transparent text watermark");
        this.add((Component)this.textWatermark, cellConstraints.xyw(1, 4, 4));
        this.textWatermark.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                WatermarkTab.this.updateTextWatermarkEnabled();
            }
        });
        this.add((Component)new JLabel("Text:"), cellConstraints.xy(1, 5));
        this.watermarkText = new JTextField("Confidential");
        this.add((Component)this.watermarkText, cellConstraints.xyw(2, 5, 3));
        this.add((Component)new JLabel("Font size:"), cellConstraints.xy(1, 6));
        this.watermarkSize = new JTextField("100");
        this.add((Component)this.watermarkSize, cellConstraints.xyw(2, 6, 3));
        this.add((Component)new JLabel("Opacity:"), cellConstraints.xy(1, 7));
        this.watermarkOpacity = new JTextField("0.25");
        this.add((Component)this.watermarkOpacity, cellConstraints.xyw(2, 7, 3));
        this.watermarkUseColor = new JCheckBox("Color:");
        this.add((Component)this.watermarkUseColor, cellConstraints.xy(1, 8));
        this.watermarkColor = new JButton("");
        this.add((Component)this.watermarkColor, cellConstraints.xyw(2, 8, 3));
        this.watermarkColor.setBackground(Color.BLACK);
        this.watermarkColor.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Color color = JColorChooser.showDialog(WatermarkTab.this.mainForm, "Select Color", WatermarkTab.this.watermarkColor.getBackground());
                if (color != null) {
                    WatermarkTab.this.watermarkColor.setBackground(color);
                }
            }
        });
        this.add((Component)new JSeparator(), cellConstraints.xyw(1, 9, 4));
        this.pageNumbers = new JCheckBox("Add page numbers");
        this.add((Component)this.pageNumbers, cellConstraints.xyw(1, 10, 4));
        ActionListener actionListener = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                WatermarkTab.this.updatePageNumbersEnabled();
            }
        };
        this.pageNumbers.addActionListener(actionListener);
        this.add((Component)new JLabel("Font size:"), cellConstraints.xy(1, 11));
        this.pgnoSize = new JTextField("10");
        this.add((Component)this.pgnoSize, cellConstraints.xyw(2, 11, 3));
        this.add((Component)new JLabel("Horizontal:"), cellConstraints.xy(1, 12));
        this.pgnoHOffset = new JTextField("25");
        this.add((Component)this.pgnoHOffset, cellConstraints.xy(2, 12));
        this.pgnoHRef = new JComboBox<String>(new String[]{"PS points from left margin", "PS points from center", "PS points from right margin", "PS points from inner margin", "PS points from outer margin"});
        this.add(this.pgnoHRef, cellConstraints.xyw(3, 12, 2));
        this.add((Component)new JLabel("Vertical:"), cellConstraints.xy(1, 13));
        this.pgnoVOffset = new JTextField("25");
        this.add((Component)this.pgnoVOffset, cellConstraints.xy(2, 13));
        this.pgnoVRef = new JComboBox<String>(new String[]{"PS points from bottom margin", "PS points from center", "PS points from top margin"});
        this.add(this.pgnoVRef, cellConstraints.xyw(3, 13, 2));
        this.useMask = new JCheckBox("Mask: ");
        this.add((Component)this.useMask, cellConstraints.xy(1, 14));
        this.useMask.addActionListener(actionListener);
        this.maskText = new JTextField("Page %1$d of %2$d");
        this.add((Component)this.maskText, cellConstraints.xyw(2, 14, 3));
        this.add((Component)new JLabel("<html><tt>%1$d</tt> - page index, <tt>%2$d</tt> - page count, <tt>%3$d</tt> - logical page number, <tt>%4$s</tt> page number text"), cellConstraints.xyw(2, 15, 3));
        this.differentPageNumbers = new JCheckBox("Use different page numbers");
        this.add((Component)this.differentPageNumbers, cellConstraints.xyw(1, 16, 2));
        this.differentPageNumbers.addActionListener(actionListener);
        this.load = new JButton("Load from document");
        this.add((Component)this.load, cellConstraints.xyw(3, 16, 2));
        this.pageNumberRanges = PageNumberTab.buildPageNumberRanges();
        this.add((Component)this.pageNumberRanges, cellConstraints.xyw(1, 17, 4));
        this.load.addActionListener(new PageNumberTab.PageNumberLoadAction(mainForm, this.pageNumberRanges));
        this.pageNumberRanges.getScrollPane().setPreferredSize(new Dimension(750, 100));
        this.updatePDFWatermarkEnabled();
        this.updateTextWatermarkEnabled();
        this.updatePageNumbersEnabled();
    }

    protected void updatePDFWatermarkEnabled() {
        this.fileButton.setEnabled(this.pdfWatermark.isSelected());
        this.filename.setEnabled(this.pdfWatermark.isSelected());
    }

    protected void updateTextWatermarkEnabled() {
        this.watermarkText.setEnabled(this.textWatermark.isSelected());
        this.watermarkSize.setEnabled(this.textWatermark.isSelected());
        this.watermarkOpacity.setEnabled(this.textWatermark.isSelected());
        this.watermarkUseColor.setEnabled(this.textWatermark.isSelected());
        this.watermarkColor.setEnabled(this.textWatermark.isSelected());
    }

    private void updatePageNumbersEnabled() {
        this.pgnoSize.setEnabled(this.pageNumbers.isSelected());
        this.pgnoHOffset.setEnabled(this.pageNumbers.isSelected());
        this.pgnoVOffset.setEnabled(this.pageNumbers.isSelected());
        this.pgnoHRef.setEnabled(this.pageNumbers.isSelected());
        this.pgnoVRef.setEnabled(this.pageNumbers.isSelected());
        this.useMask.setEnabled(this.pageNumbers.isSelected());
        this.maskText.setEnabled(this.pageNumbers.isSelected() && this.useMask.isSelected());
        this.differentPageNumbers.setEnabled(this.pageNumbers.isSelected());
        this.load.setEnabled(this.pageNumbers.isSelected() && this.differentPageNumbers.isSelected());
        this.pageNumberRanges.setEnabled(this.pageNumbers.isSelected() && this.differentPageNumbers.isSelected());
    }

    public String getTabName() {
        return "Watermark";
    }

    public void checkRun() throws IOException {
        this.pageNumberRanges.checkRun("different page number");
    }

    public PdfTweak run(PdfTweak pdfTweak) throws IOException, DocumentException {
        boolean bl = false;
        PdfInputFile pdfInputFile = null;
        String string = null;
        int n = 0;
        int n2 = 0;
        int n3 = -1;
        boolean bl2 = false;
        float f = 0.0f;
        float f2 = 0.0f;
        float f3 = 0.0f;
        Color color = null;
        String string2 = null;
        try {
            if (this.pdfWatermark.isSelected()) {
                bl = true;
                pdfInputFile = new PdfInputFile(new File(this.filename.getText()), "");
            }
            if (this.textWatermark.isSelected()) {
                bl = true;
                string = this.watermarkText.getText();
                n = Integer.parseInt(this.watermarkSize.getText());
                f = Float.parseFloat(this.watermarkOpacity.getText());
                if (n == 0) {
                    throw new IOException("Font size may not be zero");
                }
            }
            if (this.pageNumbers.isSelected()) {
                if (this.differentPageNumbers.isSelected()) {
                    PageNumberTab.updatePageNumberRanges(pdfTweak, this.pageNumberRanges);
                    string2 = "%4$s";
                }
                bl = true;
                int n4 = this.pgnoHRef.getSelectedIndex();
                if (n4 > 2) {
                    n4 = n4 * 2 - 6;
                    bl2 = true;
                }
                n3 = this.pgnoVRef.getSelectedIndex() * 3 + n4;
                n2 = Integer.parseInt(this.pgnoSize.getText());
                f2 = Float.parseFloat(this.pgnoHOffset.getText());
                f3 = Float.parseFloat(this.pgnoVOffset.getText());
                if (n2 == 0) {
                    throw new IOException("Font size may not be zero");
                }
            }
            if (this.watermarkUseColor.isSelected()) {
                color = this.watermarkColor.getBackground();
            }
            if (this.useMask.isSelected()) {
                string2 = this.maskText.getText();
            }
        }
        catch (NumberFormatException numberFormatException) {
            throw new IOException("Unparsable value: " + numberFormatException.getMessage());
        }
        if (bl) {
            pdfTweak.addWatermark(pdfInputFile, string, n, f, color, n3, bl2, n2, f2, f3, string2);
        }
        if (pdfInputFile != null) {
            pdfInputFile.close();
        }
        return pdfTweak;
    }
}

