/*
 * Decompiled with CFR 0.152.
 */
package com.jmupdf.util;

import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.HeadlessException;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.PixelGrabber;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import javax.swing.ImageIcon;

public class Util {
    public static boolean hasAlpha(Image image) {
        if (image instanceof BufferedImage) {
            BufferedImage bimage = (BufferedImage)image;
            return bimage.getColorModel().hasAlpha();
        }
        PixelGrabber pg = new PixelGrabber(image, 0, 0, 1, 1, false);
        try {
            pg.grabPixels();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        ColorModel cm = pg.getColorModel();
        return cm.hasAlpha();
    }

    public static BufferedImage toBufferedImage(Image image) {
        if (image instanceof BufferedImage) {
            return (BufferedImage)image;
        }
        image = new ImageIcon(image).getImage();
        boolean hasAlpha = Util.hasAlpha(image);
        BufferedImage bimage = null;
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        try {
            int transparency = 1;
            if (hasAlpha) {
                transparency = 2;
            }
            GraphicsDevice gs = ge.getDefaultScreenDevice();
            GraphicsConfiguration gc = gs.getDefaultConfiguration();
            bimage = gc.createCompatibleImage(image.getWidth(null), image.getHeight(null), transparency);
        }
        catch (HeadlessException transparency) {
            // empty catch block
        }
        if (bimage == null) {
            int type = 1;
            if (hasAlpha) {
                type = 2;
            }
            bimage = new BufferedImage(image.getWidth(null), image.getHeight(null), type);
        }
        Graphics2D g = bimage.createGraphics();
        g.drawImage(image, 0, 0, null);
        g.dispose();
        return bimage;
    }

    public static synchronized File createUniqueDirectory(File rootDir, String seed) throws IOException {
        int index = seed.lastIndexOf(46);
        if (index > 0) {
            seed = seed.substring(0, index);
        }
        File result = null;
        int count = 0;
        while (result == null) {
            String name = String.valueOf(seed) + "." + count + ".tmp";
            File file = new File(rootDir, name);
            if (!file.exists()) {
                file.mkdirs();
                result = file;
            }
            ++count;
        }
        return result;
    }

    public static final byte[] load(String fileName) {
        try {
            FileInputStream fin = new FileInputStream(fileName);
            return Util.load(fin);
        }
        catch (Exception e) {
            return new byte[0];
        }
    }

    public static final byte[] load(File file) {
        try {
            FileInputStream fin = new FileInputStream(file);
            return Util.load(fin);
        }
        catch (Exception e) {
            return new byte[0];
        }
    }

    public static final byte[] load(FileInputStream fin) {
        byte[] readBuf = new byte[524288];
        try {
            ByteArrayOutputStream bout = new ByteArrayOutputStream();
            int readCnt = fin.read(readBuf);
            while (readCnt > 0) {
                bout.write(readBuf, 0, readCnt);
                readCnt = fin.read(readBuf);
            }
            fin.close();
            return bout.toByteArray();
        }
        catch (Exception e) {
            return new byte[0];
        }
    }
}

