/*
 * Copyright (c) 1995, 1996 Sun Microsystems, Inc. All Rights Reserved.
 *
 * Permission to use, copy, modify, and distribute this software
 * and its documentation for NON-COMMERCIAL purposes and without
 * fee is hereby granted provided that this copyright notice
 * appears in all copies. Please refer to the file "copyright.html"
 * for further important copyright and licensing information.
 *
 * SUN MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF
 * THE SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED
 * TO THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A
 * PARTICULAR PURPOSE, OR NON-INFRINGEMENT. SUN SHALL NOT BE LIABLE FOR
 * ANY DAMAGES SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR
 * DISTRIBUTING THIS SOFTWARE OR ITS DERIVATIVES.
 */
import java.awt.*;

class FlagCanvas extends Canvas {

    private boolean selected = false;

    Container pappy;
    Image image;
    boolean trueSizeKnown = false;
    Dimension minSize;
    int w, h;

    public FlagCanvas(Image image, IntlWindow parent, 
		              int initialWidth, int initialHeight) {
	if (image == null) {
	    System.err.println("Canvas got invalid image object!");
	    return;
	}

	this.image = image;
        pappy = parent;

	w = initialWidth+2;
	h = initialHeight+2;

	minSize = new Dimension(w,h);
    }

    public boolean mouseDown(Event evt, int x, int y) {
	((IntlWindow)pappy).selectFlag(this);
	return true;
    }

    public boolean isSelected() {
	return selected;
    }

    public void setSelected(boolean check) {
	selected = check;
	repaint();
    }

    public Dimension preferredSize() {
 	return minimumSize();
    }

    public synchronized Dimension minimumSize() {
	return minSize;
    }

    public void paint (Graphics g) {
	if (image != null) {
	    if (!trueSizeKnown) {
	        int imageWidth = image.getWidth(this);
	        int imageHeight = image.getHeight(this);

	        if ((imageWidth > 0) && (imageHeight > 0)) {
		    trueSizeKnown = true;

		    //Component-initiated resizing.
		    w = imageWidth + 2;
		    h = imageHeight + 2;
		    minSize = new Dimension(w,h);
		    resize(w, h);
		    pappy.validate();
	        }
	    }

	    g.drawImage(image, 1, 1, this);
	    if (selected)
	        g.draw3DRect(0, 0, w-1, h-1, true);
	}
    }
}
