/*
 * Copyright (c) 1995, 1996 Sun Microsystems, Inc. All Rights Reserved.
 *
 * Permission to use, copy, modify, and distribute this software
 * and its documentation for NON-COMMERCIAL purposes and without
 * fee is hereby granted provided that this copyright notice
 * appears in all copies. Please refer to the file "copyright.html"
 * for further important copyright and licensing information.
 *
 * SUN MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF
 * THE SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED
 * TO THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A
 * PARTICULAR PURPOSE, OR NON-INFRINGEMENT. SUN SHALL NOT BE LIABLE FOR
 * ANY DAMAGES SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR
 * DISTRIBUTING THIS SOFTWARE OR ITS DERIVATIVES.
 */
import java.io.*;

class CheckedRAFTest {
    public static void main(String[] args) {

        Adler32 inChecker = new Adler32();
        Adler32 outChecker = new Adler32();
        CheckedDataInput cis = null;
        CheckedDataOutput cos = null;

        try {
            cis = new CheckedDataInput(new RandomAccessFile("farrago.txt", "r"), inChecker);
            cos = new CheckedDataOutput(new RandomAccessFile("outagain.txt", "rw"), outChecker);
        } catch (FileNotFoundException e) {
            System.err.println("CheckedIOTest: " + e);
            System.exit(-1);
        } catch (IOException e) {
            System.err.println("CheckedIOTest: " + e);
            System.exit(-1);
        }

        try {
            boolean EOF = false;

            while (!EOF) {
                try {
                    int c = cis.readByte();
                    cos.write(c);
                } catch (EOFException e) {
                    EOF = true;
                }
            }

            System.out.println("Input stream check sum: " + cis.getChecksum().getValue());
            System.out.println("Output stream check sum: " + cos.getChecksum().getValue());
        } catch (IOException e) {
            System.err.println("CheckedIOTest: " + e);
        }
    }
}
