/*
 * Copyright (c) 1995, 1996 Sun Microsystems, Inc. All Rights Reserved.
 *
 * Permission to use, copy, modify, and distribute this software
 * and its documentation for NON-COMMERCIAL purposes and without
 * fee is hereby granted provided that this copyright notice
 * appears in all copies. Please refer to the file "copyright.html"
 * for further important copyright and licensing information.
 *
 * SUN MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF
 * THE SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED
 * TO THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A
 * PARTICULAR PURPOSE, OR NON-INFRINGEMENT. SUN SHALL NOT BE LIABLE FOR
 * ANY DAMAGES SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR
 * DISTRIBUTING THIS SOFTWARE OR ITS DERIVATIVES.
 */
import java.io.*;

class WriteReversedThread extends Thread {
    PrintStream ps;
    DataInputStream dis;

    WriteReversedThread(PrintStream ps, DataInputStream dis) {
        this.ps = ps;
        this.dis = dis;
    }

    public void run() {
        if (ps != null && dis != null) {
            try {
                String input;
                while ((input = dis.readLine()) != null) {
                    ps.println(reverseIt(input));
                    ps.flush();
                }
                ps.close();
            } catch (IOException e) {
                System.out.println("WriteReversedThread run: " + e);
            }
        }
    }

    protected void finalize() {
        try {
            if (ps != null) {
                ps.close();
                ps = null;
            }
            if (dis != null) {
                dis.close();
                dis = null;
            }
        } catch (IOException e) {
            System.out.println("WriteReversedThread finalize: " + e);
        }
    }

    private String reverseIt(String source) {
        int i, len = source.length();
        StringBuffer dest = new StringBuffer(len);

        for (i = (len - 1); i >= 0; i--) {
            dest.append(source.charAt(i));
        }
        return dest.toString();
    }
}
