/*
 * Copyright (c) 1995, 1996 Sun Microsystems, Inc. All Rights Reserved.
 *
 * Permission to use, copy, modify, and distribute this software
 * and its documentation for NON-COMMERCIAL purposes and without
 * fee is hereby granted provided that this copyright notice
 * appears in all copies. Please refer to the file "copyright.html"
 * for further important copyright and licensing information.
 *
 * SUN MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF
 * THE SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED
 * TO THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A
 * PARTICULAR PURPOSE, OR NON-INFRINGEMENT. SUN SHALL NOT BE LIABLE FOR
 * ANY DAMAGES SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR
 * DISTRIBUTING THIS SOFTWARE OR ITS DERIVATIVES.
 */
import java.awt.*;
import java.applet.Applet;

public class ChoiceDemo extends Applet {
    Choice choice; //pop-up list of choices
    Label label;

    public void init() {

        choice = new Choice();
        choice.addItem("ichi");
        choice.addItem("ni");
        choice.addItem("san");
        choice.addItem("yon");
        label = new Label();
        setLabelText(choice.getSelectedIndex(), choice.getSelectedItem());

        //Add components to the Applet. 
        add(choice);
        add(label);

        validate();
    }

    void setLabelText(int num, String text) {
        label.setText("Item #" + num + " selected. "
                    + "Text = \"" + text + "\".");
    }
        
    public boolean action(Event e, Object arg) {
        if (e.target instanceof Choice) {
            setLabelText(choice.getSelectedIndex(), (String)arg);
            return true;
        }
        return false;
    }
}
