/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.text.html;

import java.util.StringTokenizer;
import javax.swing.SizeRequirements;
import javax.swing.text.AttributeSet;
import javax.swing.text.BoxView;
import javax.swing.text.Element;
import javax.swing.text.View;
import javax.swing.text.html.HTML;
import javax.swing.text.html.NoFramesView;

class FrameSetView
extends BoxView {
    String[] children;
    int[] percentChildren;
    int[] absoluteChildren;
    int[] relativeChildren;
    int percentTotals;
    int absoluteTotals;
    int relativeTotals;

    public FrameSetView(Element element, int n) {
        super(element, n);
        this.children = n == 1 ? this.parseRowColSpec(HTML.Attribute.ROWS) : this.parseRowColSpec(HTML.Attribute.COLS);
        this.init();
    }

    protected SizeRequirements[] getChildRequests(int n, int n2) {
        int[] nArray = new int[this.children.length];
        this.spread(n, nArray);
        int n3 = this.getViewCount();
        SizeRequirements[] sizeRequirementsArray = new SizeRequirements[n3];
        int n4 = 0;
        while (n4 < n3) {
            View view = this.getView(n4);
            if (!(view instanceof NoFramesView)) {
                sizeRequirementsArray[n4] = new SizeRequirements((int)view.getMinimumSpan(n2), nArray[n4], (int)view.getMaximumSpan(n2), 0.5f);
            } else {
                int n5 = (int)view.getMinimumSpan(n2);
                int n6 = (int)view.getPreferredSpan(n2);
                int n7 = (int)view.getMaximumSpan(n2);
                float f = view.getAlignment(n2);
                sizeRequirementsArray[n4] = new SizeRequirements(n5, n6, n7, f);
            }
            ++n4;
        }
        return sizeRequirementsArray;
    }

    private void init() {
        this.percentChildren = new int[this.children.length];
        this.relativeChildren = new int[this.children.length];
        this.absoluteChildren = new int[this.children.length];
        int n = 0;
        while (n < this.children.length) {
            this.percentChildren[n] = -1;
            this.relativeChildren[n] = -1;
            this.absoluteChildren[n] = -1;
            if (this.children[n].endsWith("*")) {
                if (this.children[n].length() > 1) {
                    this.relativeChildren[n] = Integer.parseInt(this.children[n].substring(0, this.children[n].length() - 1));
                    this.relativeTotals += this.relativeChildren[n];
                } else {
                    this.relativeChildren[n] = 1;
                    ++this.relativeTotals;
                }
            } else if (this.children[n].indexOf(37) != -1) {
                this.percentChildren[n] = this.parseDigits(this.children[n]);
                this.percentTotals += this.percentChildren[n];
            } else {
                this.absoluteChildren[n] = Integer.parseInt(this.children[n]);
            }
            ++n;
        }
        if (this.percentTotals > 100) {
            int n2 = 0;
            while (n2 < this.percentChildren.length) {
                if (this.percentChildren[n2] > 0) {
                    this.percentChildren[n2] = this.percentChildren[n2] * 100 / this.percentTotals;
                }
                ++n2;
            }
            this.percentTotals = 100;
        }
    }

    protected void layoutMajorAxis(int n, int n2, int[] nArray, int[] nArray2) {
        SizeRequirements.calculateTiledPositions(n, null, this.getChildRequests(n, n2), nArray, nArray2);
    }

    private int parseDigits(String string) {
        int n = 0;
        int n2 = 0;
        while (n2 < string.length()) {
            char c = string.charAt(n2);
            if (Character.isDigit(c)) {
                n = n * 10 + Character.digit(c, 10);
            }
            ++n2;
        }
        return n;
    }

    private String[] parseRowColSpec(HTML.Attribute attribute) {
        AttributeSet attributeSet = this.getElement().getAttributes();
        String string = "*";
        if (attributeSet != null && attributeSet.getAttribute(attribute) != null) {
            string = (String)attributeSet.getAttribute(attribute);
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        int n = stringTokenizer.countTokens();
        String[] stringArray = new String[n];
        int n2 = 0;
        while (n2 < n) {
            stringArray[n2] = stringTokenizer.nextToken().trim();
            if (stringArray[n2].equals("100%")) {
                stringArray[n2] = "*";
            }
            ++n2;
        }
        return stringArray;
    }

    public void setParent(View view) {
        super.setParent(view);
        if (view == null) {
            int n = 0;
            while (n < this.getViewCount()) {
                View view2 = this.getView(n);
                view2.setParent(null);
                ++n;
            }
        }
    }

    private void spread(int n, int[] nArray) {
        block14: {
            int n2;
            block13: {
                if (n == 0) {
                    return;
                }
                int n3 = 0;
                n2 = n;
                int n4 = 0;
                while (n4 < nArray.length) {
                    if (this.absoluteChildren[n4] > 0) {
                        nArray[n4] = this.absoluteChildren[n4];
                        n2 -= nArray[n4];
                    }
                    ++n4;
                }
                n3 = n2;
                int n5 = 0;
                while (n5 < nArray.length) {
                    if (this.percentChildren[n5] > 0 && n3 > 0) {
                        nArray[n5] = this.percentChildren[n5] * n3 / 100;
                        n2 -= nArray[n5];
                    } else if (this.percentChildren[n5] > 0 && n3 <= 0) {
                        nArray[n5] = n / nArray.length;
                        n2 -= nArray[n5];
                    }
                    ++n5;
                }
                if (n2 <= 0 || this.relativeTotals <= 0) break block13;
                int n6 = 0;
                while (n6 < nArray.length) {
                    if (this.relativeChildren[n6] > 0) {
                        nArray[n6] = n2 * this.relativeChildren[n6] / this.relativeTotals;
                    }
                    ++n6;
                }
                break block14;
            }
            if (n2 <= 0) break block14;
            float f = n - n2;
            float[] fArray = new float[nArray.length];
            n2 = n;
            int n7 = 0;
            while (n7 < nArray.length) {
                fArray[n7] = (float)nArray[n7] / f * 100.0f;
                nArray[n7] = (int)((float)n * fArray[n7] / 100.0f);
                n2 -= nArray[n7];
                ++n7;
            }
            int n8 = 0;
            while (n2 != 0) {
                if (n2 < 0) {
                    int n9 = n8++;
                    nArray[n9] = nArray[n9] - 1;
                    ++n2;
                } else {
                    int n10 = n8++;
                    nArray[n10] = nArray[n10] + 1;
                    --n2;
                }
                if (n8 != nArray.length) continue;
                n8 = 0;
            }
        }
    }
}

