/*
 * Decompiled with CFR 0.152.
 */
import java.io.IOException;
import java.io.InputStream;
import java.util.Hashtable;
import java.util.Properties;
import java.util.StringTokenizer;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.metal.DefaultMetalTheme;

public class PropertiesMetalTheme
extends DefaultMetalTheme {
    private String name = "Custom Theme";
    private ColorUIResource primary1;
    private ColorUIResource primary2;
    private ColorUIResource primary3;
    private ColorUIResource secondary1;
    private ColorUIResource secondary2;
    private ColorUIResource secondary3;
    private ColorUIResource black;
    private ColorUIResource white;

    public PropertiesMetalTheme(InputStream inputStream) {
        this.initColors();
        this.loadProperties(inputStream);
    }

    private void initColors() {
        this.primary1 = super.getPrimary1();
        this.primary2 = super.getPrimary2();
        this.primary3 = super.getPrimary3();
        this.secondary1 = super.getSecondary1();
        this.secondary2 = super.getSecondary2();
        this.secondary3 = super.getSecondary3();
        this.black = super.getBlack();
        this.white = super.getWhite();
    }

    private void loadProperties(InputStream inputStream) {
        Properties properties = new Properties();
        try {
            properties.load(inputStream);
        }
        catch (IOException iOException) {
            System.out.println(iOException);
        }
        Object v = ((Hashtable)properties).get("name");
        if (v != null) {
            this.name = v.toString();
        }
        Object object = null;
        object = ((Hashtable)properties).get("primary1");
        if (object != null) {
            this.primary1 = this.parseColor(object.toString());
        }
        if ((object = ((Hashtable)properties).get("primary2")) != null) {
            this.primary2 = this.parseColor(object.toString());
        }
        if ((object = ((Hashtable)properties).get("primary3")) != null) {
            this.primary3 = this.parseColor(object.toString());
        }
        if ((object = ((Hashtable)properties).get("secondary1")) != null) {
            this.secondary1 = this.parseColor(object.toString());
        }
        if ((object = ((Hashtable)properties).get("secondary2")) != null) {
            this.secondary2 = this.parseColor(object.toString());
        }
        if ((object = ((Hashtable)properties).get("secondary3")) != null) {
            this.secondary3 = this.parseColor(object.toString());
        }
        if ((object = ((Hashtable)properties).get("black")) != null) {
            this.black = this.parseColor(object.toString());
        }
        if ((object = ((Hashtable)properties).get("white")) != null) {
            this.white = this.parseColor(object.toString());
        }
    }

    public String getName() {
        return this.name;
    }

    protected ColorUIResource getPrimary1() {
        return this.primary1;
    }

    protected ColorUIResource getPrimary2() {
        return this.primary2;
    }

    protected ColorUIResource getPrimary3() {
        return this.primary3;
    }

    protected ColorUIResource getSecondary1() {
        return this.secondary1;
    }

    protected ColorUIResource getSecondary2() {
        return this.secondary2;
    }

    protected ColorUIResource getSecondary3() {
        return this.secondary3;
    }

    protected ColorUIResource getBlack() {
        return this.black;
    }

    protected ColorUIResource getWhite() {
        return this.white;
    }

    private ColorUIResource parseColor(String string) {
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        try {
            StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
            n = Integer.parseInt(stringTokenizer.nextToken());
            n2 = Integer.parseInt(stringTokenizer.nextToken());
            n3 = Integer.parseInt(stringTokenizer.nextToken());
        }
        catch (Exception exception) {
            System.out.println(exception);
            System.out.println("Couldn't parse color :" + string);
        }
        return new ColorUIResource(n, n2, n3);
    }
}

