/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;

public class FileChooserDemo
extends JPanel
implements ActionListener {
    static JFrame frame;
    static String metal;
    static String metalClassName;
    static String motif;
    static String motifClassName;
    static String windows;
    static String windowsClassName;
    JButton button;
    JCheckBox useFileViewButton;
    JCheckBox accessoryButton;
    JCheckBox hiddenButton;
    JCheckBox showFullDescriptionButton;
    JButton noAllFilesFilterButton;
    JButton yesAllFilesFilterButton;
    JRadioButton addFiltersButton;
    JRadioButton defaultFiltersButton;
    JRadioButton openButton;
    JRadioButton saveButton;
    JRadioButton customButton;
    JRadioButton metalButton;
    JRadioButton motifButton;
    JRadioButton windowsButton;
    JRadioButton justFilesButton;
    JRadioButton justDirectoriesButton;
    JRadioButton bothFilesAndDirectoriesButton;
    JTextField customField;
    ExampleFileFilter jpgFilter;
    ExampleFileFilter gifFilter;
    ExampleFileFilter bothFilter;
    ExampleFileView fileView;
    JPanel buttonPanel;
    public static final Dimension hpad10;
    public static final Dimension vpad10;
    FilePreviewer previewer;
    JFileChooser chooser;

    public FileChooserDemo() {
        this.setLayout(new BoxLayout(this, 1));
        this.chooser = new JFileChooser();
        this.previewer = new FilePreviewer(this.chooser);
        this.chooser.setAccessory(this.previewer);
        this.jpgFilter = new ExampleFileFilter("jpg", "JPEG Compressed Image Files");
        this.gifFilter = new ExampleFileFilter("gif", "GIF Image Files");
        this.bothFilter = new ExampleFileFilter(new String[]{"jpg", "gif"}, "JPEG and GIF Image Files");
        this.fileView = new ExampleFileView();
        this.fileView.putIcon("jpg", new ImageIcon("images/jpgIcon.jpg"));
        this.fileView.putIcon("gif", new ImageIcon("images/gifIcon.gif"));
        this.chooser.setAccessory(this.previewer);
        this.chooser.setFileView(this.fileView);
        OptionListener optionListener = new OptionListener();
        this.openButton = new JRadioButton("Open");
        this.openButton.setSelected(true);
        this.openButton.addActionListener(optionListener);
        this.saveButton = new JRadioButton("Save");
        this.saveButton.addActionListener(optionListener);
        this.customButton = new JRadioButton("Custom");
        this.customButton.addActionListener(optionListener);
        this.customField = new JTextField("Doit");
        this.customField.setAlignmentY(0.0f);
        this.customField.setEnabled(false);
        this.customField.addActionListener(optionListener);
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.openButton);
        buttonGroup.add(this.saveButton);
        buttonGroup.add(this.customButton);
        this.noAllFilesFilterButton = new JButton("Remove \"All Files\" Filter");
        this.noAllFilesFilterButton.addActionListener(optionListener);
        this.yesAllFilesFilterButton = new JButton("Add \"All Files\" Filter");
        this.yesAllFilesFilterButton.addActionListener(optionListener);
        this.defaultFiltersButton = new JRadioButton("Default Filtering");
        this.defaultFiltersButton.setSelected(true);
        this.defaultFiltersButton.addActionListener(optionListener);
        this.addFiltersButton = new JRadioButton("Add JPG and GIF Filters");
        this.addFiltersButton.addActionListener(optionListener);
        ButtonGroup buttonGroup2 = new ButtonGroup();
        buttonGroup2.add(this.addFiltersButton);
        buttonGroup2.add(this.defaultFiltersButton);
        this.accessoryButton = new JCheckBox("Show Preview");
        this.accessoryButton.addActionListener(optionListener);
        this.accessoryButton.setSelected(true);
        this.hiddenButton = new JCheckBox("Show Hidden Files");
        this.hiddenButton.addActionListener(optionListener);
        this.showFullDescriptionButton = new JCheckBox("Show Extensions");
        this.showFullDescriptionButton.addActionListener(optionListener);
        this.showFullDescriptionButton.setSelected(true);
        this.useFileViewButton = new JCheckBox("Use FileView");
        this.useFileViewButton.addActionListener(optionListener);
        this.useFileViewButton.setSelected(true);
        ButtonGroup buttonGroup3 = new ButtonGroup();
        this.justFilesButton = new JRadioButton("Just Select Files");
        this.justFilesButton.setSelected(true);
        buttonGroup3.add(this.justFilesButton);
        this.justFilesButton.addActionListener(optionListener);
        this.justDirectoriesButton = new JRadioButton("Just Select Directories");
        buttonGroup3.add(this.justDirectoriesButton);
        this.justDirectoriesButton.addActionListener(optionListener);
        this.bothFilesAndDirectoriesButton = new JRadioButton("Select Files or Directories");
        buttonGroup3.add(this.bothFilesAndDirectoriesButton);
        this.bothFilesAndDirectoriesButton.addActionListener(optionListener);
        this.button = new JButton("Show FileChooser");
        this.button.addActionListener(this);
        this.button.setMnemonic('s');
        this.metalButton = new JRadioButton(metal);
        this.metalButton.setMnemonic('o');
        this.metalButton.setActionCommand(metalClassName);
        this.motifButton = new JRadioButton(motif);
        this.motifButton.setMnemonic('m');
        this.motifButton.setActionCommand(motifClassName);
        this.windowsButton = new JRadioButton(windows);
        this.windowsButton.setMnemonic('w');
        this.windowsButton.setActionCommand(windowsClassName);
        ButtonGroup buttonGroup4 = new ButtonGroup();
        buttonGroup4.add(this.metalButton);
        buttonGroup4.add(this.motifButton);
        buttonGroup4.add(this.windowsButton);
        this.metalButton.addActionListener(optionListener);
        this.motifButton.addActionListener(optionListener);
        this.windowsButton.addActionListener(optionListener);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 0));
        jPanel.add(Box.createRigidArea(hpad10));
        jPanel.add(this.openButton);
        jPanel.add(Box.createRigidArea(hpad10));
        jPanel.add(this.saveButton);
        jPanel.add(Box.createRigidArea(hpad10));
        jPanel.add(this.customButton);
        jPanel.add(this.customField);
        jPanel.add(Box.createRigidArea(hpad10));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BoxLayout(jPanel2, 0));
        jPanel2.add(Box.createRigidArea(hpad10));
        jPanel2.add(this.noAllFilesFilterButton);
        jPanel2.add(Box.createRigidArea(hpad10));
        jPanel2.add(this.yesAllFilesFilterButton);
        jPanel2.add(Box.createRigidArea(hpad10));
        jPanel2.add(this.defaultFiltersButton);
        jPanel2.add(Box.createRigidArea(hpad10));
        jPanel2.add(this.addFiltersButton);
        jPanel2.add(Box.createRigidArea(hpad10));
        jPanel2.add(this.accessoryButton);
        jPanel2.add(Box.createRigidArea(hpad10));
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new BoxLayout(jPanel3, 0));
        jPanel3.add(Box.createRigidArea(hpad10));
        jPanel3.add(this.hiddenButton);
        jPanel3.add(Box.createRigidArea(hpad10));
        jPanel3.add(this.showFullDescriptionButton);
        jPanel3.add(Box.createRigidArea(hpad10));
        jPanel3.add(this.useFileViewButton);
        jPanel3.add(Box.createRigidArea(hpad10));
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout(new BoxLayout(jPanel4, 0));
        jPanel4.add(Box.createRigidArea(hpad10));
        jPanel4.add(this.justFilesButton);
        jPanel4.add(Box.createRigidArea(hpad10));
        jPanel4.add(this.justDirectoriesButton);
        jPanel4.add(Box.createRigidArea(hpad10));
        jPanel4.add(this.bothFilesAndDirectoriesButton);
        jPanel4.add(Box.createRigidArea(hpad10));
        JPanel jPanel5 = new JPanel();
        jPanel5.setLayout(new BoxLayout(jPanel5, 0));
        jPanel5.add(Box.createRigidArea(hpad10));
        jPanel5.add(this.button);
        jPanel5.add(Box.createRigidArea(hpad10));
        jPanel5.add(this.metalButton);
        jPanel5.add(Box.createRigidArea(hpad10));
        jPanel5.add(this.motifButton);
        jPanel5.add(Box.createRigidArea(hpad10));
        jPanel5.add(this.windowsButton);
        jPanel5.add(Box.createRigidArea(hpad10));
        this.add(Box.createRigidArea(vpad10));
        this.add(jPanel);
        this.add(Box.createRigidArea(vpad10));
        this.add(jPanel2);
        this.add(Box.createRigidArea(vpad10));
        this.add(jPanel3);
        this.add(Box.createRigidArea(vpad10));
        this.add(jPanel4);
        this.add(Box.createRigidArea(vpad10));
        this.add(Box.createRigidArea(vpad10));
        this.add(jPanel5);
        this.add(Box.createRigidArea(vpad10));
    }

    public void actionPerformed(ActionEvent actionEvent) {
        File file;
        int n = this.chooser.showDialog(frame, null);
        if (n == 0 && (file = this.chooser.getSelectedFile()) != null) {
            if (file.isDirectory()) {
                JOptionPane.showMessageDialog(frame, "You chose this directory: " + this.chooser.getSelectedFile().getAbsolutePath());
                return;
            }
            JOptionPane.showMessageDialog(frame, "You chose this file: " + this.chooser.getSelectedFile().getAbsolutePath());
            return;
        }
        JOptionPane.showMessageDialog(frame, "No file was chosen.");
    }

    public void updateState() {
        String string = UIManager.getLookAndFeel().getClass().getName();
        if (string.indexOf(metal) >= 0) {
            this.metalButton.setSelected(true);
            return;
        }
        if (string.indexOf(windows) >= 0) {
            this.windowsButton.setSelected(true);
            return;
        }
        if (string.indexOf(motif) >= 0) {
            this.motifButton.setSelected(true);
            return;
        }
        System.err.println("FileChooserDemo if using an unknown L&F: " + string);
    }

    public static void main(String[] stringArray) {
        try {
            UIManager.setLookAndFeel(UIManager.getCrossPlatformLookAndFeelClassName());
        }
        catch (Exception exception) {
            System.err.println("Error loading L&F: " + exception);
        }
        FileChooserDemo fileChooserDemo = new FileChooserDemo();
        frame = new JFrame("FileChooserDemo");
        frame.addWindowListener(new 1());
        frame.getContentPane().add("Center", fileChooserDemo);
        frame.pack();
        ((Component)frame).setVisible(true);
        fileChooserDemo.updateState();
    }

    static {
        metal = "Metal";
        metalClassName = "javax.swing.plaf.metal.MetalLookAndFeel";
        motif = "Motif";
        motifClassName = "com.sun.java.swing.plaf.motif.MotifLookAndFeel";
        windows = "Windows";
        windowsClassName = "com.sun.java.swing.plaf.windows.WindowsLookAndFeel";
        hpad10 = new Dimension(10, 1);
        vpad10 = new Dimension(1, 10);
    }

    class OptionListener
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            JComponent jComponent = (JComponent)actionEvent.getSource();
            if (jComponent == FileChooserDemo.this.openButton) {
                FileChooserDemo.this.chooser.setDialogType(0);
                FileChooserDemo.this.customField.setEnabled(false);
                FileChooserDemo.this.repaint();
                return;
            }
            if (jComponent == FileChooserDemo.this.saveButton) {
                FileChooserDemo.this.chooser.setDialogType(1);
                FileChooserDemo.this.customField.setEnabled(false);
                FileChooserDemo.this.repaint();
                return;
            }
            if (jComponent == FileChooserDemo.this.customButton || jComponent == FileChooserDemo.this.customField) {
                FileChooserDemo.this.customField.setEnabled(true);
                FileChooserDemo.this.chooser.setDialogType(2);
                FileChooserDemo.this.chooser.setApproveButtonText(FileChooserDemo.this.customField.getText());
                FileChooserDemo.this.repaint();
                return;
            }
            if (jComponent == FileChooserDemo.this.noAllFilesFilterButton) {
                FileChooserDemo.this.chooser.removeChoosableFileFilter(FileChooserDemo.this.chooser.getAcceptAllFileFilter());
                return;
            }
            if (jComponent == FileChooserDemo.this.yesAllFilesFilterButton) {
                FileChooserDemo.this.chooser.addChoosableFileFilter(FileChooserDemo.this.chooser.getAcceptAllFileFilter());
                return;
            }
            if (jComponent == FileChooserDemo.this.defaultFiltersButton) {
                FileChooserDemo.this.chooser.resetChoosableFileFilters();
                return;
            }
            if (jComponent == FileChooserDemo.this.addFiltersButton) {
                FileChooserDemo.this.chooser.addChoosableFileFilter(FileChooserDemo.this.bothFilter);
                FileChooserDemo.this.chooser.addChoosableFileFilter(FileChooserDemo.this.jpgFilter);
                FileChooserDemo.this.chooser.addChoosableFileFilter(FileChooserDemo.this.gifFilter);
                return;
            }
            if (jComponent == FileChooserDemo.this.hiddenButton) {
                FileChooserDemo.this.chooser.setFileHidingEnabled(!FileChooserDemo.this.hiddenButton.isSelected());
                return;
            }
            if (jComponent == FileChooserDemo.this.accessoryButton) {
                if (FileChooserDemo.this.accessoryButton.isSelected()) {
                    FileChooserDemo.this.chooser.setAccessory(FileChooserDemo.this.previewer);
                    return;
                }
                FileChooserDemo.this.chooser.setAccessory(null);
                return;
            }
            if (jComponent == FileChooserDemo.this.useFileViewButton) {
                if (FileChooserDemo.this.useFileViewButton.isSelected()) {
                    FileChooserDemo.this.chooser.setFileView(FileChooserDemo.this.fileView);
                    return;
                }
                FileChooserDemo.this.chooser.setFileView(null);
                return;
            }
            if (jComponent == FileChooserDemo.this.showFullDescriptionButton) {
                FileChooserDemo.this.jpgFilter.setExtensionListInDescription(FileChooserDemo.this.showFullDescriptionButton.isSelected());
                FileChooserDemo.this.gifFilter.setExtensionListInDescription(FileChooserDemo.this.showFullDescriptionButton.isSelected());
                FileChooserDemo.this.bothFilter.setExtensionListInDescription(FileChooserDemo.this.showFullDescriptionButton.isSelected());
                if (FileChooserDemo.this.addFiltersButton.isSelected()) {
                    FileChooserDemo.this.chooser.resetChoosableFileFilters();
                    FileChooserDemo.this.chooser.addChoosableFileFilter(FileChooserDemo.this.bothFilter);
                    FileChooserDemo.this.chooser.addChoosableFileFilter(FileChooserDemo.this.jpgFilter);
                    FileChooserDemo.this.chooser.setFileFilter(FileChooserDemo.this.gifFilter);
                    return;
                }
            } else {
                if (jComponent == FileChooserDemo.this.justFilesButton) {
                    FileChooserDemo.this.chooser.setFileSelectionMode(0);
                    return;
                }
                if (jComponent == FileChooserDemo.this.justDirectoriesButton) {
                    FileChooserDemo.this.chooser.setFileSelectionMode(1);
                    return;
                }
                if (jComponent == FileChooserDemo.this.bothFilesAndDirectoriesButton) {
                    FileChooserDemo.this.chooser.setFileSelectionMode(2);
                    return;
                }
                String string = actionEvent.getActionCommand();
                try {
                    UIManager.setLookAndFeel(string);
                    SwingUtilities.updateComponentTreeUI(frame);
                    if (FileChooserDemo.this.chooser != null) {
                        SwingUtilities.updateComponentTreeUI(FileChooserDemo.this.chooser);
                    }
                    frame.pack();
                    return;
                }
                catch (UnsupportedLookAndFeelException unsupportedLookAndFeelException) {
                    System.out.println("Unsupported L&F Error:" + unsupportedLookAndFeelException);
                    JRadioButton jRadioButton = (JRadioButton)actionEvent.getSource();
                    jRadioButton.setEnabled(false);
                    FileChooserDemo.this.updateState();
                    return;
                }
                catch (IllegalAccessException illegalAccessException) {
                    System.out.println("IllegalAccessException Error:" + illegalAccessException);
                    return;
                }
                catch (ClassNotFoundException classNotFoundException) {
                    System.out.println("ClassNotFoundException Error:" + classNotFoundException);
                    return;
                }
                catch (InstantiationException instantiationException) {
                    System.out.println("InstantiateException Error:" + instantiationException);
                    return;
                }
            }
        }

        OptionListener() {
            FileChooserDemo.this = FileChooserDemo.this;
        }
    }

    class FilePreviewer
    extends JComponent
    implements PropertyChangeListener {
        ImageIcon thumbnail;
        File f;

        public FilePreviewer(JFileChooser jFileChooser) {
            FileChooserDemo.this = FileChooserDemo.this;
            this.setPreferredSize(new Dimension(100, 50));
            jFileChooser.addPropertyChangeListener(this);
        }

        public void loadImage() {
            if (this.f != null) {
                ImageIcon imageIcon = new ImageIcon(this.f.getPath());
                if (imageIcon.getIconWidth() > 90) {
                    this.thumbnail = new ImageIcon(imageIcon.getImage().getScaledInstance(90, -1, 1));
                    return;
                }
                this.thumbnail = imageIcon;
            }
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            String string = propertyChangeEvent.getPropertyName();
            if (string == "SelectedFileChangedProperty") {
                this.f = (File)propertyChangeEvent.getNewValue();
                if (this.isShowing()) {
                    this.loadImage();
                    this.repaint();
                }
            }
        }

        public void paint(Graphics graphics) {
            if (this.thumbnail == null) {
                this.loadImage();
            }
            if (this.thumbnail != null) {
                int n = this.getWidth() / 2 - this.thumbnail.getIconWidth() / 2;
                int n2 = this.getHeight() / 2 - this.thumbnail.getIconHeight() / 2;
                if (n2 < 0) {
                    n2 = 0;
                }
                if (n < 5) {
                    n = 5;
                }
                this.thumbnail.paintIcon(this, graphics, n, n2);
            }
        }
    }

    private final class 1
    extends WindowAdapter {
        public void windowClosing(WindowEvent windowEvent) {
            System.exit(0);
        }

        /* synthetic */ 1() {
        }
    }
}

