/*
 * @(#)MacDesktopPaneUI.java	1.2 99/04/22
 *
 * Copyright 1998, 1999 by Sun Microsystems, Inc.,
 * 901 San Antonio Road, Palo Alto, California, 94303, U.S.A.
 * All rights reserved.
 * 
 * This software is the confidential and proprietary information
 * of Sun Microsystems, Inc. ("Confidential Information").  You
 * shall not disclose such Confidential Information and shall use
 * it only in accordance with the terms of the license agreement
 * you entered into with Sun.
 */

package com.sun.java.swing.plaf.mac;

import java.awt.*;
import javax.swing.plaf.*;
import javax.swing.*;
import javax.swing.plaf.basic.*;
import javax.swing.border.*;
import javax.swing.text.JTextComponent;
import javax.swing.text.DefaultEditorKit;

import java.net.URL;
import java.io.Serializable;


/**
 * Implements The Macintosh Platinum Look and Feel Desktop.
 * <p>
 *
 * @version 1.2 04/22/99
 * @author Steve Wilson
 */
public class MacDesktopPaneUI extends BasicDesktopPaneUI {


    public static ComponentUI createUI(JComponent c) {
        return new MacDesktopPaneUI();
    }

    protected void installDesktopManager() {
        if (desktop.getDesktopManager() == null) {
            desktopManager = new MacDesktopManager();
            desktop.setDesktopManager(desktopManager);
        }
    }

}


class MacDesktopManager extends DefaultDesktopManager implements Serializable {

    boolean isAdjusting = false;

    static final String maxProp = "MacInternalFrame.isMax";

    static final String preIconSizeProp = "MacInternalFrame.preIconSize";

    static final String prevSizeProp = "MacInternalFrame.prevSize";
    

    public void iconifyFrame(JInternalFrame f) {
        f.putClientProperty( preIconSizeProp, f.getSize() );
        BasicInternalFrameUI ui = (BasicInternalFrameUI)f.getUI();
        Component title = ui.getNorthPane();
        Dimension size = title.getSize();
        Border shadeBorder = UIManager.getBorder("InternalFrame.windowShadeBorder");
        Insets bInsets = shadeBorder.getBorderInsets(f);
        size.height += (bInsets.top + bInsets.bottom)-1;
        size.width += (bInsets.left + bInsets.right)-2;
        f.setBorder(shadeBorder);
        f.setSize(size);
    }

    public void deiconifyFrame(JInternalFrame f) {
        if (!isAdjusting) {

            Border border = UIManager.getBorder("InternalFrame.border");
            f.setBorder(border);

            Dimension size = (Dimension)f.getClientProperty(preIconSizeProp);
            if (size != null) {
                f.setSize(size);
            } else {
                f.pack();
            }
        }
    }

    public void maximizeFrame(JInternalFrame f) {
        if (!isAdjusting) {
            isAdjusting = true;
            handleMax(f);
            try {
                f.setMaximum(false); // Mac window never really max
            } catch (Exception e) {
            }
            isAdjusting = false;
        }


    }

    public void minimizeFrame(JInternalFrame f) {
        if (!isAdjusting) {
            isAdjusting = true;
            handleMax(f);
            isAdjusting = false;
        }

    }

    public void beginResizingFrame(JComponent f, int direction) {
        super.beginResizingFrame( f, direction);
        f.putClientProperty(maxProp, Boolean.FALSE);

    }

    void handleMax(JInternalFrame f) {


        if (f.getClientProperty(maxProp) != Boolean.TRUE ) {
            if (!f.isIcon()) {
               f.putClientProperty(prevSizeProp, f.getSize()); 
            }
            f.pack();
            f.putClientProperty(maxProp, Boolean.TRUE);
        } else {
            Dimension prev = (Dimension)f.getClientProperty(prevSizeProp);
            if (prev != null ) {
                f.setSize(prev);
                f.putClientProperty(maxProp, Boolean.FALSE);               
            }
        }

        f.setBorder(UIManager.getBorder("InternalFrame.border")); // in case it was iconified
        try {
            f.setIcon(false);
        } catch (Exception e) {
        }

    }
}
