/* $Id: ColumnIterator.java,v 2.1 1999/07/06 05:50:51 borg Exp $ */
/* Copyright  1999 George Reese, All Rights Reserved */
package com.imaginary.sql.msql;

import java.sql.SQLException;
import java.util.Iterator;

/**
 * Enables an application to run through a rows columns using the
 * <CODE>Iterator</CODE> interface.
 * <BR>
 * Last modified $Date: 1999/07/06 05:50:51 $
 * @version $Revision: 2.1 $
 * @author George Reese (borg@imaginary.com)
 * @see java.util.Iterator
 */
public class ColumnIterator implements Iterator {
    private int       currentColumn = -1;
    private ParsedRow row           = null;

    public ColumnIterator(ParsedRow pr) {
	super();
	row = pr;
    }
    
    public boolean hasNext() {
	try {
	    return row.hasColumn(currentColumn+1);
	}
	catch( SQLException e ) {
	    return false;
	}
    }
    
    public Object next() {
	currentColumn++;
	try {
	    return row.get(currentColumn);
	}
	catch( SQLException e ) {
	    return null;
	}
    }

    public void remove() {
	throw new UnsupportedOperationException();
    }
    
}
