/* $Id: ColumnResults.java,v 2.2 1999/07/22 20:57:54 borg Exp $ */
/* Copyright  1998-1999 George Reese, All Rights Reserved */
package com.imaginary.sql.msql;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;

/**
 * This class represents a ResultSet containing information about
 * the columns in an mSQL table.
 * <BR>
 * Last modified $Date: 1999/07/22 20:57:54 $ 
 * @version $Revision: 2.2 $
 * @author Brian Jepson (bjepson@ids.net)
 * @author George Reese (borg@imaginary.com)
 */
public class ColumnResults extends MsqlQueryData {
    // The mSQL database that owns the table in question
    private   String            catalog          = null;
    // The name pattern to search on
    private   String            namePattern      = null;

    /**
     * Constructs a new <CODE>ColumnResults</CODE> object based on
     * the specified criteria.
     * @param conn the associated connection
     * @param np not currently in use
     * @param ll the logging level
     * @throws java.sql.SQLException an error occurred
     */
    ColumnResults(MsqlConnection conn, String np, int ll)
        throws SQLException {
        super(conn, 18, ll);
        catalog = conn.getCatalog();
        namePattern = np;
    }

    /**
     * Provides a hard-coded implementation of the superclass'
     * version so that the right columns are loaded.
     * @param name the name of the desired column
     * @return the column number for the specified column name
     * @exception java.sql.SQLException thrown on a read error
     */
    public int findColumn(String name) throws SQLException {
        if( name.equals("TABLE_CAT") ) {
            return 1;
        }
        else if( name.equals("TABLE_SCHEM") ) {
            return 2;
        }
        else if( name.equals("TABLE_NAME") ) {
            return 3;
        }
        else if( name.equals("COLUMN_NAME") ) {
            return 4;
        }
        else if( name.equals("DATA_TYPE") ) {
            return 5;
        }
        else if( name.equals("TYPE_NAME") ) {
            return 6;
        }
        else if( name.equals("COLUMN_SIZE") ) {
            return 7;
        }
        else if( name.equals("BUFFER_LENGTH") ) {
            return 8;
        }
        else if( name.equals("DECIMAL_DIGITS") ) {
            return 9;
        }
        else if( name.equals("NUM_PREC_RADIX") ) {
            return 10;
        }
        else if( name.equals("NULLABLE") ) {
            return 11;
        }
        else if( name.equals("REMARKS") ) {
            return 12;
        }
        else if( name.equals("COLUMN_DEF") ) {
            return 13;
        }
        else if( name.equals("SQL_DATA_TYPE") ) {
            return 14;
        }
        else if( name.equals("SQL_DATETIME_SUB") ) {
            return 15;
        }
        else if( name.equals("CHAR_OCTET_LENGTH") ) {
            return 16;
        }
        else if( name.equals("ORDINAL_POSITION") ) {
            return 17;
        }
        else if( name.equals("IS_NULLABLE") ) {
            return 18;
        }
        else {
            throw new MsqlException("Illegal column name.");
        }
    }

    /**
     * Creates a specialized set of result set meta data for this
     * special result set.
     */
    protected ResultSetMetaData loadMetaData() throws SQLException {
        ArrayList cols = new ArrayList();
        ResultSetMetaData rsmd;

        rsmd = new MsqlResultSetMetaData(getConnection().getCatalog(), cols);
        getConnection().release();
        return rsmd;
    }
    
    /**
     * Provides a row that represents the full range of required
     * JDBC meta data for a table's columns.
     * @param the row for the specified data
     * @return an <CODE>MsqlRow</CODE> instance for that row
     * @param java.sql.SQLException an error occurred parsing the mSQL data
     */
    protected MsqlRow readRow(byte[] data) throws SQLException {
        RowTokenizer parser = new RowTokenizer(data, getEncoding(),
                                               log.getLevel());
        ColumnResultsRow crr = new ColumnResultsRow(catalog, parser);

        if( crr.get(5).equals("IDX") ) {
            return null;
        }
        else {
            return new MsqlRow(crr, getEncoding());
        }
    }
}
