/* $Id: MsqlDatabaseMetaData.java,v 2.9 1999/08/03 01:26:01 borg Exp $ */
/* Copyright (c) 1997 George Reese */
package com.imaginary.sql.msql;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;

/**
 * This class is not yet done.
 * <BR>
 * Last modified $Date: 1999/08/03 01:26:01 $
 * @version $Revision: 2.9 $
 * @author George Reese (borg@imaginary.com)
 */
public class MsqlDatabaseMetaData implements DatabaseMetaData {
    private MsqlConnection connection = null;
    private MsqlLog        log        = null;
    
    MsqlDatabaseMetaData(MsqlConnection conn, int ll) {
        super();
        log = new MsqlLog(ll, this);
        connection = conn;
    }
    
    public boolean allProceduresAreCallable() throws SQLException {
        return false;
    }

    public boolean allTablesAreSelectable() throws SQLException {
        return true;
    }

    public boolean deletesAreDetected(int type) throws SQLException {
        return false;
    }
    
    public String getURL() throws SQLException {
        return connection.url;
    }
    
    public String getUserName() throws SQLException {
        return connection.user;
    }

    public boolean isReadOnly() throws SQLException {
        return false;
    }

    public boolean nullsAreSortedHigh() throws SQLException {
        return true;
    }

    public boolean nullsAreSortedLow() throws SQLException {
        return false;
    }

    public boolean nullsAreSortedAtStart() throws SQLException {
        return false;
    }

    public boolean nullsAreSortedAtEnd() throws SQLException {
        return false;
    }

    public String getDatabaseProductName() throws SQLException {
        return "miniSQL";
    }

    public String getDatabaseProductVersion() throws SQLException {
        return connection.versionString;
    }

    public String getDriverName() throws SQLException {
        return "Imaginary mSQL-JDBC";
    }

    public String getDriverVersion() throws SQLException {
        return "2.0b5";
    }

    public int getDriverMajorVersion() {
        return 2;
    }

    public int getDriverMinorVersion() {
        return 0;
    }

    public boolean usesLocalFiles() throws SQLException {
        return true;
    }

    public boolean usesLocalFilePerTable() throws SQLException {
        return true;
    }

    public boolean supportsMixedCaseIdentifiers() throws SQLException {
        return true;
    }

    public boolean storesUpperCaseIdentifiers() throws SQLException {
        return false;
    }

    public boolean storesLowerCaseIdentifiers() throws SQLException {
        return false;
    }

    public boolean storesMixedCaseIdentifiers() throws SQLException {
        return false;
    }

    public boolean supportsMixedCaseQuotedIdentifiers() throws SQLException {
        return true;
    }

    public boolean storesUpperCaseQuotedIdentifiers() throws SQLException {
        return false;
    }

    public boolean storesLowerCaseQuotedIdentifiers() throws SQLException {
        return false;
    }

    public boolean storesMixedCaseQuotedIdentifiers() throws SQLException {
        return false;
    }

    public Connection getConnection() throws SQLException {
        return connection;
    }
    
    public String getIdentifierQuoteString() throws SQLException {
        return " ";
    }

    public String getSQLKeywords() throws SQLException {
        return "TEXT,RLIKE,CLIKE";
    }

    public String getNumericFunctions() throws SQLException {
        if( connection.version == 2 ) {
            return "";
        }
        else {
            return "";
        }
    }

    public String getStringFunctions() throws SQLException {
        return "";
    }

    public String getSystemFunctions() throws SQLException {
        return "";
    }

    public String getTimeDateFunctions() throws SQLException {
        return "";
    }

    public String getSearchStringEscape() throws SQLException {
        return "\\";
    }

    public String getExtraNameCharacters() throws SQLException {
        return "";
    }

    public boolean supportsAlterTableWithAddColumn() throws SQLException {
        return false;
    }

    public boolean supportsAlterTableWithDropColumn() throws SQLException {
        return false;
    }

    public boolean supportsColumnAliasing() throws SQLException {
        return true;
    }

    public boolean nullPlusNonNullIsNull() throws SQLException {
        return true;
    }

    public boolean supportsConvert() throws SQLException {
        return false;
    }

    public boolean supportsConvert(int fromType, int toType)
        throws SQLException {
        return false;
    }

    public boolean supportsTableCorrelationNames() throws SQLException {
        return false;
    }

    public boolean supportsDifferentTableCorrelationNames() 
        throws SQLException {
        return false;
    }

    public boolean supportsExpressionsInOrderBy() throws SQLException {
        return false;
    }

    public boolean supportsOrderByUnrelated() throws SQLException {
        return false;
    }

    public boolean supportsGroupBy() throws SQLException {
        return ((connection.version == 2) ? true : false);
    }

    public boolean supportsGroupByUnrelated() throws SQLException {
        return false;
    }

    public boolean supportsGroupByBeyondSelect() throws SQLException {
        return false;
    }

    public boolean supportsLikeEscapeClause() throws SQLException {
        return true;
    }

    public boolean supportsMultipleResultSets() throws SQLException {
        return false;
    }

    public boolean supportsMultipleTransactions() throws SQLException {
        return true;
    }

    public boolean supportsNonNullableColumns() throws SQLException {
        return true;
    }

    public boolean supportsMinimumSQLGrammar() throws SQLException {
        return false;
    }

    public boolean supportsCoreSQLGrammar() throws SQLException {
        return false;
    }

    public boolean supportsExtendedSQLGrammar() throws SQLException {
        return false;
    }

    public boolean supportsANSI92EntryLevelSQL() throws SQLException {
        return false;
    }

    public boolean supportsANSI92IntermediateSQL() throws SQLException {
        return false;
    }

    public boolean supportsANSI92FullSQL() throws SQLException {
        return false;
    }

    public boolean supportsIntegrityEnhancementFacility()
        throws SQLException {
        return false;
    }

    public boolean supportsOuterJoins() throws SQLException {
        return false;
    }

    public boolean supportsFullOuterJoins() throws SQLException {
        return false;
    }

    public boolean supportsLimitedOuterJoins() throws SQLException {
        return false;
    }

    public String getSchemaTerm() throws SQLException {
        throw new SQLException("mSQL does not support schemas.");
    }

    public String getProcedureTerm() throws SQLException {
        throw new SQLException("mSQL does not support procedures.");
    }

    public String getCatalogTerm() throws SQLException {
        return "database";
    }

    public boolean isCatalogAtStart() throws SQLException {
        return false;
    }

    public String getCatalogSeparator() throws SQLException {
        return null;
    }

    public boolean supportsSchemasInDataManipulation() throws SQLException {
        throw new SQLException("mSQL does not support schemas.");
    }

    public boolean supportsSchemasInProcedureCalls() throws SQLException {
        throw new SQLException("mSQL does not support schemas.");
    }

    public boolean supportsSchemasInTableDefinitions() throws SQLException {
        throw new SQLException("mSQL does not support schemas.");
    }

    public boolean supportsSchemasInIndexDefinitions() throws SQLException {
        throw new SQLException("mSQL does not support schemas.");
    }

    public boolean supportsSchemasInPrivilegeDefinitions() throws SQLException{
        throw new SQLException("mSQL does not support schemas.");
    }

    public boolean supportsCatalogsInDataManipulation() throws SQLException {
        return false;
    }

    public boolean supportsCatalogsInProcedureCalls() throws SQLException {
        return false;
    }
    
    public boolean supportsCatalogsInTableDefinitions() throws SQLException {
        return false;
    }

    public boolean supportsCatalogsInIndexDefinitions() throws SQLException {
        return false;
    }

    public boolean supportsCatalogsInPrivilegeDefinitions()
        throws SQLException {
        return false;
    }

    public boolean supportsPositionedDelete() throws SQLException {
        return false;
    }

    public boolean supportsPositionedUpdate() throws SQLException {
        return false;
    }

    public boolean supportsSelectForUpdate() throws SQLException {
        return false;
    }

    public boolean supportsStoredProcedures() throws SQLException {
        return false;
    }

    public boolean supportsSubqueriesInComparisons() throws SQLException {
        return ((connection.version == 2) ? true : false);
    }

    public boolean supportsSubqueriesInExists() throws SQLException {
        return false;
    }

    public boolean supportsSubqueriesInIns() throws SQLException {
        return ((connection.version == 2) ? true : false);
    }

    public boolean supportsSubqueriesInQuantifieds() throws SQLException {
        return false;
    }

    public boolean supportsCorrelatedSubqueries() throws SQLException {
        return ((connection.version == 2) ? true : false);
    }

    public boolean supportsUnion() throws SQLException {
        return false;
    }

    public boolean supportsUnionAll() throws SQLException {
        return false;
    }

    public boolean supportsOpenCursorsAcrossCommit() throws SQLException {
        return false;
    }

    public boolean supportsOpenCursorsAcrossRollback() throws SQLException {
        return false;
    }

    public boolean supportsOpenStatementsAcrossCommit() throws SQLException {
        return true;
    }

    public boolean supportsOpenStatementsAcrossRollback()
        throws SQLException {
        return true;
    }

    public int getMaxBinaryLiteralLength() throws SQLException {
        return 0;
    }

    public int getMaxCharLiteralLength() throws SQLException {
        return 0;
    }

    public int getMaxColumnNameLength() throws SQLException {
        return 0;
    }

    public int getMaxColumnsInGroupBy() throws SQLException {
        return 0;
    }

    public int getMaxColumnsInIndex() throws SQLException {
        return 1;
    }

    public int getMaxColumnsInOrderBy() throws SQLException {
        return 0;
    }

    public int getMaxColumnsInSelect() throws SQLException {
        return 4096;
    }

    public int getMaxColumnsInTable() throws SQLException {
        return 0;
    }

    public int getMaxConnections() throws SQLException {
        return 0;
    }

    public int getMaxCursorNameLength() throws SQLException {
        return 0;
    }

    public int getMaxIndexLength() throws SQLException {
        return 0;
    }

    public int getMaxSchemaNameLength() throws SQLException {
        return 0;
    }

    public int getMaxProcedureNameLength() throws SQLException {
        return 0;
    }

    public int getMaxCatalogNameLength() throws SQLException {
        return 0;
    }

    public int getMaxRowSize() throws SQLException {
        return 0;
    }

    public boolean doesMaxRowSizeIncludeBlobs() throws SQLException {
        return true;
    }

    public int getMaxStatementLength() throws SQLException {
        return 0;
    }

    public int getMaxStatements() throws SQLException {
        return 24;
    }

    public int getMaxTableNameLength() throws SQLException {
        return 0;
    }

    public int getMaxTablesInSelect() throws SQLException {
        return 0;
    }

    public int getMaxUserNameLength() throws SQLException {
        return 8;
    }

    public int getDefaultTransactionIsolation() throws SQLException {
        return Connection.TRANSACTION_NONE;
    }

    public boolean supportsTransactions() throws SQLException {
        return false;
    }

    public boolean supportsTransactionIsolationLevel(int level)
        throws SQLException {
        return (level == Connection.TRANSACTION_NONE);
    }

    public boolean supportsDataDefinitionAndDataManipulationTransactions()
        throws SQLException {
        return true;
    }
    
    public boolean supportsDataManipulationTransactionsOnly()
        throws SQLException {
        return false;
    }
    
    public boolean dataDefinitionCausesTransactionCommit()
        throws SQLException {
        return true;
    }
    
    public boolean dataDefinitionIgnoredInTransactions() throws SQLException {
        return false;
    }

    public ResultSet getProcedures(String catalog, String schemaPattern,
                                   String procedureNamePattern)
        throws SQLException {
        throw new SQLException("mSQL does not support stored procedures.");
    }

    public ResultSet getProcedureColumns(String catalog,
                                         String schemaPattern,
                                         String procedureNamePattern, 
                                         String columnNamePattern)
        throws SQLException {
        throw new SQLException("mSQL does not support stored procedures.");
    }

    /**
     * This method is used by MsqlDatabaseMetaData to grab table information
     * from the database.
     * @return the tables in the database in the form of a result set
     * @exception java.sql.SQLException an error occurred retrieving the
     * tables
     */
    public ResultSet getTables(String ct, String sch, String tn,
                               String[] typs) throws SQLException {
        MsqlOutputStream output = connection.getOutputStream();

        connection.capture();
        try {
            output.writeString("5\n", connection.getEncoding());
        }
        catch( IOException e ) {
            connection.release();
            throw new MsqlException(e);
        }
        return new TableResults(connection, log.getLevel());
    }

    public ResultSet getSchemas() throws SQLException {
        return new MsqlEmptyResultSet(log.getLevel());
    }

    public ResultSet getCatalogs() throws SQLException {
        return new MsqlEmptyResultSet(log.getLevel());
    }

    public ResultSet getTableTypes() throws SQLException {
        return null; //FLAG: TABLE TYPES
    }

    /**
     * Provides column information for the specified table from the database.
     * The implementation for this method was provided by Brian Jepson.
     * @param ct catalog name--not yet supported
     * @param sch schema name, should be null for mSQL
     * @param tn the name of the table whose columns are being sought
     * @param col a search string on the column name, null for all columns
     * @return the columns for a specific table in the form of a result set
     * @throws java.sql.SQLException an error getting column information
     * occurred
     */
    public ResultSet getColumns(String ct, String sch, String tn, String col)
        throws SQLException {
        MsqlOutputStream output = connection.getOutputStream();
	
        connection.capture();
        // Ask for the column info.
        try {
            output.writeString("6:" + tn + "\n", connection.getEncoding());
        }
        catch( IOException e ) {
            connection.release();
            throw new MsqlException(e);
        }
        return new ColumnResults(connection, tn, log.getLevel());
    }                                              
    
    public ResultSet getColumnPrivileges(String ct, String sch, String tn,
                                         String cn) throws SQLException {
        return new MsqlEmptyResultSet(log.getLevel());
    }

    public ResultSet getTablePrivileges(String ct, String sch, String tn)
        throws SQLException {
        return new MsqlEmptyResultSet(log.getLevel());
    }

    public ResultSet getBestRowIdentifier(String ct, String sch, String t,
                                          int scope, boolean nullable)
        throws SQLException {
        return new MsqlEmptyResultSet(log.getLevel());
    }
	
    public ResultSet getVersionColumns(String ct, String sch, String t)
        throws SQLException {
        return new MsqlEmptyResultSet(log.getLevel());
    }

    /**
     * This method is used by MsqlDatabaseMetaData to grab column information
     * from the database.  The result set is kind of weird - each row has
     * one column (DATA). The first row is the index type, and the
     * remaining rows correspond to each column in the index expression.
     * @return the primary key information the form of a result set
     * @throws java.sql.SQLException an error occurred retrieving the
     * tables
     */
    public ResultSet getPrimaryKeys(String ct, String sch, String t)
        throws SQLException {
        MsqlOutputStream output = connection.getOutputStream();
        ArrayList cols = new ArrayList();
	
        connection.capture();
        // Ask for the column info.
        try {
            output.writeString("6:" + t + "\n", connection.getEncoding());
        }
        catch( IOException e ) {
            connection.release();
            throw new MsqlException(e);
        }
        while( true ) {
            byte[] data;

            try {
                data = connection.getInputStream().read();
            }
            catch( Exception e ) {
                log.log("getPrimaryKeys()", MsqlLog.ERROR,
                        "Error reading results: " + e.getMessage());
                connection.release();
                throw new MsqlException(e);
            }
            if( data.length > 2 && data[0] == '-' && data[1] == '1' &&
                data[2] == ':' ) {
                String tmp;
		
                try {
                    tmp = new String(data, connection.getEncoding());
                }
                catch( UnsupportedEncodingException e ) {
                    log.log("getPrimaryKeys()", MsqlLog.ERROR,
                            "Unsupported encoding in result set load.");
                    connection.release();
                    throw new MsqlException(e);
                }
                log.log("getPrimaryKeys()", MsqlLog.ERROR,
                        "Error processing results: " + tmp);
                throw new MsqlException(tmp);
            }
            else if( data.length > 4 && data[0] == '-' && data[1] == '1' &&
                     data[2] == '0' && data[3] == '0' && data[4] == ':' ) {
                break;
            }
            else {
                try {
                    RowTokenizer row = new RowTokenizer(data,
                                                      connection.getEncoding(),
                                                        log.getLevel());
		    
                    cols.add(row);
                }
                catch( Exception e ) {
                    log.log("getPrimaryKeys()", MsqlLog.ERROR,
                            "Error reading row: " + e.getMessage());
                    connection.release();
                    throw new MsqlException(e);
                }
            }
        }
        try {
            PrimaryKeyResults pk;
	    
            pk = new PrimaryKeyResults(connection, cols, log.getLevel());
            connection.release();
            return pk;
        }
        catch( SQLException e ) {
            log.log("getPrimaryKeys()", MsqlLog.ERROR,
                    "SQL exception getting results: " + e.getMessage());
            connection.release();
            throw e;
        }
        catch( Exception e ) {
            log.log("getPrimaryKeys()", MsqlLog.ERROR,
                    "General error getting results: " + e.getMessage());
            connection.release();
            throw new MsqlException(e);
        }		
    }
    
    public ResultSet getImportedKeys(String ct, String sch, String t)
        throws SQLException {
        return new MsqlEmptyResultSet(log.getLevel());
    }

    public ResultSet getExportedKeys(String ct, String sch, String t)
        throws SQLException {
        return new MsqlEmptyResultSet(log.getLevel());
    }

    public ResultSet getCrossReference(String pcat, String pschem,
                                       String ptable, String fcat,
                                       String fschem, String ftable)
        throws SQLException {
        throw new SQLException("This makes no sense.");
    }  

    public ResultSet getTypeInfo() throws SQLException {
        //	return new MsqlTypeInfo(connection.version);
        return new MsqlEmptyResultSet(log.getLevel());
    }
	
    public ResultSet getIndexInfo(String catalog, String schema, String table,
                                  boolean unique, boolean approximate)
        throws SQLException {
        return new MsqlEmptyResultSet(log.getLevel());
    }

    public ResultSet getUDTs(String catalog, String schema, String tn,
                             int[] types) throws SQLException {
        return new MsqlEmptyResultSet(log.getLevel());
    }

    public boolean insertsAreDetected(int type) throws SQLException {
        return false;
    }
    
    public boolean othersDeletesAreVisible(int type) throws SQLException {
        return false;
    }
    
    public boolean othersInsertsAreVisible(int type) throws SQLException {
        return false;
    }
    
    public boolean othersUpdatesAreVisible(int type) throws SQLException {
        return false;
    }
    
    public boolean ownDeletesAreVisible(int type) throws SQLException {
        if( type == ResultSet.TYPE_SCROLL_SENSITIVE ) {
            return true;
        }
        else {
            return false;
        }
    }
    
    public boolean ownInsertsAreVisible(int type) throws SQLException {
        if( type == ResultSet.TYPE_SCROLL_SENSITIVE ) {
            return true;
        }
        else {
            return false;
        }
    }
    
    public boolean ownUpdatesAreVisible(int type) throws SQLException {
        if( type == ResultSet.TYPE_SCROLL_SENSITIVE ) {
            return true;
        }
        else {
            return false;
        }
    }
    
    public boolean supportsBatchUpdates() throws SQLException {
        return true;
    }
    
    public boolean supportsResultSetConcurrency(int type, int concur)
        throws SQLException {
        if( concur != ResultSet.CONCUR_READ_ONLY ) {
            return false;
        }
        else {
            return supportsResultSetType(type);
        }
    }
    
    public boolean supportsResultSetType(int type) throws SQLException {
        if( type == ResultSet.TYPE_SCROLL_SENSITIVE ) {
            return false;
        }
        else {
            return true;
        }
    }
    
    public boolean updatesAreDetected(int type) throws SQLException {
        return false;
    }
}

