/* $Id: TableResults.java,v 2.2 1999/07/22 20:57:58 borg Exp $ */
/* Copyright  1999 George Reese, All Rights Reserved */
package com.imaginary.sql.msql;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;

/**
 * This class represents a ResultSet containing information about
 * the tables in an mSQL database.
 * <BR>
 * Last modified $Date: 1999/07/22 20:57:58 $ 
 * @version $Revision: 2.2 $
 * @author George Reese (borg@imaginary.com)
 */
public class TableResults extends MsqlQueryData {
    // The mSQL database that owns the table in question
    private   String            catalog          = null;

    /**
     * Constructs a new <CODE>TableResults</CODE> object based on
     * the specified criteria.
     * @param conn the associated connection
     * @param ll the logging level
     * @throws java.sql.SQLException an error occurred
     */
    TableResults(MsqlConnection conn, int ll)
        throws SQLException {
        super(conn, 5, ll);
        catalog = conn.getCatalog();
    }

    /**
     * Provides a hard-coded implementation of the superclass'
     * version so that the right columns are loaded.
     * @param name the name of the desired column
     * @return the column number for the specified column name
     * @exception java.sql.SQLException thrown on a read error
     */
    public int findColumn(String name) throws SQLException {
        if( name.equals("TABLE_CAT") ) {
            return 1;
        }
        else if( name.equals("TABLE_SCHEM") ) {
            return 2;
        }
        else if( name.equals("TABLE_NAME") ) {
            return 3;
        }
        else if( name.equals("TABLE_TYPE") ) {
            return 4;
        }
        else if( name.equals("REMARKS") ) {
            return 5;
        }
        else {
            throw new MsqlException("Illegal column name.");
        }
    }

    /**
     * Creates a specialized set of result set meta data for this
     * special result set.
     */
    protected ResultSetMetaData loadMetaData() throws SQLException {
        ArrayList cols = new ArrayList();
        ResultSetMetaData rsmd;

        rsmd = new MsqlResultSetMetaData(catalog, cols);
        getConnection().release();
        return rsmd;
    }
    
    /**
     * Provides a row that represents the full range of required
     * JDBC meta data for a table's columns.
     * @param the row for the specified data
     * @return an <CODE>MsqlRow</CODE> instance for that row
     * @param java.sql.SQLException an error occurred parsing the mSQL data
     */
    protected MsqlRow readRow(byte[] data) throws SQLException {
        RowTokenizer parser = new RowTokenizer(data, getEncoding(),
                                               log.getLevel());
        TableResultsRow crr = new TableResultsRow(catalog, parser);

        return new MsqlRow(crr, getEncoding());
    }
}
