/* $Id: TableResultsRow.java,v 2.1 1999/07/06 05:51:02 borg Exp $ */
/* Copyright  1999 George Reese, All Rights Reserved */
package com.imaginary.sql.msql;

import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.sql.Types;
import java.util.Iterator;

/**
 * This class represents the odd unification of JDBC table meta-data
 * requirements and the format in which mSQL presents them via the
 * mSQL socket protocol.
 * <BR>
 * Last modified $Date: 1999/07/06 05:51:02 $ 
 * @version $Revision: 2.1 $
 * @author George Reese (borg@imaginary.com)
 */
public class TableResultsRow implements ParsedRow {
    // the JDBC catalog/mSQL database
    private String         catalog     = null;
    // the row of data from mSQL
    private ParsedRow      internalRow = null;

    /**
     * Constructs a new table results row using the specified
     * <CODE>ParsedRow</CODE> to represent the data coming from mSQL
     * about the specified table.
     * @param cat the name of the catalog for the meta data 
     * @param pr the row of data from mSQL
     */
    public TableResultsRow(String cat, ParsedRow pr) {
	super();
	catalog = cat;
	internalRow = pr;
    }

    /**
     * Provides an <CODE>Iterator</CODE> to help move through the columns.
     * @return the columns as an <CODE>Iterator</CODE>
     * @throws java.sql.SQLException an error occurred parsing data from mSQL
     */
    public Iterator columns() throws SQLException {
	return internalRow.columns();
    }

    /**
     * Retrieves the specified column as a <CODE>String</CODE>.
     * @param col the desired column
     * @return the value of the column as a <CODE>String</CODE>
     * @throws java.sql.SQLException an error occurred parsing data from mSQL
     */
    public String get(int col) throws SQLException {
	switch( col ) {
	case 0:
	    // catalog
	    {
		return catalog;
	    }
	    
	case 1:
	    // schema
	    {
		return null;
	    }
	    
	case 2:
	    // table name
	    {
		return internalRow.get(0);
	    }

	case 3:
	    // table type
	    {
		return "TABLE";
	    }

	case 4:
	    // remarks
	    {
		return "Fetchez la vache!";
	    }
	    
	default:
	    {
		return null;
	    }
	}
    }

    /**
     * Provides a quick method for determining if this row contains
     * the specified column number.
     * @param col the desired column
     * @return true if the column exists, false otherwise
     */
    public boolean hasColumn(int col) {
	return (col < 5);
    }

    /**
     * This method always throws an exception since meta data result
     * sets are most definitely not updatable.
     * @param col unused
     * @param val unused
     * @throws java.sql.SQLException thrown any time this method is called
     */
    public void set(int col, String val) throws SQLException {
	throw new MsqlException("This result set may not be modified.");
    }

    /**
     * @return 18
     */
    public int size() {
	return 5;
    }
}
