/*
 * Decompiled with CFR 0.152.
 */
package xBaseJ;

import java.io.IOException;
import java.io.RandomAccessFile;
import java.io.UnsupportedEncodingException;
import java.text.NumberFormat;
import java.util.Calendar;
import java.util.Date;
import xBaseJ.Field;
import xBaseJ.xBaseJException;

public class DateField
extends Field {
    private Calendar value;

    protected Object clone() throws CloneNotSupportedException {
        DateField dateField = (DateField)super.clone();
        dateField.Name = new String(this.Name);
        dateField.Length = 8;
        return dateField;
    }

    protected DateField(String string, RandomAccessFile randomAccessFile) throws xBaseJException {
        super.setField(string, 8, randomAccessFile);
    }

    public DateField(String string) throws IOException, xBaseJException {
        super.setField(string, 8, null);
        this.put("");
    }

    private DateField() throws xBaseJException {
        this.Length = 8;
        this.buffer = new byte[this.Length];
        this.put("");
    }

    public char type() {
        return 'D';
    }

    public char getType() {
        return 'D';
    }

    public void put(String string) throws xBaseJException {
        string = string.trim();
        boolean bl = true;
        int n = 0;
        while (n < string.length()) {
            if (string.charAt(n) != ' ') {
                bl = false;
            }
            ++n;
        }
        if (string.length() == 0 || bl) {
            n = 0;
            while (n < 8) {
                this.buffer[n] = 32;
                ++n;
            }
            return;
        }
        if (string.length() != 8) {
            throw new xBaseJException("Invalid length for date Field");
        }
        n = 0;
        while (n < 8) {
            if (!Character.isDigit(string.charAt(n))) {
                throw new xBaseJException("Invalid format for date Field, " + string + " non numeric at position " + n);
            }
            ++n;
        }
        int n2 = Integer.parseInt(string.substring(0, 4));
        int n3 = Integer.parseInt(string.substring(4, 6));
        if (n3 < 1 || n3 > 12) {
            throw new xBaseJException("Invalid format for date Field (month) " + string);
        }
        int n4 = Integer.parseInt(string.substring(6, 8));
        if (n4 < 1) {
            throw new xBaseJException("Invalid format for date Field (day) " + string);
        }
        int[] nArray = new int[13];
        nArray[1] = 31;
        nArray[2] = 28;
        nArray[3] = 31;
        nArray[4] = 30;
        nArray[5] = 31;
        nArray[6] = 30;
        nArray[7] = 31;
        nArray[8] = 31;
        nArray[9] = 30;
        nArray[10] = 31;
        nArray[11] = 30;
        nArray[12] = 31;
        int[] nArray2 = nArray;
        if (n2 == 2000 || n2 % 4 == 0 && n2 % 100 == 0) {
            nArray2[2] = nArray2[2] + 1;
        }
        if (n4 > nArray2[n3]) {
            throw new xBaseJException("Invalid format for date Field, number of days > days in month");
        }
        super.put(string);
    }

    public void put(Date date) throws xBaseJException {
        super.put(String.valueOf((date.getYear() + 1900) * 10000 + (date.getMonth() + 1) * 100 + date.getDate()));
    }

    public void put(Calendar calendar) throws xBaseJException {
        super.put(String.valueOf(calendar.get(1) * 10000 + (calendar.get(2) + 1) * 100 + calendar.get(5)));
    }

    public void put(long l) throws xBaseJException {
        this.put(Long.toString(l));
    }

    public int compareTo(DateField dateField) {
        return this.get().compareTo(dateField.get());
    }

    public int compareTo(Calendar calendar) throws xBaseJException {
        DateField dateField = new DateField();
        dateField.put(calendar);
        return this.compareTo(dateField);
    }

    public Calendar getCalendar() throws xBaseJException {
        Calendar calendar = Calendar.getInstance();
        calendar.set(1, Integer.parseInt(this.get(1)));
        calendar.set(2, Integer.parseInt(this.get(2)) - 1);
        calendar.set(5, Integer.parseInt(this.get(5)));
        return calendar;
    }

    public String get(int n) throws xBaseJException {
        switch (n) {
            case 1: {
                return new String(this.buffer, 0, 4);
            }
            case 2: {
                return new String(this.buffer, 4, 2);
            }
            case 5: {
                return new String(this.buffer, 6, 2);
            }
        }
        throw new xBaseJException("Field type invalid");
    }

    public void set(int n, int n2) throws xBaseJException {
        NumberFormat numberFormat = NumberFormat.getNumberInstance();
        switch (n) {
            case 1: {
                byte[] byArray;
                numberFormat.setMinimumIntegerDigits(4);
                numberFormat.setMaximumIntegerDigits(4);
                String string = numberFormat.format(n2);
                try {
                    byArray = string.getBytes("8859_1");
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    byArray = string.getBytes();
                }
                this.buffer[0] = byArray[0];
                this.buffer[1] = byArray[1];
                this.buffer[2] = byArray[2];
                this.buffer[3] = byArray[3];
                return;
            }
            case 2: {
                if (n2 < 1 || n2 > 12) {
                    throw new xBaseJException("Month value out of range");
                }
                numberFormat.setMinimumIntegerDigits(2);
                numberFormat.setMaximumIntegerDigits(2);
                String string = numberFormat.format(n2);
                byte[] byArray = string.getBytes();
                this.buffer[4] = byArray[0];
                this.buffer[5] = byArray[1];
                return;
            }
            case 5: {
                if (n2 < 1 || n2 > 31) {
                    throw new xBaseJException("Day value out of range");
                }
                numberFormat.setMinimumIntegerDigits(2);
                numberFormat.setMaximumIntegerDigits(2);
                String string = numberFormat.format(n2);
                byte[] byArray = string.getBytes();
                this.buffer[6] = byArray[0];
                this.buffer[7] = byArray[1];
                return;
            }
        }
        throw new xBaseJException("Field type invalid");
    }
}

