/*
 * Decompiled with CFR 0.152.
 */
package xBaseJ;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.PrintJob;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.File;
import java.io.Serializable;
import java.util.Vector;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableCellEditor;
import xBaseJ.dbfTableModel;
import xBaseJ.dbfTableRecordPanel;

public class dbfTable
extends JFrame
implements ActionListener,
WindowListener,
ListSelectionListener {
    private boolean playWithLineStyle = false;
    private String lineStyle = "Angled";
    private boolean DEBUG = true;
    Vector names;
    String fname;
    JTable table;
    JMenuBar menuBar;
    JMenu menuFile;
    JMenu menuView;
    JMenuItem menuPrint;
    JMenuItem menuSave;
    JMenuItem menuOpen;
    JMenuItem horizontalView;
    JSplitPane splitPane;
    JScrollPane tableScrollPane;
    JScrollPane recordScrollPane;
    dbfTableModel tableModel;
    dbfTableRecordPanel dbfrp;
    private String lastDirectory = "./.";

    public dbfTable(String string) {
        Serializable serializable;
        this.setTitle(string);
        this.fname = string;
        if (string == null) {
            this.tableModel = new dbfTableModel();
        } else {
            this.tableModel = new dbfTableModel(string, this);
            serializable = new File(string);
            this.lastDirectory = serializable.getPath();
        }
        this.table = new JTable(this.tableModel);
        this.table.getSelectionModel().addListSelectionListener(this);
        this.tableScrollPane = new JScrollPane(this.table);
        try {
            this.dbfrp = new dbfTableRecordPanel(this, this.tableModel);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.exit(0);
        }
        this.dbfrp.goTo(1);
        this.recordScrollPane = new JScrollPane(this.dbfrp);
        this.menuBar = new JMenuBar();
        this.setJMenuBar(this.menuBar);
        this.menuFile = new JMenu("File");
        this.menuBar.add(this.menuFile);
        this.menuOpen = new JMenuItem("Open...");
        this.menuPrint = new JMenuItem("Print");
        this.menuSave = new JMenuItem("Save...");
        this.menuFile.add(this.menuOpen);
        this.menuFile.add(this.menuPrint);
        this.menuFile.add(this.menuSave);
        this.menuView = new JMenu("View");
        this.menuBar.add(this.menuView);
        this.horizontalView = new JMenuItem("Vertical");
        this.menuView.add(this.horizontalView);
        this.getContentPane().setLayout(new GridLayout(1, 0));
        serializable = new Dimension(200, 150);
        this.tableScrollPane.setMinimumSize((Dimension)serializable);
        this.recordScrollPane.setMinimumSize((Dimension)serializable);
        this.splitPane = new JSplitPane(1, this.tableScrollPane, this.recordScrollPane);
        serializable = new Dimension(400, 300);
        this.splitPane.setMinimumSize((Dimension)serializable);
        this.getContentPane().add(this.splitPane);
        this.menuOpen.addActionListener(this);
        this.menuPrint.addActionListener(this);
        this.menuSave.addActionListener(this);
        this.horizontalView.addActionListener(this);
        this.addWindowListener(this);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.menuOpen) {
            JFileChooser jFileChooser = new JFileChooser(new File(String.valueOf(this.lastDirectory) + "/*.dbf"));
            jFileChooser.showOpenDialog(this);
            File file = jFileChooser.getSelectedFile();
            if (file == null) {
                return;
            }
            this.setCursor(new Cursor(3));
            this.lastDirectory = file.getPath();
            this.fname = file.getAbsolutePath();
            int n = this.splitPane.getOrientation();
            this.getContentPane().remove(this.splitPane);
            this.setTitle(this.fname);
            this.tableModel = new dbfTableModel(this.fname, this);
            this.table = new JTable(this.tableModel);
            this.table.setAutoResizeMode(0);
            this.table.getSelectionModel().addListSelectionListener(this);
            this.tableScrollPane = new JScrollPane(this.table);
            try {
                this.dbfrp = new dbfTableRecordPanel(this, this.tableModel);
            }
            catch (Exception exception) {
                exception.printStackTrace();
                System.exit(0);
            }
            this.dbfrp.goTo(1);
            this.recordScrollPane = new JScrollPane(this.dbfrp);
            Dimension dimension = new Dimension(200, 150);
            this.tableScrollPane.setMinimumSize(dimension);
            this.recordScrollPane.setMinimumSize(dimension);
            this.splitPane = new JSplitPane(n, this.tableScrollPane, this.recordScrollPane);
            dimension = new Dimension(400, 300);
            this.splitPane.setMinimumSize(dimension);
            this.getContentPane().add(this.splitPane);
            this.table.revalidate();
            this.table.repaint();
            this.validate();
            this.setCursor(new Cursor(0));
            return;
        }
        if (actionEvent.getSource() == this.menuPrint) {
            PrintJob printJob = this.getToolkit().getPrintJob(this, "Stream Dump", null);
            if (printJob == null) {
                return;
            }
            Graphics graphics = printJob.getGraphics();
            if (graphics == null) {
                return;
            }
            TableCellEditor tableCellEditor = this.table.getCellEditor();
            if (tableCellEditor != null) {
                tableCellEditor.stopCellEditing();
            }
            ((Component)this.tableScrollPane.getViewport()).printAll(graphics);
            graphics.dispose();
            return;
        }
        if (actionEvent.getSource() == this.menuSave) {
            this.setCursor(new Cursor(3));
            TableCellEditor tableCellEditor = this.table.getCellEditor();
            if (tableCellEditor != null) {
                tableCellEditor.stopCellEditing();
            }
            this.tableModel.save();
            this.setCursor(new Cursor(0));
        }
        if (actionEvent.getSource() == this.horizontalView) {
            if (this.horizontalView.getText().compareTo("Vertical") == 0) {
                this.splitPane.setOrientation(0);
                this.horizontalView.setText("Horizontal");
            } else {
                this.splitPane.setOrientation(1);
                this.horizontalView.setText("Vertical");
            }
            this.splitPane.resetToPreferredSizes();
            this.pack();
        }
        this.repaint();
    }

    public static void main(String[] stringArray) {
        dbfTable dbfTable2 = stringArray.length == 0 ? new dbfTable(null) : new dbfTable(stringArray[0]);
        ((Component)dbfTable2).setSize(400, 125);
        ((Component)dbfTable2).setVisible(true);
    }

    public void windowClosing(WindowEvent windowEvent) {
        System.exit(0);
    }

    public void windowOpened(WindowEvent windowEvent) {
    }

    public void windowClosed(WindowEvent windowEvent) {
        System.exit(0);
    }

    public void windowIconified(WindowEvent windowEvent) {
    }

    public void windowDeiconified(WindowEvent windowEvent) {
    }

    public void windowActivated(WindowEvent windowEvent) {
    }

    public void windowDeactivated(WindowEvent windowEvent) {
    }

    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        ListSelectionModel listSelectionModel = (ListSelectionModel)listSelectionEvent.getSource();
        if (!listSelectionModel.isSelectionEmpty()) {
            this.dbfrp.goTo(listSelectionModel.getMinSelectionIndex() + 1);
        }
    }
}

