// --------------------------------------------------------------------------
// The jSyncManager Project -- Source File.
// Copyright (c) 1998 - 2003 Brad BARCLAY <bbarclay@jsyncmanager.org>
// --------------------------------------------------------------------------
// OSI Certified Open Source Software
// --------------------------------------------------------------------------
//
// This library is free software; you can redistribute it and/or modify it
// under the terms of the GNU Lesser General Public License as published 
// by the Free Software Foundation; either version 2.1 of the License, or 
// (at your option) any later version.
//
// This library is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of 
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU 
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public 
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
//
// --------------------------------------------------------------------------
// $Id: StampObject.java,v 1.1 2003/10/31 05:03:53 yaztromo Exp $
// --------------------------------------------------------------------------

package org.jSyncManager.JSerial.TestSuite;

/* Stamp Object Class                  */
/* Written by Brad Barclay             */
/* Creation Date: July 19th, 1998      */
/* Last Modified Date: July 19th, 1998 */

import java.io.*;

/** A class for storing simple date/timestamp and message data.
 ** This class is intended for storing a date and timestamp, along
 ** with a simple string message for use in the DataObject class.
 ** @author Brad Barclay.
 ** @version 1.0
 */

public class StampObject implements Serializable {
   private java.util.Date stamp=null;     // Used to store the date/timestamp
   private String message=null;           // Used to store a simple message.


   /** Construct a new Stamp Object.
	** @param msg The message to be stored.
	*/

   public StampObject(String msg) {
	  stamp=new java.util.Date();
	  message=new String(msg);
   }         
   /** Returns the datestamp as a java.util.Date Object
	** @see java.util.Date
	** @return the java.util.Date object created at object initialization.
	*/

   public java.util.Date getDate() {
	  return stamp;
   }      
   /** Returns the date/timestamp as a String.
	** @see java.util.Date
	** @return the date and time this object was created as a String.
	*/

   public String getDateString() {
	  return stamp.toString();
   }      
   /** A method for retrieving the message from this object.
	** @return the message contained in this StampObject.
	*/

   public String getMessage() {
	  return message;
   }      
}
