// --------------------------------------------------------------------------
// The jSyncManager Project -- Source File.
// Copyright (c) 1998 - 2003 Brad BARCLAY <bbarclay@jsyncmanager.org>
// --------------------------------------------------------------------------
// OSI Certified Open Source Software
// --------------------------------------------------------------------------
//
// This library is free software; you can redistribute it and/or modify it
// under the terms of the GNU Lesser General Public License as published 
// by the Free Software Foundation; either version 2.1 of the License, or 
// (at your option) any later version.
//
// This library is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of 
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU 
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public 
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
//
// --------------------------------------------------------------------------
// $Id: TerminalThread.java,v 1.1 2003/10/31 05:03:53 yaztromo Exp $
// --------------------------------------------------------------------------

package org.jSyncManager.JSerial.TestSuite;

/**
 * A simple class to represent a thread for use by TerminalUI.
 * This class simply creates a runnable object which is used as a thread by
 * the TerminalUI to retrieve characters from the SerialInterface InputStream,
 * and write them to the TerminalUI's display.
 * @author Brad Barclay.
 * @version 1.0
 */
class TerminalThread implements java.lang.Runnable {
	public java.io.DataInputStream is = null;
	public TerminalUI parent = null;
	public boolean running = false;

/**
 * This constructor creates a new runnable thread for the TerminalUI class.
 * @param is The DataInputStream for incoming character bytes.
 * @param parent The TerminalUI parent object.
 */
public TerminalThread (java.io.DataInputStream is, TerminalUI parent) {
	this.parent=parent;
	this.is=is;
}
/**
 * Starts the thread.
 */
public void run() {
	char c;
	while(running) {
		try {
			c=(char)is.readByte();
			parent.writeChar(c);
		} catch (Exception e) {
			// Blah
		}	
	}		
}
/**
 * Used to signal wether or not this thread should continue to execute.
 * @param b <B>true</B> if this thread should continue to execute, <B>false</B> otherwise.
 */
public synchronized void setRunning(boolean b) {
	running=b;
}
}