/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.css.parser;

public class ScannerUtilities {
    protected static final int[] IDENTIFIER_START;
    protected static final int[] NAME;
    protected static final int[] HEXADECIMAL;
    protected static final int[] STRING;
    protected static final int[] URI;

    static {
        int[] nArray = new int[4];
        nArray[2] = 0x7FFFFFE;
        nArray[3] = 0x7FFFFFE;
        IDENTIFIER_START = nArray;
        int[] nArray2 = new int[4];
        nArray2[1] = 67051520;
        nArray2[2] = 0x7FFFFFE;
        nArray2[3] = 0x7FFFFFE;
        NAME = nArray2;
        int[] nArray3 = new int[4];
        nArray3[1] = 0x3FF0000;
        nArray3[2] = 126;
        nArray3[3] = 126;
        HEXADECIMAL = nArray3;
        STRING = new int[]{512, -133, -1, Integer.MAX_VALUE};
        int[] nArray4 = new int[4];
        nArray4[1] = -902;
        nArray4[2] = -1;
        nArray4[3] = Integer.MAX_VALUE;
        URI = nArray4;
    }

    protected ScannerUtilities() {
    }

    public static boolean isCSSHexadecimalCharacter(char c2) {
        return c2 < '\u0080' && (HEXADECIMAL[c2 / 32] & 1 << c2 % 32) != 0;
    }

    public static boolean isCSSIdentifierStartCharacter(char c2) {
        return c2 >= '\u0080' || (IDENTIFIER_START[c2 / 32] & 1 << c2 % 32) != 0;
    }

    public static boolean isCSSNameCharacter(char c2) {
        return c2 >= '\u0080' || (NAME[c2 / 32] & 1 << c2 % 32) != 0;
    }

    public static boolean isCSSSpace(char c2) {
        return c2 <= ' ' && (4294981120L >> c2 & 1L) != 0L;
    }

    public static boolean isCSSStringCharacter(char c2) {
        return c2 >= '\u0080' || (STRING[c2 / 32] & 1 << c2 % 32) != 0;
    }

    public static boolean isCSSURICharacter(char c2) {
        return c2 >= '\u0080' || (URI[c2 / 32] & 1 << c2 % 32) != 0;
    }
}

