/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.util.io;

import java.io.IOException;
import java.io.InputStream;
import org.apache.batik.util.io.AbstractCharDecoder;

public class UTF16Decoder
extends AbstractCharDecoder {
    protected boolean bigEndian;

    public UTF16Decoder(InputStream inputStream) throws IOException {
        super(inputStream);
        int n2;
        int n3 = inputStream.read();
        if (n3 == -1) {
            this.endOfStreamError("UTF-16");
        }
        if ((n2 = inputStream.read()) == -1) {
            this.endOfStreamError("UTF-16");
        }
        int n4 = (n3 & 0xFF) << 8 | n2 & 0xFF;
        switch (n4) {
            case 65279: {
                this.bigEndian = true;
                break;
            }
            default: {
                this.charError("UTF-16");
            }
            case 65534: 
        }
    }

    public UTF16Decoder(InputStream inputStream, boolean bl) {
        super(inputStream);
        this.bigEndian = bl;
    }

    public int readChar() throws IOException {
        int n2;
        if (this.position == this.count) {
            this.fillBuffer();
        }
        if (this.count == -1) {
            return -1;
        }
        byte by = this.buffer[this.position++];
        if (this.position == this.count) {
            this.fillBuffer();
        }
        if (this.count == -1) {
            this.endOfStreamError("UTF-16");
        }
        byte by2 = this.buffer[this.position++];
        int n3 = n2 = this.bigEndian ? (by & 0xFF) << 8 | by2 & 0xFF : (by2 & 0xFF) << 8 | by & 0xFF;
        if (n2 == 65534) {
            this.charError("UTF-16");
        }
        return n2;
    }
}

